/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.win32;

import com.sun.jna.FunctionMapper;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Pointer;
import java.lang.reflect.Method;

public class StdCallFunctionMapper
implements FunctionMapper {
    protected int getArgumentNativeStackSize(Class cls) {
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls.isArray()) {
            return Pointer.SIZE;
        }
        try {
            return Native.getNativeSize(cls);
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("Unknown native stack allocation size for " + cls);
        }
    }

    @Override
    public String getFunctionName(NativeLibrary library, Method method) {
        String name2 = method.getName();
        int pop2 = 0;
        Class<?>[] argTypes = method.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            pop2 += this.getArgumentNativeStackSize(argTypes[i]);
        }
        String decorated = name2 + "@" + pop2;
        int conv = 1;
        try {
            name2 = library.getFunction(decorated, conv).getName();
        }
        catch (UnsatisfiedLinkError e2) {
            try {
                name2 = library.getFunction("_" + decorated, conv).getName();
            }
            catch (UnsatisfiedLinkError e22) {
                // empty catch block
            }
        }
        return name2;
    }
}

