/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lmediathek/tool/FileDialogs;", "", "()V", "Companion", "MediathekView"})
public final class FileDialogs {
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @Nullable
    public static final File chooseDirectoryLocation(@NotNull Frame parent, @NotNull String title, @NotNull String initialFile) {
        return Companion.chooseDirectoryLocation(parent, title, initialFile);
    }

    @JvmStatic
    @Nullable
    public static final File chooseLoadFileLocation(@NotNull Frame parent, @NotNull String title, @NotNull String initialFile) {
        return Companion.chooseLoadFileLocation(parent, title, initialFile);
    }

    @JvmStatic
    @Nullable
    public static final File chooseSaveFileLocation(@NotNull Frame parent, @NotNull String title, @NotNull String initialFile) {
        return Companion.chooseSaveFileLocation(parent, title, initialFile);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\"\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a8\u0006\f"}, d2={"Lmediathek/tool/FileDialogs$Companion;", "", "()V", "chooseDirectoryLocation", "Ljava/io/File;", "parent", "Ljava/awt/Frame;", "title", "", "initialFile", "chooseLoadFileLocation", "chooseSaveFileLocation", "MediathekView"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final File chooseDirectoryLocation(@NotNull Frame parent, @NotNull String title, @NotNull String initialFile) {
            Intrinsics.checkParameterIsNotNull(parent, "parent");
            Intrinsics.checkParameterIsNotNull(title, "title");
            Intrinsics.checkParameterIsNotNull(initialFile, "initialFile");
            File resultFile = null;
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog chooser = new FileDialog(parent, title);
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                chooser.setMode(0);
                chooser.setMultipleMode(false);
                CharSequence charSequence = initialFile;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    chooser.setDirectory(initialFile);
                }
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    File[] files = chooser.getFiles();
                    Intrinsics.checkExpressionValueIsNotNull(files, "files");
                    File[] fileArray = files;
                    boolean bl2 = false;
                    File[] fileArray2 = fileArray;
                    boolean bl3 = false;
                    if (!(fileArray2.length == 0)) {
                        resultFile = files[0];
                    }
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                JFileChooser chooser = new JFileChooser();
                CharSequence charSequence = initialFile;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    chooser.setCurrentDirectory(new File(initialFile));
                }
                chooser.setFileSelectionMode(1);
                chooser.setDialogTitle(title);
                chooser.setFileHidingEnabled(true);
                if (chooser.showOpenDialog(null) == 0) {
                    File file = chooser.getSelectedFile();
                    Intrinsics.checkExpressionValueIsNotNull(file, "chooser.selectedFile");
                    resultFile = new File(file.getAbsolutePath());
                }
            }
            return resultFile;
        }

        @JvmStatic
        @Nullable
        public final File chooseLoadFileLocation(@NotNull Frame parent, @NotNull String title, @NotNull String initialFile) {
            Intrinsics.checkParameterIsNotNull(parent, "parent");
            Intrinsics.checkParameterIsNotNull(title, "title");
            Intrinsics.checkParameterIsNotNull(initialFile, "initialFile");
            File resultFile = null;
            if (SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_WINDOWS) {
                FileDialog chooser = new FileDialog(parent, title);
                chooser.setMode(0);
                chooser.setMultipleMode(false);
                CharSequence charSequence = initialFile;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    chooser.setDirectory(initialFile);
                }
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    File[] files = chooser.getFiles();
                    Intrinsics.checkExpressionValueIsNotNull(files, "files");
                    File[] fileArray = files;
                    boolean bl2 = false;
                    File[] fileArray2 = fileArray;
                    boolean bl3 = false;
                    if (!(fileArray2.length == 0)) {
                        resultFile = files[0];
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                CharSequence charSequence = initialFile;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    chooser.setCurrentDirectory(new File(initialFile));
                }
                chooser.setFileSelectionMode(0);
                chooser.setDialogTitle(title);
                chooser.setFileHidingEnabled(true);
                if (chooser.showOpenDialog(null) == 0) {
                    File file = chooser.getSelectedFile();
                    Intrinsics.checkExpressionValueIsNotNull(file, "chooser.selectedFile");
                    resultFile = new File(file.getAbsolutePath());
                }
            }
            return resultFile;
        }

        @JvmStatic
        @Nullable
        public final File chooseSaveFileLocation(@NotNull Frame parent, @NotNull String title, @NotNull String initialFile) {
            Intrinsics.checkParameterIsNotNull(parent, "parent");
            Intrinsics.checkParameterIsNotNull(title, "title");
            Intrinsics.checkParameterIsNotNull(initialFile, "initialFile");
            File resultFile = null;
            if (SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_WINDOWS) {
                FileDialog chooser = new FileDialog(parent, title);
                chooser.setMode(1);
                chooser.setMultipleMode(false);
                CharSequence charSequence = initialFile;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    chooser.setDirectory(initialFile);
                }
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    File[] files = chooser.getFiles();
                    Intrinsics.checkExpressionValueIsNotNull(files, "files");
                    File[] fileArray = files;
                    boolean bl2 = false;
                    File[] fileArray2 = fileArray;
                    boolean bl3 = false;
                    if (!(fileArray2.length == 0)) {
                        resultFile = files[0];
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                CharSequence charSequence = initialFile;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    chooser.setCurrentDirectory(new File(initialFile));
                }
                chooser.setFileSelectionMode(0);
                chooser.setDialogTitle(title);
                chooser.setFileHidingEnabled(true);
                if (chooser.showSaveDialog(null) == 0) {
                    File file = chooser.getSelectedFile();
                    Intrinsics.checkExpressionValueIsNotNull(file, "chooser.selectedFile");
                    resultFile = new File(file.getAbsolutePath());
                }
            }
            return resultFile;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

