/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.time;

import net.sourceforge.plantuml.StringUtils;

public enum Month {
    JANUARY(31),
    FEBRUARY(28),
    MARCH(31),
    APRIL(30),
    MAY(31),
    JUNE(30),
    JULY(31),
    AUGUST(31),
    SEPTEMBER(30),
    OCTOBER(31),
    NOVEMBER(30),
    DECEMBER(31);

    private final int daysPerMonth;

    private Month(int daysPerMonth) {
        this.daysPerMonth = daysPerMonth;
    }

    public String shortName() {
        return this.longName().substring(0, 3);
    }

    public String longName() {
        return StringUtils.capitalize(this.name());
    }

    public static String getRegexString() {
        StringBuilder sb = new StringBuilder();
        for (Month month : Month.values()) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(month.name().substring(0, 3) + "[a-z]*");
        }
        return sb.toString();
    }

    public static Month fromString(String value) {
        value = StringUtils.goUpperCase(value).substring(0, 3);
        for (Month m : Month.values()) {
            if (!m.name().startsWith(value)) continue;
            return m;
        }
        throw new IllegalArgumentException();
    }

    public final int getDaysPerMonth(int year) {
        if (this == FEBRUARY && year % 4 == 0) {
            return 29;
        }
        return this.daysPerMonth;
    }

    public Month next() {
        return Month.values()[(this.ordinal() + 1) % 12];
    }

    public int m() {
        return 3 + (this.ordinal() + 10) % 12;
    }
}

