/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.probes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.snaptracer.TracerProbe;
import org.netbeans.modules.profiler.snaptracer.TracerProbeDescriptor;

public final class ProbePresenter
extends JLabel {
    private static final Color SELECTED_FILTER;
    private static final float[] FRACTIONS;
    private static final Color[] COLORS;
    private static final Color BACKGROUND;
    private LinearGradientPaint gradientPaint;
    private static final boolean GRADIENT;
    private boolean isSelected = false;

    public ProbePresenter(TracerProbe tracerProbe, TracerProbeDescriptor tracerProbeDescriptor) {
        super(tracerProbeDescriptor.getProbeName(), tracerProbeDescriptor.getProbeIcon(), 10);
        this.putClientProperty("ToolTipHelper", tracerProbeDescriptor.getProbeDescription());
        this.setIconTextGap(7);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
    }

    public void setSelected(boolean bl) {
        if (this.isSelected == bl) {
            return;
        }
        this.isSelected = bl;
        this.repaint();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        if (GRADIENT) {
            this.gradientPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, n4 - 1, FRACTIONS, COLORS);
        }
        super.reshape(n, n2, n3, n4);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n = this.getHeight() - 1;
        ((Graphics2D)graphics).setPaint(GRADIENT ? this.gradientPaint : BACKGROUND);
        graphics.fillRect(0, 0, this.getWidth(), n);
        if (this.isSelected) {
            graphics.setColor(SELECTED_FILTER);
            graphics.fillRect(0, 0, this.getWidth(), n);
        }
        super.paintComponent(graphics);
    }

    static {
        Color[] colorArray;
        SELECTED_FILTER = new Color(0, 0, 200, 40);
        FRACTIONS = new float[]{0.0f, 0.49f, 0.51f, 1.0f};
        if (!UIUtils.isDarkResultsBackground()) {
            Color[] colorArray2 = new Color[4];
            colorArray2[0] = new Color(250, 251, 252, 120);
            colorArray2[1] = new Color(237, 240, 242, 120);
            colorArray2[2] = new Color(229, 233, 236, 125);
            colorArray = colorArray2;
            colorArray2[3] = new Color(215, 221, 226, 130);
        } else {
            Color[] colorArray3 = new Color[4];
            colorArray3[0] = new Color(40, 41, 42, 220);
            colorArray3[1] = new Color(31, 32, 34, 220);
            colorArray3[2] = new Color(29, 27, 30, 225);
            colorArray = colorArray3;
            colorArray3[3] = new Color(13, 17, 22, 230);
        }
        COLORS = colorArray;
        BACKGROUND = !UIUtils.isDarkResultsBackground() ? UIManager.getColor("Panel.background") : new Color(30, 30, 30);
        GRADIENT = !Utils.forceSpeed();
    }
}

