/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;
import javajs.util.PT;
import jspecview.source.JDXSource;
import jspecview.source.XMLReader;

class CMLReader
extends XMLReader {
    private boolean specfound = false;
    String Ydelim = "";
    Vector<double[]> peakData;

    @Override
    protected JDXSource getXML(BufferedReader br) {
        try {
            this.source = new JDXSource(0, this.filePath);
            this.getSimpleXmlReader(br);
            this.processXML(4, 10);
            if (!this.checkPointCount()) {
                return null;
            }
            this.populateVariables();
        }
        catch (Exception pe) {
            System.err.println("Error: " + pe);
        }
        this.processErrors("CML");
        try {
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.source;
    }

    @Override
    protected boolean processTag(int tagId) throws Exception {
        switch (tagId) {
            case 4: {
                this.processSpectrum();
                return false;
            }
            case 9: {
                this.processSpectrumData();
                return true;
            }
            case 10: {
                this.processPeaks();
                return false;
            }
            case 8: {
                this.processSample();
                return true;
            }
            case 5: {
                this.processMetadataList();
                return true;
            }
            case 6: {
                this.processConditionList();
                return true;
            }
            case 7: {
                this.processParameterList();
                return true;
            }
            case 12: {
                this.processPeakList();
                return true;
            }
        }
        System.out.println("CMLSource not processing tag " + tagNames[tagId]);
        return false;
    }

    @Override
    protected void processEndTag(int tagId) throws Exception {
    }

    private void processSpectrum() throws Exception {
        if (this.attrList.contains("title")) {
            this.title = this.parser.getAttrValue("title");
        } else if (this.attrList.contains("id")) {
            this.title = this.parser.getAttrValue("id");
        }
        if (this.attrList.contains("type")) {
            this.techname = this.parser.getAttrValue("type").toUpperCase() + " SPECTRUM";
        }
    }

    private void processMetadataList() throws Exception {
        if (this.tagName.equals("metadata")) {
            this.tagName = this.parser.getAttrValueLC("name");
            if (this.tagName.contains(":origin")) {
                this.origin = this.attrList.contains("content") ? this.parser.getAttrValue("content") : this.parser.thisValue();
            } else if (this.tagName.contains(":owner")) {
                this.owner = this.attrList.contains("content") ? this.parser.getAttrValue("content") : this.parser.thisValue();
            } else if (this.tagName.contains("observenucleus")) {
                this.obNucleus = this.attrList.contains("content") ? this.parser.getAttrValue("content") : this.parser.thisValue();
            }
        }
    }

    private void processParameterList() throws Exception {
        if (this.tagName.equals("parameter")) {
            String title = this.parser.getAttrValueLC("title");
            if (title.equals("nmr.observe frequency")) {
                this.StrObFreq = this.parser.qualifiedValue();
                this.obFreq = Double.parseDouble(this.StrObFreq);
            } else if (title.equals("nmr.observe nucleus")) {
                this.obNucleus = this.parser.getAttrValue("value");
            } else if (title.equals("spectrometer/data system")) {
                this.modelType = this.parser.getAttrValue("value");
            } else if (title.equals("resolution")) {
                this.resolution = this.parser.qualifiedValue();
            }
        }
    }

    private void processConditionList() throws Exception {
        String dictRef;
        if (this.tagName.equals("scalar") && (dictRef = this.parser.getAttrValueLC("dictRef")).contains(":field")) {
            this.StrObFreq = this.parser.thisValue();
            if (this.StrObFreq.charAt(0) > '/' && this.StrObFreq.charAt(0) < ':') {
                this.obFreq = Double.parseDouble(this.StrObFreq);
            }
        }
    }

    private void processSample() throws Exception {
        if (this.tagName.equals("formula")) {
            if (this.attrList.contains("concise")) {
                this.molForm = this.parser.getAttrValue("concise");
            } else if (this.attrList.contains("inline")) {
                this.molForm = this.parser.getAttrValue("inline");
            }
        } else if (this.tagName.equals("name")) {
            this.casName = this.parser.thisValue();
        }
    }

    private void processSpectrumData() throws Exception {
        if (this.tagName.equals("xaxis")) {
            if (this.attrList.contains("multipliertodata")) {
                this.xFactor = Double.parseDouble(this.parser.getAttrValue("multiplierToData"));
            }
            this.parser.nextTag();
            this.tagName = this.parser.getTagName();
            this.attrList = this.parser.getAttributeList();
            if (this.tagName.equals("array")) {
                this.xUnits = CMLReader.checkUnits(this.parser.getAttrValue("units"));
                this.npoints = Integer.parseInt(this.parser.getAttrValue("size"));
                this.xaxisData = new double[this.npoints];
                if (this.attrList.contains("start")) {
                    this.firstX = Double.parseDouble(this.parser.getAttrValue("start"));
                    this.lastX = Double.parseDouble(this.parser.getAttrValue("end"));
                    this.deltaX = (this.lastX - this.firstX) / (double)(this.npoints - 1);
                    this.increasing = this.deltaX > 0.0;
                    this.continuous = true;
                    for (int j = 0; j < this.npoints; ++j) {
                        this.xaxisData[j] = this.firstX + this.deltaX * (double)j;
                    }
                } else {
                    int posDelim = 0;
                    int jj = -1;
                    String tempX = "";
                    this.Ydelim = " ";
                    this.attrList = this.parser.getCharacters().replace('\n', ' ').replace('\r', ' ').trim();
                    do {
                        posDelim = this.attrList.indexOf(this.Ydelim);
                        tempX = this.attrList.substring(0, posDelim);
                        this.xaxisData[++jj] = Double.parseDouble(tempX) * this.xFactor;
                        this.attrList = this.attrList.substring(posDelim + 1, this.attrList.length()).trim();
                        posDelim = this.attrList.indexOf(this.Ydelim);
                        while (posDelim > 0) {
                            tempX = this.attrList.substring(0, posDelim);
                            this.xaxisData[++jj] = Double.parseDouble(tempX) * this.xFactor;
                            this.attrList = this.attrList.substring(posDelim + 1, this.attrList.length()).trim();
                            posDelim = this.attrList.indexOf(this.Ydelim);
                        }
                        if (jj >= this.npoints - 1) continue;
                        this.xaxisData[++jj] = Double.parseDouble(this.attrList) * this.xFactor;
                    } while (jj < this.npoints - 1);
                    this.firstX = this.xaxisData[0];
                    this.lastX = this.xaxisData[this.npoints - 1];
                    this.continuous = true;
                }
            }
        } else if (this.tagName.equals("yaxis")) {
            if (this.attrList.contains("multipliertodata")) {
                this.yFactor = Double.parseDouble(this.parser.getAttrValue("multiplierToData"));
            }
            this.parser.nextTag();
            this.tagName = this.parser.getTagName();
            this.attrList = this.parser.getAttributeList();
            if (this.tagName.equals("array")) {
                this.yUnits = CMLReader.checkUnits(this.parser.getAttrValue("units"));
                Integer npointsY = Integer.valueOf(this.parser.getAttrValue("size"));
                if (this.npoints != npointsY) {
                    System.err.println("npoints variation between X and Y arrays");
                }
                this.yaxisData = new double[this.npoints];
                this.Ydelim = this.parser.getAttrValue("delimeter");
                if (this.Ydelim.equals("")) {
                    this.Ydelim = " ";
                }
                int posDelim = 0;
                int jj = -1;
                String tempY = "";
                this.attrList = this.parser.getCharacters().replace('\n', ' ').replace('\r', ' ').trim();
                do {
                    posDelim = this.attrList.indexOf(this.Ydelim);
                    tempY = this.attrList.substring(0, posDelim);
                    this.yaxisData[++jj] = Double.parseDouble(tempY) * this.yFactor;
                    this.attrList = this.attrList.substring(posDelim + 1, this.attrList.length()).trim();
                    posDelim = this.attrList.indexOf(this.Ydelim);
                    while (posDelim > 0) {
                        tempY = this.attrList.substring(0, posDelim);
                        this.yaxisData[++jj] = Double.parseDouble(tempY) * this.yFactor;
                        this.attrList = this.attrList.substring(posDelim + 1, this.attrList.length()).trim();
                        posDelim = this.attrList.indexOf(this.Ydelim);
                    }
                    if (jj >= this.npoints - 1) continue;
                    this.yaxisData[++jj] = Double.parseDouble(this.attrList) * this.yFactor;
                } while (jj < this.npoints - 1);
            }
            this.firstY = this.yaxisData[0];
            this.specfound = true;
        }
    }

    private void processPeaks() throws Exception {
        if (this.specfound) {
            return;
        }
        this.peakData = new Vector();
        this.process(12, true);
        this.npoints = this.peakData.size();
        this.xaxisData = new double[this.npoints];
        this.yaxisData = new double[this.npoints];
        for (int i = 0; i < this.npoints; ++i) {
            double[] xy = this.peakData.get(i);
            this.xaxisData[i] = xy[0];
            this.yaxisData[i] = xy[1];
        }
        this.peakData = null;
        this.firstX = this.xaxisData[0];
        this.lastX = this.xaxisData[this.npoints - 1];
        this.firstY = this.yaxisData[0];
        this.increasing = this.lastX > this.firstX;
        this.continuous = false;
    }

    void processPeakList() {
        if (this.tagName.equals("peak") && this.attrList.contains("xvalue")) {
            double[] xy = new double[2];
            xy[1] = 50.0;
            xy[0] = Double.parseDouble(this.parser.getAttrValue("xValue"));
            if (this.attrList.contains("xunits")) {
                this.xUnits = CMLReader.checkUnits(this.parser.getAttrValue("xUnits"));
            }
            if (this.attrList.contains("yvalue")) {
                xy[1] = Double.parseDouble(this.parser.getAttrValue("yValue"));
            }
            if (this.attrList.contains("yunits")) {
                this.yUnits = CMLReader.checkUnits(this.parser.getAttrValue("yUnits"));
            }
            if (this.attrList.contains("atomrefs")) {
                xy[1] = 49 * PT.getTokens(this.parser.getAttrValue("atomRefs")).length;
            }
            this.peakData.add(xy);
        }
    }

    private static String checkUnits(String units) {
        return (units = units.substring(units.indexOf(":") + 1).toUpperCase()).equals("RELABUNDANCE") ? "RELATIVE ABUNDANCE" : (units.contains("ARBITRARY") ? "ARBITRARY UNITS" : (units.equals("MOVERZ") ? "M/Z" : (units.equals("CM-1") ? "1/CM" : (units.equals("NM") ? "NANOMETERS" : units))));
    }
}

