/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.PrimaryConstructorLowering;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u0018\u0019\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u0015\u001a\u00020\u000e*\u00020\nH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "buildInitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "createInitFunction", "", "lower", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "openInitializerBox", "addInternalValueParameters", "hasStrictSignature", "", "CallSiteTransformer", "ES6_INIT_BOX_PARAMETER", "ES6_RESULT_TYPE_PARAMETER", "ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION", "backend.js"})
public final class ES6AddInternalParametersToConstructorPhase
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        boolean bl = this.context.getEs6mode();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        container.transform(new CallSiteTransformer(), null);
        if (!(container instanceof IrConstructor)) {
            return;
        }
        if (!this.hasStrictSignature((IrConstructor)container)) {
            this.addInternalValueParameters((IrConstructor)container);
        }
        if (container.getOrigin() == PrimaryConstructorLowering.SYNTHETIC_PRIMARY_CONSTRUCTOR.INSTANCE) {
            this.createInitFunction((IrConstructor)container);
            this.openInitializerBox((IrConstructor)container);
        }
    }

    private final void addInternalValueParameters(IrConstructor $this$addInternalValueParameters) {
        DeclarationBuildersKt.addValueParameter($this$addInternalValueParameters, "box", this.context.getDynamicType(), ES6_INIT_BOX_PARAMETER.INSTANCE);
        if (!$this$addInternalValueParameters.isPrimary()) {
            DeclarationBuildersKt.addValueParameter($this$addInternalValueParameters, "resultType", this.context.getDynamicType(), ES6_RESULT_TYPE_PARAMETER.INSTANCE);
        }
    }

    private final void createInitFunction(IrConstructor constructor) {
        IrClass irClass2 = IrUtilsKt.getParentAsClass(constructor);
        IrSimpleFunction initFunction = this.buildInitFunction(constructor, irClass2);
        Collection collection = irClass2.getDeclarations();
        boolean bl = false;
        collection.add(initFunction);
        this.context.getMapping().getConstructorToInitFunction().set((IrConstructor)((IrDeclaration)constructor), initFunction);
        initFunction.transformChildren(new IrElementTransformerVoid(initFunction){
            final /* synthetic */ IrSimpleFunction $initFunction;

            @NotNull
            public IrStatement visitDeclaration(@NotNull IrDeclaration declaration2) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                declaration2.setParent(this.$initFunction);
                return declaration2;
            }
            {
                this.$initFunction = $captured_local_variable$0;
            }
        }, null);
    }

    private final void openInitializerBox(IrConstructor constructor) {
        IrBody irBody = constructor.getBody();
        if (irBody == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        }
        IrBlockBody irBlockBody2 = (IrBlockBody)irBody;
        boolean bl = false;
        boolean bl2 = false;
        IrBlockBody $this$with = irBlockBody2;
        boolean bl3 = false;
        $this$with.getStatements().clear();
        Collection collection = $this$with.getStatements();
        IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIntrinsics().getJsOpenInitializerBox(), null, null, 6, null);
        boolean bl4 = false;
        boolean bl5 = false;
        IrCall it = irCall;
        boolean bl6 = false;
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(constructor).getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        it.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)irValueParameter.getSymbol()));
        it.putValueArgument(1, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)CollectionsKt.last(constructor.getValueParameters()).getSymbol()));
        bl4 = false;
        collection.add(irCall);
    }

    private final IrSimpleFunction buildInitFunction(IrConstructor constructor, IrClass irClass2) {
        String functionName = irClass2.getName() + "_init";
        IrType irType = this.context.getIrBuiltIns().getUnitType();
        IrDeclarationParent irDeclarationParent = irClass2;
        Visibility visibility = Visibilities.PROTECTED;
        Intrinsics.checkNotNullExpressionValue(visibility, "Visibilities.PROTECTED");
        IrSimpleFunction irSimpleFunction = JsIrBuilder.buildFunction$default(JsIrBuilder.INSTANCE, functionName, irType, irDeclarationParent, visibility, Modality.FINAL, constructor.isInline(), constructor.isExternal(), false, false, false, false, ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION.INSTANCE, 1920, null);
        boolean bl = false;
        boolean bl2 = false;
        IrSimpleFunction $this$apply = irSimpleFunction;
        boolean bl3 = false;
        DeclarationBuildersKt.addValueParameter$default($this$apply, "$this$", this.context.getDynamicType(), null, 4, null);
        Object object = constructor.getBody();
        if (object == null || (object = IrUtilsKt.getStatements((IrBody)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        $this$apply.setBody(JsIrBuilder.INSTANCE.buildBlockBody((List<? extends IrStatement>)object));
        $this$apply.transformChildren(new IrElementTransformerVoid($this$apply, this, constructor){
            final /* synthetic */ IrSimpleFunction $this_apply;
            final /* synthetic */ ES6AddInternalParametersToConstructorPhase this$0;
            final /* synthetic */ IrConstructor $constructor$inlined;
            {
                this.$this_apply = $receiver;
                this.this$0 = eS6AddInternalParametersToConstructorPhase;
                this.$constructor$inlined = irConstructor;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrGetValue irGetValue;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(this.$constructor$inlined).getThisReceiver();
                Intrinsics.checkNotNull(irValueParameter);
                if (irValueDeclaration == irValueParameter) {
                    boolean bl = false;
                    boolean bl2 = false;
                    IrGetValue $this$with = expression2;
                    boolean bl3 = false;
                    irGetValue = new IrGetValueImpl($this$with.getStartOffset(), $this$with.getEndOffset(), $this$with.getType(), (IrValueSymbol)CollectionsKt.single(this.$this_apply.getValueParameters()).getSymbol(), null, 16, null);
                } else {
                    irGetValue = expression2;
                }
                return irGetValue;
            }
        }, null);
        return irSimpleFunction;
    }

    private final boolean hasStrictSignature(IrConstructor $this$hasStrictSignature) {
        Object object = this.context.getIrBuiltIns();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$with = object;
        boolean bl3 = false;
        List<IrClassSymbol> primitives = CollectionsKt.plus((Collection)((IrBuiltIns)$this$with).getPrimitiveArrays(), ((IrBuiltIns)$this$with).getStringClass());
        object = IrUtilsKt.getParentAsClass($this$hasStrictSignature);
        bl = false;
        bl2 = false;
        $this$with = object;
        boolean bl4 = false;
        return $this$with.isExternal() || $this$with.isInline() || primitives.contains($this$with.getSymbol());
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public ES6AddInternalParametersToConstructorPhase(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase$ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
    public static final class ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION
    extends IrDeclarationOriginImpl {
        public static final ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION INSTANCE;

        private ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION() {
            super("ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION", false, 2, null);
        }

        static {
            ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION eS6_SYNTHETIC_PRIMARY_INIT_FUNCTION;
            INSTANCE = eS6_SYNTHETIC_PRIMARY_INIT_FUNCTION = new ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase$ES6_INIT_BOX_PARAMETER;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
    public static final class ES6_INIT_BOX_PARAMETER
    extends IrDeclarationOriginImpl {
        public static final ES6_INIT_BOX_PARAMETER INSTANCE;

        private ES6_INIT_BOX_PARAMETER() {
            super("ES6_INIT_BOX_PARAMETER", false, 2, null);
        }

        static {
            ES6_INIT_BOX_PARAMETER eS6_INIT_BOX_PARAMETER;
            INSTANCE = eS6_INIT_BOX_PARAMETER = new ES6_INIT_BOX_PARAMETER();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase$ES6_RESULT_TYPE_PARAMETER;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
    public static final class ES6_RESULT_TYPE_PARAMETER
    extends IrDeclarationOriginImpl {
        public static final ES6_RESULT_TYPE_PARAMETER INSTANCE;

        private ES6_RESULT_TYPE_PARAMETER() {
            super("ES6_RESULT_TYPE_PARAMETER", false, 2, null);
        }

        static {
            ES6_RESULT_TYPE_PARAMETER eS6_RESULT_TYPE_PARAMETER;
            INSTANCE = eS6_RESULT_TYPE_PARAMETER = new ES6_RESULT_TYPE_PARAMETER();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase$CallSiteTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase;)V", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "backend.js"})
    public final class CallSiteTransformer
    extends IrElementTransformerVoid {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrConstructor constructor = (IrConstructor)expression2.getSymbol().getOwner();
            IrClass parent2 = IrUtilsKt.getParentAsClass(constructor);
            if (ES6AddInternalParametersToConstructorPhase.this.hasStrictSignature(constructor) || IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(parent2))) {
                return expression2;
            }
            int newArgsCount = constructor.isPrimary() ? 1 : 2;
            IrConstructorCall irConstructorCall = expression2;
            boolean bl = false;
            boolean bl2 = false;
            IrConstructorCall $this$run = irConstructorCall;
            boolean bl3 = false;
            IrConstructorCallImpl irConstructorCallImpl = new IrConstructorCallImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), $this$run.getSymbol(), $this$run.getTypeArgumentsCount(), $this$run.getConstructorTypeArgumentsCount(), $this$run.getValueArgumentsCount() + newArgsCount, null, 128, null);
            boolean bl4 = false;
            boolean bl5 = false;
            IrConstructorCallImpl it = irConstructorCallImpl;
            boolean bl6 = false;
            int n = 0;
            int n2 = $this$run.getValueArgumentsCount();
            while (n < n2) {
                void i;
                it.putValueArgument((int)i, $this$run.getValueArgument((int)i));
                ++i;
            }
            it.putValueArgument($this$run.getValueArgumentsCount(), JsIrBuilder.INSTANCE.buildNull(ES6AddInternalParametersToConstructorPhase.this.getContext().getDynamicType()));
            if (!constructor.isPrimary()) {
                it.putValueArgument($this$run.getValueArgumentsCount() + 1, JsIrBuilder.INSTANCE.buildNull(ES6AddInternalParametersToConstructorPhase.this.getContext().getDynamicType()));
            }
            return irConstructorCallImpl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrConstructor constructor = (IrConstructor)expression2.getSymbol().getOwner();
            IrClass parent2 = IrUtilsKt.getParentAsClass(constructor);
            if (ES6AddInternalParametersToConstructorPhase.this.hasStrictSignature(constructor) || IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(parent2))) {
                return expression2;
            }
            int newArgsCount = constructor.isPrimary() ? 1 : 2;
            IrDelegatingConstructorCall irDelegatingConstructorCall = expression2;
            boolean bl = false;
            boolean bl2 = false;
            IrDelegatingConstructorCall $this$run = irDelegatingConstructorCall;
            boolean bl3 = false;
            IrDelegatingConstructorCallImpl irDelegatingConstructorCallImpl = new IrDelegatingConstructorCallImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), $this$run.getSymbol(), $this$run.getTypeArgumentsCount(), $this$run.getValueArgumentsCount() + newArgsCount);
            boolean bl4 = false;
            boolean bl5 = false;
            IrDelegatingConstructorCallImpl it = irDelegatingConstructorCallImpl;
            boolean bl6 = false;
            int n = 0;
            int n2 = $this$run.getValueArgumentsCount();
            while (n < n2) {
                void i;
                it.putValueArgument((int)i, $this$run.getValueArgument((int)i));
                ++i;
            }
            it.putValueArgument($this$run.getValueArgumentsCount(), JsIrBuilder.INSTANCE.buildNull(ES6AddInternalParametersToConstructorPhase.this.getContext().getDynamicType()));
            if (!constructor.isPrimary()) {
                it.putValueArgument($this$run.getValueArgumentsCount() + 1, JsIrBuilder.INSTANCE.buildNull(ES6AddInternalParametersToConstructorPhase.this.getContext().getDynamicType()));
            }
            return irDelegatingConstructorCallImpl;
        }
    }
}

