/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.List;
import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.VirtualMemory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.hardware.platform.linux.LinuxVirtualMemory;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;
import oshi.util.tuples.Pair;

@ThreadSafe
final class LinuxGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<Pair<Long, Long>> availTotal = Memoizer.memoize(LinuxGlobalMemory::readMemInfo, Memoizer.defaultExpiration());
    private final Supplier<Long> pageSize = Memoizer.memoize(LinuxGlobalMemory::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(LinuxGlobalMemory::createVirtualMemory);

    LinuxGlobalMemory() {
    }

    @Override
    public long getAvailable() {
        return this.availTotal.get().getA();
    }

    @Override
    public long getTotal() {
        return this.availTotal.get().getB();
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private static long queryPageSize() {
        return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("getconf PAGE_SIZE"), 4096L);
    }

    private static Pair<Long, Long> readMemInfo() {
        long memFree = 0L;
        long activeFile = 0L;
        long inactiveFile = 0L;
        long sReclaimable = 0L;
        long memTotal = 0L;
        List<String> procMemInfo = FileUtil.readFile(ProcPath.MEMINFO);
        for (String checkLine : procMemInfo) {
            String[] memorySplit = ParseUtil.whitespaces.split(checkLine);
            if (memorySplit.length <= 1) continue;
            switch (memorySplit[0]) {
                case "MemTotal:": {
                    memTotal = LinuxGlobalMemory.parseMeminfo(memorySplit);
                    break;
                }
                case "MemAvailable:": {
                    long memAvailable = LinuxGlobalMemory.parseMeminfo(memorySplit);
                    return new Pair<Long, Long>(memAvailable, memTotal);
                }
                case "MemFree:": {
                    memFree = LinuxGlobalMemory.parseMeminfo(memorySplit);
                    break;
                }
                case "Active(file):": {
                    activeFile = LinuxGlobalMemory.parseMeminfo(memorySplit);
                    break;
                }
                case "Inactive(file):": {
                    inactiveFile = LinuxGlobalMemory.parseMeminfo(memorySplit);
                    break;
                }
                case "SReclaimable:": {
                    sReclaimable = LinuxGlobalMemory.parseMeminfo(memorySplit);
                    break;
                }
            }
        }
        return new Pair<Long, Long>(memFree + activeFile + inactiveFile + sReclaimable, memTotal);
    }

    private static long parseMeminfo(String[] memorySplit) {
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
        if (memorySplit.length > 2 && "kB".equals(memorySplit[2])) {
            memory *= 1024L;
        }
        return memory;
    }

    private static VirtualMemory createVirtualMemory() {
        return new LinuxVirtualMemory();
    }
}

