/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;

public abstract class AbstractWMFReader {
    public static final float PIXEL_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    public static final float MM_PER_PIXEL = 25.4f / (float)Toolkit.getDefaultToolkit().getScreenResolution();
    protected int left = -1;
    protected int right = this.left + this.width;
    protected int top = -1;
    protected int bottom = this.top + this.height;
    protected int width = -1;
    protected int height = -1;
    protected int inch;
    protected float scaleX = 1.0f;
    protected float scaleY = 1.0f;
    protected float scaleXY = 1.0f;
    protected int vpW;
    protected int vpH;
    protected int vpX;
    protected int vpY;
    protected int xSign = 1;
    protected int ySign = 1;
    protected volatile boolean bReading = false;
    protected boolean isAldus = false;
    protected boolean isotropic = true;
    protected int mtType;
    protected int mtHeaderSize;
    protected int mtVersion;
    protected int mtSize;
    protected int mtNoObjects;
    protected int mtMaxRecord;
    protected int mtNoParameters;
    protected int windowWidth;
    protected int windowHeight;
    protected int numObjects = 0;
    protected List objectVector = new ArrayList();
    public int lastObjectIdx;

    public AbstractWMFReader() {
    }

    public AbstractWMFReader(int n, int n2) {
        this();
        this.width = n;
        this.height = n2;
    }

    protected short readShort(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[2];
        dataInputStream.readFully(byArray);
        int n = (0xFF & byArray[1]) << 8;
        short s = (short)(0xFFFF & n);
        s = (short)(s | 0xFF & byArray[0]);
        return s;
    }

    protected int readInt(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        int n = (0xFF & byArray[3]) << 24;
        n |= (0xFF & byArray[2]) << 16;
        n |= (0xFF & byArray[1]) << 8;
        return n |= 0xFF & byArray[0];
    }

    public float getViewportWidthUnits() {
        return this.vpW;
    }

    public float getViewportHeightUnits() {
        return this.vpH;
    }

    public float getViewportWidthInch() {
        return (float)this.vpW / (float)this.inch;
    }

    public float getViewportHeightInch() {
        return (float)this.vpH / (float)this.inch;
    }

    public float getPixelsPerUnit() {
        return PIXEL_PER_INCH / (float)this.inch;
    }

    public int getVpW() {
        return (int)(PIXEL_PER_INCH * (float)this.vpW / (float)this.inch);
    }

    public int getVpH() {
        return (int)(PIXEL_PER_INCH * (float)this.vpH / (float)this.inch);
    }

    public int getLeftUnits() {
        return this.left;
    }

    public int getRightUnits() {
        return this.right;
    }

    public int getTopUnits() {
        return this.top;
    }

    public int getWidthUnits() {
        return this.width;
    }

    public int getHeightUnits() {
        return this.height;
    }

    public int getBottomUnits() {
        return this.bottom;
    }

    public int getMetaFileUnitsPerInch() {
        return this.inch;
    }

    public Rectangle getRectangleUnits() {
        Rectangle rectangle = new Rectangle(this.left, this.top, this.width, this.height);
        return rectangle;
    }

    public Rectangle2D getRectanglePixel() {
        float f = PIXEL_PER_INCH * (float)this.left / (float)this.inch;
        float f2 = PIXEL_PER_INCH * (float)this.right / (float)this.inch;
        float f3 = PIXEL_PER_INCH * (float)this.top / (float)this.inch;
        float f4 = PIXEL_PER_INCH * (float)this.bottom / (float)this.inch;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f3, f2 - f, f4 - f3);
        return float_;
    }

    public Rectangle2D getRectangleInch() {
        float f = (float)this.left / (float)this.inch;
        float f2 = (float)this.right / (float)this.inch;
        float f3 = (float)this.top / (float)this.inch;
        float f4 = (float)this.bottom / (float)this.inch;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f3, f2 - f, f4 - f3);
        return float_;
    }

    public int getWidthPixels() {
        return (int)(PIXEL_PER_INCH * (float)this.width / (float)this.inch);
    }

    public float getUnitsToPixels() {
        return PIXEL_PER_INCH / (float)this.inch;
    }

    public float getVpWFactor() {
        return PIXEL_PER_INCH * (float)this.width / (float)this.inch / (float)this.vpW;
    }

    public float getVpHFactor() {
        return PIXEL_PER_INCH * (float)this.height / (float)this.inch / (float)this.vpH;
    }

    public int getHeightPixels() {
        return (int)(PIXEL_PER_INCH * (float)this.height / (float)this.inch);
    }

    public int getXSign() {
        return this.xSign;
    }

    public int getYSign() {
        return this.ySign;
    }

    protected synchronized void setReading(boolean bl) {
        this.bReading = bl;
    }

    public synchronized boolean isReading() {
        return this.bReading;
    }

    public abstract void reset();

    protected abstract boolean readRecords(DataInputStream var1) throws IOException;

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        this.reset();
        this.setReading(true);
        int n2 = this.readInt(dataInputStream);
        if (n2 == -1698247209) {
            int n3;
            int n4 = n2;
            this.isAldus = true;
            this.readShort(dataInputStream);
            this.left = this.readShort(dataInputStream);
            this.top = this.readShort(dataInputStream);
            this.right = this.readShort(dataInputStream);
            this.bottom = this.readShort(dataInputStream);
            this.inch = this.readShort(dataInputStream);
            n = this.readInt(dataInputStream);
            short s = this.readShort(dataInputStream);
            if (this.left > this.right) {
                n3 = this.right;
                this.right = this.left;
                this.left = n3;
                this.xSign = -1;
            }
            if (this.top > this.bottom) {
                n3 = this.bottom;
                this.bottom = this.top;
                this.top = n3;
                this.ySign = -1;
            }
            this.width = this.right - this.left;
            this.height = this.bottom - this.top;
            this.mtType = this.readShort(dataInputStream);
            this.mtHeaderSize = this.readShort(dataInputStream);
        } else {
            this.mtType = n2 << 16 >> 16;
            this.mtHeaderSize = n2 >> 16;
        }
        this.mtVersion = this.readShort(dataInputStream);
        this.mtSize = this.readInt(dataInputStream);
        this.mtNoObjects = this.readShort(dataInputStream);
        this.mtMaxRecord = this.readInt(dataInputStream);
        this.mtNoParameters = this.readShort(dataInputStream);
        this.numObjects = this.mtNoObjects;
        ArrayList<GdiObject> arrayList = new ArrayList<GdiObject>(this.numObjects);
        for (n = 0; n < this.numObjects; ++n) {
            arrayList.add(new GdiObject(n, false));
        }
        this.objectVector.addAll(arrayList);
        n = this.readRecords(dataInputStream) ? 1 : 0;
        dataInputStream.close();
        if (n == 0) {
            throw new IOException("Unhandled exception while reading records");
        }
    }

    public int addObject(int n, Object object) {
        int n2;
        for (int i = n2 = 0; i < this.numObjects; ++i) {
            GdiObject gdiObject = (GdiObject)this.objectVector.get(i);
            if (gdiObject.used) continue;
            gdiObject.Setup(n, object);
            this.lastObjectIdx = i;
            break;
        }
        return this.lastObjectIdx;
    }

    public int addObjectAt(int n, Object object, int n2) {
        if (n2 == 0 || n2 > this.numObjects) {
            this.addObject(n, object);
            return this.lastObjectIdx;
        }
        this.lastObjectIdx = n2;
        for (int i = 0; i < this.numObjects; ++i) {
            GdiObject gdiObject = (GdiObject)this.objectVector.get(i);
            if (i != n2) continue;
            gdiObject.Setup(n, object);
            break;
        }
        return n2;
    }

    public GdiObject getObject(int n) {
        return (GdiObject)this.objectVector.get(n);
    }

    public int getNumObjects() {
        return this.numObjects;
    }
}

