/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.breadcrumb;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.protege.editor.core.Fonts;
import org.protege.editor.owl.model.util.OboUtilities;
import org.protege.editor.owl.ui.breadcrumb.BreadcrumbView;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class BreadcrumbViewImpl
extends JPanel
implements BreadcrumbView {
    private static final int PARENT_ARROW_BOX_WIDTH = 9;
    private static final Color ARROW_COLOR = new Color(150, 150, 150);
    private static final Color TEXT_COLOR = Color.DARK_GRAY;
    @Nonnull
    private final OWLObject object;
    @Nonnull
    private final String rendering;
    private boolean parentArrowVisible = true;
    private Consumer<OWLObject> clickHandler = owlObject -> {};

    public BreadcrumbViewImpl(final @Nonnull OWLObject object, @Nonnull String rendering) {
        this.object = object;
        this.rendering = rendering;
        this.setFont(Fonts.getMediumDialogFont());
        this.setupTooltip(object, rendering);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                BreadcrumbViewImpl.this.clickHandler.accept(object);
            }
        });
    }

    @Override
    public void setViewClickedHandler(@Nonnull Consumer<OWLObject> objectConsumer) {
        this.clickHandler = (Consumer)Preconditions.checkNotNull(objectConsumer);
    }

    private void setupTooltip(@Nonnull OWLObject object, @Nonnull String rendering) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        sb.append("<span style=\"font-weight: bold;\">");
        sb.append(rendering);
        sb.append("</span>");
        if (object instanceof OWLEntity) {
            OWLEntity entity = (OWLEntity)object;
            OboUtilities.getOboIdFromIri(entity.getIRI()).ifPresent(id -> {
                sb.append("<br>");
                sb.append((String)id);
            });
            sb.append("<br>");
            sb.append("<span style=\"color: #a0a0a0;\">");
            sb.append(entity.getIRI().toString());
            sb.append("</span>");
        }
        sb.append("</body></html>");
        this.setToolTipText(sb.toString());
    }

    @Override
    public void setParentArrowVisible(boolean visible) {
        this.parentArrowVisible = visible;
    }

    @Override
    public JComponent asJComponent() {
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle2D renderingBounds = fm.getStringBounds(this.rendering, this.getGraphics());
        int prefWidth = 2 + (int)renderingBounds.getWidth();
        if (this.parentArrowVisible) {
            prefWidth += 9;
        }
        int prefTextHeight = fm.getMaxAscent() + fm.getMaxDescent() + fm.getLeading();
        return new Dimension(prefWidth, prefTextHeight);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = 0;
        if (this.parentArrowVisible) {
            g2.setColor(ARROW_COLOR);
            g2.drawLine(x + 1, 0, x + 5, this.getHeight() / 2);
            g2.drawLine(x + 1, this.getHeight(), x + 5, this.getHeight() / 2);
            x += 9;
        }
        g2.setColor(TEXT_COLOR);
        g.drawString(this.rendering, x, this.getFontMetrics(this.getFont()).getAscent());
        int width = this.getWidth();
        if (width < this.getPreferredSize().width) {
            int fadeLength = 12;
            int fadeX = width - fadeLength;
            Color bgColor = this.getBackground();
            Color transparentBgColor = new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 0);
            GradientPaint paint = new GradientPaint(fadeX, 0.0f, transparentBgColor, fadeX + fadeLength, 0.0f, bgColor);
            g2.setPaint(paint);
            g2.fillRect(fadeX, 0, fadeLength, this.getHeight());
        }
    }
}

