/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomFoldingBuilder
extends FoldingBuilderEx
implements PossiblyDumbAware {
    private CustomFoldingProvider myDefaultProvider;
    private static final RegistryValue myMaxLookupDepth = Registry.get("custom.folding.max.lookup.depth");
    private static final ThreadLocal<Set<ASTNode>> ourCustomRegionElements = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root2, @NotNull Document document, boolean quick) {
        if (root2 == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(1);
        }
        ourCustomRegionElements.set(new HashSet());
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        try {
            if (CustomFoldingProvider.getAllProviders().size() > 0) {
                this.myDefaultProvider = null;
                ASTNode rootNode = root2.getNode();
                if (rootNode != null) {
                    this.addCustomFoldingRegionsRecursively(new FoldingStack(rootNode), rootNode, descriptors, 0);
                }
            }
            this.buildLanguageFoldRegions(descriptors, root2, document, quick);
        }
        finally {
            ourCustomRegionElements.set(null);
        }
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    @Override
    @NotNull
    public final FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (document == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(4);
        }
        return this.buildFoldRegions(node.getPsi(), document, false);
    }

    protected abstract void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> var1, @NotNull PsiElement var2, @NotNull Document var3, boolean var4);

    private void addCustomFoldingRegionsRecursively(@NotNull FoldingStack foldingStack, @NotNull ASTNode node, @NotNull List<? super FoldingDescriptor> descriptors, int currDepth) {
        if (foldingStack == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (node == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (descriptors == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(7);
        }
        FoldingStack localFoldingStack = this.isCustomFoldingRoot(node) ? new FoldingStack(node) : foldingStack;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            ProgressManager.checkCanceled();
            if (this.isCustomRegionStart(child)) {
                localFoldingStack.push(child);
                continue;
            }
            if (this.isCustomRegionEnd(child)) {
                if (localFoldingStack.isEmpty()) continue;
                ASTNode startNode = (ASTNode)localFoldingStack.pop();
                int startOffset = startNode.getTextRange().getStartOffset();
                TextRange range = new TextRange(startOffset, child.getTextRange().getEndOffset());
                descriptors.add(new CompositeFoldingBuilder.FoldingDescriptorWrapper(new FoldingDescriptor(startNode, range), this));
                Set<ASTNode> nodeSet = ourCustomRegionElements.get();
                nodeSet.add(startNode);
                nodeSet.add(child);
                continue;
            }
            if (currDepth >= myMaxLookupDepth.asInteger()) continue;
            this.addCustomFoldingRegionsRecursively(localFoldingStack, child, descriptors, currDepth + 1);
        }
    }

    @Override
    public final String getPlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        String elementText;
        CustomFoldingProvider defaultProvider;
        if (node == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(8);
        }
        if (range == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(9);
        }
        if (this.isCustomFoldingCandidate(node) && (defaultProvider = this.getDefaultProvider(elementText = node.getText())) != null && defaultProvider.isCustomRegionStart(elementText)) {
            return defaultProvider.getPlaceholderText(elementText);
        }
        return this.getLanguagePlaceholderText(node, range);
    }

    protected abstract String getLanguagePlaceholderText(@NotNull ASTNode var1, @NotNull TextRange var2);

    @Override
    public final String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(10);
        }
        return "...";
    }

    @Override
    public final boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(11);
        }
        if (this.isCustomRegionStart(node)) {
            String childText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(childText);
            return defaultProvider != null && defaultProvider.isCollapsedByDefault(childText);
        }
        return this.isRegionCollapsedByDefault(node);
    }

    protected abstract boolean isRegionCollapsedByDefault(@NotNull ASTNode var1);

    public final boolean isCustomRegionStart(@NotNull ASTNode node) {
        if (node == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(12);
        }
        if (this.isCustomFoldingCandidate(node)) {
            String nodeText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(nodeText);
            return defaultProvider != null && defaultProvider.isCustomRegionStart(nodeText);
        }
        return false;
    }

    protected final boolean isCustomRegionEnd(@NotNull ASTNode node) {
        if (node == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(13);
        }
        if (this.isCustomFoldingCandidate(node)) {
            String nodeText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(nodeText);
            return defaultProvider != null && defaultProvider.isCustomRegionEnd(nodeText);
        }
        return false;
    }

    protected static boolean isCustomRegionElement(PsiElement element) {
        Set<ASTNode> set = ourCustomRegionElements.get();
        return set != null && element != null && set.contains(element.getNode());
    }

    @Nullable
    private CustomFoldingProvider getDefaultProvider(String elementText) {
        if (this.myDefaultProvider == null) {
            for (CustomFoldingProvider provider : CustomFoldingProvider.getAllProviders()) {
                if (!provider.isCustomRegionStart(elementText) && !provider.isCustomRegionEnd(elementText)) continue;
                this.myDefaultProvider = provider;
            }
        }
        return this.myDefaultProvider;
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(14);
        }
        return node.getPsi() instanceof PsiComment;
    }

    public final boolean isCustomFoldingCandidate(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(15);
        }
        return (node = element.getNode()) != null && this.isCustomFoldingCandidate(node);
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            CustomFoldingBuilder.$$$reportNull$$$0(16);
        }
        return node.getFirstChildNode() != null;
    }

    @Override
    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/folding/CustomFoldingBuilder";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingStack";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/folding/CustomFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCustomFoldingRegionsRecursively";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCustomRegionStart";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCustomRegionEnd";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingCandidate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingRoot";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FoldingStack
    extends Stack<ASTNode> {
        @NotNull
        private final ASTNode owner;

        private FoldingStack(@NotNull ASTNode owner) {
            if (owner == null) {
                FoldingStack.$$$reportNull$$$0(0);
            }
            super(1);
            this.owner = owner;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/folding/CustomFoldingBuilder$FoldingStack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/folding/CustomFoldingBuilder$FoldingStack";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

