/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmStaticChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/JvmTarget;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "isLessJVM18", "", "supportJvmStaticInInterface", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkVisibility", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "frontend.java"})
public final class JvmStaticChecker
implements DeclarationChecker {
    private final boolean isLessJVM18;
    private final boolean supportJvmStaticInInterface;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (AnnotationUtilKt.hasJvmStaticAnnotation(descriptor2) && (declaration2 instanceof KtNamedFunction || declaration2 instanceof KtProperty || declaration2 instanceof KtPropertyAccessor || declaration2 instanceof KtParameter)) {
            this.checkDeclaration(declaration2, descriptor2, context2.getTrace());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDeclaration(KtDeclaration declaration, DeclarationDescriptor descriptor, DiagnosticSink diagnosticHolder) {
        container = descriptor.getContainingDeclaration();
        insideObject = DescriptorUtils.isObject(container);
        if (!DescriptorUtils.isCompanionObject(container)) ** GOTO lbl-1000
        v0 = container;
        Intrinsics.checkNotNull(v0);
        if (DescriptorUtils.isInterface(v0.getContainingDeclaration())) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = insideCompanionObjectInInterface = false;
        }
        if (!insideObject || insideCompanionObjectInInterface) {
            if (insideCompanionObjectInInterface && this.supportJvmStaticInInterface && descriptor instanceof DeclarationDescriptorWithVisibility) {
                this.checkVisibility((DeclarationDescriptorWithVisibility)descriptor, diagnosticHolder, declaration);
                if (this.isLessJVM18) {
                    diagnosticHolder.report(ErrorsJvm.JVM_STATIC_IN_INTERFACE_1_6.on((KtDeclaration)((PsiElement)declaration)));
                }
            } else {
                diagnosticHolder.report((this.supportJvmStaticInInterface != false ? ErrorsJvm.JVM_STATIC_NOT_IN_OBJECT_OR_COMPANION : ErrorsJvm.JVM_STATIC_NOT_IN_OBJECT_OR_CLASS_COMPANION).on((KtDeclaration)((PsiElement)declaration)));
            }
        }
        if ((var8_7 = declaration) instanceof KtPropertyAccessor) {
            v2 = declaration.getParent();
            if (v2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            }
            v3 = (KtProperty)v2;
        } else {
            v3 = checkDeclaration = declaration;
        }
        if (DescriptorUtils.isNonCompanionObject(container)) {
            v4 = checkDeclaration.getModifierList();
            if (v4 != null) {
                if (v4.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                    diagnosticHolder.report(ErrorsJvm.OVERRIDE_CANNOT_BE_STATIC.on((KtDeclaration)((PsiElement)declaration)));
                }
            }
        }
        if (descriptor instanceof PropertyDescriptor && (((PropertyDescriptor)descriptor).isConst() || JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor))) {
            diagnosticHolder.report(ErrorsJvm.JVM_STATIC_ON_CONST_OR_JVM_FIELD.on((KtDeclaration)((PsiElement)declaration)));
        }
    }

    private final void checkVisibility(DeclarationDescriptorWithVisibility descriptor2, DiagnosticSink diagnosticHolder, KtDeclaration declaration2) {
        block2: {
            block1: {
                if (!(Intrinsics.areEqual(descriptor2.getVisibility(), Visibilities.PUBLIC) ^ true)) break block1;
                diagnosticHolder.report(ErrorsJvm.JVM_STATIC_ON_NON_PUBLIC_MEMBER.on((KtDeclaration)((PsiElement)declaration2)));
                break block2;
            }
            if (!(descriptor2 instanceof PropertyDescriptor)) break block2;
            PropertySetterDescriptor propertySetterDescriptor = ((PropertyDescriptor)descriptor2).getSetter();
            if (propertySetterDescriptor != null) {
                PropertySetterDescriptor propertySetterDescriptor2 = propertySetterDescriptor;
                boolean bl = false;
                boolean bl2 = false;
                PropertySetterDescriptor it = propertySetterDescriptor2;
                boolean bl3 = false;
                PropertySetterDescriptor propertySetterDescriptor3 = it;
                Intrinsics.checkNotNullExpressionValue(propertySetterDescriptor3, "it");
                this.checkVisibility(propertySetterDescriptor3, diagnosticHolder, declaration2);
            }
        }
    }

    public JvmStaticChecker(@NotNull JvmTarget jvmTarget, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(jvmTarget, "jvmTarget");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.isLessJVM18 = jvmTarget.getBytecodeVersion() < JvmTarget.JVM_1_8.getBytecodeVersion();
        this.supportJvmStaticInInterface = languageVersionSettings.supportsFeature(LanguageFeature.JvmStaticInInterface);
    }
}

