/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.starter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mediathek.config.Daten;
import mediathek.controller.starter.Start;
import mediathek.gui.messages.DownloadProgressChangedEvent;
import mediathek.tool.Log;
import mediathek.tool.MVFilmSize;
import mediathek.tool.SysMsg;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuntimeExec {
    public static final String TRENNER_PROG_ARRAY = "<>";
    private static final int INPUT = 1;
    private static final int ERROR = 2;
    private Process process = null;
    private Start start;
    private static int procnr = 0;
    private static final Pattern patternFlvstreamer = Pattern.compile("([0-9]*.[0-9]{1}%)");
    private static final Pattern patternFlvstreamerComplete = Pattern.compile("Download complete");
    private static final Pattern patternFfmpeg = Pattern.compile("(?<=  Duration: )[^,]*");
    private static final Pattern patternZeit = Pattern.compile("(?<=time=)[^ ]*");
    private static final Pattern patternSize = Pattern.compile("(?<=size=)[^k]*");
    private double totalSecs = 0.0;
    private long oldSize = 0L;
    private long oldSecs = 0L;
    private MVFilmSize mVFilmSize = null;
    private final String strProgCall;
    private String[] arrProgCallArray = null;
    private String strProgCallArray = "";
    private static final Logger logger = LogManager.getLogger(RuntimeExec.class);

    public RuntimeExec(MVFilmSize mVFilmSize, Start start, String strProgCall, String strProgCallArray) {
        this.mVFilmSize = mVFilmSize;
        this.start = start;
        this.strProgCall = strProgCall;
        this.arrProgCallArray = strProgCallArray.split(TRENNER_PROG_ARRAY);
        this.strProgCallArray = strProgCallArray;
        if (this.arrProgCallArray.length <= 1) {
            this.arrProgCallArray = null;
        }
    }

    public RuntimeExec(String p) {
        this.strProgCall = p;
    }

    public Process exec(boolean log) {
        try {
            if (this.arrProgCallArray != null) {
                if (log) {
                    logger.info("=====================");
                    logger.info("Starte Array: ");
                    logger.info(" -> " + this.strProgCallArray);
                    logger.info("=====================");
                }
                this.process = Runtime.getRuntime().exec(this.arrProgCallArray);
            } else {
                if (log) {
                    logger.info("=====================");
                    logger.info("Starte nicht als Array:");
                    logger.info(" -> " + this.strProgCall);
                    logger.info("=====================");
                }
                this.process = Runtime.getRuntime().exec(this.strProgCall);
            }
            Thread clearIn = new Thread(new ClearInOut(1, this.process));
            Thread clearOut = new Thread(new ClearInOut(2, this.process));
            clearIn.start();
            clearOut.start();
        }
        catch (Exception ex) {
            Log.errorLog(450028932, ex, "Fehler beim Starten");
        }
        return this.process;
    }

    private class ClearInOut
    implements Runnable {
        private final int art;
        private BufferedReader buff;
        private InputStream in;
        private final Process process;
        private int percent = 0;
        private int percent_start = -1;

        public ClearInOut(int a, Process p) {
            this.art = a;
            this.process = p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object titel = "";
            try {
                String inStr;
                switch (this.art) {
                    case 1: {
                        this.in = this.process.getInputStream();
                        titel = "INPUTSTREAM";
                        break;
                    }
                    case 2: {
                        this.in = this.process.getErrorStream();
                        ClearInOut clearInOut = this;
                        synchronized (clearInOut) {
                            titel = "ERRORSTREAM [" + ++procnr + "]";
                            break;
                        }
                    }
                }
                this.buff = new BufferedReader(new InputStreamReader(this.in));
                while ((inStr = this.buff.readLine()) != null) {
                    this.GetPercentageFromErrorStream(inStr);
                    SysMsg.playerMsg((String)titel + ": " + inStr);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.buff.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void GetPercentageFromErrorStream(String input) {
            Matcher matcher = patternFlvstreamer.matcher(input);
            if (matcher.find()) {
                try {
                    String prozent = matcher.group();
                    prozent = prozent.substring(0, prozent.length() - 1);
                    double d = Double.parseDouble(prozent);
                    this.meldenDouble(d);
                }
                catch (Exception ex) {
                    Daten.getInstance().getMessageBus().publishAsync(new DownloadProgressChangedEvent());
                    Log.errorLog(912036780, input);
                }
                return;
            }
            matcher = patternFlvstreamerComplete.matcher(input);
            if (matcher.find()) {
                this.meldenDouble(100.0);
                return;
            }
            try {
                String s2;
                matcher = patternFfmpeg.matcher(input);
                if (matcher.find()) {
                    String dauer = matcher.group().trim();
                    String[] hms = dauer.split(":");
                    RuntimeExec.this.totalSecs = (double)(Integer.parseInt(hms[0]) * 3600 + Integer.parseInt(hms[1]) * 60) + Double.parseDouble(hms[2]);
                }
                if ((matcher = patternSize.matcher(input)).find() && !(s2 = matcher.group().trim()).isEmpty()) {
                    try {
                        long aktSize = Integer.parseInt(StringUtils.replace(s2, "kB", ""));
                        RuntimeExec.this.mVFilmSize.setAktSize(aktSize * 1000L);
                        long akt = RuntimeExec.this.start.startZeit.diffInSekunden();
                        if (RuntimeExec.this.oldSecs < akt - 5L) {
                            RuntimeExec.this.start.bandbreite = (aktSize - RuntimeExec.this.oldSize) * 1000L / (akt - RuntimeExec.this.oldSecs);
                            RuntimeExec.this.oldSecs = akt;
                            RuntimeExec.this.oldSize = aktSize;
                        }
                    }
                    catch (NumberFormatException aktSize) {
                        // empty catch block
                    }
                }
                matcher = patternZeit.matcher(input);
                if (RuntimeExec.this.totalSecs > 0.0 && matcher.find()) {
                    String zeit = matcher.group();
                    if (zeit.contains(":")) {
                        String[] hms = zeit.split(":");
                        double aktSecs = (double)(Integer.parseInt(hms[0]) * 3600 + Integer.parseInt(hms[1]) * 60) + Double.parseDouble(hms[2]);
                        double d = aktSecs / RuntimeExec.this.totalSecs * 100.0;
                        this.meldenDouble(d);
                    } else {
                        double aktSecs = Double.parseDouble(zeit);
                        double d = aktSecs / RuntimeExec.this.totalSecs * 100.0;
                        this.meldenDouble(d);
                    }
                }
            }
            catch (Exception ex) {
                Daten.getInstance().getMessageBus().publishAsync(new DownloadProgressChangedEvent());
                Log.errorLog(912036780, input);
            }
        }

        private void meldenDouble(double d) {
            int pNeu;
            RuntimeExec.this.start.percent = pNeu = (int)(d *= 10.0);
            if (pNeu != this.percent) {
                this.percent = pNeu;
                if (this.percent_start == -1) {
                    this.percent_start = this.percent;
                }
                if (this.percent > this.percent_start + 5) {
                    int diffZeit = RuntimeExec.this.start.startZeit.diffInSekunden();
                    int diffProzent = this.percent - this.percent_start;
                    int restProzent = 1000 - this.percent;
                    RuntimeExec.this.start.restSekunden = diffZeit * restProzent / diffProzent;
                }
                Daten.getInstance().getMessageBus().publishAsync(new DownloadProgressChangedEvent());
            }
        }
    }
}

