/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.snapshot.diff;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.profiling.snapshot.ProfilerSnapshot;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.modules.profiler.LoadedSnapshot;

final class SnapshotDiffContainer
extends DataSource {
    private ResultsSnapshot diffSnapshot;
    private ProfilerSnapshot snapshot1;
    private ProfilerSnapshot snapshot2;

    public SnapshotDiffContainer(ProfilerSnapshot ps1, ProfilerSnapshot ps2, DataSource master) {
        super(master);
        this.diffSnapshot = SnapshotDiffContainer.createDiff(ps1, ps2);
        if (this.diffSnapshot == null) {
            throw new UnsupportedOperationException("Unable to create diff from " + (Object)((Object)ps1) + " and " + (Object)((Object)ps2));
        }
        this.snapshot1 = ps1;
        this.snapshot2 = ps2;
    }

    public ResultsSnapshot getDiff() {
        return this.diffSnapshot;
    }

    public ProfilerSnapshot getSnapshot1() {
        return this.snapshot1;
    }

    public ProfilerSnapshot getSnapshot2() {
        return this.snapshot2;
    }

    private static ResultsSnapshot createDiff(ProfilerSnapshot ps1, ProfilerSnapshot ps2) {
        LoadedSnapshot s1 = ps1.getLoadedSnapshot();
        LoadedSnapshot s2 = ps2.getLoadedSnapshot();
        if (s1.getSnapshot() instanceof AllocMemoryResultsSnapshot && s2.getSnapshot() instanceof AllocMemoryResultsSnapshot) {
            return new AllocMemoryResultsDiff((AllocMemoryResultsSnapshot)s1.getSnapshot(), (AllocMemoryResultsSnapshot)s2.getSnapshot());
        }
        if (s1.getSnapshot() instanceof LivenessMemoryResultsSnapshot && s2.getSnapshot() instanceof LivenessMemoryResultsSnapshot) {
            return new LivenessMemoryResultsDiff((LivenessMemoryResultsSnapshot)s1.getSnapshot(), (LivenessMemoryResultsSnapshot)s2.getSnapshot());
        }
        if (s1.getSnapshot() instanceof SampledMemoryResultsSnapshot && s2.getSnapshot() instanceof SampledMemoryResultsSnapshot) {
            return new SampledMemoryResultsDiff((SampledMemoryResultsSnapshot)s1.getSnapshot(), (SampledMemoryResultsSnapshot)s2.getSnapshot());
        }
        return null;
    }
}

