/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.nls;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jgit.errors.TranslationBundleLoadingException;
import org.eclipse.jgit.errors.TranslationStringMissingException;

public abstract class TranslationBundle {
    private Locale effectiveLocale;
    private ResourceBundle resourceBundle;

    public Locale effectiveLocale() {
        return this.effectiveLocale;
    }

    public ResourceBundle resourceBundle() {
        return this.resourceBundle;
    }

    void load(Locale locale) throws TranslationBundleLoadingException {
        Class<?> bundleClass = this.getClass();
        try {
            this.resourceBundle = ResourceBundle.getBundle(bundleClass.getName(), locale, bundleClass.getClassLoader());
        }
        catch (MissingResourceException e2) {
            throw new TranslationBundleLoadingException(bundleClass, locale, e2);
        }
        this.effectiveLocale = this.resourceBundle.getLocale();
        for (Field field : bundleClass.getFields()) {
            if (!field.getType().equals(String.class)) continue;
            try {
                String translatedText = this.resourceBundle.getString(field.getName());
                field.set(this, translatedText);
            }
            catch (MissingResourceException e3) {
                throw new TranslationStringMissingException(bundleClass, locale, field.getName(), (Exception)e3);
            }
            catch (IllegalArgumentException e4) {
                throw new Error(e4);
            }
            catch (IllegalAccessException e5) {
                throw new Error(e5);
            }
        }
    }
}

