#
# Completions for flac
#
complete -c flac -s v -l version -d "Show the flac version number"
complete -c flac -s h -l help -d "Show this screen"
complete -c flac -s H -l explain -d "Show detailed explanation of usage and options"
complete -c flac -s d -l decode -d "Decode (the default behavior is to encode)"
complete -c flac -s t -l test -d "Same as -d except no decoded file is written"
complete -c flac -s a -l analyze -d "Same as -d except an analysis file is written"
complete -c flac -s c -l stdout -d "Write output to stdout"
complete -c flac -s s -l silent -d "Do not write runtime encode/decode statistics"
complete -c flac -l totally-silent -d "Do not print anything including errors"
complete -c flac -s f -l force -d "Force overwriting of output files"
complete -c flac -r -s o -l output-name -d "Force the output file name"
complete -c flac -l output-prefix -d "Prepend STRING to output names"
complete -c flac -l delete-input-file -d "Deletes after a successful encode/decode"
complete -c flac -l skip -d "Skip the given initial samples for each input {#|mm:ss.ss}"
complete -c flac -l until -d "Stop at the given sample for each input file {#|[+|-]mm:ss.ss}"
complete -c flac -l ogg -d "Use Ogg as transport layer"
complete -c flac -l serial-number -d "Serial number to use for the FLAC stream"
complete -c flac -l residual-text -d "Include residual signal in text output"
complete -c flac -l residual-gnuplot -d "Generate gnuplot files of residual distribution"
complete -c flac -s F -l decode-through-errors -d "Continue decoding through stream errors"
complete -c flac -l cue -d "Set the beginning and ending cuepoints to decode [#.#][-[#.#]]"
complete -c flac -s V -l verify -d "Verify a correct encoding"
complete -c flac -l lax -d "Allow encoder to generate non-Subset files"
complete -c flac -l sector-align -d "Align multiple files on sector boundaries"
complete -c flac -l replay-gain -d "Calculate ReplayGain & store in Vorbis comments"
complete -c flac -l cuesheet -d "Import cuesheet and store in CUESHEET block"
complete -c flac -x -s T -l tag -d "Add a Vorbis comment FIELD=VALUE; may appear multiple times"
complete -c flac -x -s T -l tag-from-file -d "Read tags from file"
complete -c flac -x -s S -l seekpoint -d "Add seek point(s) {#|X|#x|#s}"
complete -c flac -x -s P -l padding -d "Write a PADDING block of length #"
complete -c flac -s 0 -l compression-level-0 -d "Synonymous with -l 0 -b 1152 -r 22"
complete -c flac -l fast -d "Synonymous with -l 0 -b 1152 -r 22"
complete -c flac -s 1 -l compression-level-1 -d "Synonymous with -l 0 -b 1152 -M -r 2,2"
complete -c flac -s 2 -l compression-level-2 -d "Synonymous with -l 0 -b 1152 -m -r 3"
complete -c flac -s 3 -l compression-level-3 -d "Synonymous with -l 6 -b 4608 -r 3,3"
complete -c flac -s 4 -l compression-level-4 -d "Synonymous with -l 8 -b 4608 -M -r 3,3"
complete -c flac -s 5 -l compression-level-5 -d "Synonymous with -l 8 -b 4608 -m -r 3,3"
complete -c flac -s 6 -l compression-level-6 -d "Synonymous with -l 8 -b 4608 -m -r 4"
complete -c flac -s 7 -l compression-level-7 -d "Synonymous with -l 8 -b 4608 -m -e -r 6"
complete -c flac -s 8 -l compression-level-8 -d "Synonymous with -l 12 -b 4608 -m -e -r 6"
complete -c flac -l best -d "Synonymous with -l 12 -b 4608 -m -e -r 6"
complete -c flac -x -s b -l blocksize -d "Specify blocksize in samples"
complete -c flac -s m -l mid-side -d "Try mid-side coding for each frame"
complete -c flac -s M -l adaptive-mid-side -d "Adaptive mid-side coding for all frames"
complete -c flac -s e -l exhaustive-model-search -d "Do exhaustive model search (expensive!)"
complete -c flac -x -s l -l max-lpc-order -d "Max LPC order; 0 => only fixed predictors"
complete -c flac -s p -l qlp-coeff-precision-search -d "Exhaustively search LP coeff quantization"
complete -c flac -x -s q -l qlp-coeff-precision -d "Specify precision in bits"
complete -c flac -x -s r -l rice-partition-order -d "Set [min,]max residual partition order"

complete -c flac -l endian=big -d "Set byte order for samples"
complete -c flac -l endian=little -d "Set byte order for samples"
complete -c flac -l channels -d "Number of channels"
complete -c flac -l bps -d "Number of bits per sample"
complete -c flac -l sample-rate -d "Sample rate in Hz"
complete -c flac -l sign=unsigned -d "Sign of samples"
complete -c flac -l sign=signed -d "Sign of samples"
complete -c flac -l input-size -d "Size of the raw input in bytes"
complete -c flac -l force-aiff-format -d "Force decoding to AIFF format"
complete -c flac -l force-raw-format -d "Treat input or output as raw samples"

complete -c flac -l no-adaptive-mid-side -d "No adaptive mid-side coding for all frames"
complete -c flac -l no-decode-through-errors -d "Don't continue decoding through stream errors"
complete -c flac -l no-delete-input-file -d "Don't delete after a successful encode/decode"
complete -c flac -l no-exhaustive-model-search -d "No exhaustive model search"
complete -c flac -l no-lax -d "Don't allow encoder to generate non-Subset files"
complete -c flac -l no-mid-side -d "Don't try mid-side coding for each frame"
complete -c flac -l no-ogg -d "Don't use Ogg as transport layer"
complete -c flac -l no-padding -d "Don't write a PADDING block of length #"
complete -c flac -l no-qlp-coeff-prec-search -d "Don't exhaustively search LP coeff quantization"
complete -c flac -l no-replay-gain -d "Don't calculate ReplayGain & store in Vorbis comments"
complete -c flac -l no-residual-gnuplot -d "Don't generate gnuplot files of residual distribution"
complete -c flac -l no-residual-text -d "Don't include residual signal in text output"
complete -c flac -l no-sector-align -d "Don't align multiple files on sector boundaries"
complete -c flac -l no-seektable
complete -c flac -l no-silent -d "Write runtime encode/decode statistics"
complete -c flac -l no-force -d "Don't force overwriting of output files"
complete -c flac -l no-verify -d "Don't verify a correct encoding"


