/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.awt.Graphics;
import javax.swing.UIManager;

final class WindowsUtils {
    private WindowsUtils() {
    }

    public static void drawRoundedDashedRect(Graphics g, int x, int y, int width, int height) {
        int vx = x + 1;
        while (vx < x + width) {
            g.fillRect(vx, y, 1, 1);
            g.fillRect(vx, y + height - 1, 1, 1);
            vx += 2;
        }
        int offset = (width + 1) % 2;
        int vy = y + 1;
        while (vy < y + height - offset) {
            g.fillRect(x, vy, 1, 1);
            g.fillRect(x + width - 1, vy + offset, 1, 1);
            vy += 2;
        }
    }

    static void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(UIManager.getColor("controlLtHighlight"));
        g.drawLine(0, 0, w - 2, 0);
        g.drawLine(0, 0, 0, h - 2);
        g.setColor(UIManager.getColor("controlShadow"));
        g.drawLine(w - 1, 0, w - 1, h - 1);
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.translate(-x, -y);
    }

    static void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(UIManager.getColor("controlShadow"));
        g.drawLine(0, 0, w - 2, 0);
        g.drawLine(0, 0, 0, h - 2);
        g.setColor(UIManager.getColor("controlLtHighlight"));
        g.drawLine(w - 1, 0, w - 1, h - 1);
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.translate(-x, -y);
    }
}

