/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.storage;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.storage.DefaultSimpleLock;
import org.jetbrains.annotations.NotNull;

public final class CancellableSimpleLock
extends DefaultSimpleLock {
    private final Runnable checkCancelled;

    @Override
    public void lock() {
        while (!this.getLock().tryLock(50L, TimeUnit.MILLISECONDS)) {
            this.checkCancelled.run();
        }
    }

    public CancellableSimpleLock(@NotNull Lock lock, @NotNull Runnable checkCancelled) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        Intrinsics.checkNotNullParameter((Object)checkCancelled, (String)"checkCancelled");
        super(lock);
        this.checkCancelled = checkCancelled;
    }

    public CancellableSimpleLock(@NotNull Runnable checkCancelled) {
        Intrinsics.checkNotNullParameter((Object)checkCancelled, (String)"checkCancelled");
        Lock lock = new ReentrantLock();
        Runnable runnable = checkCancelled;
        this(lock, runnable);
    }
}

