% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.KDE_GUI-functions.R
\name{rk.show.message}
\alias{rk.show.message}
\alias{rk.show.question}
\alias{rk.select.list}
\alias{rk.askYesNo}
\title{Message boxes and selection list using native KDE GUI}
\usage{
rk.show.message(message, caption = gettext("Information"), wait = TRUE)

rk.show.question(message, caption = gettext("Question"),
  button.yes = "yes", button.no = "no", button.cancel = "cancel",
  default = TRUE)

rk.askYesNo(msg, default = TRUE, prompts = c("yes", "no", "cancel"),
  caption = gettext("Question"), is.rk.askYesNo = TRUE, ...)

rk.select.list(list, preselect = NULL, multiple = FALSE,
  title = NULL)
}
\arguments{
\item{message}{a string for the content of the message box.}

\item{caption}{a string for title of the message box.}

\item{wait}{a logical (not NA) indicating whether the R interpreter should
wait for the user's action, or run it asynchronously.}

\item{button.yes}{a string for the text label of the \bold{Yes} button. Can
be an empty string (\code{""}), in which case the button is not displayed
at all. Note that the default value of "yes" (lower case) means to use a default
rendering of a "Yes" button, which may or may not be the literal string "Yes"
(importantly, it will be translated, automatically).}

\item{button.no}{a string used for the text label of the \bold{No} button.
This behaves similar to \code{button.yes}, including the meaning of the
default value "no".}

\item{button.cancel}{a string used for the text label of the \bold{Cancel} button.
This behaves similar to \code{button.yes}, including the meaning of the
default value "cancel".}

\item{default}{The expected or "safe" default response (e.g. \code{TRUE} for "Yes button").
The corresponding button will focused, so that it will become selected option,
if the user simply presses enter.}

\item{msg}{like \code{message}, only the argument was renamed to mimic the formals of
\code{askYesNo}.}

\item{prompts}{either a character vector containing 3 prompts corresponding to return
values of TRUE, FALSE, or NA, or a single character value containing the prompts
separated by \code{/} characters.}

\item{is.rk.askYesNo}{a logical value, you can safely ignore this argument if you call
\code{rk.askYesNo} manually. This argument is needed if \code{rk.askYesNo} is set
via \code{options("askYesNo"=rk.askYesNo)} because otherwise we'd either need more
complicated function code there, fail with an error or end up in an infinite loop.}

\item{list}{a vector, coerced into a character vector.}

\item{multiple}{a logical (not NA), when \code{TRUE} multiple selection
selection is allowed.}

\item{title}{a string, for the window title of the displayed list}

\item{preselct}{a vector, coerced into a character vector, items to be
preselected.}
}
\value{
\code{rk.show.message} always returns \code{TRUE}, invisibly.

\code{rk.show.question} returns \code{TRUE} for \bold{Yes}, \code{FALSE} for
  \bold{No}, and \code{NULL} for \bold{Cancel} actions. If the dialog is closed
  without clicking on any button, \code{NULL} is returned, as well.

\code{rk.askYesNo} has the same return values as \code{rk.show.question}, except
  it returns \code{NA} for \bold{Cancel} actions.

\code{rk.select.list} returns the value of \code{\link{select.list}}.
}
\description{
Multi-purpose pop-up message boxes and selection list using native KDE GUI
elements. The message boxes can be used either to show some information or
ask some question. The selection list can be used to get a vector of
selected items.
}
\details{
For \code{rk.show.question}, the R interpreter always waits for the user's
choice.

\code{rk.select.list} replaces \code{utils::select.list} for the running
session acting as a drop-in replacement for \code{tk_select.list}. Use
\code{.rk.backups$select.list} for the original \code{utils::select.list}
function (see Examples).
}
\examples{

require (rkward)

## Message boxes
if (rk.show.question ("Question:\\nDo you want to know about RKWard?", 
    button.yes = "Yes, I do!", button.no = "No, I don't care!", button.cancel = "")) {
  rk.show.message ("Message:\\nRKWard is a KDE GUI for R.", "RKWard Info")
} else {
  rk.show.message ("You must be joking!", "RKWard Info",
      wait = FALSE) ## Run asynchronously
}

## Selection lists:
rk.select.list (LETTERS, preselect = c("A", "E", "I", "O", "U"), 
  multiple = TRUE, title = "vowels")
.rk.backups$select.list (LETTERS, preselect = c("A", "E", "I", "O", "U"), 
  multiple = TRUE, title = "vowels")
}
\seealso{
\code{\link{system}}, \code{\link{select.list}}
}
\author{
Thomas Friedrichsmeier \email{rkward-devel@kde.org}
}
\keyword{utilities}
