/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanDefinition;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ParametrizedBeanFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Qualifier;

@Internal
public abstract class AbstractParametrizedBeanDefinition<T>
extends AbstractBeanDefinition<T>
implements ParametrizedBeanFactory<T> {
    private final Argument[] requiredArguments = this.resolveRequiredArguments();

    public AbstractParametrizedBeanDefinition(Class<T> producedType, Class<?> declaringType, String methodName, AnnotationMetadata methodMetadata, boolean requiresReflection, Argument ... arguments) {
        super(producedType, declaringType, methodName, methodMetadata, requiresReflection, arguments);
    }

    protected AbstractParametrizedBeanDefinition(Class<T> type, AnnotationMetadata annotationMetadata, boolean requiresReflection, Argument ... arguments) {
        super(type, annotationMetadata, requiresReflection, arguments);
    }

    @Override
    public Argument<?>[] getRequiredArguments() {
        return this.requiredArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T build(BeanResolutionContext resolutionContext, BeanContext context, BeanDefinition<T> definition, Map<String, Object> requiredArgumentValues) throws BeanInstantiationException {
        requiredArgumentValues = requiredArgumentValues != null ? new LinkedHashMap<String, Object>(requiredArgumentValues) : Collections.emptyMap();
        Argument<?>[] requiredArguments = this.getRequiredArguments();
        Optional eachBeanType = definition.classValue(EachBean.class);
        for (Argument<?> requiredArgument : requiredArguments) {
            if (requiredArgument.getType() == BeanResolutionContext.class) {
                requiredArgumentValues.put(requiredArgument.getName(), resolutionContext);
            }
            BeanResolutionContext.Path path = resolutionContext.getPath();
            try {
                boolean requiresConversion;
                path.pushConstructorResolve(this, requiredArgument);
                String argumentName = requiredArgument.getName();
                if (!requiredArgumentValues.containsKey(argumentName) && !requiredArgument.isNullable()) {
                    if (eachBeanType.filter(type -> type == requiredArgument.getType()).isPresent()) {
                        T t = null;
                        return t;
                    }
                    throw new BeanInstantiationException(resolutionContext, "Missing bean argument value: " + argumentName);
                }
                Object value = requiredArgumentValues.get(argumentName);
                boolean bl = requiresConversion = value != null && !requiredArgument.getType().isInstance(value);
                if (!requiresConversion) continue;
                Optional converted = ConversionService.SHARED.convert(value, requiredArgument.getType(), (ConversionContext)ConversionContext.of(requiredArgument));
                Object finalValue = value;
                value = converted.orElseThrow(() -> new BeanInstantiationException(resolutionContext, "Invalid value [" + finalValue + "] for argument: " + argumentName));
                requiredArgumentValues.put(argumentName, value);
            }
            finally {
                path.pop();
            }
        }
        return this.doBuild(resolutionContext, context, definition, requiredArgumentValues);
    }

    protected abstract T doBuild(BeanResolutionContext var1, BeanContext var2, BeanDefinition<T> var3, Map<String, Object> var4);

    private Argument[] resolveRequiredArguments() {
        return (Argument[])Arrays.stream(this.getConstructor().getArguments()).filter(arg -> {
            Optional qualifierType = arg.getAnnotationMetadata().getAnnotationTypeByStereotype(Qualifier.class);
            return qualifierType.isPresent() && qualifierType.get() == Parameter.class;
        }).toArray(Argument[]::new);
    }
}

