/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.storage.reftable.LogCursor;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.Reftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ReflogEntry;

public class ReftableCompactor {
    private final ReftableWriter writer = new ReftableWriter();
    private final ArrayDeque<Reftable> tables = new ArrayDeque();
    private long compactBytesLimit;
    private long bytesToCompact;
    private boolean includeDeletes;
    private long minUpdateIndex = -1L;
    private long maxUpdateIndex;
    private long oldestReflogTimeMillis;
    private ReftableWriter.Stats stats;

    public ReftableCompactor setConfig(ReftableConfig cfg) {
        this.writer.setConfig(cfg);
        return this;
    }

    public ReftableCompactor setCompactBytesLimit(long bytes2) {
        this.compactBytesLimit = bytes2;
        return this;
    }

    public ReftableCompactor setIncludeDeletes(boolean deletes) {
        this.includeDeletes = deletes;
        return this;
    }

    public ReftableCompactor setMinUpdateIndex(long min2) {
        this.minUpdateIndex = min2;
        return this;
    }

    public ReftableCompactor setMaxUpdateIndex(long max2) {
        this.maxUpdateIndex = max2;
        return this;
    }

    public ReftableCompactor setOldestReflogTimeMillis(long timeMillis) {
        this.oldestReflogTimeMillis = timeMillis;
        return this;
    }

    public void addAll(List<? extends Reftable> readers) throws IOException {
        this.tables.addAll(readers);
        for (Reftable reftable : readers) {
            if (!(reftable instanceof ReftableReader)) continue;
            this.adjustUpdateIndexes((ReftableReader)reftable);
        }
    }

    public boolean tryAddFirst(ReftableReader reader2) throws IOException {
        long sz = reader2.size();
        if (this.compactBytesLimit > 0L && this.bytesToCompact + sz > this.compactBytesLimit) {
            return false;
        }
        this.bytesToCompact += sz;
        this.adjustUpdateIndexes(reader2);
        this.tables.addFirst(reader2);
        return true;
    }

    private void adjustUpdateIndexes(ReftableReader reader2) throws IOException {
        this.minUpdateIndex = this.minUpdateIndex == -1L ? reader2.minUpdateIndex() : Math.min(this.minUpdateIndex, reader2.minUpdateIndex());
        this.maxUpdateIndex = Math.max(this.maxUpdateIndex, reader2.maxUpdateIndex());
    }

    public void compact(OutputStream out) throws IOException {
        MergedReftable mr = new MergedReftable(new ArrayList<Reftable>(this.tables));
        mr.setIncludeDeletes(this.includeDeletes);
        this.writer.setMinUpdateIndex(Math.max(this.minUpdateIndex, 0L));
        this.writer.setMaxUpdateIndex(this.maxUpdateIndex);
        this.writer.begin(out);
        this.mergeRefs(mr);
        this.mergeLogs(mr);
        this.writer.finish();
        this.stats = this.writer.getStats();
    }

    public ReftableWriter.Stats getStats() {
        return this.stats;
    }

    private void mergeRefs(MergedReftable mr) throws IOException {
        try (RefCursor rc = mr.allRefs();){
            while (rc.next()) {
                this.writer.writeRef(rc.getRef(), rc.getUpdateIndex());
            }
        }
    }

    private void mergeLogs(MergedReftable mr) throws IOException {
        if (this.oldestReflogTimeMillis == Long.MAX_VALUE) {
            return;
        }
        try (LogCursor lc = mr.allLogs();){
            while (lc.next()) {
                long updateIndex = lc.getUpdateIndex();
                if (updateIndex < this.minUpdateIndex || updateIndex > this.maxUpdateIndex) continue;
                String refName = lc.getRefName();
                ReflogEntry log = lc.getReflogEntry();
                if (log == null) {
                    if (!this.includeDeletes) continue;
                    this.writer.deleteLog(refName, updateIndex);
                    continue;
                }
                PersonIdent who = log.getWho();
                if (who.getWhen().getTime() < this.oldestReflogTimeMillis) continue;
                this.writer.writeLog(refName, updateIndex, who, log.getOldId(), log.getNewId(), log.getComment());
            }
        }
    }
}

