/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0002J\u0014\u0010\n\u001a\u00020\b*\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector;", "", "()V", "getMainFunctionOrNull", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "isMain", "", "allowEmptyParameters", "isSuitableForMainParametersSize", "backend.js"})
public final class JsMainFunctionDetector {
    public static final JsMainFunctionDetector INSTANCE;

    private final boolean isSuitableForMainParametersSize(IrSimpleFunction $this$isSuitableForMainParametersSize, boolean allowEmptyParameters) {
        boolean bl;
        switch ($this$isSuitableForMainParametersSize.getValueParameters().size()) {
            case 1: {
                bl = true;
                break;
            }
            case 0: {
                bl = allowEmptyParameters;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMain(IrSimpleFunction $this$isMain, boolean allowEmptyParameters) {
        boolean bl;
        block19: {
            void $this$filterIsInstanceTo$iv$iv;
            Collection collection = $this$isMain.getTypeParameters();
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                return false;
            }
            if (!this.isSuitableForMainParametersSize($this$isMain, allowEmptyParameters)) {
                return false;
            }
            if (!IrTypePredicatesKt.isUnit($this$isMain.getReturnType())) {
                return false;
            }
            if (Intrinsics.areEqual($this$isMain.getName().asString(), "main") ^ true) {
                return false;
            }
            if ($this$isMain.getExtensionReceiverParameter() != null) {
                return false;
            }
            if ($this$isMain.getValueParameters().size() == 1) {
                IrValueParameter parameter = CollectionsKt.single($this$isMain.getValueParameters());
                if (!IrTypePredicatesKt.isArray(parameter.getType())) {
                    return false;
                }
                IrType irType = parameter.getType();
                if (irType == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
                }
                IrSimpleType type2 = (IrSimpleType)irType;
                if (type2.getArguments().size() != 1) {
                    return false;
                }
                IrTypeArgument irTypeArgument = CollectionsKt.single(type2.getArguments());
                if (!(irTypeArgument instanceof IrTypeProjection)) {
                    irTypeArgument = null;
                }
                IrTypeProjection irTypeProjection = (IrTypeProjection)irTypeArgument;
                if (irTypeProjection == null) {
                    return false;
                }
                IrTypeProjection argument2 = irTypeProjection;
                if (argument2.getVariance() == Variance.IN_VARIANCE) {
                    return false;
                }
                return IrTypePredicatesKt.isString(argument2.getType());
            }
            boolean parameter = false;
            boolean type2 = false;
            type2 = false;
            boolean argument2 = false;
            if (!allowEmptyParameters) {
                boolean bl3 = false;
                String argument2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(argument2.toString());
            }
            parameter = $this$isMain.getValueParameters().isEmpty();
            type2 = false;
            argument2 = false;
            argument2 = false;
            boolean bl4 = false;
            if (!parameter) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            IrDeclarationParent irDeclarationParent = $this$isMain.getParent();
            if (irDeclarationParent == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            }
            IrFile file2 = (IrFile)irDeclarationParent;
            Iterable $this$filterIsInstance$iv = file2.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl6 = false;
                    if (!INSTANCE.isMain(it, false)) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IrSimpleFunction getMainFunctionOrNull(@NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Pair<String, IrSimpleFunction> resultPair = null;
        Iterable $this$forEach$iv = module2.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fqn;
            IrSimpleFunction irSimpleFunction;
            Object v0;
            block5: {
                void $this$filterIsInstanceTo$iv$iv;
                IrFile f = (IrFile)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(f.getFqName().asString(), "f.fqName.asString()");
                Iterable $this$filterIsInstance$iv = f.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv2 : $this$singleOrNull$iv) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv2;
                    boolean bl2 = false;
                    if (!INSTANCE.isMain(it, true)) continue;
                    if (found$iv) {
                        v0 = null;
                        break block5;
                    }
                    single$iv = element$iv2;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            if ((IrSimpleFunction)v0 == null) continue;
            boolean bl = false;
            boolean bl3 = false;
            IrSimpleFunction it = irSimpleFunction;
            boolean bl4 = false;
            Pair<String, IrSimpleFunction> result2 = resultPair;
            if (result2 == null) {
                resultPair = new Pair<String, IrSimpleFunction>(fqn, it);
                continue;
            }
            if (fqn.compareTo((String)result2.getFirst()) >= 0) continue;
            resultPair = new Pair<String, IrSimpleFunction>(fqn, it);
        }
        Pair<String, IrSimpleFunction> pair = resultPair;
        return pair != null ? (IrSimpleFunction)pair.getSecond() : null;
    }

    private JsMainFunctionDetector() {
    }

    static {
        JsMainFunctionDetector jsMainFunctionDetector;
        INSTANCE = jsMainFunctionDetector = new JsMainFunctionDetector();
    }
}

