/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.context.InlineFunctionContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006*\u00020\u0002H\u0002\u001a&\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a \u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\f\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u001a\u001a\u0010\u0016\u001a\u00020\n*\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\"\u0010\u001b\u001a\u00020\u000e*\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"requiresExtensionReceiverParameter", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getRequiresExtensionReceiverParameter", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "getCorrectTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.jvm.PlatformType", "reportInlineFunction", "", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumer;", "descriptor", "translatedFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "sourceInfo", "Lcom/intellij/psi/PsiElement;", "translateAndAliasParameters", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "targetList", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "translateFunction", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "wrapWithInlineMetadata", "outerContext", "js.translator"})
public final class FunctionTranslatorKt {
    @NotNull
    public static final TranslationContext translateAndAliasParameters(@NotNull TranslationContext $this$translateAndAliasParameters, @NotNull FunctionDescriptor descriptor2, @NotNull List<JsParameter> targetList2) {
        boolean bl;
        JsParameter jsParameter;
        Collection collection;
        JsParameter suggestedName;
        Collection paramNameForType;
        Intrinsics.checkNotNullParameter($this$translateAndAliasParameters, "$this$translateAndAliasParameters");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(targetList2, "targetList");
        boolean bl2 = false;
        Map aliases = new LinkedHashMap();
        Iterator<TypeParameterDescriptor> iterator2 = FunctionTranslatorKt.getCorrectTypeParameters(descriptor2).iterator();
        while (iterator2.hasNext()) {
            JsName paramName;
            TypeParameterDescriptor type2;
            TypeParameterDescriptor typeParameterDescriptor = type2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor, "type");
            if (!typeParameterDescriptor.isReified()) continue;
            Intrinsics.checkNotNullExpressionValue($this$translateAndAliasParameters.getNameForDescriptor(type2), "getNameForDescriptor(type)");
            Collection collection2 = targetList2;
            JsParameter jsParameter2 = new JsParameter((JsName)((Object)paramNameForType));
            boolean bl3 = false;
            collection2.add(jsParameter2);
            Intrinsics.checkNotNullExpressionValue(Namer.isInstanceSuggestedName(type2), "Namer.isInstanceSuggestedName(type)");
            Intrinsics.checkNotNullExpressionValue(JsScope.declareTemporaryName((String)((Object)suggestedName)), "JsScope.declareTemporaryName(suggestedName)");
            collection = targetList2;
            jsParameter = new JsParameter(paramName);
            bl = false;
            collection.add(jsParameter);
            JsNameRef jsNameRef = paramName.makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "paramName.makeRef()");
            aliases.put(type2, jsNameRef);
        }
        if (FunctionTranslatorKt.getRequiresExtensionReceiverParameter(descriptor2)) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue(jsName, "JsScope.declareTemporary\u2026tReceiverParameterName())");
            JsName receiverParameterName = jsName;
            JsNameRef jsNameRef = receiverParameterName.makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "receiverParameterName.makeRef()");
            JsNameRef receiverRef = jsNameRef;
            JsExpression jsExpression = receiverRef;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            Intrinsics.checkNotNull(receiverParameterDescriptor);
            Intrinsics.checkNotNullExpressionValue(receiverParameterDescriptor, "descriptor.extensionReceiverParameter!!");
            MetadataProperties.setType(jsExpression, receiverParameterDescriptor.getType());
            ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getExtensionReceiverParameter();
            Intrinsics.checkNotNull(receiverParameterDescriptor2);
            Intrinsics.checkNotNullExpressionValue(receiverParameterDescriptor2, "descriptor.extensionReceiverParameter!!");
            aliases.put(receiverParameterDescriptor2, receiverRef);
            paramNameForType = targetList2;
            suggestedName = new JsParameter(receiverParameterName);
            boolean paramName = false;
            paramNameForType.add(suggestedName);
        }
        for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
            JsNameRef parameterRef;
            JsName tmpName;
            JsName name;
            Intrinsics.checkNotNullExpressionValue($this$translateAndAliasParameters.getNameForDescriptor(valueParameter), "getNameForDescriptor(valueParameter)");
            JsName paramName = JsScope.declareTemporaryName(name.getIdent());
            boolean bl4 = false;
            boolean bl5 = false;
            JsName it = paramName;
            boolean bl6 = false;
            JsName jsName = it;
            Intrinsics.checkNotNullExpressionValue(jsName, "it");
            MetadataProperties.setDescriptor(jsName, (DeclarationDescriptor)valueParameter);
            Intrinsics.checkNotNullExpressionValue(paramName, "JsScope.declareTemporary\u2026riptor = valueParameter }");
            Intrinsics.checkNotNullExpressionValue(JsAstUtils.pureFqn(tmpName, null), "JsAstUtils.pureFqn(tmpName, null)");
            JsExpression jsExpression = parameterRef;
            ValueParameterDescriptor valueParameterDescriptor = valueParameter;
            Intrinsics.checkNotNullExpressionValue(valueParameterDescriptor, "valueParameter");
            MetadataProperties.setType(jsExpression, valueParameterDescriptor.getType());
            aliases.put(valueParameter, parameterRef);
            collection = targetList2;
            jsParameter = new JsParameter(tmpName);
            bl = false;
            boolean bl7 = false;
            JsParameter $this$apply = jsParameter;
            boolean bl8 = false;
            MetadataProperties.setHasDefaultValue($this$apply, ArgumentsUtilsKt.hasDefaultValue(valueParameter));
            bl = false;
            collection.add(jsParameter);
        }
        ValueParameterDescriptor continuationDescriptor = $this$translateAndAliasParameters.getContinuationParameterDescriptor();
        if (continuationDescriptor != null) {
            JsParameter jsParameter3 = new JsParameter($this$translateAndAliasParameters.getNameForDescriptor(continuationDescriptor));
            Collection collection3 = targetList2;
            boolean bl9 = false;
            collection3.add(jsParameter3);
            JsExpression jsExpression = JsAstUtils.stateMachineReceiver();
            Intrinsics.checkNotNullExpressionValue(jsExpression, "JsAstUtils.stateMachineReceiver()");
            aliases.put(continuationDescriptor, jsExpression);
        }
        TranslationContext translationContext = $this$translateAndAliasParameters.innerContextWithDescriptorsAliased(aliases);
        Intrinsics.checkNotNullExpressionValue(translationContext, "this.innerContextWithDescriptorsAliased(aliases)");
        return translationContext;
    }

    private static final List<TypeParameterDescriptor> getCorrectTypeParameters(FunctionDescriptor $this$getCorrectTypeParameters) {
        List<TypeParameterDescriptor> list2;
        FunctionDescriptor functionDescriptor = $this$getCorrectTypeParameters;
        if (!(functionDescriptor instanceof PropertyAccessorDescriptor)) {
            functionDescriptor = null;
        }
        if ((list2 = (PropertyAccessorDescriptor)functionDescriptor) == null || (list2 = list2.getCorrespondingProperty()) == null || (list2 = list2.getTypeParameters()) == null) {
            list2 = $this$getCorrectTypeParameters.getTypeParameters();
        }
        Intrinsics.checkNotNullExpressionValue(list2, "(this as? PropertyAccess\u2026ameters ?: typeParameters");
        return list2;
    }

    private static final boolean getRequiresExtensionReceiverParameter(FunctionDescriptor $this$requiresExtensionReceiverParameter) {
        return DescriptorUtils.isExtension($this$requiresExtensionReceiverParameter);
    }

    public static final void translateFunction(@NotNull TranslationContext $this$translateFunction, @NotNull KtDeclarationWithBody declaration2, @NotNull JsFunction function2) {
        Intrinsics.checkNotNullParameter($this$translateFunction, "$this$translateFunction");
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(function2, "function");
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor($this$translateFunction.bindingContext(), declaration2);
        Intrinsics.checkNotNullExpressionValue(functionDescriptor, "BindingUtils.getFunction\u2026ngContext(), declaration)");
        FunctionDescriptor descriptor2 = functionDescriptor;
        if (declaration2.hasBody()) {
            JsBlock jsBlock = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration2, $this$translateFunction);
            Intrinsics.checkNotNullExpressionValue(jsBlock, "translateFunctionBody(de\u2026iptor, declaration, this)");
            JsBlock body2 = jsBlock;
            JsBlock jsBlock2 = function2.getBody();
            Intrinsics.checkNotNullExpressionValue(jsBlock2, "function.body");
            Collection collection = jsBlock2.getStatements();
            List<JsStatement> list2 = body2.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "body.statements");
            Iterable iterable = list2;
            boolean bl = false;
            CollectionsKt.addAll(collection, iterable);
        }
        MetadataProperties.setFunctionDescriptor(function2, descriptor2);
    }

    @NotNull
    public static final JsExpression wrapWithInlineMetadata(@NotNull TranslationContext $this$wrapWithInlineMetadata, @NotNull TranslationContext outerContext, @NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter($this$wrapWithInlineMetadata, "$this$wrapWithInlineMetadata");
        Intrinsics.checkNotNullParameter(outerContext, "outerContext");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue(sourceElement, "descriptor.source");
        PsiElement sourceInfo = KotlinSourceElementKt.getPsi(sourceElement);
        if (descriptor2.isInline()) {
            IncrementalResultsConsumer incrementalResults;
            boolean bl;
            JsExpression jsExpression2;
            DeclarationDescriptor declarationDescriptor = descriptor2;
            JsConfig jsConfig = $this$wrapWithInlineMetadata.getConfig();
            Intrinsics.checkNotNullExpressionValue(jsConfig, "config");
            if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.shouldBeExported(declarationDescriptor, jsConfig)) {
                InlineMetadata metadata = InlineMetadata.Companion.compose(function2, descriptor2, $this$wrapWithInlineMetadata);
                jsExpression2 = metadata.functionWithMetadata(outerContext, sourceInfo);
            } else {
                InlineFunctionContext inlineFunctionContext = $this$wrapWithInlineMetadata.getInlineFunctionContext();
                Intrinsics.checkNotNull(inlineFunctionContext);
                InlineFunctionContext inlineFunctionContext2 = inlineFunctionContext;
                bl = false;
                boolean bl2 = false;
                InlineFunctionContext it = inlineFunctionContext2;
                boolean bl3 = false;
                List<JsStatement> list2 = it.getImportBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, "it.importBlock.statements");
                Collection collection = list2;
                List<JsStatement> list3 = it.getPrototypeBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(list3, "it.prototypeBlock.statements");
                Collection collection2 = CollectionsKt.plus(collection, (Iterable)list3);
                List<JsStatement> list4 = it.getDeclarationsBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(list4, "it.declarationsBlock.statements");
                JsBlock block = new JsBlock(CollectionsKt.plus((Collection)CollectionsKt.plus(collection2, (Iterable)list4), new JsReturn(function2)));
                jsExpression2 = InlineMetadata.Companion.wrapFunction(outerContext, new FunctionWithWrapper(function2, block), sourceInfo);
            }
            JsExpression jsExpression3 = jsExpression2;
            boolean bl4 = false;
            bl = false;
            JsExpression it = jsExpression3;
            boolean bl5 = false;
            JsConfig jsConfig2 = $this$wrapWithInlineMetadata.getConfig();
            Intrinsics.checkNotNullExpressionValue(jsConfig2, "config");
            IncrementalResultsConsumer incrementalResultsConsumer = incrementalResults = jsConfig2.getConfiguration().get(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER);
            if (incrementalResultsConsumer != null) {
                FunctionTranslatorKt.reportInlineFunction(incrementalResultsConsumer, descriptor2, it, sourceInfo);
            }
            jsExpression = jsExpression3;
        } else {
            jsExpression = function2;
        }
        return jsExpression;
    }

    private static final void reportInlineFunction(IncrementalResultsConsumer $this$reportInlineFunction, FunctionDescriptor descriptor2, JsExpression translatedFunction, PsiElement sourceInfo) {
        String string2;
        Object object;
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue(sourceElement, "descriptor.source");
        SourceFile sourceFile = sourceElement.getContainingFile();
        if (!(sourceFile instanceof PsiSourceFile)) {
            sourceFile = null;
        }
        if ((object = (PsiSourceFile)sourceFile) == null || (object = ((PsiSourceFile)object).getPsiFile()) == null) {
            return;
        }
        Object psiFile = object;
        File file2 = VfsUtilCore.virtualToIoFile(psiFile.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue(file2, "VfsUtilCore.virtualToIoFile(psiFile.virtualFile)");
        File file3 = file2;
        Visibility visibility = descriptor2.getVisibility();
        Intrinsics.checkNotNullExpressionValue(visibility, "descriptor.visibility");
        if (EffectiveVisibilityKt.effectiveVisibility(visibility, descriptor2, true).getPrivateApi()) {
            return;
        }
        FunctionDescriptor functionDescriptor = descriptor2;
        if (functionDescriptor instanceof PropertyGetterDescriptor) {
            StringBuilder stringBuilder2 = new StringBuilder().append("<get>");
            PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "descriptor.correspondingProperty");
            string2 = stringBuilder2.append(DescriptorUtilsKt.getFqNameSafe(propertyDescriptor).asString()).toString();
        } else if (functionDescriptor instanceof PropertySetterDescriptor) {
            StringBuilder stringBuilder3 = new StringBuilder().append("<set>");
            PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "descriptor.correspondingProperty");
            string2 = stringBuilder3.append(DescriptorUtilsKt.getFqNameSafe(propertyDescriptor).asString()).toString();
        } else {
            String string3 = DescriptorUtilsKt.getFqNameSafe(descriptor2).asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "descriptor.fqNameSafe.asString()");
        }
        String fqName2 = string2;
        UserDataHolder userDataHolder = sourceInfo;
        Integer offset2 = userDataHolder != null && (userDataHolder = userDataHolder.getNode()) != null ? Integer.valueOf(userDataHolder.getStartOffset()) : null;
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        Intrinsics.checkNotNullExpressionValue(fileViewProvider, "psiFile.viewProvider");
        Document document = fileViewProvider.getDocument();
        int sourceLine = -1;
        int sourceColumn = -1;
        if (offset2 != null && document != null) {
            sourceLine = document.getLineNumber(offset2);
            sourceColumn = offset2 - document.getLineStartOffset(sourceLine);
        }
        $this$reportInlineFunction.processInlineFunction(file3, fqName2, translatedFunction, sourceLine, sourceColumn);
    }
}

