/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.anim.values.AnimatableBooleanValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedBoolean;

public class SVGOMAnimatedBoolean
extends AbstractSVGAnimatedValue
implements SVGAnimatedBoolean {
    protected boolean defaultValue;
    protected boolean valid;
    protected boolean baseVal;
    protected boolean animVal;
    protected boolean changing;

    public SVGOMAnimatedBoolean(AbstractElement abstractElement, String string, String string2, boolean bl) {
        super(abstractElement, string, string2);
        this.defaultValue = bl;
    }

    public boolean getBaseVal() {
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    protected void update() {
        Attr attr = this.element.getAttributeNodeNS(this.namespaceURI, this.localName);
        this.baseVal = attr == null ? this.defaultValue : attr.getValue().equals("true");
        this.valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaseVal(boolean bl) throws DOMException {
        try {
            this.baseVal = bl;
            this.valid = true;
            this.changing = true;
            this.element.setAttributeNS(this.namespaceURI, this.localName, String.valueOf(bl));
        }
        finally {
            this.changing = false;
        }
    }

    public boolean getAnimVal() {
        if (this.hasAnimVal) {
            return this.animVal;
        }
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    public void setAnimatedValue(boolean bl) {
        this.hasAnimVal = true;
        this.animVal = bl;
        this.fireAnimatedAttributeListeners();
    }

    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            this.animVal = ((AnimatableBooleanValue)animatableValue).getValue();
        }
        this.fireAnimatedAttributeListeners();
    }

    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        return new AnimatableBooleanValue(animationTarget, this.getBaseVal());
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }
}

