# -*- coding: utf-8 -*-
info = {
    "name": "ms",
    "date_order": "DMY",
    "january": [
        "januari",
        "jan"
    ],
    "february": [
        "februari",
        "feb"
    ],
    "march": [
        "mac"
    ],
    "april": [
        "april",
        "apr"
    ],
    "may": [
        "mei"
    ],
    "june": [
        "jun"
    ],
    "july": [
        "julai",
        "jul"
    ],
    "august": [
        "ogos",
        "ogo"
    ],
    "september": [
        "september",
        "sep"
    ],
    "october": [
        "oktober",
        "okt"
    ],
    "november": [
        "november",
        "nov"
    ],
    "december": [
        "disember",
        "dis"
    ],
    "monday": [
        "isnin",
        "isn"
    ],
    "tuesday": [
        "selasa",
        "sel"
    ],
    "wednesday": [
        "rabu",
        "rab"
    ],
    "thursday": [
        "khamis",
        "kha"
    ],
    "friday": [
        "jumaat",
        "jum"
    ],
    "saturday": [
        "sabtu",
        "sab"
    ],
    "sunday": [
        "ahad",
        "ahd"
    ],
    "am": [
        "pg"
    ],
    "pm": [
        "ptg"
    ],
    "year": [
        "tahun",
        "thn"
    ],
    "month": [
        "bulan",
        "bln"
    ],
    "week": [
        "minggu",
        "mgu"
    ],
    "day": [
        "hari"
    ],
    "hour": [
        "jam"
    ],
    "minute": [
        "minit",
        "min"
    ],
    "second": [
        "saat"
    ],
    "relative-type": {
        "1 year ago": [
            "tahun lalu",
            "thn lepas"
        ],
        "0 year ago": [
            "tahun ini",
            "thn ini"
        ],
        "in 1 year": [
            "tahun depan",
            "thn depan"
        ],
        "1 month ago": [
            "bulan lalu",
            "bln lalu"
        ],
        "0 month ago": [
            "bulan ini",
            "bln ini"
        ],
        "in 1 month": [
            "bulan depan",
            "bln depan"
        ],
        "1 week ago": [
            "minggu lalu",
            "mng lepas"
        ],
        "0 week ago": [
            "minggu ini",
            "mng ini"
        ],
        "in 1 week": [
            "minggu depan",
            "mng depan"
        ],
        "1 day ago": [
            "semalam",
            "semlm"
        ],
        "0 day ago": [
            "hari ini"
        ],
        "in 1 day": [
            "esok"
        ],
        "0 hour ago": [
            "jam ini"
        ],
        "0 minute ago": [
            "pada minit ini"
        ],
        "0 second ago": [
            "sekarang"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "dalam (\\d+) saat",
            "dalam (\\d+) thn"
        ],
        "\\1 year ago": [
            "(\\d+) tahun lalu",
            "(\\d+) thn lalu"
        ],
        "in \\1 month": [
            "dalam (\\d+) bulan",
            "dlm (\\d+) bln"
        ],
        "\\1 month ago": [
            "(\\d+) bulan lalu",
            "(\\d+) bln lalu"
        ],
        "in \\1 week": [
            "dalam (\\d+) minggu",
            "dlm (\\d+) mgu"
        ],
        "\\1 week ago": [
            "(\\d+) minggu lalu",
            "(\\d+) mgu lalu"
        ],
        "in \\1 day": [
            "dalam (\\d+) hari",
            "dlm (\\d+) hari"
        ],
        "\\1 day ago": [
            "(\\d+) hari lalu"
        ],
        "in \\1 hour": [
            "dalam (\\d+) jam",
            "dlm (\\d+) jam"
        ],
        "\\1 hour ago": [
            "(\\d+) jam lalu"
        ],
        "in \\1 minute": [
            "dalam (\\d+) minit",
            "dlm (\\d+) min"
        ],
        "\\1 minute ago": [
            "(\\d+) minit lalu",
            "(\\d+) min lalu"
        ],
        "in \\1 second": [
            "dalam (\\d+) saat",
            "dlm (\\d+) saat"
        ],
        "\\1 second ago": [
            "(\\d+) saat lalu"
        ]
    },
    "locale_specific": {
        "ms-SG": {
            "name": "ms-SG"
        },
        "ms-BN": {
            "name": "ms-BN"
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
