/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.Font;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.diagram.AbstractPaintDevice;
import net.sf.sdedit.diagram.DiagramDataProvider;
import net.sf.sdedit.diagram.DiagramFactory;
import net.sf.sdedit.diagram.GraphicDevice;
import net.sf.sdedit.diagram.PaintDevice;
import net.sf.sdedit.diagram.SDPaintDevice;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.diagram.SequenceDiagramFactory;
import net.sf.sdedit.error.DiagramError;
import net.sf.sdedit.error.FatalError;
import net.sf.sdedit.error.SemanticError;
import net.sf.sdedit.text.TextHandler;
import net.sf.sdedit.ui.PanelGraphicDevice;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.impl.DiagramTextTab;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;

public class SequenceDiagramTextTab
extends DiagramTextTab {
    private static final long serialVersionUID = 5278509849011224397L;

    public SequenceDiagramTextTab(UserInterfaceImpl ui, Font codeFont, Bean<? extends Configuration> configuration) {
        super(ui, codeFont, configuration);
    }

    @Override
    public DiagramDataProvider createProvider() {
        return new TextHandler(this.getCode());
    }

    private SequenceDiagram diagram() {
        return (SequenceDiagram)this.getDiagram();
    }

    @Override
    protected boolean _handleDiagramError(DiagramError error) {
        if (error == null) {
            int noteNumber;
            this.setError(false, "", -1, -1);
            if (this.diagram().getFragmentManager().openFragmentsExist()) {
                this.setError(true, "Warning: There are open comments. Use [c:<type> <text>]...[/c]", -1, -1);
            }
            if ((noteNumber = this.diagram().getNextFreeNoteNumber()) == 0) {
                this.setStatus("");
            } else {
                this.setStatus("Next note number: " + this.diagram().getNextFreeNoteNumber());
            }
        } else if (!(error instanceof FatalError)) {
            TextHandler handler = (TextHandler)error.getProvider();
            String prefix = "";
            if (error instanceof SemanticError) {
                prefix = this.diagram().isThreaded() && this.diagram().getCallerThread() != -1 ? "Thread " + this.diagram().getCallerThread() + ": " : "";
            }
            this.setError(false, prefix + error.getMessage(), handler.getLineBegin(), handler.getLineEnd());
        } else {
            return false;
        }
        return true;
    }

    @Override
    public DiagramFactory createFactory(PaintDevice paintDevice) {
        return new SequenceDiagramFactory(this, paintDevice);
    }

    @Override
    public String getCategory() {
        return "Sequence diagrams";
    }

    @Override
    public AbstractPaintDevice createPaintDevice(GraphicDevice graphicDevice) {
        if (graphicDevice == null) {
            PanelGraphicDevice ppd = new PanelGraphicDevice(true);
            if (this.getInteraction() != null) {
                ppd.setPartner(this.getInteraction());
            }
            graphicDevice = ppd;
        }
        return new SDPaintDevice(graphicDevice);
    }
}

