/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.vsm;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.text.vsm.ITermWeighting;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class TermDocumentMatrixBuilderDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.vsm.TermDocumentMatrixBuilder";
    public final String prefix = "TermDocumentMatrixBuilder";
    public final String title = "Builds a term document matrix based on the provided <code>PreprocessingContext</code>";
    public final String label = "";
    public final String description = "";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "TermDocumentMatrixBuilder";
    }

    public String getTitle() {
        return "Builds a term document matrix based on the provided <code>PreprocessingContext</code>";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(TermDocumentMatrixBuilderDescriptor.attributes.titleWordsBoost);
        ownAttrs.add(TermDocumentMatrixBuilderDescriptor.attributes.maximumMatrixSize);
        ownAttrs.add(TermDocumentMatrixBuilderDescriptor.attributes.maxWordDf);
        ownAttrs.add(TermDocumentMatrixBuilderDescriptor.attributes.termWeighting);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(TermDocumentMatrixBuilderDescriptor.attributes.titleWordsBoost);
        allAttrs.add(TermDocumentMatrixBuilderDescriptor.attributes.maximumMatrixSize);
        allAttrs.add(TermDocumentMatrixBuilderDescriptor.attributes.maxWordDf);
        allAttrs.add(TermDocumentMatrixBuilderDescriptor.attributes.termWeighting);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder titleWordsBoost(double value) {
            this.map.put("TermDocumentMatrixBuilder.titleWordsBoost", value);
            return this;
        }

        public AttributeBuilder titleWordsBoost(IObjectFactory<? extends Double> value) {
            this.map.put("TermDocumentMatrixBuilder.titleWordsBoost", value);
            return this;
        }

        public AttributeBuilder maximumMatrixSize(int value) {
            this.map.put("TermDocumentMatrixBuilder.maximumMatrixSize", value);
            return this;
        }

        public AttributeBuilder maximumMatrixSize(IObjectFactory<? extends Integer> value) {
            this.map.put("TermDocumentMatrixBuilder.maximumMatrixSize", value);
            return this;
        }

        public AttributeBuilder maxWordDf(double value) {
            this.map.put("TermDocumentMatrixBuilder.maxWordDf", value);
            return this;
        }

        public AttributeBuilder maxWordDf(IObjectFactory<? extends Double> value) {
            this.map.put("TermDocumentMatrixBuilder.maxWordDf", value);
            return this;
        }

        public AttributeBuilder termWeighting(ITermWeighting value) {
            this.map.put("TermDocumentMatrixBuilder.termWeighting", value);
            return this;
        }

        public AttributeBuilder termWeighting(Class<?> clazz) {
            this.map.put("TermDocumentMatrixBuilder.termWeighting", clazz);
            return this;
        }

        public AttributeBuilder termWeighting(IObjectFactory<? extends ITermWeighting> value) {
            this.map.put("TermDocumentMatrixBuilder.termWeighting", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo titleWordsBoost = new AttributeInfo("TermDocumentMatrixBuilder.titleWordsBoost", "org.carrot2.text.vsm.TermDocumentMatrixBuilder", "titleWordsBoost", "Title word boost. Gives more weight to words that appeared in\n{@link org.carrot2.core.Document#TITLE} fields.", null, "Title word boost", "Gives more weight to words that appeared in <code>org.carrot2.core.Document.TITLE</code> fields.", "Labels", AttributeLevel.MEDIUM, null);
        public final AttributeInfo maximumMatrixSize = new AttributeInfo("TermDocumentMatrixBuilder.maximumMatrixSize", "org.carrot2.text.vsm.TermDocumentMatrixBuilder", "maximumMatrixSize", "Maximum matrix size. The maximum number of the term-document matrix elements. The\nlarger the size, the more accurate, time- and memory-consuming clustering.", null, "Maximum matrix size", "The maximum number of the term-document matrix elements. The larger the size, the more accurate, time- and memory-consuming clustering.", "Matrix model", AttributeLevel.ADVANCED, null);
        public final AttributeInfo maxWordDf = new AttributeInfo("TermDocumentMatrixBuilder.maxWordDf", "org.carrot2.text.vsm.TermDocumentMatrixBuilder", "maxWordDf", "Maximum word document frequency. The maximum document frequency allowed for words\nas a fraction of all documents. Words with document frequency larger than\n<code>maxWordDf</code> will be ignored. For example, when <code>maxWordDf</code> is\n<code>0.4</code>, words appearing in more than 40% of documents will be be ignored.\nA value of <code>1.0</code> means that all words will be taken into\naccount, no matter in how many documents they appear.\n<p>\nThis attribute may be useful when certain words appear in most of the input\ndocuments (e.g. company name from header or footer) and such words dominate the\ncluster labels. In such case, setting <code>maxWordDf</code> to a value lower than\n<code>1.0</code>, e.g. <code>0.9</code> may improve the clusters. \n</p>\n<p>\nAnother useful application of this attribute is when there is a need to generate\nonly very specific clusters, i.e. clusters containing small numbers of documents.\nThis can be achieved by setting <code>maxWordDf</code> to extremely low values,\ne.g. <code>0.1</code> or <code>0.05</code>.\n</p>", null, "Maximum word document frequency", "The maximum document frequency allowed for words as a fraction of all documents. Words with document frequency larger than <code>maxWordDf</code> will be ignored. For example, when <code>maxWordDf</code> is <code>0.4</code>, words appearing in more than 40% of documents will be be ignored. A value of <code>1.0</code> means that all words will be taken into account, no matter in how many documents they appear. <p> This attribute may be useful when certain words appear in most of the input documents (e.g. company name from header or footer) and such words dominate the cluster labels. In such case, setting <code>maxWordDf</code> to a value lower than <code>1.0</code>, e.g. <code>0.9</code> may improve the clusters. </p> <p> Another useful application of this attribute is when there is a need to generate only very specific clusters, i.e. clusters containing small numbers of documents. This can be achieved by setting <code>maxWordDf</code> to extremely low values, e.g. <code>0.1</code> or <code>0.05</code>. </p>", "Matrix model", AttributeLevel.ADVANCED, null);
        public final AttributeInfo termWeighting = new AttributeInfo("TermDocumentMatrixBuilder.termWeighting", "org.carrot2.text.vsm.TermDocumentMatrixBuilder", "termWeighting", "Term weighting. The method for calculating weight of words in the term-document\nmatrices.", null, "Term weighting", "The method for calculating weight of words in the term-document matrices.", "Matrix model", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String TITLE_WORDS_BOOST = "TermDocumentMatrixBuilder.titleWordsBoost";
        public static final String MAXIMUM_MATRIX_SIZE = "TermDocumentMatrixBuilder.maximumMatrixSize";
        public static final String MAX_WORD_DF = "TermDocumentMatrixBuilder.maxWordDf";
        public static final String TERM_WEIGHTING = "TermDocumentMatrixBuilder.termWeighting";

        protected Keys() {
        }
    }
}

