/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp4;

import com.drew.imaging.mp4.Mp4Handler;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Metadata;
import com.drew.metadata.mp4.Mp4HandlerFactory;
import com.drew.metadata.mp4.boxes.Box;
import com.drew.metadata.mp4.media.Mp4MediaDirectory;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public abstract class Mp4MediaHandler<T extends Mp4MediaDirectory>
extends Mp4Handler<T> {
    public Mp4MediaHandler(Metadata metadata) {
        super(metadata);
        if (Mp4HandlerFactory.HANDLER_PARAM_CREATION_TIME != null && Mp4HandlerFactory.HANDLER_PARAM_MODIFICATION_TIME != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1904, 0, 1, 0, 0, 0);
            Date date = calendar.getTime();
            long macToUnixEpochOffset = date.getTime();
            String creationTimeStamp = new Date(Mp4HandlerFactory.HANDLER_PARAM_CREATION_TIME * 1000L + macToUnixEpochOffset).toString();
            String modificationTimeStamp = new Date(Mp4HandlerFactory.HANDLER_PARAM_MODIFICATION_TIME * 1000L + macToUnixEpochOffset).toString();
            String language = Mp4HandlerFactory.HANDLER_PARAM_LANGUAGE;
            ((Mp4MediaDirectory)this.directory).setString(101, creationTimeStamp);
            ((Mp4MediaDirectory)this.directory).setString(102, modificationTimeStamp);
            ((Mp4MediaDirectory)this.directory).setString(104, language);
        }
    }

    @Override
    public boolean shouldAcceptBox(@NotNull Box box) {
        return box.type.equals(this.getMediaInformation()) || box.type.equals("stsd") || box.type.equals("stts");
    }

    @Override
    public boolean shouldAcceptContainer(@NotNull Box box) {
        return box.type.equals("stbl") || box.type.equals("minf");
    }

    @Override
    public Mp4Handler processBox(@NotNull Box box, @Nullable byte[] payload) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (box.type.equals(this.getMediaInformation())) {
                this.processMediaInformation(reader, box);
            } else if (box.type.equals("stsd")) {
                this.processSampleDescription(reader, box);
            } else if (box.type.equals("stts")) {
                this.processTimeToSample(reader, box);
            }
        }
        return this;
    }

    protected abstract String getMediaInformation();

    protected abstract void processSampleDescription(@NotNull SequentialReader var1, @NotNull Box var2) throws IOException;

    protected abstract void processMediaInformation(@NotNull SequentialReader var1, @NotNull Box var2) throws IOException;

    protected abstract void processTimeToSample(@NotNull SequentialReader var1, @NotNull Box var2) throws IOException;
}

