/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

class GUID
implements Comparable<GUID> {
    int[] guid;

    public static GUID fromCurlyBraceUTF16Bytes(byte[] guid) {
        int[] intGuid = new int[16];
        String utf16Str = new String(guid, StandardCharsets.UTF_16LE).replaceAll("\\{", "").replaceAll("-", "").replaceAll("}", "");
        for (int i = 0; i < utf16Str.length(); i += 2) {
            intGuid[i / 2] = Integer.parseUnsignedInt("" + utf16Str.charAt(i) + utf16Str.charAt(i + 1), 16);
        }
        return new GUID(intGuid);
    }

    @Override
    public int compareTo(GUID o) {
        return GUID.memcmp(this.guid, o.guid, 16);
    }

    public GUID(int[] guid) {
        this.guid = guid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GUID guid1 = (GUID)o;
        return Arrays.equals(this.guid, guid1.guid);
    }

    public int hashCode() {
        return Arrays.hashCode(this.guid);
    }

    public static int memcmp(int[] b1, int[] b2, int sz) {
        for (int i = 0; i < sz; ++i) {
            if (b1[i] == b2[i]) continue;
            if (b1[i] >= 0 && b2[i] >= 0 || b1[i] < 0 && b2[i] < 0) {
                return b1[i] - b2[i];
            }
            if (b1[i] < 0 && b2[i] >= 0) {
                return 1;
            }
            if (b2[i] >= 0 || b1[i] < 0) continue;
            return -1;
        }
        return 0;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (i = 0; i < 4; ++i) {
            sb.append(StringUtils.leftPad((String)Integer.toHexString(this.guid[i]), (int)2, (char)'0'));
        }
        sb.append("-");
        for (i = 4; i < 6; ++i) {
            sb.append(StringUtils.leftPad((String)Integer.toHexString(this.guid[i]), (int)2, (char)'0'));
        }
        sb.append("-");
        for (i = 6; i < 8; ++i) {
            sb.append(StringUtils.leftPad((String)Integer.toHexString(this.guid[i]), (int)2, (char)'0'));
        }
        sb.append("-");
        for (i = 8; i < 10; ++i) {
            sb.append(StringUtils.leftPad((String)Integer.toHexString(this.guid[i]), (int)2, (char)'0'));
        }
        sb.append("-");
        for (i = 10; i < 16; ++i) {
            sb.append(StringUtils.leftPad((String)Integer.toHexString(this.guid[i]), (int)2, (char)'0'));
        }
        sb.append("}");
        return sb.toString().toUpperCase(Locale.US);
    }

    public static GUID nil() {
        return new GUID(new int[16]);
    }

    public int[] getGuid() {
        return this.guid;
    }

    public GUID setGuid(int[] guid) {
        this.guid = guid;
        return this;
    }

    public String getGuidString() {
        return this.guid.toString();
    }
}

