/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NullSceneGraphObjectState;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;

public class BackgroundState
extends LeafState {
    private int image;
    private int boundingLeaf;
    private SceneGraphObjectState branchState;

    public BackgroundState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.boundingLeaf = controller.getSymbolTable().addReference((SceneGraphObject)((Background)this.node).getApplicationBoundingLeaf());
            this.image = controller.getSymbolTable().addReference((SceneGraphObject)((Background)this.node).getImage());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.boundingLeaf);
        dataOutput.writeInt(0);
        dataOutput.writeInt(this.image);
        this.control.writeBounds(dataOutput, ((Background)this.node).getApplicationBounds());
        Color3f color3f = new Color3f();
        ((Background)this.node).getColor(color3f);
        this.control.writeColor3f(dataOutput, color3f);
        dataOutput.writeInt(((Background)this.node).getImageScaleMode());
        this.control.writeObject(dataOutput, this.control.createState((SceneGraphObject)((Background)this.node).getGeometry()));
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.boundingLeaf = dataInput.readInt();
        dataInput.readInt();
        this.image = dataInput.readInt();
        ((Background)this.node).setApplicationBounds(this.control.readBounds(dataInput));
        ((Background)this.node).setColor(this.control.readColor3f(dataInput));
        ((Background)this.node).setImageScaleMode(dataInput.readInt());
        if (this.control.getCurrentFileVersion() < 4) {
            return;
        }
        this.branchState = this.control.readObject(dataInput);
        if (!(this.branchState instanceof NullSceneGraphObjectState)) {
            ((Background)this.node).setGeometry((BranchGroup)this.branchState.getNode());
        }
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.image);
    }

    public void buildGraph() {
        ((Background)this.node).setApplicationBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        ((Background)this.node).setImage((ImageComponent2D)this.control.getSymbolTable().getJ3dNode(this.image));
        if (this.branchState != null && !this.branchState.getSymbol().graphBuilt) {
            this.branchState.buildGraph();
            this.branchState.getSymbol().graphBuilt = true;
        }
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new Background();
    }
}

