#!/usr/bin/env perl
# BEGIN COPYRIGHT BLOCK
# Copyright (C) 2013 Red Hat, Inc.
# All rights reserved.
#
# License: GPL (version 3 or any later version).
# See LICENSE for details. 
# END COPYRIGHT BLOCK
#

use lib qw(/usr/lib/dirsrv/perl);

use strict;

use Setup;
use SetupLog;
use Inf;
use Resource;
use DialogManager;
use DSUtil;
use DSCreate;
use DSUpdate;

my $res = new Resource("/usr/share/dirsrv/properties/setup-ds.res");

my $setup = new Setup($res);

if (!$setup->{silent}) {
    my $dialogmgr = new DialogManager($setup, $res, $TYPICAL);

    my @dialogs;
    if ($setup->{update}) {
        require DSUpdateDialogs;
        push @dialogs, DSUpdateDialogs->getDialogs();
    } else {
        require SetupDialogs;
        require DSDialogs;
        push @dialogs, SetupDialogs->getDialogs();
        push @dialogs, DSDialogs->getDialogs();
    }

    $dialogmgr->addDialog(@dialogs);

    my $rc = $dialogmgr->run();
    if ($rc) {
        $setup->doExit();
    }
}

my @errs;
if ($setup->{update}) {
    @errs = updateDS($setup);
} else {
    @errs = createDSInstance($setup->{inf});
}

if (@errs) {
    $setup->msg(@errs);
    if ($setup->{update}) {
        $setup->msg($FATAL, 'error_updating');
    } else {
        if($setup->{inf}->{slapd}->{ServerIdentifier} eq "admin"){
            # 'admin' is reserved for the admin server - log the correct error 
            $setup->msg($FATAL, 'error_creating_dsinstance_adminid',
                    $setup->{inf}->{slapd}->{ServerIdentifier});
        } else {
            $setup->msg($FATAL, 'error_creating_dsinstance',
                    $setup->{inf}->{slapd}->{ServerIdentifier});
        }
    }
    $setup->doExit(1);
} else {
    if ($setup->{update}) {
        $setup->msg('update_successful');
    } else {
        $setup->msg('created_dsinstance',
                    $setup->{inf}->{slapd}->{ServerIdentifier});
    }
}

$setup->doExit(0);

END {
    if ($setup and $setup->{keep}) {
        $setup->{inf}->write("__temp__");
    }
}

# emacs settings
# Local Variables:
# mode:perl
# indent-tabs-mode: nil
# tab-width: 4
# End:
