/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_mn extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "\u043d\u044d\u0433\u0434\u04af\u0433\u044d\u044d\u0440 \u0441\u0430\u0440",
               "\u0445\u043e\u0451\u0440\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
               "\u0433\u0443\u0440\u0430\u0432\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
               "\u0434\u04e9\u0440\u04e9\u0432\u0434\u04af\u0433\u044d\u044d\u0440 \u0441\u0430\u0440",
               "\u0442\u0430\u0432\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
               "\u0437\u0443\u0440\u0433\u0430\u0430\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
               "\u0434\u043e\u043b\u043e\u043e\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
               "\u043d\u0430\u0439\u043c\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
               "\u0435\u0441\u0434\u04af\u0433\u044d\u044d\u0440 \u0441\u0430\u0440",
               "\u0430\u0440\u0430\u0432\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
               "\u0430\u0440\u0432\u0430\u043d \u043d\u044d\u0433\u0434\u04af\u0433\u044d\u044d\u0440 \u0441\u0430\u0440",
               "\u0430\u0440\u0432\u0430\u043d \u0445\u043e\u0451\u0440\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "1-\u0440 \u0441\u0430\u0440",
               "2-\u0440 \u0441\u0430\u0440",
               "3-\u0440 \u0441\u0430\u0440",
               "4-\u0440 \u0441\u0430\u0440",
               "5-\u0440 \u0441\u0430\u0440",
               "6-\u0440 \u0441\u0430\u0440",
               "7-\u0440 \u0441\u0430\u0440",
               "8-\u0440 \u0441\u0430\u0440",
               "9-\u0440 \u0441\u0430\u0440",
               "10-\u0440 \u0441\u0430\u0440",
               "11-\u0440 \u0441\u0430\u0440",
               "12-\u0440 \u0441\u0430\u0440",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "I",
               "II",
               "III",
               "IV",
               "V",
               "VI",
               "VII",
               "VIII",
               "IX",
               "X",
               "XI",
               "XII",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u043d\u044f\u043c",
               "\u0434\u0430\u0432\u0430\u0430",
               "\u043c\u044f\u0433\u043c\u0430\u0440",
               "\u043b\u0445\u0430\u0433\u0432\u0430",
               "\u043f\u04af\u0440\u044d\u0432",
               "\u0431\u0430\u0430\u0441\u0430\u043d",
               "\u0431\u044f\u043c\u0431\u0430",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\u041d\u044f",
               "\u0414\u0430",
               "\u041c\u044f",
               "\u041b\u0445",
               "\u041f\u04af",
               "\u0411\u0430",
               "\u0411\u044f",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "1-\u0440 \u0443\u043b\u0438\u0440\u0430\u043b",
               "2-\u0440 \u0443\u043b\u0438\u0440\u0430\u043b",
               "3-\u0440 \u0443\u043b\u0438\u0440\u0430\u043b",
               "4-\u0440 \u0443\u043b\u0438\u0440\u0430\u043b",
            };
        final String[] metaValue_QuarterAbbreviations = new String[] {
               "I \u0443\u043b\u0438\u0440\u0430\u043b",
               "II \u0443\u043b\u0438\u0440\u0430\u043b",
               "III \u0443\u043b\u0438\u0440\u0430\u043b",
               "IV \u0443\u043b\u0438\u0440\u0430\u043b",
            };
        final String[] metaValue_QuarterNarrows = new String[] {
               "I",
               "II",
               "III",
               "IV",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "\u04af.\u04e9.",
               "\u04af.\u0445.",
            };
        final String[] metaValue_Eras = new String[] {
               "\u041c\u042d\u04e8",
               "\u041c\u042d",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "HH:mm:ss (zzzz)",
               "HH:mm:ss (z)",
               "HH:mm:ss",
               "HH:mm",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "G y '\u043e\u043d\u044b' MMMM'\u044b\u043d' d. cccc '\u0433\u0430\u0440\u0430\u0433'",
               "G y '\u043e\u043d\u044b' MM '\u0441\u0430\u0440\u044b\u043d' dd",
               "G y '\u043e\u043d\u044b' MMM'\u044b\u043d' d",
               "GGGGG y.MM.dd",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "GGGG y '\u043e\u043d\u044b' MMMM'\u044b\u043d' d. EEEE '\u0433\u0430\u0440\u0430\u0433'",
               "GGGG y '\u043e\u043d\u044b' MM '\u0441\u0430\u0440\u044b\u043d' dd",
               "GGGG y '\u043e\u043d\u044b' MMM'\u044b\u043d' d",
               "G y.MM.dd",
            };
        final String metaValue_calendarname_gregorian = "\u0433\u0440\u0435\u0433\u043e\u0440\u0438\u0439\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\u0436\u0438\u043b" },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "narrow.Eras", metaValue_Eras },
            { "abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "timezone.regionFormat.standard", "{0}-\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0446\u0430\u0433" },
            { "japanese.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.japanese", "\u044f\u043f\u043e\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "long.Eras",
                new String[] {
                    "\u043c\u0430\u043d\u0430\u0439 \u044d\u0440\u0438\u043d\u0438\u0439 \u04e9\u043c\u043d\u04e9\u0445",
                    "\u043c\u0430\u043d\u0430\u0439 \u044d\u0440\u0438\u043d\u0438\u0439",
                }
            },
            { "roc.QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\u043c\u0438\u043d\u0443\u0442" },
            { "field.era", "\u044d\u0440\u0438\u043d" },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "\u04af.\u04e9./\u04af.\u0445." },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "japanese.QuarterNarrows", metaValue_QuarterNarrows },
            { "calendarname.roc", "\u043c\u0438\u043d\u0433\u043e \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "field.month", "\u0441\u0430\u0440" },
            { "field.second", "\u0441\u0435\u043a\u0443\u043d\u0434" },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayAbbreviations },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "\u0438\u0441\u043b\u0430\u043c\u044b\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "japanese.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "timezone.regionFormat", "{0}-\u043d \u0446\u0430\u0433" },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0' '\u043c\u044f\u043d\u0433\u0430 other:0' '\u043c\u044f\u043d\u0433\u0430}",
                    "{one:00' '\u043c\u044f\u043d\u0433\u0430 other:00' '\u043c\u044f\u043d\u0433\u0430}",
                    "{one:000' '\u043c\u044f\u043d\u0433\u0430 other:000' '\u043c\u044f\u043d\u0433\u0430}",
                    "{one:0' '\u0441\u0430\u044f other:0' '\u0441\u0430\u044f}",
                    "{one:00' '\u0441\u0430\u044f other:00' '\u0441\u0430\u044f}",
                    "{one:000' '\u0441\u0430\u044f other:000' '\u0441\u0430\u044f}",
                    "{one:0' '\u0442\u044d\u0440\u0431\u0443\u043c other:0' '\u0442\u044d\u0440\u0431\u0443\u043c}",
                    "{one:00' '\u0442\u044d\u0440\u0431\u0443\u043c other:00' '\u0442\u044d\u0440\u0431\u0443\u043c}",
                    "{one:000' '\u0442\u044d\u0440\u0431\u0443\u043c other:000' '\u0442\u044d\u0440\u0431\u0443\u043c}",
                    "{one:0' '\u0438\u0445' '\u043d\u0430\u044f\u0434 other:0' '\u0438\u0445' '\u043d\u0430\u044f\u0434}",
                    "{one:00' '\u0438\u0445' '\u043d\u0430\u044f\u0434 other:00' '\u0438\u0445' '\u043d\u0430\u044f\u0434}",
                    "{one:000' '\u0438\u0445' '\u043d\u0430\u044f\u0434 other:000' '\u0438\u0445' '\u043d\u0430\u044f\u0434}",
                }
            },
            { "buddhist.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "standalone.DayNarrows", metaValue_DayAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayAbbreviations },
            { "field.zone", "\u0446\u0430\u0433\u0438\u0439\u043d \u0431\u04af\u0441" },
            { "japanese.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "buddhist.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "Eras", metaValue_Eras },
            { "roc.DayNames", metaValue_DayNames },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "standalone.QuarterNarrows", metaValue_QuarterNarrows },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "field.weekday", "\u0433\u0430\u0440\u0430\u0433" },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.MonthNames", metaValue_MonthNames },
            { "field.week", "\u0434\u043e\u043b\u043e\u043e \u0445\u043e\u043d\u043e\u0433" },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayAbbreviations },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "short.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0\u00a0\u043c\u044f\u043d\u0433\u0430 other:0\u00a0\u043c\u044f\u043d\u0433\u0430}",
                    "{one:00\u00a0\u043c\u044f\u043d\u0433\u0430 other:00\u00a0\u043c\u044f\u043d\u0433\u0430}",
                    "{one:000\u00a0\u043c\u044f\u043d\u0433\u0430 other:000\u00a0\u043c\u044f\u043d\u0433\u0430}",
                    "{one:0\u00a0\u0441\u0430\u044f other:0\u00a0\u0441\u0430\u044f}",
                    "{one:00\u00a0\u0441\u0430\u044f other:00\u00a0\u0441\u0430\u044f}",
                    "{one:000\u00a0\u0441\u0430\u044f other:000\u00a0\u0441\u0430\u044f}",
                    "{one:0\u00a0\u0442\u044d\u0440\u0431\u0443\u043c other:0\u00a0\u0442\u044d\u0440\u0431\u0443\u043c}",
                    "{one:00\u00a0\u0442\u044d\u0440\u0431\u0443\u043c other:00\u00a0\u0442\u044d\u0440\u0431\u0443\u043c}",
                    "{one:000\u0422 other:000\u0422}",
                    "{one:0\u0418\u041d other:0\u0418\u041d}",
                    "{one:00\u0418\u041d other:00\u0418\u041d}",
                    "{one:000\u0418\u041d other:000\u0418\u041d}",
                }
            },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "timezone.regionFormat.daylight", "{0}-\u043d \u0437\u0443\u043d\u044b \u0446\u0430\u0433" },
            { "DatePatterns",
                new String[] {
                    "y '\u043e\u043d\u044b' MMMM'\u044b\u043d' d, EEEE '\u0433\u0430\u0440\u0430\u0433'",
                    "y '\u043e\u043d\u044b' MMMM'\u044b\u043d' d",
                    "y '\u043e\u043d\u044b' MMM'\u044b\u043d' d",
                    "y.MM.dd",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames",
                new String[] {
                    "\u041d\u044f\u043c",
                    "\u0414\u0430\u0432\u0430\u0430",
                    "\u041c\u044f\u0433\u043c\u0430\u0440",
                    "\u041b\u0445\u0430\u0433\u0432\u0430",
                    "\u041f\u04af\u0440\u044d\u0432",
                    "\u0411\u0430\u0430\u0441\u0430\u043d",
                    "\u0411\u044f\u043c\u0431\u0430",
                }
            },
            { "field.hour", "\u0446\u0430\u0433" },
            { "calendarname.buddhist", "\u0431\u0443\u0434\u0434\u044b\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "standalone.MonthNames",
                new String[] {
                    "\u041d\u044d\u0433\u0434\u04af\u0433\u044d\u044d\u0440 \u0441\u0430\u0440",
                    "\u0425\u043e\u0451\u0440\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
                    "\u0413\u0443\u0440\u0430\u0432\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
                    "\u0414\u04e9\u0440\u04e9\u0432\u0434\u04af\u0433\u044d\u044d\u0440 \u0441\u0430\u0440",
                    "\u0422\u0430\u0432\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
                    "\u0417\u0443\u0440\u0433\u0430\u0430\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
                    "\u0414\u043e\u043b\u043e\u043e\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
                    "\u041d\u0430\u0439\u043c\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
                    "\u0415\u0441\u0434\u04af\u0433\u044d\u044d\u0440 \u0441\u0430\u0440",
                    "\u0410\u0440\u0430\u0432\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
                    "\u0410\u0440\u0432\u0430\u043d \u043d\u044d\u0433\u0434\u04af\u0433\u044d\u044d\u0440 \u0441\u0430\u0440",
                    "\u0410\u0440\u0432\u0430\u043d \u0445\u043e\u0451\u0440\u0434\u0443\u0433\u0430\u0430\u0440 \u0441\u0430\u0440",
                    "",
                }
            },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "\u00a4\u00a0#,##0.00",
                    "#,##0%",
                    "\u00a4\u00a0#,##0.00",
                }
            },
            { "buddhist.DayNarrows", metaValue_DayAbbreviations },
            { "japanese.DayNarrows", metaValue_DayAbbreviations },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
