/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.FontFilesResource;
import com.jidesoft.utils.SystemInfo;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.plaf.FontUIResource;

public class SecurityUtils {
    public static final String BOLD = "Bold";
    public static final String ITALIC = "Italic";
    public static final String BOLD_ITALIC = "Bold Italic";
    private static boolean _AWTEventListenerDisabled = false;
    private static boolean _translucentWindowFeatureDisabled = !SystemInfo.isJdk6u10Above() || !SystemInfo.isWindows();

    public static FontUIResource createFontUIResource(String string, int n, int n2) {
        Font font = SecurityUtils.createFont(string, n, n2);
        if (font != null) {
            return new FontUIResource(font);
        }
        return null;
    }

    private static String createFontStrings(String string, int n) {
        String string2;
        switch (n) {
            case 1: {
                string2 = string + " " + BOLD;
                break;
            }
            case 2: {
                string2 = string + " " + ITALIC;
                break;
            }
            case 3: {
                string2 = string + " " + BOLD_ITALIC;
                break;
            }
            default: {
                string2 = string;
            }
        }
        return string2.replace(' ', '_');
    }

    public static Font createFont(String string, int n, int n2) {
        try {
            return new Font(string, n, n2);
        }
        catch (AccessControlException accessControlException) {
            ClassLoader classLoader = SecurityUtils.class.getClassLoader();
            try {
                String string2 = null;
                try {
                    string2 = FontFilesResource.getResourceBundle(Locale.getDefault()).getString(SecurityUtils.createFontStrings(string, n));
                }
                catch (MissingResourceException missingResourceException) {
                    try {
                        string2 = FontFilesResource.getResourceBundle(Locale.getDefault()).getString(string);
                    }
                    catch (MissingResourceException missingResourceException2) {
                        // empty catch block
                    }
                }
                if (string2 == null) {
                    return null;
                }
                Font font = Font.createFont(0, classLoader.getResourceAsStream(string2));
                if (font != null) {
                    return font.deriveFont(n, n2);
                }
            }
            catch (FontFormatException fontFormatException) {
                fontFormatException.printStackTrace();
                throw accessControlException;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw accessControlException;
            }
            return null;
        }
    }

    public static String getProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (AccessControlException accessControlException) {
            return string2;
        }
    }

    public static boolean isAWTEventListenerDisabled() {
        return _AWTEventListenerDisabled;
    }

    public static void setAWTEventListenerDisabled(boolean bl) {
        _AWTEventListenerDisabled = bl;
    }

    public static boolean isTranslucentWindowFeatureDisabled() {
        return _translucentWindowFeatureDisabled;
    }

    public static void setTranslucentWindowFeatureDisabled(boolean bl) {
        _translucentWindowFeatureDisabled = bl;
    }

    static class FontStruct {
        String font;
        int style;

        FontStruct() {
        }
    }
}

