/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.NotThreadSafe;
import oshi.util.platform.windows.PerfCounterQueryHandler;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

@NotThreadSafe
public class PerfCounterQuery<T extends Enum<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(PerfCounterQuery.class);
    protected final Class<T> propertyEnum;
    protected final String perfObject;
    protected final String perfWmiClass;
    protected final String queryKey;
    protected CounterDataSource source;
    protected PerfCounterQueryHandler pdhQueryHandler;
    private EnumMap<T, PerfDataUtil.PerfCounter> counterMap = null;
    protected WbemcliUtil.WmiQuery<T> counterQuery = null;
    public static final String TOTAL_INSTANCE = "_Total";
    public static final String TOTAL_INSTANCES = "*_Total";
    public static final String NOT_TOTAL_INSTANCE = "^_Total";
    public static final String NOT_TOTAL_INSTANCES = "^*_Total";

    public PerfCounterQuery(Class<T> propertyEnum, String perfObject, String perfWmiClass) {
        this(propertyEnum, perfObject, perfWmiClass, perfObject);
    }

    public PerfCounterQuery(Class<T> propertyEnum, String perfObject, String perfWmiClass, String queryKey) {
        this.propertyEnum = propertyEnum;
        this.perfObject = perfObject;
        this.perfWmiClass = perfWmiClass;
        this.queryKey = queryKey;
        this.pdhQueryHandler = new PerfCounterQueryHandler();
        this.source = CounterDataSource.PDH;
    }

    public boolean setDataSource(CounterDataSource source2) {
        this.source = source2;
        switch (source2) {
            case PDH: {
                LOG.debug("Attempting to set PDH Data Source.");
                this.unInitWmiCounters();
                return this.initPdhCounters();
            }
            case WMI: {
                LOG.debug("Attempting to set WMI Data Source.");
                this.unInitPdhCounters();
                this.initWmiCounters();
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid Data Source specified.");
    }

    protected boolean initPdhCounters() {
        this.counterMap = new EnumMap(this.propertyEnum);
        for (Enum prop : (Enum[])this.propertyEnum.getEnumConstants()) {
            PerfDataUtil.PerfCounter counter = PerfDataUtil.createCounter(this.perfObject, ((PdhCounterProperty)((Object)prop)).getInstance(), ((PdhCounterProperty)((Object)prop)).getCounter());
            this.counterMap.put(prop, counter);
            if (this.pdhQueryHandler.addCounterToQuery(counter, this.queryKey)) continue;
            this.unInitPdhCounters();
            return false;
        }
        return true;
    }

    protected void unInitPdhCounters() {
        this.pdhQueryHandler.removeAllCountersFromQuery(this.queryKey);
        this.counterMap = null;
    }

    protected void initWmiCounters() {
        this.counterQuery = new WbemcliUtil.WmiQuery<T>(this.perfWmiClass, this.propertyEnum);
    }

    protected void unInitWmiCounters() {
        this.counterQuery = null;
    }

    public Map<T, Long> queryValues() {
        EnumMap valueMap = new EnumMap(this.propertyEnum);
        Enum[] props = (Enum[])this.propertyEnum.getEnumConstants();
        if (this.source.equals((Object)CounterDataSource.PDH)) {
            if (this.initPdhCounters() && this.queryPdh(valueMap, props)) {
                this.unInitPdhCounters();
            } else {
                this.setDataSource(CounterDataSource.WMI);
            }
        }
        if (this.source.equals((Object)CounterDataSource.WMI)) {
            this.queryWmi(valueMap, props);
        }
        return valueMap;
    }

    private boolean queryPdh(Map<T, Long> valueMap, T[] props) {
        if (this.counterMap != null && 0L < this.pdhQueryHandler.updateQuery(this.queryKey)) {
            for (T prop : props) {
                valueMap.put(prop, this.pdhQueryHandler.queryCounter(this.counterMap.get(prop)));
            }
            return true;
        }
        return false;
    }

    private void queryWmi(Map<T, Long> valueMap, T[] props) {
        WbemcliUtil.WmiResult<T> result = WmiQueryHandler.createInstance().queryWMI(this.counterQuery);
        if (result.getResultCount() > 0) {
            block5: for (T prop : props) {
                switch (result.getCIMType(prop)) {
                    case 18: {
                        valueMap.put(prop, Long.valueOf(WmiUtil.getUint16(result, prop, 0)));
                        continue block5;
                    }
                    case 19: {
                        valueMap.put(prop, WmiUtil.getUint32asLong(result, prop, 0));
                        continue block5;
                    }
                    case 21: {
                        valueMap.put(prop, WmiUtil.getUint64(result, prop, 0));
                        continue block5;
                    }
                    default: {
                        throw new ClassCastException("Unimplemented CIM Type Mapping.");
                    }
                }
            }
        }
    }

    public static enum CounterDataSource {
        PDH,
        WMI;

    }

    public static interface PdhCounterProperty {
        public String getInstance();

        public String getCounter();
    }
}

