/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;

public class Ehdr_p2 {
    StructAccessor accessor;
    private final int mdIdx;
    private final MachineDataInfo md;
    private static final int[] Ehdr_p2_size = new int[]{28, 28, 28, 28, 28, 28, 40, 40};
    private static final int[] e_entry_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] e_phoff_offset = new int[]{4, 4, 4, 4, 4, 4, 8, 8};
    private static final int[] e_shoff_offset = new int[]{8, 8, 8, 8, 8, 8, 16, 16};
    private static final int[] e_flags_offset = new int[]{12, 12, 12, 12, 12, 12, 24, 24};
    private static final int[] e_ehsize_offset = new int[]{16, 16, 16, 16, 16, 16, 28, 28};
    private static final int[] e_phentsize_offset = new int[]{18, 18, 18, 18, 18, 18, 30, 30};
    private static final int[] e_phnum_offset = new int[]{20, 20, 20, 20, 20, 20, 32, 32};
    private static final int[] e_shentsize_offset = new int[]{22, 22, 22, 22, 22, 22, 34, 34};
    private static final int[] e_shnum_offset = new int[]{24, 24, 24, 24, 24, 24, 36, 36};
    private static final int[] e_shstrndx_offset = new int[]{26, 26, 26, 26, 26, 26, 38, 38};

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public Ehdr_p2 setE_entry(long l) {
        this.accessor.setLongAt(e_entry_offset[this.mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public long getE_entry() {
        return this.accessor.getLongAt(e_entry_offset[this.mdIdx], this.md.longSizeInBytes());
    }

    public Ehdr_p2 setE_phoff(long l) {
        this.accessor.setLongAt(e_phoff_offset[this.mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public long getE_phoff() {
        return this.accessor.getLongAt(e_phoff_offset[this.mdIdx], this.md.longSizeInBytes());
    }

    public Ehdr_p2 setE_shoff(long l) {
        this.accessor.setLongAt(e_shoff_offset[this.mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public long getE_shoff() {
        return this.accessor.getLongAt(e_shoff_offset[this.mdIdx], this.md.longSizeInBytes());
    }

    public Ehdr_p2 setE_flags(int n) {
        this.accessor.setIntAt(e_flags_offset[this.mdIdx], n);
        return this;
    }

    public int getE_flags() {
        return this.accessor.getIntAt(e_flags_offset[this.mdIdx]);
    }

    public Ehdr_p2 setE_ehsize(short s) {
        this.accessor.setShortAt(e_ehsize_offset[this.mdIdx], s);
        return this;
    }

    public short getE_ehsize() {
        return this.accessor.getShortAt(e_ehsize_offset[this.mdIdx]);
    }

    public Ehdr_p2 setE_phentsize(short s) {
        this.accessor.setShortAt(e_phentsize_offset[this.mdIdx], s);
        return this;
    }

    public short getE_phentsize() {
        return this.accessor.getShortAt(e_phentsize_offset[this.mdIdx]);
    }

    public Ehdr_p2 setE_phnum(short s) {
        this.accessor.setShortAt(e_phnum_offset[this.mdIdx], s);
        return this;
    }

    public short getE_phnum() {
        return this.accessor.getShortAt(e_phnum_offset[this.mdIdx]);
    }

    public Ehdr_p2 setE_shentsize(short s) {
        this.accessor.setShortAt(e_shentsize_offset[this.mdIdx], s);
        return this;
    }

    public short getE_shentsize() {
        return this.accessor.getShortAt(e_shentsize_offset[this.mdIdx]);
    }

    public Ehdr_p2 setE_shnum(short s) {
        this.accessor.setShortAt(e_shnum_offset[this.mdIdx], s);
        return this;
    }

    public short getE_shnum() {
        return this.accessor.getShortAt(e_shnum_offset[this.mdIdx]);
    }

    public Ehdr_p2 setE_shstrndx(short s) {
        this.accessor.setShortAt(e_shstrndx_offset[this.mdIdx], s);
        return this;
    }

    public short getE_shstrndx() {
        return this.accessor.getShortAt(e_shstrndx_offset[this.mdIdx]);
    }

    public static int size(int n) {
        return Ehdr_p2_size[n];
    }

    public static Ehdr_p2 create(int n) {
        return Ehdr_p2.create(n, Buffers.newDirectByteBuffer(Ehdr_p2.size(n)));
    }

    public static Ehdr_p2 create(int n, ByteBuffer byteBuffer) {
        return new Ehdr_p2(n, byteBuffer);
    }

    Ehdr_p2(int n, ByteBuffer byteBuffer) {
        this.mdIdx = n;
        this.md = MachineDataInfo.StaticConfig.values()[n].md;
        this.accessor = new StructAccessor(byteBuffer);
    }
}

