/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.ui.cpu.LiveCPUView;
import org.openide.util.Lookup;

public class LiveCPUViewUpdater {
    private static final int MIN_UPDATE_DIFF = 900;
    private static final int MAX_UPDATE_DIFF = 1400;
    private CCTHandler handler;
    private final LiveCPUView cpuView;
    private final ProfilerClient client;
    private volatile boolean paused;
    private volatile boolean forceRefresh;

    public LiveCPUViewUpdater(LiveCPUView liveCPUView, ProfilerClient profilerClient) {
        this.cpuView = liveCPUView;
        this.client = profilerClient;
        this.handler = CCTHandler.registerUpdater(this);
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public void setForceRefresh(boolean bl) {
        this.forceRefresh = bl;
    }

    public void update() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.forceRefresh || !this.paused && this.cpuView.getLastUpdate() + 1400L < System.currentTimeMillis()) {
            this.client.forceObtainedResultsDump(true);
        }
    }

    public void cleanup() {
        this.handler.unregisterUpdater(this);
        this.handler = null;
    }

    private void updateData() throws ClientUtils.TargetAppOrVMTerminated, CPUResultsSnapshot.NoDataAvailableException {
        if (!this.forceRefresh && (this.paused || this.cpuView.getLastUpdate() + 900L > System.currentTimeMillis())) {
            return;
        }
        boolean bl = this.client.getCurrentInstrType() == 2;
        CPUResultsSnapshot cPUResultsSnapshot = this.client.getStatus().getInstrMethodClasses() == null ? null : this.client.getCPUProfilingResultsSnapshot(false);
        this.cpuView.setData(cPUResultsSnapshot, bl);
        this.forceRefresh = false;
    }

    private void resetData() {
        this.cpuView.resetData();
    }

    public static class CCTHandler
    implements CPUCCTProvider.Listener {
        private final List<LiveCPUViewUpdater> updaters = new ArrayList<LiveCPUViewUpdater>();

        public static CCTHandler registerUpdater(LiveCPUViewUpdater liveCPUViewUpdater) {
            CCTHandler cCTHandler = (CCTHandler)Lookup.getDefault().lookup(CCTHandler.class);
            cCTHandler.updaters.add(liveCPUViewUpdater);
            return cCTHandler;
        }

        public void unregisterUpdater(LiveCPUViewUpdater liveCPUViewUpdater) {
            this.updaters.remove(liveCPUViewUpdater);
        }

        public final void cctEstablished(RuntimeCCTNode runtimeCCTNode, boolean bl) {
            if (!bl) {
                for (LiveCPUViewUpdater liveCPUViewUpdater : this.updaters) {
                    try {
                        liveCPUViewUpdater.updateData();
                    }
                    catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    }
                    catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
                        Logger.getLogger(LiveCPUView.class.getName()).log(Level.FINE, null, noDataAvailableException);
                    }
                }
            }
        }

        public final void cctReset() {
            for (LiveCPUViewUpdater liveCPUViewUpdater : this.updaters) {
                liveCPUViewUpdater.resetData();
            }
        }
    }
}

