/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class OnlineResourceMenu
extends JMenu {
    public OnlineResourceMenu() {
        super(I18n.tr("Work Offline...", new Object[0]));
        this.setToolTipText(I18n.tr("Block network access to resources", new Object[0]));
        this.setIcon(ImageProvider.get("offline", ImageProvider.ImageSizes.MENU));
        this.addMenuListener(new ToggleMenuListener());
        for (OnlineResource onlineResource : OnlineResource.values()) {
            ToggleOnlineResourceAction action = new ToggleOnlineResourceAction(onlineResource);
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
            action.addButtonModel(item.getModel());
            this.add(item);
        }
    }

    private class ToggleMenuListener
    implements MenuListener {
        private ToggleMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            for (Component component : OnlineResourceMenu.this.getMenuComponents()) {
                JMenuItem menuItem = (JMenuItem)component;
                ToggleOnlineResourceAction action = (ToggleOnlineResourceAction)menuItem.getAction();
                action.updateSelectedState();
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }

    private static class ToggleOnlineResourceAction
    extends ToggleAction {
        private final OnlineResource onlineResource;

        ToggleOnlineResourceAction(OnlineResource onlineResource) {
            super(onlineResource.getLocName(), null, null, null, false);
            this.onlineResource = onlineResource;
            this.setToolbarId("menu:offline:" + onlineResource.name());
            this.updateSelectedState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isOffline()) {
                NetworkManager.setOnline(this.onlineResource);
            } else {
                NetworkManager.setOffline(this.onlineResource);
            }
            this.updateSelectedState();
        }

        private void updateSelectedState() {
            this.setEnabled(this.onlineResource == OnlineResource.ALL || !NetworkManager.isOffline(OnlineResource.ALL));
            this.setSelected(this.isOffline());
            this.notifySelectedState();
        }

        private boolean isOffline() {
            return NetworkManager.isOffline(this.onlineResource);
        }

        @Override
        protected boolean listenToSelectionChange() {
            return false;
        }
    }
}

