/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.rtklib.RtkLibPosReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class RtkLibImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("pos", "pos", I18n.tr("RTKLib Positioning Solution Files", new Object[0]), false);

    public RtkLibImporter() {
        super(FILE_FILTER);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        String fn = file.getName();
        try (InputStream fis = Compression.getUncompressedFileInputStream(file);){
            RtkLibPosReader r = RtkLibImporter.buildAndParse(fis);
            if (r.getNumberOfCoordinates() > 0) {
                r.getGpxData().storageFile = file;
                GpxLayer gpxLayer = new GpxLayer(r.getGpxData(), fn, true);
                File fileFinal = file;
                GuiHelper.runInEDT(() -> {
                    MainApplication.getLayerManager().addLayer(gpxLayer);
                    if (Config.getPref().getBoolean("marker.makeautomarkers", true)) {
                        MarkerLayer ml = new MarkerLayer(r.getGpxData(), I18n.tr("Markers from {0}", fn), fileFinal, gpxLayer);
                        if (!ml.data.isEmpty()) {
                            MainApplication.getLayerManager().addLayer(ml);
                        }
                    }
                });
            }
            RtkLibImporter.showRtkLibInfobox(r.getNumberOfCoordinates() > 0, r);
        }
    }

    private static void showRtkLibInfobox(boolean success, RtkLibPosReader r) {
        StringBuilder msg = new StringBuilder(160).append("<html>").append(I18n.tr("Coordinates imported: {0}", r.getNumberOfCoordinates())).append("</html>");
        if (success) {
            SwingUtilities.invokeLater(() -> new Notification("<h3>" + I18n.tr("RTKLib import success:", new Object[0]) + "</h3>" + msg.toString()).setIcon(1).show());
        } else {
            HelpAwareOptionPane.showMessageDialogInEDT(MainApplication.getMainFrame(), msg.toString(), I18n.tr("RTKLib import failure!", new Object[0]), 0, null);
        }
    }

    public static GpxImporter.GpxImporterData loadLayers(InputStream is, File associatedFile, String gpxLayerName) throws IOException {
        RtkLibPosReader r = RtkLibImporter.buildAndParse(is);
        boolean parsedProperly = r.getNumberOfCoordinates() > 0;
        r.getGpxData().storageFile = associatedFile;
        return GpxImporter.loadLayers(r.getGpxData(), parsedProperly, gpxLayerName);
    }

    static RtkLibPosReader buildAndParse(InputStream fis) throws IOException {
        RtkLibPosReader r = new RtkLibPosReader(fis);
        try {
            r.parse(true);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return r;
    }
}

