/*
 * Decompiled with CFR 0.152.
 */
package ome.jxrlib;

import java.nio.ByteBuffer;
import ome.jxrlib.FormatConverter;
import ome.jxrlib.ImageDecoder;
import ome.jxrlib.JXRJNI;

class CodecFactory {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected CodecFactory(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(CodecFactory obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                JXRJNI.delete_CodecFactory(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void decoderFromFile(ImageDecoder decoder, String inputFile) {
        JXRJNI.CodecFactory_decoderFromFile(this.swigCPtr, this, ImageDecoder.getCPtr(decoder), decoder, inputFile);
    }

    public void decoderFromBytes(ImageDecoder decoder, ByteBuffer NIOBUFFER, long offset, long length) {
        assert (NIOBUFFER.isDirect()) : "Buffer must be allocated direct.";
        JXRJNI.CodecFactory_decoderFromBytes(this.swigCPtr, this, ImageDecoder.getCPtr(decoder), decoder, NIOBUFFER, offset, length);
    }

    public FormatConverter createFormatConverter(ImageDecoder decoder, String extension) {
        return new FormatConverter(JXRJNI.CodecFactory_createFormatConverter(this.swigCPtr, this, ImageDecoder.getCPtr(decoder), decoder, extension), true);
    }

    public CodecFactory() {
        this(JXRJNI.new_CodecFactory(), true);
    }
}

