/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.types;

import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmPrimitiveTypeKind {
    public static final JvmPrimitiveTypeKind BOOLEAN = new JvmPrimitiveTypeKind("boolean", "java.lang.Boolean", "Z");
    public static final JvmPrimitiveTypeKind BYTE = new JvmPrimitiveTypeKind("byte", "java.lang.Byte", "B");
    public static final JvmPrimitiveTypeKind CHAR = new JvmPrimitiveTypeKind("char", "java.lang.Character", "C");
    public static final JvmPrimitiveTypeKind DOUBLE = new JvmPrimitiveTypeKind("double", "java.lang.Double", "D");
    public static final JvmPrimitiveTypeKind FLOAT = new JvmPrimitiveTypeKind("float", "java.lang.Float", "F");
    public static final JvmPrimitiveTypeKind INT = new JvmPrimitiveTypeKind("int", "java.lang.Integer", "I");
    public static final JvmPrimitiveTypeKind LONG = new JvmPrimitiveTypeKind("long", "java.lang.Long", "J");
    public static final JvmPrimitiveTypeKind SHORT = new JvmPrimitiveTypeKind("short", "java.lang.Short", "S");
    public static final JvmPrimitiveTypeKind VOID = new JvmPrimitiveTypeKind("void", "java.lang.Void", "V");
    private final String myName;
    private final String myBoxedFqn;
    private final String myBinaryName;
    private static final Map<String, JvmPrimitiveTypeKind> ourNameToKind;
    private static final Map<String, JvmPrimitiveTypeKind> ourFqnToKind;

    private JvmPrimitiveTypeKind(String name, String boxedFqn, String binaryName) {
        this.myName = name;
        this.myBoxedFqn = boxedFqn;
        this.myBinaryName = binaryName;
    }

    @Contract(pure=true)
    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public String getBoxedFqn() {
        String string2 = this.myBoxedFqn;
        if (string2 == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public String getBinaryName() {
        String string2 = this.myBinaryName;
        if (string2 == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static JvmPrimitiveTypeKind getKindByName(@Nullable String name) {
        return ourNameToKind.get(name);
    }

    @Contract(pure=true)
    @NotNull
    public static Collection<String> getBoxedFqns() {
        Collection<String> collection = Collections.unmodifiableCollection(ourFqnToKind.keySet());
        if (collection == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(3);
        }
        return collection;
    }

    static {
        JvmPrimitiveTypeKind[] values = new JvmPrimitiveTypeKind[]{BOOLEAN, BYTE, CHAR, DOUBLE, FLOAT, INT, LONG, SHORT, VOID};
        THashMap nameToKind = new THashMap();
        THashMap fqnToKind = new THashMap();
        for (JvmPrimitiveTypeKind kind : values) {
            nameToKind.put((Object)kind.getName(), (Object)kind);
            fqnToKind.put((Object)kind.getBoxedFqn(), (Object)kind);
        }
        nameToKind.compact();
        fqnToKind.compact();
        ourNameToKind = nameToKind;
        ourFqnToKind = fqnToKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/jvm/types/JvmPrimitiveTypeKind";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoxedFqn";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoxedFqns";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

