export = ClientRequestCache;
/**
 * Caches requests in memory and handles expiring them.
 */
declare class ClientRequestCache {
    /**
     * @param ttl {Number} How old a result can be before it gets expired.
     * @param size {Number} How many results to store before we trim.
     * @param requestFunc The function to use on cache miss.
     */
    constructor(ttl: number, size: number, requestFunc: any);
    _requestContent: Map<any, any>;
    requestFunc: any;
    ttl: number;
    maxSize: number;
    /**
     * Gets a result of a request from the cache, or otherwise
     * tries to fetch the the result with this.requestFunc
     *
     * @param {string}} key Key of the item to get/store.
     * @param {any[]} args A set of arguments to pass to the request func.
     * @returns {Promise} The request, or undefined if not retrievable.
     * @throws {Error} If the key is not a string.
     */
    get(key: any, ...args: any[]): Promise<any>;
    /**
     * Clone the current request result cache, mapping keys to their cache records.
     * @returns {Map<string,any>}
     */
    getCachedResults(): Map<string, any>;
}
