export = UserBridgeStore;
/**
 * Construct a store suitable for user bridging information.
 * @constructor
 * @param {Datastore} db The connected NEDB database instance
 * @param {Object} opts Options for this store.
 */
declare function UserBridgeStore(db: any, opts: Object): void;
declare class UserBridgeStore {
    /**
     * Construct a store suitable for user bridging information.
     * @constructor
     * @param {Datastore} db The connected NEDB database instance
     * @param {Object} opts Options for this store.
     */
    constructor(db: any, opts: Object);
    db: any;
    getRemoteUsersFromMatrixId(userId: string): Promise<import("../models/users/remote")[], Error>;
    getMatrixUsersFromRemoteId(remoteId: string): Promise<import("../models/users/matrix")[], Error>;
    getByMatrixLocalpart(localpart: string): Promise<import("../models/users/matrix") | null, Error>;
    getMatrixUser(userId: string): Promise<import("../models/users/matrix") | null, Error>;
    setMatrixUser(matrixUser: import("../models/users/matrix")): Promise<any>;
    getRemoteUser(id: string): Promise<import("../models/users/remote") | null, Error>;
    getByRemoteData(dataQuery: Object): Promise<import("../models/users/remote")[], Error>;
    getByMatrixData(dataQuery: Object): Promise<import("../models/users/matrix")[], Error>;
    setRemoteUser(remoteUser: import("../models/users/remote")): Promise<any>;
    linkUsers(matrixUser: import("../models/users/matrix"), remoteUser: import("../models/users/remote")): Promise<any>;
    unlinkUsers(matrixUser: import("../models/users/matrix"), remoteUser: import("../models/users/remote")): Promise<number, Error>;
    unlinkUserIds(matrixUserId: string, remoteUserId: string): Promise<number, Error>;
    getMatrixLinks(remoteId: string): Promise<string[], Error>;
    getRemoteLinks(matrixId: string): Promise<string[], Error>;
}
