/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import java.util.List;
import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.CLibrary;
import oshi.software.os.InternetProtocolStats;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.mac.SysctlUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public class MacInternetProtocolStats
implements InternetProtocolStats {
    private boolean isElevated;
    private Supplier<Pair<Long, Long>> establishedv4v6 = Memoizer.memoize(MacInternetProtocolStats::queryTcpnetstat, Memoizer.defaultExpiration());
    private Supplier<CLibrary.Tcpstat> tcpstat = Memoizer.memoize(MacInternetProtocolStats::queryTcpstat, Memoizer.defaultExpiration());
    private Supplier<CLibrary.Udpstat> udpstat = Memoizer.memoize(MacInternetProtocolStats::queryUdpstat, Memoizer.defaultExpiration());
    private Supplier<CLibrary.Ipstat> ipstat = Memoizer.memoize(MacInternetProtocolStats::queryIpstat, Memoizer.defaultExpiration());
    private Supplier<CLibrary.Ip6stat> ip6stat = Memoizer.memoize(MacInternetProtocolStats::queryIp6stat, Memoizer.defaultExpiration());

    public MacInternetProtocolStats(boolean elevated) {
        this.isElevated = elevated;
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        CLibrary.Tcpstat tcp = this.tcpstat.get();
        if (this.isElevated) {
            return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getA(), ParseUtil.unsignedIntToLong(tcp.tcps_connattempt), ParseUtil.unsignedIntToLong(tcp.tcps_accepts), ParseUtil.unsignedIntToLong(tcp.tcps_conndrops), ParseUtil.unsignedIntToLong(tcp.tcps_drops), ParseUtil.unsignedIntToLong(tcp.tcps_snd_swcsum - tcp.tcps_sndrexmitpack), ParseUtil.unsignedIntToLong(tcp.tcps_rcv_swcsum), ParseUtil.unsignedIntToLong(tcp.tcps_sndrexmitpack), ParseUtil.unsignedIntToLong(tcp.tcps_rcvbadsum + tcp.tcps_rcvbadoff + tcp.tcps_rcvmemdrop + tcp.tcps_rcvshort), 0L);
        }
        CLibrary.Ipstat ip = this.ipstat.get();
        CLibrary.Udpstat udp = this.udpstat.get();
        return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getA(), ParseUtil.unsignedIntToLong(tcp.tcps_connattempt), ParseUtil.unsignedIntToLong(tcp.tcps_accepts), ParseUtil.unsignedIntToLong(tcp.tcps_conndrops), ParseUtil.unsignedIntToLong(tcp.tcps_drops), Math.max(0L, ParseUtil.unsignedIntToLong(ip.ips_snd_swcsum - udp.udps_snd_swcsum - tcp.tcps_sndrexmitpack)), Math.max(0L, ParseUtil.unsignedIntToLong(ip.ips_rcv_swcsum - udp.udps_rcv_swcsum)), ParseUtil.unsignedIntToLong(tcp.tcps_sndrexmitpack), Math.max(0L, ParseUtil.unsignedIntToLong(ip.ips_badsum + ip.ips_tooshort + ip.ips_toosmall + ip.ips_badhlen + ip.ips_badlen - udp.udps_hdrops + udp.udps_badsum + udp.udps_badlen)), 0L);
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv6Stats() {
        CLibrary.Ip6stat ip6 = this.ip6stat.get();
        CLibrary.Udpstat udp = this.udpstat.get();
        return new InternetProtocolStats.TcpStats(this.establishedv4v6.get().getB(), 0L, 0L, 0L, 0L, ip6.ip6s_localout - ParseUtil.unsignedIntToLong(udp.udps_snd6_swcsum), ip6.ip6s_total - ParseUtil.unsignedIntToLong(udp.udps_rcv6_swcsum), 0L, 0L, 0L);
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        CLibrary.Udpstat stat = this.udpstat.get();
        return new InternetProtocolStats.UdpStats(ParseUtil.unsignedIntToLong(stat.udps_snd_swcsum), ParseUtil.unsignedIntToLong(stat.udps_rcv_swcsum), ParseUtil.unsignedIntToLong(stat.udps_noportmcast), ParseUtil.unsignedIntToLong(stat.udps_hdrops + stat.udps_badsum + stat.udps_badlen));
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        CLibrary.Udpstat stat = this.udpstat.get();
        return new InternetProtocolStats.UdpStats(ParseUtil.unsignedIntToLong(stat.udps_snd6_swcsum), ParseUtil.unsignedIntToLong(stat.udps_rcv6_swcsum), 0L, 0L);
    }

    private static CLibrary.Tcpstat queryTcpstat() {
        CLibrary.Tcpstat tcpstat = new CLibrary.Tcpstat();
        SysctlUtil.sysctl("net.inet.tcp.stats", tcpstat);
        return tcpstat;
    }

    private static CLibrary.Ipstat queryIpstat() {
        CLibrary.Ipstat ipstat = new CLibrary.Ipstat();
        SysctlUtil.sysctl("net.inet.ip.stats", ipstat);
        return ipstat;
    }

    private static CLibrary.Ip6stat queryIp6stat() {
        CLibrary.Ip6stat ip6stat = new CLibrary.Ip6stat();
        SysctlUtil.sysctl("net.inet6.ip6.stats", ip6stat);
        return ip6stat;
    }

    private static CLibrary.Udpstat queryUdpstat() {
        CLibrary.Udpstat udpstat = new CLibrary.Udpstat();
        SysctlUtil.sysctl("net.inet.udp.stats", udpstat);
        return udpstat;
    }

    private static Pair<Long, Long> queryTcpnetstat() {
        long tcp4 = 0L;
        long tcp6 = 0L;
        List<String> activeConns = ExecutingCommand.runNative("netstat -n -p tcp");
        for (String s2 : activeConns) {
            if (!s2.endsWith("ESTABLISHED")) continue;
            if (s2.startsWith("tcp4")) {
                ++tcp4;
                continue;
            }
            if (!s2.startsWith("tcp6")) continue;
            ++tcp6;
        }
        return new Pair<Long, Long>(tcp4, tcp6);
    }
}

