/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.command.PSystemSingleLineFactory;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.version.PSystemKeycheck;
import net.sourceforge.plantuml.version.PSystemKeygen;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemVersionFactory
extends PSystemSingleLineFactory {
    @Override
    protected AbstractPSystem executeLine(String line) {
        try {
            Pattern p;
            Matcher m;
            if (line.matches("(?i)^(authors?|about)\\s*$")) {
                return PSystemVersion.createShowAuthors();
            }
            if (line.matches("(?i)^version\\s*$")) {
                return PSystemVersion.createShowVersion();
            }
            if (line.matches("(?i)^stdlib\\s*$")) {
                return PSystemVersion.createStdLib();
            }
            if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE && line.matches("(?i)^path\\s*$")) {
                return PSystemVersion.createPath();
            }
            if (line.matches("(?i)^testdot\\s*$")) {
                return PSystemVersion.createTestDot();
            }
            if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE && line.matches("(?i)^dumpstacktrace\\s*$")) {
                return PSystemVersion.createDumpStackTrace();
            }
            if (line.matches("(?i)^keydistributor\\s*$")) {
                return PSystemVersion.createKeyDistributor();
            }
            if (line.matches("(?i)^keygen\\s*$")) {
                line = line.trim();
                return new PSystemKeygen("");
            }
            if (line.matches("(?i)^keyimport(\\s+[0-9a-z]+)?\\s*$")) {
                line = line.trim();
                String key = line.substring("keyimport".length()).trim();
                return new PSystemKeygen(key);
            }
            if (line.matches("(?i)^keycheck\\s+([0-9a-z]+)\\s+([0-9a-z]+)\\s*$") && (m = (p = Pattern.compile("(?i)^keycheck\\s+([0-9a-z]+)\\s+([0-9a-z]+)\\s*$")).matcher(line)).find()) {
                return new PSystemKeycheck(m.group(1), m.group(2));
            }
        }
        catch (IOException e) {
            Log.error("Error " + e);
        }
        return null;
    }
}

