/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.plugin;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.DOMUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractPluginLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String type;
    private final boolean preRegister;
    private final boolean requireName;
    private final Class<T> pluginClassType;

    public AbstractPluginLoader(String type, Class<T> pluginClassType, boolean preRegister, boolean requireName) {
        this.type = type;
        this.pluginClassType = pluginClassType;
        this.preRegister = preRegister;
        this.requireName = requireName;
    }

    public AbstractPluginLoader(String type, Class<T> pluginClassType) {
        this(type, pluginClassType, false, true);
    }

    protected String[] getDefaultPackages() {
        return new String[0];
    }

    protected T create(SolrResourceLoader loader, String name, String className, Node node) throws Exception {
        return loader.newInstance(className, this.pluginClassType, this.getDefaultPackages());
    }

    protected abstract T register(String var1, T var2) throws Exception;

    protected abstract void init(T var1, Node var2) throws Exception;

    public T load(SolrResourceLoader loader, NodeList nodes) {
        ArrayList<PluginInitInfo> info = new ArrayList<PluginInitInfo>();
        T defaultPlugin = null;
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = null;
                try {
                    name = DOMUtil.getAttr(node, "name", this.requireName ? this.type : null);
                    String className = DOMUtil.getAttr(node, "class", this.type);
                    String defaultStr = DOMUtil.getAttr(node, "default", null);
                    T plugin = this.create(loader, name, className, node);
                    if (log.isDebugEnabled()) {
                        log.debug("created {}: {}", (Object)(name != null ? name : ""), (Object)plugin.getClass().getName());
                    }
                    if (this.preRegister) {
                        info.add(new PluginInitInfo(plugin, node));
                    } else {
                        this.init(plugin, node);
                    }
                    T old = this.register(name, plugin);
                    if (old != null && (name != null || this.requireName)) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple " + this.type + " registered to the same name: " + name + " ignoring: " + old);
                    }
                    if (defaultStr == null || !Boolean.parseBoolean(defaultStr)) continue;
                    if (defaultPlugin != null) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple default " + this.type + " plugins: " + defaultPlugin + " AND " + name);
                    }
                    defaultPlugin = plugin;
                    continue;
                }
                catch (Exception ex) {
                    SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Plugin init failure for " + this.type + (null != name ? " \"" + name + "\"" : "") + ": " + ex.getMessage(), (Throwable)ex);
                    throw e;
                }
            }
        }
        for (PluginInitInfo pinfo : info) {
            try {
                this.init(pinfo.plugin, pinfo.node);
            }
            catch (Exception ex) {
                SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Plugin Initializing failure for " + this.type, (Throwable)ex);
                throw e;
            }
        }
        return defaultPlugin;
    }

    public T loadSingle(SolrResourceLoader loader, Node node) {
        ArrayList<PluginInitInfo> info = new ArrayList<PluginInitInfo>();
        Object plugin = null;
        try {
            String name = DOMUtil.getAttr(node, "name", this.requireName ? this.type : null);
            String className = DOMUtil.getAttr(node, "class", this.type);
            plugin = this.create(loader, name, className, node);
            if (log.isDebugEnabled()) {
                log.debug("created {}: {}", (Object)name, (Object)plugin.getClass().getName());
            }
            if (this.preRegister) {
                info.add(new PluginInitInfo(plugin, node));
            } else {
                this.init(plugin, node);
            }
            Object old = this.register(name, plugin);
            if (old != null && (name != null || this.requireName)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple " + this.type + " registered to the same name: " + name + " ignoring: " + old);
            }
        }
        catch (Exception ex) {
            SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Plugin init failure for " + this.type, (Throwable)ex);
            throw e;
        }
        for (PluginInitInfo pinfo : info) {
            try {
                this.init(pinfo.plugin, pinfo.node);
            }
            catch (Exception ex) {
                SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Plugin init failure for " + this.type, (Throwable)ex);
                throw e;
            }
        }
        return (T)plugin;
    }

    private class PluginInitInfo {
        final T plugin;
        final Node node;

        PluginInitInfo(T plugin, Node node) {
            this.plugin = plugin;
            this.node = node;
        }
    }
}

