/*
 * uvector - uniform (homogeneous) numeric vector types (SRFI-4)
 *
 *   Copyright (c) 1999-2007 Shiro Kawai, All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *   3. Neither the name of the authors nor the names of its contributors
 *      may be used to endorse or promote products derived from this
 *      software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  This file is automatically generated.  DO NOT EDIT.
 */

#ifndef GAUCHE_UVECT_H
#define GAUCHE_UVECT_H

#include <gauche.h>

SCM_DECL_BEGIN

#if defined(EXTUVECTOR_EXPORTS)
#define LIBGAUCHE_EXT_BODY
#endif
#include <gauche/extern.h>      /* redefine SCM_EXTERN */

/*
 * This header file is for other extension modules which need
 * to access uniform vectors in C level.
 */

SCM_EXTERN ScmObj Scm_UVectorAlias(ScmClass *klass, ScmUVector *v,
                                   ScmSmallInt start, ScmSmallInt end);

SCM_EXTERN ScmObj Scm_UVectorCopy(ScmUVector *v,
                                  ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_UVectorSwapBytes(ScmUVector *v, int option);
SCM_EXTERN ScmObj Scm_UVectorSwapBytesX(ScmUVector *v, int option);

SCM_EXTERN ScmObj Scm_ReadBlockX(ScmUVector *v, ScmPort *port,
                                 ScmSmallInt start, ScmSmallInt end,
                                 ScmSymbol *endian);
SCM_EXTERN ScmObj Scm_WriteBlock(ScmUVector *v, ScmPort *port,
                                 ScmSmallInt start, ScmSmallInt end, 
                                 ScmSymbol *endian);

/* S8Vector */

SCM_EXTERN ScmObj Scm_S8VectorFill(ScmUVector *vec, int8_t fill, int, int);
SCM_EXTERN ScmObj Scm_S8VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_S8VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_S8VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_S8VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToS8Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_S8VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToS8Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_S8VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S8VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S8VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S8VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S8VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S8VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S8VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S8VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_S8VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S8VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S8VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S8VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S8VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S8VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_S8VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMS8VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_S8VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_S8VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_S8VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_S8VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_S8VectorSwapBytesX(ScmUVector *v0);

/* U8Vector */

SCM_EXTERN ScmObj Scm_U8VectorFill(ScmUVector *vec, uint8_t fill, int, int);
SCM_EXTERN ScmObj Scm_U8VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_U8VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_U8VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_U8VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToU8Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_U8VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToU8Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_U8VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U8VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U8VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U8VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U8VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U8VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U8VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U8VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_U8VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U8VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U8VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U8VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U8VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U8VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_U8VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMU8VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_U8VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_U8VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_U8VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_U8VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_U8VectorSwapBytesX(ScmUVector *v0);

/* S16Vector */

SCM_EXTERN ScmObj Scm_S16VectorFill(ScmUVector *vec, int16_t fill, int, int);
SCM_EXTERN ScmObj Scm_S16VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_S16VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_S16VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_S16VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToS16Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_S16VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToS16Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_S16VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S16VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S16VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S16VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S16VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S16VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S16VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S16VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_S16VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S16VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S16VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S16VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S16VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S16VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_S16VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMS16VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_S16VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_S16VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_S16VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_S16VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_S16VectorSwapBytesX(ScmUVector *v0);

/* U16Vector */

SCM_EXTERN ScmObj Scm_U16VectorFill(ScmUVector *vec, uint16_t fill, int, int);
SCM_EXTERN ScmObj Scm_U16VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_U16VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_U16VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_U16VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToU16Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_U16VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToU16Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_U16VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U16VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U16VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U16VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U16VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U16VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U16VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U16VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_U16VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U16VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U16VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U16VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U16VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U16VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_U16VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMU16VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_U16VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_U16VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_U16VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_U16VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_U16VectorSwapBytesX(ScmUVector *v0);

/* S32Vector */

SCM_EXTERN ScmObj Scm_S32VectorFill(ScmUVector *vec, int32_t fill, int, int);
SCM_EXTERN ScmObj Scm_S32VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_S32VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_S32VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_S32VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToS32Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_S32VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToS32Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_S32VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S32VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S32VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S32VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S32VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S32VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S32VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S32VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_S32VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S32VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S32VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S32VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S32VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S32VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_S32VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMS32VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_S32VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_S32VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_S32VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_S32VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_S32VectorSwapBytesX(ScmUVector *v0);

/* U32Vector */

SCM_EXTERN ScmObj Scm_U32VectorFill(ScmUVector *vec, uint32_t fill, int, int);
SCM_EXTERN ScmObj Scm_U32VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_U32VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_U32VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_U32VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToU32Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_U32VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToU32Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_U32VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U32VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U32VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U32VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U32VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U32VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U32VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U32VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_U32VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U32VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U32VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U32VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U32VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U32VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_U32VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMU32VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_U32VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_U32VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_U32VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_U32VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_U32VectorSwapBytesX(ScmUVector *v0);

/* S64Vector */

SCM_EXTERN ScmObj Scm_S64VectorFill(ScmUVector *vec, int64_t fill, int, int);
SCM_EXTERN ScmObj Scm_S64VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_S64VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_S64VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_S64VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToS64Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_S64VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToS64Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_S64VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S64VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S64VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S64VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S64VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S64VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S64VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_S64VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_S64VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S64VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S64VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S64VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S64VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_S64VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_S64VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMS64VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_S64VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_S64VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_S64VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_S64VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_S64VectorSwapBytesX(ScmUVector *v0);

/* U64Vector */

SCM_EXTERN ScmObj Scm_U64VectorFill(ScmUVector *vec, uint64_t fill, int, int);
SCM_EXTERN ScmObj Scm_U64VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_U64VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_U64VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_U64VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToU64Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_U64VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToU64Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_U64VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U64VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U64VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U64VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U64VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U64VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U64VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_U64VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_U64VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U64VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U64VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U64VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U64VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_U64VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_U64VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMU64VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_U64VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_U64VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_U64VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_U64VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_U64VectorSwapBytesX(ScmUVector *v0);

/* F16Vector */

SCM_EXTERN ScmObj Scm_F16VectorFill(ScmUVector *vec, ScmHalfFloat fill, int, int);
SCM_EXTERN ScmObj Scm_F16VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_F16VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_F16VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_F16VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToF16Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_F16VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToF16Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_F16VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F16VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F16VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F16VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F16VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F16VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F16VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F16VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_F16VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F16VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F16VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F16VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F16VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F16VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_F16VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMF16VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_F16VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_F16VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_F16VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_F16VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_F16VectorSwapBytesX(ScmUVector *v0);

/* F32Vector */

SCM_EXTERN ScmObj Scm_F32VectorFill(ScmUVector *vec, float fill, int, int);
SCM_EXTERN ScmObj Scm_F32VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_F32VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_F32VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_F32VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToF32Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_F32VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToF32Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_F32VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F32VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F32VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F32VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F32VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F32VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F32VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F32VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_F32VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F32VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F32VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F32VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F32VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F32VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_F32VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMF32VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_F32VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_F32VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_F32VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_F32VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_F32VectorSwapBytesX(ScmUVector *v0);

/* F64Vector */

SCM_EXTERN ScmObj Scm_F64VectorFill(ScmUVector *vec, double fill, int, int);
SCM_EXTERN ScmObj Scm_F64VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_F64VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_F64VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_F64VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToF64Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_F64VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToF64Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_F64VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F64VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F64VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F64VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F64VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F64VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F64VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_F64VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_F64VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F64VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F64VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F64VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F64VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_F64VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_F64VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMF64VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_F64VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_F64VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_F64VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_F64VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_F64VectorSwapBytesX(ScmUVector *v0);

/* C32Vector */

SCM_EXTERN ScmObj Scm_C32VectorFill(ScmUVector *vec, ScmHalfComplex fill, int, int);
SCM_EXTERN ScmObj Scm_C32VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_C32VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_C32VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_C32VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToC32Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_C32VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToC32Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_C32VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C32VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C32VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C32VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C32VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C32VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C32VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C32VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_C32VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C32VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C32VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C32VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C32VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C32VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_C32VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMC32VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_C32VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_C32VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_C32VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_C32VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_C32VectorSwapBytesX(ScmUVector *v0);

/* C64Vector */

SCM_EXTERN ScmObj Scm_C64VectorFill(ScmUVector *vec, complex float fill, int, int);
SCM_EXTERN ScmObj Scm_C64VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_C64VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_C64VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_C64VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToC64Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_C64VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToC64Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_C64VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C64VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C64VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C64VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C64VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C64VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C64VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C64VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_C64VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C64VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C64VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C64VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C64VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C64VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_C64VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMC64VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_C64VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_C64VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_C64VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_C64VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_C64VectorSwapBytesX(ScmUVector *v0);

/* C128Vector */

SCM_EXTERN ScmObj Scm_C128VectorFill(ScmUVector *vec, complex double fill, int, int);
SCM_EXTERN ScmObj Scm_C128VectorSet(ScmUVector *vec, int index, ScmObj val, int clamp);
SCM_EXTERN ScmObj Scm_C128VectorToList(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_C128VectorCopy(ScmUVector *vec,
                                     ScmSmallInt start, ScmSmallInt end);
SCM_EXTERN ScmObj Scm_C128VectorCopyX(ScmUVector *dst, ScmSmallInt dstart,
                                      ScmUVector *src, ScmSmallInt sstart,
                                      ScmSmallInt send);
SCM_EXTERN ScmObj Scm_ObjArrayToC128Vector(ScmObj *arr, int size, int clamp);
SCM_EXTERN ScmObj Scm_C128VectorToVector(ScmUVector *vec, int start, int end);
SCM_EXTERN ScmObj Scm_VectorToC128Vector(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
SCM_EXTERN ScmObj Scm_C128VectorAdd(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C128VectorAddX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C128VectorSub(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C128VectorSubX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C128VectorMul(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C128VectorMulX(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C128VectorDiv(ScmUVector *s0, ScmObj s1, int clamp);
SCM_EXTERN ScmObj Scm_C128VectorDivX(ScmUVector *s0, ScmObj s1, int clamp);

SCM_EXTERN ScmObj Scm_C128VectorAnd(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C128VectorAndX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C128VectorIor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C128VectorIorX(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C128VectorXor(ScmUVector *s0, ScmObj s1);
SCM_EXTERN ScmObj Scm_C128VectorXorX(ScmUVector *s0, ScmObj s1);

SCM_EXTERN ScmObj Scm_C128VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_VMC128VectorDotProd(ScmUVector *v0, ScmObj v1);
SCM_EXTERN ScmObj Scm_C128VectorRangeCheck(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_C128VectorClamp(ScmUVector *v0, ScmObj min, ScmObj max);
SCM_EXTERN ScmObj Scm_C128VectorClampX(ScmUVector *v0, ScmObj min, ScmObj max);

SCM_EXTERN ScmObj Scm_C128VectorSwapBytes(ScmUVector *v0);
SCM_EXTERN ScmObj Scm_C128VectorSwapBytesX(ScmUVector *v0);


#undef LIBGAUCHE_EXT_BODY

SCM_DECL_END

#endif /* GAUCHE_UVECT_H */

