/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.engine.stats.behavior.ICacheStats;
import org.apache.commons.jcs3.engine.stats.behavior.IStatElement;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.data.imagery.CachedTileLoaderFactory;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.layer.WMTSLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.ButtonColumn;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class CacheSettingsPanel
extends JPanel {
    private final JosmTextField cacheDir = new JosmTextField(11);
    private final JSpinner maxElementsOnDisk = new JSpinner(new SpinnerNumberModel(AbstractCachedTileSourceLayer.MAX_DISK_CACHE_SIZE.get(), 0, Integer.MAX_VALUE, 1));

    public CacheSettingsPanel() {
        super(new GridBagLayout());
        this.add((Component)new JLabel(I18n.tr("Tile cache directory: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.cacheDir, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr("Maximum size of disk cache (per imagery) in MB: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.maxElementsOnDisk, GBC.eop());
        MainApplication.worker.submit(() -> {
            this.addToPanel(TMSLayer.getCache(), "TMS");
            this.addToPanel(WMSLayer.getCache(), "WMS");
            this.addToPanel(WMTSLayer.getCache(), "WMTS");
        });
    }

    private void addToPanel(CacheAccess<String, BufferedImageCacheEntry> cache, String name) {
        Long cacheSize = CacheSettingsPanel.getCacheSize(cache);
        String sizeString = Utils.getSizeString(cacheSize, Locale.getDefault());
        DefaultTableModel tableModel = CacheSettingsPanel.getTableModel(cache);
        GuiHelper.runInEDT(() -> {
            this.add((Component)new JLabel(I18n.tr("{0} cache, total cache size: {1}", name, sizeString)), GBC.eol().insets(5, 5, 0, 0));
            this.add((Component)new JScrollPane(CacheSettingsPanel.getTableForCache(cache, tableModel)), GBC.eol().fill(1));
        });
    }

    private static Long getCacheSize(CacheAccess<String, BufferedImageCacheEntry> cache) {
        ICacheStats stats = cache.getStatistics();
        for (IStats cacheStats : stats.getAuxiliaryCacheStats()) {
            for (IStatElement<?> statElement : cacheStats.getStatElements()) {
                Object val;
                if (!"Data File Length".equals(statElement.getName()) || !((val = statElement.getData()) instanceof Long)) continue;
                return (Long)val;
            }
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    public static String[][] getCacheStats(CacheAccess<String, BufferedImageCacheEntry> cache) {
        Set keySet = cache.getCacheControl().getKeySet();
        ConcurrentHashMap<String, int[]> temp = new ConcurrentHashMap<String, int[]>();
        for (Object key : keySet) {
            String[] stringArray = ((String)key).split(":", 2);
            if (stringArray.length == 2) {
                int[] counter = (int[])temp.get(stringArray[0]);
                if (counter == null) {
                    temp.put(stringArray[0], new int[]{1});
                    continue;
                }
                counter[0] = counter[0] + 1;
                continue;
            }
            Logging.warn("Could not parse the key: {0}. No colon found", key);
        }
        ArrayList<Pair> sortedStats = new ArrayList<Pair>();
        for (Map.Entry entry : temp.entrySet()) {
            sortedStats.add(new Pair<String, Integer>((String)entry.getKey(), ((int[])entry.getValue())[0]));
        }
        sortedStats.sort(Comparator.comparing(o -> (Integer)o.b, Comparator.reverseOrder()));
        String[][] ret = new String[sortedStats.size()][3];
        boolean bl = false;
        for (Pair e : sortedStats) {
            void var5_9;
            ret[var5_9] = new String[]{(String)e.a, ((Integer)e.b).toString(), I18n.tr("Clear", new Object[0])};
            ++var5_9;
        }
        return ret;
    }

    private static JTable getTableForCache(final CacheAccess<String, BufferedImageCacheEntry> cache, final TableModel tableModel) {
        final JTable ret = new JTable(tableModel);
        TableHelper.setFont(ret, CacheSettingsPanel.class);
        ButtonColumn buttonColumn = new ButtonColumn(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ret.convertRowIndexToModel(ret.getEditingRow());
                tableModel.setValueAt("0", row, 1);
                cache.remove(ret.getValueAt(row, 0).toString() + ':');
            }
        });
        TableColumn tableColumn = ret.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(buttonColumn);
        tableColumn.setCellEditor(buttonColumn);
        return ret;
    }

    private static DefaultTableModel getTableModel(CacheAccess<String, BufferedImageCacheEntry> cache) {
        return new DefaultTableModel(CacheSettingsPanel.getCacheStats(cache), new String[]{I18n.tr("Cache name", new Object[0]), I18n.tr("Object Count", new Object[0]), I18n.tr("Clear", new Object[0])}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 2;
            }
        };
    }

    void loadSettings() {
        this.cacheDir.setText(CachedTileLoaderFactory.PROP_TILECACHE_DIR.get());
        this.maxElementsOnDisk.setValue(AbstractCachedTileSourceLayer.MAX_DISK_CACHE_SIZE.get());
    }

    boolean saveSettings() {
        boolean restartRequired = CacheSettingsPanel.removeCacheFiles(CachedTileLoaderFactory.PROP_TILECACHE_DIR.get(), 0x100000L * (long)((Integer)this.maxElementsOnDisk.getValue()).intValue());
        if (!AbstractCachedTileSourceLayer.MAX_DISK_CACHE_SIZE.get().equals(this.maxElementsOnDisk.getValue())) {
            AbstractCachedTileSourceLayer.MAX_DISK_CACHE_SIZE.put((Integer)this.maxElementsOnDisk.getValue());
            restartRequired = true;
        }
        if (!CachedTileLoaderFactory.PROP_TILECACHE_DIR.get().equals(this.cacheDir.getText())) {
            restartRequired = true;
            CacheSettingsPanel.removeCacheFiles(CachedTileLoaderFactory.PROP_TILECACHE_DIR.get(), 0L);
            CachedTileLoaderFactory.PROP_TILECACHE_DIR.put(this.cacheDir.getText());
        }
        return restartRequired;
    }

    private static boolean removeCacheFiles(String path, long maxSize) {
        File directory = new File(path);
        File[] cacheFiles = directory.listFiles((dir, name) -> name.endsWith(".data") || name.endsWith(".key"));
        boolean restartRequired = false;
        if (cacheFiles != null) {
            for (File cacheFile : cacheFiles) {
                if (cacheFile.length() <= maxSize) continue;
                if (!restartRequired) {
                    JCSCacheManager.shutdown();
                    restartRequired = true;
                }
                Utils.deleteFile(cacheFile);
                File otherFile = null;
                if (cacheFile.getName().endsWith(".data")) {
                    otherFile = new File(cacheFile.getPath().replaceAll("\\.data$", ".key"));
                } else if (cacheFile.getName().endsWith(".key")) {
                    otherFile = new File(cacheFile.getPath().replaceAll("\\.key$", ".data"));
                }
                if (otherFile == null) continue;
                Utils.deleteFileIfExists(otherFile);
            }
        }
        return restartRequired;
    }
}

