/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.RestartAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.advanced.AdvancedPreference;
import org.openstreetmap.josm.gui.preferences.audio.AudioPreference;
import org.openstreetmap.josm.gui.preferences.display.ColorPreference;
import org.openstreetmap.josm.gui.preferences.display.DisplayPreference;
import org.openstreetmap.josm.gui.preferences.display.DrawingPreference;
import org.openstreetmap.josm.gui.preferences.display.GPXPreference;
import org.openstreetmap.josm.gui.preferences.display.LafPreference;
import org.openstreetmap.josm.gui.preferences.display.LanguagePreference;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.BackupPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPreference;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreference;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.remotecontrol.RemoteControlPreference;
import org.openstreetmap.josm.gui.preferences.server.AuthenticationPreference;
import org.openstreetmap.josm.gui.preferences.server.OverpassServerPreference;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.preferences.server.ServerAccessPreference;
import org.openstreetmap.josm.gui.preferences.shortcut.ShortcutPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTagCheckerRulesPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTestsPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public final class PreferenceTabbedPane
extends JTabbedPane
implements ExpertToggleAction.ExpertModeChangeListener,
ChangeListener {
    private final transient List<PreferenceTab> tabs = new ArrayList<PreferenceTab>();
    private static final Collection<PreferenceSettingFactory> SETTINGS_FACTORIES = new LinkedList<PreferenceSettingFactory>();
    private static final PreferenceSettingFactory ADVANCED_PREFERENCE_FACTORY = new AdvancedPreference.Factory();
    private final transient List<PreferenceSetting> settings = new ArrayList<PreferenceSetting>();
    private final transient List<PreferenceSetting> settingsInitialized = new ArrayList<PreferenceSetting>();
    final transient List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();

    public void addValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public PreferencePanel createPreferenceTab(TabPreferenceSetting caller) {
        return this.createPreferenceTab(caller, false);
    }

    public PreferencePanel createPreferenceTab(TabPreferenceSetting caller, boolean inScrollPane) {
        PreferencePanel p;
        CheckParameterUtil.ensureParameterNotNull(caller, "caller");
        JComponent tab = p = new PreferencePanel(caller);
        if (inScrollPane) {
            PreferenceScrollPane sp = new PreferenceScrollPane(p);
            tab = sp;
        }
        this.tabs.add((PreferenceTab)((Object)tab));
        return p;
    }

    private void selectTabBy(Predicate<TabPreferenceSetting> predicate) {
        IntStream.range(0, this.getTabCount()).filter(i -> this.getComponentAt(i) instanceof PreferenceTab && predicate.test(((PreferenceTab)((Object)this.getComponentAt(i))).getTabPreferenceSetting())).findFirst().ifPresent(this::setSelectedIndex);
    }

    public void selectTabByName(String name) {
        Objects.requireNonNull(name);
        this.selectTabBy(tps -> Objects.equals(name, tps.getIconName()));
    }

    public void selectTabByPref(Class<? extends TabPreferenceSetting> clazz) {
        this.selectTabBy(clazz::isInstance);
    }

    public boolean selectSubTabByPref(Class<? extends SubPreferenceSetting> clazz) {
        try {
            SubPreferenceSetting sub = this.getSetting(clazz);
            TabPreferenceSetting tab = sub.getTabPreferenceSetting(this);
            this.selectTabBy(tps -> tps.equals(tab));
            return tab.selectSubTab(sub);
        }
        catch (NoSuchElementException ignore) {
            Logging.trace(ignore);
            return false;
        }
    }

    public Pair<Class<? extends TabPreferenceSetting>, Class<? extends SubPreferenceSetting>> getSelectedTab() {
        Component selected = this.getSelectedComponent();
        if (selected instanceof PreferenceTab) {
            TabPreferenceSetting setting = ((PreferenceTab)((Object)selected)).getTabPreferenceSetting();
            return Pair.create(setting.getClass(), setting.getSelectedSubTab());
        }
        return null;
    }

    public DisplayPreference getDisplayPreference() {
        return this.getSetting(DisplayPreference.class);
    }

    public MapPreference getMapPreference() {
        return this.getSetting(MapPreference.class);
    }

    public PluginPreference getPluginPreference() {
        return this.getSetting(PluginPreference.class);
    }

    public ImageryPreference getImageryPreference() {
        return this.getSetting(ImageryPreference.class);
    }

    public ShortcutPreference getShortcutPreference() {
        return this.getSetting(ShortcutPreference.class);
    }

    public ServerAccessPreference getServerPreference() {
        return this.getSetting(ServerAccessPreference.class);
    }

    public ValidatorPreference getValidatorPreference() {
        return this.getSetting(ValidatorPreference.class);
    }

    public void savePreferences() {
        PluginPreference preference = this.getPluginPreference();
        if (preference != null) {
            Set<PluginInformation> toDownload = preference.getPluginsScheduledForUpdateOrDownload();
            PluginDownloadTask task = toDownload != null && !toDownload.isEmpty() ? new PluginDownloadTask((Component)this, toDownload, I18n.tr("Download plugins", new Object[0])) : null;
            PluginDownloadAfterTask continuation = new PluginDownloadAfterTask(preference, task, toDownload);
            if (task != null) {
                MainApplication.worker.submit(task);
                MainApplication.worker.submit(() -> GuiHelper.runInEDT(continuation));
            } else {
                continuation.run();
            }
        }
    }

    public PreferenceTabbedPane() {
        super(2, 1);
        super.addMouseWheelListener(new WheelListener(this));
        super.getModel().addChangeListener(this);
        ExpertToggleAction.addExpertModeChangeListener(this);
    }

    public void buildGui() {
        ArrayList<PreferenceSettingFactory> factories = new ArrayList<PreferenceSettingFactory>(SETTINGS_FACTORIES);
        factories.addAll(PluginHandler.getPreferenceSetting());
        factories.add(ADVANCED_PREFERENCE_FACTORY);
        for (PreferenceSettingFactory factory : factories) {
            PreferenceSetting setting;
            if (factory == null || (setting = factory.createPreferenceSetting()) == null) continue;
            this.settings.add(setting);
        }
        this.addGUITabs(false);
    }

    private void addGUITabsForSetting(Icon icon, TabPreferenceSetting tps) {
        for (PreferenceTab tab : this.tabs) {
            if (!tab.getTabPreferenceSetting().equals(tps)) continue;
            this.insertGUITabsForSetting(icon, tps, this.getTabCount());
        }
    }

    private int insertGUITabsForSetting(Icon icon, TabPreferenceSetting tps, int index) {
        int position = index;
        for (PreferenceTab tab : this.tabs) {
            if (!tab.getTabPreferenceSetting().equals(tps)) continue;
            this.insertTab(null, icon, tab.getComponent(), tps.getTooltip(), position++);
        }
        return position - 1;
    }

    private void addGUITabs(boolean clear) {
        int index;
        boolean expert = ExpertToggleAction.isExpert();
        Component sel = this.getSelectedComponent();
        if (clear) {
            this.removeAll();
        }
        for (PreferenceSetting setting : this.settings) {
            if (setting instanceof TabPreferenceSetting) {
                TabPreferenceSetting tps = (TabPreferenceSetting)setting;
                if (!expert && tps.isExpert()) continue;
                String iconName = tps.getIconName();
                ImageIcon icon = null;
                if (iconName != null && !iconName.isEmpty()) {
                    icon = ImageProvider.get("preferences", iconName, ImageProvider.ImageSizes.SETTINGS_TAB);
                }
                if (this.settingsInitialized.contains(tps)) {
                    this.addGUITabsForSetting(icon, tps);
                    continue;
                }
                this.addTab(null, icon, new PreferencePanel(tps), tps.getTooltip());
                continue;
            }
            if (setting instanceof SubPreferenceSetting) continue;
            Logging.warn("Ignoring preferences " + setting);
        }
        if (sel != null && (index = this.indexOfComponent(sel)) > -1) {
            this.setSelectedIndex(index);
        }
    }

    @Override
    public void expertChanged(boolean isExpert) {
        this.addGUITabs(true);
    }

    public List<PreferenceSetting> getSettings() {
        return Collections.unmodifiableList(this.settings);
    }

    public <T extends PreferenceSetting> T getSetting(Class<? extends T> clazz) {
        return (T)((PreferenceSetting)Utils.filteredCollection(this.settings, clazz).iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.getSelectedIndex();
        Component sel = this.getSelectedComponent();
        if (index > -1 && sel instanceof PreferenceTab) {
            Container ancestor;
            PreferenceTab tab = (PreferenceTab)((Object)sel);
            TabPreferenceSetting preferenceSettings = tab.getTabPreferenceSetting();
            if (!this.settingsInitialized.contains(preferenceSettings)) {
                try {
                    this.getModel().removeChangeListener(this);
                    preferenceSettings.addGui(this);
                    for (PreferenceSetting setting : this.settings) {
                        if (!(setting instanceof SubPreferenceSetting)) continue;
                        this.addSubPreferenceSetting(preferenceSettings, (SubPreferenceSetting)setting);
                    }
                    Icon icon = this.getIconAt(index);
                    this.remove(index);
                    if (index <= this.insertGUITabsForSetting(icon, preferenceSettings, index)) {
                        this.setSelectedIndex(index);
                    }
                }
                catch (SecurityException ex) {
                    Logging.error(ex);
                }
                catch (RuntimeException ex) {
                    BugReportExceptionHandler.handleException(ex);
                }
                finally {
                    this.settingsInitialized.add(preferenceSettings);
                    this.getModel().addChangeListener(this);
                }
            }
            if ((ancestor = this.getTopLevelAncestor()) instanceof PreferenceDialog) {
                ((PreferenceDialog)ancestor).setHelpContext(preferenceSettings.getHelpContext());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubPreferenceSetting(TabPreferenceSetting preferenceSettings, SubPreferenceSetting sps) {
        if (sps.getTabPreferenceSetting(this) == preferenceSettings) {
            try {
                sps.addGui(this);
            }
            catch (SecurityException ex) {
                Logging.error(ex);
            }
            catch (RuntimeException ex) {
                BugReportExceptionHandler.handleException(ex);
            }
            finally {
                this.settingsInitialized.add(sps);
            }
        }
    }

    static {
        SETTINGS_FACTORIES.add(new DisplayPreference.Factory());
        SETTINGS_FACTORIES.add(new DrawingPreference.Factory());
        SETTINGS_FACTORIES.add(new GPXPreference.Factory());
        SETTINGS_FACTORIES.add(new ColorPreference.Factory());
        SETTINGS_FACTORIES.add(new LafPreference.Factory());
        SETTINGS_FACTORIES.add(new LanguagePreference.Factory());
        SETTINGS_FACTORIES.add(new ServerAccessPreference.Factory());
        SETTINGS_FACTORIES.add(new AuthenticationPreference.Factory());
        SETTINGS_FACTORIES.add(new ProxyPreference.Factory());
        SETTINGS_FACTORIES.add(new OverpassServerPreference.Factory());
        SETTINGS_FACTORIES.add(new MapPreference.Factory());
        SETTINGS_FACTORIES.add(new ProjectionPreference.Factory());
        SETTINGS_FACTORIES.add(new MapPaintPreference.Factory());
        SETTINGS_FACTORIES.add(new TaggingPresetPreference.Factory());
        SETTINGS_FACTORIES.add(new BackupPreference.Factory());
        SETTINGS_FACTORIES.add(new PluginPreference.Factory());
        SETTINGS_FACTORIES.add(MainApplication.getToolbar());
        SETTINGS_FACTORIES.add(new AudioPreference.Factory());
        SETTINGS_FACTORIES.add(new ShortcutPreference.Factory());
        SETTINGS_FACTORIES.add(new ValidatorPreference.Factory());
        SETTINGS_FACTORIES.add(new ValidatorTestsPreference.Factory());
        SETTINGS_FACTORIES.add(new ValidatorTagCheckerRulesPreference.Factory());
        SETTINGS_FACTORIES.add(new RemoteControlPreference.Factory());
        SETTINGS_FACTORIES.add(new ImageryPreference.Factory());
    }

    static final class WheelListener
    implements MouseWheelListener {
        final JTabbedPane tabbedPane;

        WheelListener(JTabbedPane tabbedPane) {
            this.tabbedPane = tabbedPane;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent wev) {
            if (this.tabbedPane.indexAtLocation(wev.getPoint().x, wev.getPoint().y) < 0) {
                return;
            }
            int newTab = Utils.clamp(this.tabbedPane.getSelectedIndex() + wev.getWheelRotation(), 0, this.tabbedPane.getTabCount() - 1);
            this.tabbedPane.setSelectedIndex(newTab);
        }
    }

    public static final class PreferenceScrollPane
    extends JScrollPane
    implements PreferenceTab {
        private final transient TabPreferenceSetting preferenceSetting;

        private PreferenceScrollPane(Component view, TabPreferenceSetting preferenceSetting) {
            super(view);
            this.preferenceSetting = preferenceSetting;
        }

        private PreferenceScrollPane(PreferencePanel preferencePanel) {
            this(preferencePanel.getComponent(), preferencePanel.getTabPreferenceSetting());
        }

        @Override
        public TabPreferenceSetting getTabPreferenceSetting() {
            return this.preferenceSetting;
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    public static final class PreferencePanel
    extends JPanel
    implements PreferenceTab {
        private final transient TabPreferenceSetting preferenceSetting;

        private PreferencePanel(TabPreferenceSetting preferenceSetting) {
            super(new GridBagLayout());
            CheckParameterUtil.ensureParameterNotNull(preferenceSetting);
            this.preferenceSetting = preferenceSetting;
            this.buildPanel();
        }

        private void buildPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)PreferencePanel.buildHtmlPanel(this.preferenceSetting.getTitle(), 1), GBC.eol().insets(0, 5, 0, 10).anchor(18).fill(2));
            this.add((Component)PreferencePanel.buildHtmlPanel(this.preferenceSetting.getDescription(), 2), GBC.eol().insets(5, 0, 5, 20).fill(2));
        }

        private static JLabel buildHtmlPanel(String text, int fontStyle) {
            JLabel label = new JLabel("<html>" + text + "</html>");
            label.setFont(label.getFont().deriveFont(fontStyle));
            return label;
        }

        @Override
        public TabPreferenceSetting getTabPreferenceSetting() {
            return this.preferenceSetting;
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    private static interface PreferenceTab {
        public TabPreferenceSetting getTabPreferenceSetting();

        public Component getComponent();
    }

    @FunctionalInterface
    public static interface ValidationListener {
        public boolean validatePreferences();
    }

    private final class PluginDownloadAfterTask
    implements Runnable {
        private final PluginPreference preference;
        private final PluginDownloadTask task;
        private final Set<PluginInformation> toDownload;

        private PluginDownloadAfterTask(PluginPreference preference, PluginDownloadTask task, Set<PluginInformation> toDownload) {
            this.preference = preference;
            this.task = task;
            this.toDownload = toDownload;
        }

        @Override
        public void run() {
            boolean requiresRestart = false;
            for (PreferenceSetting setting : PreferenceTabbedPane.this.settingsInitialized) {
                if (!setting.ok()) continue;
                requiresRestart = true;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (this.task != null && !this.task.isCanceled()) {
                PluginHandler.refreshLocalUpdatedPluginInfo(this.task.getDownloadedPlugins());
                sb.append(PluginPreference.buildDownloadSummary(this.task));
            }
            if (requiresRestart) {
                sb.append(I18n.tr("You have to restart JOSM for some settings to take effect.", new Object[0]));
                sb.append("<br/><br/>");
                sb.append(I18n.tr("Would you like to restart now?", new Object[0]));
            }
            sb.append("</html>");
            if (requiresRestart) {
                HelpAwareOptionPane.ButtonSpec[] options = RestartAction.getButtonSpecs();
                if (0 == HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), sb.toString(), I18n.tr("Restart", new Object[0]), 1, null, options, options[0], null)) {
                    MainApplication.getMenu().restart.actionPerformed(null);
                }
            } else if (this.task != null && !this.task.isCanceled()) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), sb.toString(), I18n.tr("Warning", new Object[0]), 2);
            }
            List<PluginInformation> newPlugins = this.preference.getNewlyActivatedPlugins();
            if (newPlugins != null) {
                boolean removed;
                Collection<PluginInformation> downloadedPlugins = null;
                if (this.task != null && !this.task.isCanceled()) {
                    downloadedPlugins = this.task.getDownloadedPlugins();
                }
                ArrayList<PluginInformation> toLoad = new ArrayList<PluginInformation>();
                for (PluginInformation pi : newPlugins) {
                    if (this.toDownload.contains(pi) && downloadedPlugins != null && !downloadedPlugins.contains(pi) || !pi.canloadatruntime) continue;
                    toLoad.add(pi);
                }
                HashSet<PluginInformation> allPlugins = new HashSet<PluginInformation>(toLoad);
                allPlugins.addAll(PluginHandler.getPlugins());
                do {
                    removed = false;
                    Iterator it = toLoad.iterator();
                    while (it.hasNext()) {
                        if (PluginHandler.checkRequiredPluginsPreconditions(null, allPlugins, (PluginInformation)it.next(), requiresRestart)) continue;
                        it.remove();
                        removed = true;
                    }
                } while (removed);
                if (!toLoad.isEmpty()) {
                    PluginHandler.loadPlugins(PreferenceTabbedPane.this, toLoad, null);
                }
            }
            if (MainApplication.getMainFrame() != null) {
                MainApplication.getMainFrame().repaint();
            }
        }
    }
}

