/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_km extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AL = "\u17a2\u17b6\u179b\u17cb\u1794\u17b6\u1793\u17b8";
        final String metaValue_AM = "\u17a2\u17b6\u1798\u17c1\u1793\u17b8";
        final String metaValue_AZ = "\u17a2\u17b6\u179f\u17ca\u17c2\u1794\u17c3\u17a0\u17d2\u179f\u1784\u17cb";
        final String metaValue_BD = "\u1794\u1784\u17cb\u1780\u17d2\u179b\u17b6\u178a\u17c2\u179f";
        final String metaValue_BG = "\u1794\u17ca\u17bb\u179b\u17a0\u17d2\u1782\u17b6\u179a\u17b8";
        final String metaValue_BY = "\u1794\u17c1\u17a1\u17b6\u179a\u17bb\u179f";
        final String metaValue_CN = "\u1785\u17b7\u1793";
        final String metaValue_DE = "\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb";
        final String metaValue_DK = "\u178a\u17b6\u178e\u17ba\u1798\u17c9\u17b6\u1780";
        final String metaValue_EE = "\u17a2\u17c1\u179f\u17d2\u178f\u17bc\u1793\u17b8";
        final String metaValue_ES = "\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789";
        final String metaValue_ET = "\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8";
        final String metaValue_FI = "\u17a0\u17d2\u179c\u17b6\u17c6\u1784\u17a1\u1784\u17cb";
        final String metaValue_FR = "\u1794\u17b6\u179a\u17b6\u17c6\u1784";
        final String metaValue_GE = "\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17ca\u17b8";
        final String metaValue_GR = "\u1780\u17d2\u179a\u17b7\u1780";
        final String metaValue_HT = "\u17a0\u17c3\u1791\u17b8";
        final String metaValue_HU = "\u17a0\u17bb\u1784\u1782\u17d2\u179a\u17b8";
        final String metaValue_ID = "\u17a5\u178e\u17d2\u178c\u17bc\u178e\u17c1\u179f\u17ca\u17b8";
        final String metaValue_IE = "\u17a2\u17c0\u179a\u17a1\u1784\u17cb";
        final String metaValue_IL = "\u17a2\u17ca\u17b8\u179f\u17d2\u179a\u17b6\u17a2\u17c2\u179b";
        final String metaValue_IS = "\u17a2\u17ca\u17b8\u179f\u17d2\u179b\u1784\u17cb";
        final String metaValue_IT = "\u17a2\u17ca\u17b8\u178f\u17b6\u179b\u17b8";
        final String metaValue_JP = "\u1787\u1794\u17c9\u17bb\u1793";
        final String metaValue_LA = "\u17a1\u17b6\u179c";
        final String metaValue_LK = "\u179f\u17d2\u179a\u17b8\u179b\u1784\u17d2\u1780\u17b6";
        final String metaValue_LT = "\u179b\u17b8\u1791\u17bb\u1799\u17a2\u17b6\u1793\u17b8";
        final String metaValue_LU = "\u179b\u17bb\u1785\u179f\u17c6\u1794\u17bd";
        final String metaValue_MD = "\u1798\u17c9\u17bb\u179b\u178a\u17b6\u179c\u17b8";
        final String metaValue_MN = "\u1798\u17c9\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179b\u17b8";
        final String metaValue_NL = "\u17a0\u17bc\u17a1\u1784\u17cb";
        final String metaValue_NO = "\u1793\u17d0\u179a\u179c\u17c2\u179f";
        final String metaValue_NP = "\u1793\u17c1\u1794\u17c9\u17b6\u179b\u17cb";
        final String metaValue_NR = "\u178e\u17bc\u179a\u17bc";
        final String metaValue_PH = "\u17a0\u17d2\u179c\u17b8\u179b\u17b8\u1796\u17b8\u1793";
        final String metaValue_PL = "\u1794\u17c9\u17bc\u17a1\u17bc\u1789";
        final String metaValue_PT = "\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1782\u17b6\u179b\u17cb";
        final String metaValue_RO = "\u179a\u17bc\u1798\u17c9\u17b6\u1793\u17b8";
        final String metaValue_RU = "\u179a\u17bb\u179f\u17d2\u179f\u17ca\u17b8";
        final String metaValue_SD = "\u179f\u17ca\u17bc\u178a\u1784\u17cb";
        final String metaValue_SE = "\u179f\u17ca\u17bb\u1799\u17a2\u17c2\u178f";
        final String metaValue_SK = "\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1782\u17b8";
        final String metaValue_SO = "\u179f\u17bc\u1798\u17c9\u17b6\u179b\u17b8";
        final String metaValue_SY = "\u179f\u17ca\u17b8\u179a\u17b8";
        final String metaValue_TH = "\u1790\u17c3";
        final String metaValue_TO = "\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17b6";
        final String metaValue_TV = "\u1791\u17bc\u179c\u17c9\u17b6\u179b\u17bc";
        final String metaValue_UA = "\u17a2\u17ca\u17bb\u1799\u1780\u17d2\u179a\u17c2\u1793";
        final String metaValue_VN = "\u179c\u17c0\u178f\u178e\u17b6\u1798";
        final String metaValue_WS = "\u179f\u17b6\u1798\u17d0\u179a";
        final String metaValue_ar = "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb";
        final String metaValue_bo = "\u1791\u17b8\u1794\u17c1";
        final String metaValue_km = "\u1781\u17d2\u1798\u17c2\u179a";
        final String metaValue_kn = "\u1781\u17b6\u178e\u17b6\u178a\u17b6";
        final String metaValue_ko = "\u1780\u17bc\u179a\u17c9\u17c1";
        final String metaValue_my = "\u1797\u17bc\u1798\u17b6";
        final String metaValue_or = "\u17a2\u17bc\u178c\u17c0";
        final String metaValue_ta = "\u178f\u17b6\u1798\u17b8\u179b";
        final String metaValue_te = "\u178f\u17c1\u179b\u17bb\u1782\u17bb";
        final String metaValue_type_nu_taml = "\u179b\u17c1\u1781\u200b\u178f\u17b6\u1798\u17b8\u179b";
        final Object[][] data = new Object[][] {
            { "ksh", "\u1780\u17bc\u17a1\u17bc\u1789" },
            { "mwl", "\u1798\u17b8\u179a\u17c9\u17b6\u1793\u178a\u17c1\u179f" },
            { "Zsym", "\u1793\u17b7\u1798\u17b7\u178f\u17d2\u178f\u179f\u1789\u17d2\u1789\u17b6" },
            { "Zsye", "\u179f\u1789\u17d2\u1789\u17b6\u17a2\u17b6\u179a\u1798\u17d2\u1798\u178e\u17cd" },
            { "tem", "\u1792\u17b8\u1798\u1793\u17b8" },
            { "teo", "\u178f\u17c1\u179f\u17bc" },
            { "rap", "\u179a\u17c9\u17b6\u1794\u17c9\u17b6\u1793\u17bc" },
            { "AC", "\u1780\u17c4\u17c7\u200b\u17a2\u17b6\u179f\u17c1\u1793\u179f\u17b7\u1793" },
            { "rar", "\u179a\u17c9\u17b6\u179a\u17c9\u17bc\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17b6\u1793" },
            { "tet", "\u1791\u17b8\u1791\u17bb\u17c6" },
            { "AD", "\u17a2\u1784\u17cb\u178a\u17bc\u179a\u17c9\u17b6" },
            { "AE", "\u17a2\u17c1\u1798\u17b8\u179a\u17c9\u17b6\u178f\u200b\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u200b\u179a\u17bd\u1798" },
            { "nl_BE", "\u1795\u17d2\u179b\u17b6\u1798\u17b8\u179f" },
            { "AF", "\u17a2\u17b6\u17a0\u17d2\u179c\u17a0\u17d2\u1782\u17b6\u1793\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "AG", "\u17a2\u1784\u17cb\u1791\u17b8\u17a0\u17d2\u1782\u17b6 \u1793\u17b7\u1784 \u1794\u17b6\u1794\u17ca\u17bb\u1799\u178a\u17b6" },
            { "type.ca.ethiopic", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u200b\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8" },
            { "AI", "\u17a2\u1784\u17cb\u17a0\u17d2\u1782\u17b8\u17a1\u17b6" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "\u17a2\u1784\u17cb\u17a0\u17d2\u1782\u17c4\u17a1\u17b6" },
            { "AQ", "\u17a2\u1784\u17cb\u178f\u17b6\u1780\u17cb\u1791\u17b7\u1780" },
            { "AR", "\u17a2\u17b6\u17a0\u17d2\u179f\u1784\u17cb\u1791\u17b8\u1793" },
            { "AS", "\u179f\u17b6\u1798\u17d0\u179a \u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u17b6\u17c6\u1784" },
            { "AT", "\u17a2\u17bc\u1791\u17d2\u179a\u17b8\u179f" },
            { "AU", "\u17a2\u17bc\u179f\u17d2\u178f\u17d2\u179a\u17b6\u179b\u17b8" },
            { "AW", "\u17a2\u17b6\u179a\u17bc\u1794\u17b6" },
            { "AX", "\u1780\u17c4\u17c7\u200b\u17a2\u17b6\u17a1\u1784\u17cb" },
            { "AZ", metaValue_AZ },
            { "BA", "\u1794\u17bc\u179f\u17d2\u1793\u17b8 \u1793\u17b7\u1784\u17a0\u17ba\u17a0\u17d2\u179f\u17b8\u17a0\u17d2\u1782\u17bc\u179c\u17b8\u178e\u17b6" },
            { "BB", "\u1794\u17b6\u1794\u17b6\u178a\u17bb\u179f" },
            { "ceb", "\u179f\u17ca\u17b8\u1794\u17ca\u17bc\u17a2\u17b6\u178e\u17bc" },
            { "BD", metaValue_BD },
            { "kum", "\u1782\u17bc\u1798\u17b8\u1782" },
            { "BE", "\u1794\u17c2\u179b\u17a0\u17d2\u179f\u17ca\u17b7\u1780" },
            { "BF", "\u1794\u17bd\u1782\u17b8\u178e\u17b6\u17a0\u17d2\u179c\u17b6\u179f\u17bc" },
            { "BG", metaValue_BG },
            { "BH", "\u1794\u17b6\u179a\u17c9\u17c2\u1793" },
            { "BI", "\u1794\u17ca\u17bc\u179a\u17bb\u1793\u178c\u17b8" },
            { "BJ", "\u1794\u17c1\u178e\u17b6\u17c6\u1784" },
            { "BL", "\u179f\u17b6\u17c6\u1784\u200b\u1794\u17b6\u1790\u17c1\u17a1\u17c1\u1798\u17b8" },
            { "BM", "\u1794\u17ca\u17ba\u1798\u17bb\u1799\u178a\u17b6" },
            { "myv", "\u17a2\u17ba\u17a0\u17d2\u179f\u17ca\u17b8\u1799\u17c9\u17b6" },
            { "BN", "\u1796\u17d2\u179a\u17bb\u1799\u178e\u17c1" },
            { "BO", "\u1794\u17bc\u179b\u17b8\u179c\u17b8" },
            { "BQ", "\u17a0\u17bc\u17a1\u1784\u17cb \u1780\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u1793" },
            { "BR", "\u1794\u17d2\u179a\u17c1\u179f\u17ca\u17b8\u179b" },
            { "BS", "\u1794\u17b6\u17a0\u17b6\u1798\u17c9\u17b6" },
            { "xog", "\u179f\u17bc\u17a0\u17d2\u1782\u17b6" },
            { "BT", "\u1794\u17ca\u17bc\u178f\u1784\u17cb" },
            { "BV", "\u1780\u17c4\u17c7\u200b\u1794\u17ca\u17bc\u179c\u17c9\u17c1\u178f" },
            { "BW", "\u1794\u17bb\u178f\u179f\u17d2\u179c\u17b6\u178e\u17b6" },
            { "BY", metaValue_BY },
            { "BZ", "\u1794\u17c1\u179b\u17b8" },
            { "type.ca.persian", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u1796\u17c2\u1780\u17d2\u179f" },
            { "type.nu.hebr", "\u179b\u17c1\u1781\u17a0\u17c1\u1794\u17d2\u179a\u17ba" },
            { "CA", "\u1780\u17b6\u178e\u17b6\u178a\u17b6" },
            { "CC", "\u1780\u17c4\u17c7\u200b\u1780\u17bc\u1780\u17bc\u179f (\u1782\u17b8\u179b\u17b8\u1784)" },
            { "mzn", "\u1798\u17c9\u17b6\u17a0\u17d2\u179f\u17b6\u1793\u178a\u17ba\u179a\u17c1\u1793\u17b8" },
            { "CD", "\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4- \u1782\u17b8\u1793\u179f\u17d2\u17a0\u17b6\u179f\u17b6" },
            { "CF", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1780\u178e\u17d2\u178a\u17b6\u179b" },
            { "CG", "\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4 - \u1794\u17d2\u179a\u17b6\u17a0\u17d2\u179f\u17b6\u179c\u17b8\u179b" },
            { "CH", "\u179f\u17d2\u179c\u17b8\u179f" },
            { "CI", "\u1780\u17bc\u178f\u178c\u17b8\u179c\u17d0\u179a" },
            { "CK", "\u1780\u17c4\u17c7\u200b\u1781\u17bc\u1780" },
            { "CL", "\u179f\u17ca\u17b8\u179b\u17b8" },
            { "CM", "\u1780\u17b6\u1798\u17c1\u179a\u17bc\u1793" },
            { "CN", metaValue_CN },
            { "CO", "\u1780\u17bc\u17a1\u17bb\u17c6\u1794\u17ca\u17b8" },
            { "CP", "\u1780\u17c4\u17c7\u200b\u1783\u17d2\u179b\u17b8\u1797\u17ba\u178f\u17bb\u1793" },
            { "CR", "\u1780\u17bc\u179f\u17d2\u178f\u17b6\u179a\u17b8\u1780\u17b6" },
            { "CU", "\u1782\u17bb\u1799\u1794\u17b6" },
            { "CV", "\u1780\u17b6\u1794\u17cb\u179c\u17c2\u179a" },
            { "CW", "\u1780\u17bc\u179a\u17c9\u17b6\u1780\u17c5" },
            { "CX", "\u1780\u17c4\u17c7\u200b\u1782\u17d2\u179a\u17b8\u179f\u17d2\u1798\u17b6\u179f" },
            { "CY", "\u179f\u17ca\u17b8\u1794" },
            { "CZ", "\u1786\u17c2\u1782\u17b6" },
            { "eka", "\u17a2\u17ca\u17b8\u1780\u17b6\u1787\u17bb\u1780" },
            { "DE", metaValue_DE },
            { "ace", "\u17a2\u17b6\u1780\u17a0\u17ca\u17b8\u1793\u17ba\u179f" },
            { "cgg", "\u1788\u17b8\u17a0\u17d2\u1782\u17b6" },
            { "DG", "\u178c\u17c0\u17a0\u17d2\u1782\u17c4\u17a0\u17d2\u1782\u17b6\u179f\u17ca\u17b8" },
            { "type.nu.deva", "\u179b\u17c1\u1781\u200b\u178c\u17b8\u179c\u17c9\u17b6\u178e\u17b6\u1780\u17b6\u179a\u17b8" },
            { "DJ", "\u1787\u17b8\u1794\u17ca\u17bc\u1791\u17b8" },
            { "DK", metaValue_DK },
            { "Brai", "\u17a2\u1780\u17d2\u179f\u179a\u200b\u179f\u1798\u17d2\u179a\u17b6\u1794\u17cb\u1798\u1793\u17bb\u179f\u17d2\u179f\u200b\u1796\u17b7\u1780\u17b6\u179a\u200b\u1797\u17d2\u1793\u17c2\u1780" },
            { "DM", "\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780" },
            { "type.nu.armnlow", "\u179b\u17c1\u1781\u200b\u178f\u17bc\u1785\u200b\u17a2\u17b6\u1798\u17c1\u1793\u17b8" },
            { "DO", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u200b\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780" },
            { "gor", "\u17a0\u17d2\u1782\u17bc\u179a\u17bb\u1793\u178f\u17b6\u17a1\u17bc" },
            { "zun", "\u17a0\u17d2\u179f\u17bc\u1793\u17b8" },
            { "tig", "\u1792\u17b8\u17a0\u17d2\u1782\u17d2\u179a\u17b6" },
            { "DZ", "\u17a2\u17b6\u179b\u17cb\u17a0\u17d2\u179f\u17c1\u179a\u17b8" },
            { "pag", "\u1797\u17c1\u1793\u17a0\u17d2\u1782\u17b6\u179f\u17ca\u17b8\u178e\u17b6\u1793" },
            { "EA", "\u1787\u17ba\u178f\u17b6 \u1793\u17b7\u1784\u200b\u1798\u17c9\u17c1\u179b\u17b8\u17a1\u17b6" },
            { "pam", "\u1795\u17b6\u1798\u1797\u17c1\u1793\u17a0\u17d2\u1782\u17b6" },
            { "EC", "\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u1791\u17d0\u179a" },
            { "pap", "\u1794\u17c9\u17b6\u1794\u17c9\u17c3\u1798\u17c1\u1793\u178f\u17bc" },
            { "ada", "\u17a2\u17b6\u178a\u17c1\u1784\u1798\u17b8" },
            { "EE", metaValue_EE },
            { "EG", "\u17a2\u17c1\u17a0\u17d2\u179f\u17ca\u17b8\u1794" },
            { "EH", "\u179f\u17b6\u17a0\u17b6\u179a\u17c9\u17b6\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "pau", "\u1794\u17c9\u17b6\u179b\u17bc\u17a2\u17b6\u1793" },
            { "chk", "\u1788\u17bc\u1782\u17b8" },
            { "chm", "\u1798\u17c9\u17b6\u179a\u17b8" },
            { "cho", "\u1786\u17bb\u1780\u178f\u17b6\u179c" },
            { "chr", "\u1786\u17c1\u179a\u17bc\u1782\u17b8" },
            { "ER", "\u17a2\u17c1\u179a\u17b8\u178f\u17d2\u179a\u17c1" },
            { "ES", metaValue_ES },
            { "ET", metaValue_ET },
            { "EU", "\u179f\u17a0\u1797\u17b6\u1796\u200b\u17a2\u17ba\u179a\u17c9\u17bb\u1794" },
            { "type.ca.gregorian", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u200b\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17ca\u17b8" },
            { "EZ", "\u178f\u17c6\u1794\u1793\u17cb\u1785\u17b6\u1799\u179b\u17bb\u1799\u17a2\u17ba\u179a\u17c9\u17bc" },
            { "chy", "\u1788\u17b8\u1799\u17b8\u1793\u17b8" },
            { "type.nu.gujr", "\u179b\u17c1\u1781\u200b\u17a0\u17d2\u1780\u17bb\u1799\u17c9\u17b6\u179a\u17b6\u1791\u17b8" },
            { "ady", "\u17a2\u17b6\u178c\u17b8\u17a0\u17d2\u1782\u17b8" },
            { "FI", metaValue_FI },
            { "FJ", "\u17a0\u17d2\u179c\u17b8\u1787\u17b8" },
            { "FK", "\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179c\u1780\u17cb\u17a1\u17c2\u1793" },
            { "FM", "\u1798\u17b8\u1780\u17d2\u179a\u17bc\u178e\u17c1\u179f\u17ca\u17b8" },
            { "FO", "\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179c\u17b6\u179a\u17c9\u17bc" },
            { "Taml", metaValue_ta },
            { "FR", metaValue_FR },
            { "root", "\u179a\u17bc\u178f" },
            { "GA", "\u17a0\u17d2\u1782\u17b6\u1794\u17bb\u1784" },
            { "GB", "\u1785\u1780\u17d2\u179a\u1797\u1796\u200b\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f" },
            { "pcm", "\u1797\u17b6\u179f\u17b6\u1791\u17c6\u1793\u17b6\u1780\u17cb\u1791\u17c6\u1793\u1784\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a\u17b8\u1799\u17c9\u17b6" },
            { "GD", "\u17a0\u17d2\u1782\u17d2\u179a\u17be\u178e\u17b6\u178a" },
            { "GE", metaValue_GE },
            { "GF", "\u17a0\u17d2\u1782\u17b8\u17a2\u17b6\u178e\u17b6 \u1794\u17b6\u179a\u17b6\u17c6\u1784" },
            { "GG", "\u17a0\u17d2\u1782\u17c1\u1793\u179f\u17ca\u17b8" },
            { "GH", "\u17a0\u17d2\u1782\u17b6\u178e\u17b6" },
            { "GI", "\u17a0\u17d2\u179f\u17ca\u17b8\u1794\u17d2\u179a\u17b6\u179b\u17cb\u178f\u17b6" },
            { "GL", "\u17a0\u17d2\u1782\u17d2\u179a\u17c4\u17a2\u1784\u17cb\u17a1\u1784\u17cb" },
            { "GM", "\u17a0\u17d2\u1782\u17c6\u1794\u17ca\u17b8" },
            { "GN", "\u17a0\u17d2\u1782\u17b8\u178e\u17c1" },
            { "GP", "\u17a0\u17d2\u1782\u17c4\u178a\u17ba\u17a1\u17bb\u1794" },
            { "GQ", "\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u1791\u17d0\u179a" },
            { "GR", metaValue_GR },
            { "GS", "\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784 \u1793\u17b7\u1784 \u179f\u1784\u17cb\u179c\u17b7\u1785\u200b\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "GT", "\u1780\u17d2\u179c\u17b6\u178f\u17c1\u1798\u17c9\u17b6\u17a1\u17b6" },
            { "GU", "\u17a0\u17d2\u1782\u17b6\u17c6" },
            { "GW", "\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u1794\u17ca\u17b8\u179f\u17d2\u179f\u17bc" },
            { "tlh", "\u1783\u17d2\u179b\u17b8\u1793\u17a0\u17d2\u1782\u17bb\u1793" },
            { "GY", "\u17a0\u17d2\u1782\u17b8\u1799\u17c9\u17b6\u1793" },
            { "ckb", "\u1783\u17be\u178a\u1797\u17b6\u1782\u1780\u178e\u17d2\u178f\u17b6\u179b" },
            { "zxx", "\u1782\u17d2\u1798\u17b6\u1793\u200b\u1791\u17b7\u1793\u17d2\u1793\u1793\u17d0\u1799\u200b\u1797\u17b6\u179f\u17b6" },
            { "HK", "\u17a0\u17bb\u1784\u1780\u17bb\u1784" },
            { "HM", "\u1780\u17c4\u17c7\u200b\u17a0\u17ba\u178a \u1793\u17b7\u1784\u200b\u1798\u17c9\u17b6\u1780\u17cb\u178a\u17bc\u178e\u17b6\u179b\u17cb" },
            { "HN", "\u17a0\u17bb\u1784\u178c\u17bc\u179a\u17c9\u17b6\u179f" },
            { "HR", "\u1780\u17d2\u179a\u17bc\u17a2\u17b6\u179f\u17ca\u17b8" },
            { "agq", "\u17a2\u17b6\u17a0\u17d2\u1782\u17b8\u1798" },
            { "gsw", "\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784 (\u179f\u17d2\u179c\u17b8\u179f)" },
            { "HT", metaValue_HT },
            { "HU", metaValue_HU },
            { "IC", "\u1780\u17c4\u17c7\u200b\u1780\u17b6\u178e\u17b6\u179a\u17b8" },
            { "ID", metaValue_ID },
            { "IE", metaValue_IE },
            { "nap", "\u1793\u17b6\u1794\u17c9\u17bc\u179b\u17b8\u178f\u17b6\u1793" },
            { "naq", "\u178e\u17b6\u1798\u17c9\u17b6" },
            { "zza", "\u17a0\u17d2\u179f\u17b6\u17a0\u17d2\u179f\u17b6" },
            { "IL", metaValue_IL },
            { "IM", "\u17a2\u17c2\u179b\u17a2\u17bb\u17a0\u17d2\u179c\u1798\u17c2\u1793" },
            { "IN", "\u17a5\u178e\u17d2\u178c\u17b6" },
            { "IO", "\u178a\u17c2\u1793\u178a\u17b8\u200b\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f\u200b\u1793\u17c5\u200b\u1798\u17a0\u17b6\u200b\u179f\u1798\u17bb\u1791\u17d2\u179a\u200b\u17a5\u178e\u17d2\u178c\u17b6" },
            { "IQ", "\u17a2\u17ca\u17b8\u179a\u17c9\u17b6\u1780\u17cb" },
            { "IR", "\u17a2\u17ca\u17b8\u179a\u17c9\u1784\u17cb" },
            { "IS", metaValue_IS },
            { "IT", metaValue_IT },
            { "Zmth", "\u1793\u17b7\u1798\u17b7\u178f\u17d2\u178f\u179f\u1789\u17d2\u1789\u17b6\u1782\u178e\u17b7\u178f\u179c\u17b7\u1791\u17d2\u1799\u17b6" },
            { "type.nu.thai", "\u179b\u17c1\u1781\u200b\u1790\u17c3" },
            { "type.nu.beng", "\u179b\u17c1\u1781\u200b\u1794\u1784\u17cb\u1780\u17d2\u179b\u17b6\u178a\u17c2\u179f" },
            { "JE", "\u1787\u17ba\u179f\u17ca\u17b8" },
            { "type.ca.islamic", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u17a2\u17ca\u17b8\u179f\u17d2\u179b\u17b6\u1798" },
            { "Beng", metaValue_BD },
            { "JM", "\u17a0\u17d2\u179f\u17b6\u1798\u17c9\u17b6\u17a2\u17ca\u17b8\u1780" },
            { "JO", "\u17a0\u17ca\u17d2\u179f\u1780\u178a\u17b6\u1793\u17b8" },
            { "JP", metaValue_JP },
            { "ain", "\u17a2\u17b6\u1799\u1793\u17bc" },
            { "guz", "\u17a0\u17d2\u1782\u17bc\u179f\u17ca\u17b8" },
            { "type.nu.knda", "\u179b\u17c1\u1781\u1781\u17b6\u178e\u17b6\u178a\u17b6" },
            { "type.ca.buddhist", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u1796\u17bb\u1791\u17d2\u1792\u179f\u17b6\u179f\u1793\u17b6" },
            { "KE", "\u1780\u17c1\u1793\u1799\u17c9\u17b6" },
            { "419", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u17a1\u17b6\u1791\u17b8\u1793" },
            { "KG", "\u1780\u17c0\u17a0\u17d2\u179f\u17ca\u17b8\u179f\u17ca\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "KH", "\u1780\u1798\u17d2\u1796\u17bb\u1787\u17b6" },
            { "KI", "\u1782\u17b7\u179a\u17b8\u1794\u17b6\u1791\u17b8" },
            { "KM", "\u1780\u17bc\u1798\u17d0\u179a" },
            { "Knda", metaValue_kn },
            { "KN", "\u179f\u17b6\u17c6\u1784\u200b\u1782\u17b8\u178f \u1793\u17b7\u1784 \u178e\u17c1\u179c\u17b8\u179f" },
            { "KP", "\u1780\u17bc\u179a\u17c9\u17c1\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "KR", "\u1780\u17bc\u179a\u17c9\u17c1\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "KW", "\u1780\u17bc\u179c\u17c9\u17c2\u178f" },
            { "tpi", "\u1790\u17bb\u1780\u1796\u17b8\u179f\u17ca\u17b8\u1793" },
            { "KY", "\u1780\u17c4\u17c7\u200b\u1780\u17c3\u1798\u17c9\u1784\u17cb" },
            { "KZ", "\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u1790\u17b6\u1793" },
            { "Cyrl", "\u179f\u17ca\u17b8\u179a\u17b8\u179b\u17b8\u1780" },
            { "LA", metaValue_LA },
            { "LB", "\u179b\u17b8\u1794\u1784\u17cb" },
            { "LC", "\u179f\u17b6\u17c6\u1784\u179b\u17bc\u179f\u17ca\u17b8" },
            { "gwi", "\u17a0\u17d2\u1782\u17b8\u1785\u1788\u17b8\u1793" },
            { "nds", "\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb\u1780\u17d2\u179a\u17c4\u1798" },
            { "LI", "\u179b\u17b7\u1785\u178f\u17b7\u1793\u179f\u17d2\u178a\u17b6\u1789" },
            { "LK", metaValue_LK },
            { "LR", "\u179b\u17b8\u1794\u17c1\u179a\u17b8\u1799\u17c9\u17b6" },
            { "LS", "\u17a1\u17c1\u179f\u17bc\u178f\u17bc" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", "\u17a1\u17c1\u178f\u17bc\u1793\u17b8" },
            { "Kana", "\u1780\u17b6\u178f\u17b6\u1780\u17b6\u178e\u17b6" },
            { "LY", "\u179b\u17b8\u1794\u17ca\u17b8" },
            { "lad", "\u17a1\u17b6\u178c\u17b8\u178e\u17bc" },
            { "vun", "\u179c\u17bb\u1793\u1785\u17bc" },
            { "lag", "\u17a1\u17b6\u1793\u17a0\u17d2\u1782\u17b8" },
            { "Thaa", "\u1790\u17b6\u178e\u17b6" },
            { "MA", "\u1798\u17c9\u17b6\u179a\u17c9\u17bb\u1780" },
            { "MC", "\u1798\u17c9\u17bc\u178e\u17b6\u1780\u17bc" },
            { "MD", metaValue_MD },
            { "ME", "\u1798\u17c9\u17bb\u1784\u178f\u17c1\u178e\u17c1\u17a0\u17d2\u1782\u17d2\u179a\u17c4" },
            { "MF", "\u179f\u17b6\u17c6\u1784\u200b\u1798\u17c9\u17b6\u1791\u17b8\u1793" },
            { "MG", "\u1798\u17c9\u17b6\u178a\u17b6\u17a0\u17d2\u1782\u17b6\u179f\u17d2\u1780\u17b6" },
            { "Thai", metaValue_TH },
            { "MH", "\u1780\u17c4\u17c7\u200b\u1798\u17c9\u17b6\u179f\u17cb\u179f\u179b" },
            { "ale", "\u17a2\u17b6\u179b\u17bc\u178f" },
            { "MK", "\u1798\u17c9\u17b6\u179f\u17c1\u178a\u17d2\u179c\u17b6\u1793" },
            { "ML", "\u1798\u17c9\u17b6\u179b\u17b8" },
            { "MM", "\u1798\u17b8\u1799\u17c9\u17b6\u1793\u17cb\u1798\u17c9\u17b6 (\u1797\u17bc\u1798\u17b6)" },
            { "MN", metaValue_MN },
            { "new", "\u1793\u17c1\u179c\u17c9\u17b6\u179c\u17b8" },
            { "MO", "\u1798\u17c9\u17b6\u1780\u17b6\u179c \u178f\u17c6\u1794\u1793\u17cb\u179a\u178a\u17d2\u178b\u1794\u17b6\u179b\u1796\u17b7\u179f\u17c1\u179f\u1785\u17b7\u1793" },
            { "MP", "\u1780\u17c4\u17c7\u200b\u1798\u17c9\u17b6\u179a\u17b8\u178e\u17b6\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "MQ", "\u1798\u17c9\u17b6\u1791\u17b8\u1793\u17b8\u1780" },
            { "MR", "\u1798\u17c9\u17bc\u179a\u17b8\u178f\u17b6\u1793\u17b8" },
            { "MS", "\u1798\u17c9\u17bb\u1784\u179f\u17ca\u17c2\u179a\u17c9\u17b6" },
            { "MT", "\u1798\u17c9\u17b6\u179b\u17cb\u178f\u17cd" },
            { "MU", "\u1798\u17c9\u17bc\u179a\u17b8\u179f" },
            { "alt", "\u17a2\u17b6\u179b\u17cb\u178f\u17c3\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "MV", "\u1798\u17c9\u17b6\u179b\u17cb\u178c\u17b8\u179c" },
            { "MW", "\u1798\u17c9\u17b6\u17a1\u17b6\u179c\u17b8" },
            { "MX", "\u1798\u17c9\u17b7\u1780\u179f\u17ca\u17b7\u1780" },
            { "type.ca.japanese", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u200b\u1787\u1794\u17c9\u17bb\u1793" },
            { "MY", "\u1798\u17c9\u17b6\u17a1\u17c1\u179f\u17ca\u17b8" },
            { "MZ", "\u1798\u17c9\u17bc\u179f\u17c6\u1794\u17ca\u17b7\u1780" },
            { "NA", "\u178e\u17b6\u1798\u17b8\u1794\u17ca\u17b8" },
            { "202", "\u17a2\u1793\u17bb\u178f\u17c6\u1794\u1793\u17cb\u179f\u17b6\u17a0\u17b6\u179a\u17c9\u17b6\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780" },
            { "type.ca.hebrew", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u17a0\u17c1\u1794\u17d2\u179a\u17ba" },
            { "NC", "\u1793\u17bc\u179c\u17c2\u179b\u200b\u1780\u17b6\u17a1\u17c1\u178a\u17bc\u1793\u17b8" },
            { "NE", "\u1793\u17b8\u17a0\u17d2\u179f\u17c1" },
            { "NF", "\u1780\u17c4\u17c7\u200b\u178e\u17d0\u179a\u17a0\u17d2\u179c\u1780\u17cb" },
            { "NG", "\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a\u17b8\u1799\u17c9\u17b6" },
            { "trv", "\u178f\u17b6\u179a\u17c9\u17bc\u1780\u17bc" },
            { "NI", "\u1793\u17b8\u1780\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17b6" },
            { "NL", metaValue_NL },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "\u178e\u17c0" },
            { "rof", "\u179a\u17bb\u1798\u1794\u17bc" },
            { "NZ", "\u1793\u17bc\u179c\u17c2\u179b\u200b\u179f\u17c1\u17a1\u1784\u17cb" },
            { "OM", "\u17a2\u17bc\u1798\u17c9\u1784\u17cb" },
            { "anp", "\u17a2\u17b6\u17a0\u17d2\u1782\u17b8\u1780\u17b6" },
            { "crs", "\u179f\u17c1\u179f\u17c1\u179b\u179c\u17c9\u17b6\u1782\u17d2\u179a\u17b8\u17a2\u17bc\u179b (\u1794\u17b6\u179a\u17b6\u17c6\u1784)" },
            { "PA", "\u1794\u17c9\u17b6\u178e\u17b6\u1798\u17c9\u17b6" },
            { "PE", "\u1794\u17c9\u17c1\u179a\u17bc" },
            { "PF", "\u1794\u17c9\u17bc\u179b\u17b8\u200b\u178e\u17c1\u179f\u17ca\u17b8\u200b\u1794\u17b6\u179a\u17b6\u17c6\u1784" },
            { "PG", "\u1794\u17c9\u17b6\u1796\u17bc\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1793\u17bc\u179c\u17c2\u179b\u17a0\u17d2\u1782\u17b8\u178e\u17c1" },
            { "PH", metaValue_PH },
            { "PK", "\u1794\u17c9\u17b6\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "PL", metaValue_PL },
            { "ewo", "\u17a2\u17ca\u17b8\u179c\u17c9\u17bb\u1793\u178a\u17bc" },
            { "PM", "\u179f\u1784\u17cb\u1796\u17d2\u1799\u17c2\u179a \u1793\u17b7\u1784\u200b\u1798\u17b8\u1782\u17b8\u17a1\u17bb\u1784" },
            { "PN", "\u1780\u17c4\u17c7\u200b\u1797\u17b8\u178f\u1780\u17b6\u1793" },
            { "PR", "\u1796\u17d0\u179a\u178f\u17bc\u179a\u17b8\u1780\u17bc" },
            { "PS", "\u178a\u17c2\u1793\u200b\u178a\u17b8\u1794\u17c9\u17b6\u179b\u17c1\u179f\u17d2\u1791\u17b8\u1793" },
            { "PT", metaValue_PT },
            { "PW", "\u1795\u17c5\u17a1\u17bc" },
            { "nia", "\u1793\u17b8\u17a2\u17b6\u179f" },
            { "type.nu.greklow", "\u179b\u17c1\u1781\u200b\u178f\u17bc\u1785\u200b\u1780\u17d2\u179a\u17b7\u1780" },
            { "PY", "\u1794\u17c9\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17b6\u1799" },
            { "tum", "\u1791\u17bb\u1798\u1794\u17ca\u17bc\u1780\u17b6" },
            { "Hebr", metaValue_IL },
            { "QA", "\u1780\u17b6\u178f\u17b6" },
            { "niu", "\u1793\u17bc\u17a2\u17c0\u1793" },
            { "QO", "\u178f\u17c6\u1794\u1793\u17cb\u1787\u17b6\u1799\u17a2\u17bc\u179f\u17c1\u17a2\u17b6\u1793\u17b8" },
            { "lez", "\u17a1\u17c1\u179f\u17a0\u17d2\u1782\u17b8" },
            { "tvl", metaValue_TV },
            { "001", "\u1796\u17b7\u1797\u1796\u179b\u17c4\u1780" },
            { "002", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780" },
            { "003", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "RE", "\u179a\u17c1\u17a2\u17bb\u1799\u1789\u17c9\u17bb\u1784" },
            { "005", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "jbo", "\u179b\u17bb\u1785\u1794\u17b6\u1793" },
            { "009", "\u17a2\u17bc\u179f\u17c1\u17a2\u17b6\u1793\u17b8" },
            { "RO", metaValue_RO },
            { "RS", "\u179f\u17c2\u1794\u17ca\u17b8" },
            { "RU", metaValue_RU },
            { "RW", "\u179a\u179c\u17c9\u17b6\u1793\u17cb\u178a\u17b6" },
            { "SA", "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u179f\u17b6\u17a2\u17bc\u178c\u17b8\u178f" },
            { "SB", "\u1780\u17c4\u17c7\u200b\u179f\u17bc\u17a1\u17bc\u1798\u17c9\u17bb\u1784" },
            { "twq", "\u178f\u17b6\u179f\u17b6\u179c\u17c9\u17b6\u1780\u17cb" },
            { "011", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u200b\u1781\u17b6\u1784\u200b\u179b\u17b7\u1785" },
            { "SC", "\u179f\u17b8\u179f\u17d2\u17a0\u17c2\u179b" },
            { "SD", metaValue_SD },
            { "SE", metaValue_SE },
            { "013", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u1780\u178e\u17d2\u178a\u17b6\u179b" },
            { "014", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1781\u17b6\u1784\u1780\u17be\u178f" },
            { "015", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "SG", "\u179f\u17b7\u1784\u17d2\u17a0\u1794\u17bb\u179a\u17b8" },
            { "SH", "\u179f\u1784\u17cb\u200b\u17a0\u17c1\u17a1\u17c1\u178e\u17b6" },
            { "type.lb.strict", "\u179a\u1794\u17c0\u1794\u1785\u17bb\u17c7\u1794\u1793\u17d2\u1791\u17b6\u178f\u17cb\u178f\u17b9\u1784\u179a\u17b9\u1784" },
            { "017", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u200b\u1780\u178e\u17d2\u178f\u17b6\u179b" },
            { "SI", "\u179f\u17d2\u179b\u17bc\u179c\u17c1\u1793\u17b8" },
            { "018", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1797\u17b6\u1782\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "SJ", "\u179f\u17d2\u179c\u17b6\u179b\u1794\u17b6\u178a \u1793\u17b7\u1784 \u17a0\u17d2\u179f\u1784\u17cb\u1798\u17c9\u17b6\u1799\u17c1\u1793" },
            { "SK", metaValue_SK },
            { "019", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "SL", "\u179f\u17c0\u179a\u17c9\u17b6\u17a1\u17c1\u17a2\u17bc\u1793" },
            { "SM", "\u179f\u17b6\u1793\u200b\u1798\u17c9\u17b6\u179a\u17b8\u178e\u17bc" },
            { "SN", "\u179f\u17c1\u178e\u17c1\u17a0\u17d2\u1782\u17b6\u179b\u17cb" },
            { "SO", metaValue_SO },
            { "arn", "\u1798\u17c9\u17b6\u1796\u17bc\u1788\u17b8" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "arp", "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17c9\u17b6\u17a0\u17bc" },
            { "SR", "\u179f\u17bc\u179a\u17b8\u178e\u17b6\u1798" },
            { "SS", "\u179f\u17ca\u17bc\u178a\u1784\u17cb\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "ST", "\u179f\u17c5\u178f\u17bc\u1798\u17c9\u17c1 \u1793\u17b7\u1784 \u1794\u17d2\u179a\u17b6\u17c6\u1784\u179f\u17ca\u17b8\u1794" },
            { "SV", "\u17a2\u17c2\u179b\u179f\u17b6\u179b\u17cb\u179c\u17c9\u17b6\u178c\u17d0\u179a" },
            { "SX", "\u179f\u17b8\u1784\u200b\u1798\u17c9\u17b6\u1792\u17b8\u1793" },
            { "SY", metaValue_SY },
            { "SZ", "\u179f\u17d2\u179c\u17b6\u179f\u17ca\u17b8\u17a1\u1784\u17cb" },
            { "TA", "\u1791\u17d2\u179a\u17b8\u179f\u17d2\u178f\u1784\u17cb\u200b\u178a\u17b6\u200b\u1785\u17bc\u1793\u17a0\u17b6" },
            { "asa", "\u17a2\u17b6\u179f\u17ca\u17bc" },
            { "type.ms.ussystem", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792\u179c\u17b6\u179f\u17cb\u179c\u17c2\u1784\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "021", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u1797\u17b6\u1782\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "TC", "\u1780\u17c4\u17c7\u200b\u1791\u17bd\u1782 \u1793\u17b7\u1784 \u1780\u17c3\u1780\u17bc\u179f" },
            { "yav", "\u1799\u17c9\u17b6\u1784\u1794\u17c1\u1793" },
            { "TD", "\u1786\u17b6\u178a" },
            { "TF", "\u178a\u17c2\u1793\u178a\u17b8\u200b\u1794\u17b6\u179a\u17b6\u17c6\u1784\u200b\u1793\u17c5\u200b\u1797\u17b6\u1782\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "TG", "\u178f\u17bc\u17a0\u17d2\u1782\u17c4" },
            { "TH", metaValue_TH },
            { "TJ", "\u178f\u17b6\u17a0\u17d2\u179f\u17ca\u17b8\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "029", "\u1780\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u1793" },
            { "TK", "\u178f\u17bc\u1781\u17c1\u17a1\u17c5" },
            { "TL", "\u1791\u17b8\u1798\u17d0\u179a\u179b\u17b8\u179f" },
            { "ybb", "\u1799\u17c1\u1798\u1794\u17b6" },
            { "TM", "\u178f\u17bd\u1780\u1798\u17c9\u17c1\u1793\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "TN", "\u1791\u17bb\u1799\u1793\u17b8\u179f\u17ca\u17b8" },
            { "TO", metaValue_TO },
            { "TR", "\u178f\u17bd\u1780\u1782\u17b8" },
            { "TT", "\u1791\u17d2\u179a\u17b8\u1793\u17b8\u178a\u17b6\u178f \u1793\u17b7\u1784\u200b\u178f\u17bc\u1794\u17b6\u17a0\u17d2\u1782\u17c4" },
            { "TV", metaValue_TV },
            { "TW", "\u178f\u17c3\u179c\u17c9\u17b6\u1793\u17cb" },
            { "ast", "\u17a2\u17b6\u179f\u17d2\u1791\u17bc\u179a\u17b8" },
            { "TZ", "\u178f\u1784\u17cb\u179f\u17b6\u1793\u17b8" },
            { "nmg", "\u1780\u17d2\u179c\u17b6\u179f\u17d2\u1799\u17bc" },
            { "Zzzz", "\u17a2\u1780\u17d2\u179f\u179a\u1798\u17b7\u1793\u179f\u17d2\u1782\u17b6\u179b\u17cb" },
            { "UA", metaValue_UA },
            { "rup", "\u17a2\u17b6\u179a\u17c9\u17bc\u1798\u17c9\u17b6\u1793\u17b8" },
            { "030", "\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u200b\u1780\u17be\u178f" },
            { "tyv", "\u1791\u17bc\u179c\u17b8\u1793\u17c0" },
            { "sw_CD", "\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179f\u17d2\u179c\u17b6\u17a0\u17ca\u17b8\u179b\u17b8" },
            { "034", "\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "035", "\u17a2\u17b6\u179f\u17ca\u17b8\u17a2\u17b6\u1782\u17d2\u1793\u17c1\u1799\u17cd" },
            { "UG", "\u17a2\u17ca\u17bc\u17a0\u17d2\u1782\u1784\u17cb\u178a\u17b6" },
            { "039", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "Sinh", "\u179f\u17ca\u17b8\u1793\u17a0\u17b6\u17a1\u17b6" },
            { "UM", "\u1780\u17c4\u17c7\u200b\u17a2\u17c5\u17a1\u17b6\u1799\u17b8\u1784\u200b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "UN", "\u17a2\u1784\u17d2\u1782\u1780\u17b6\u179a\u179f\u17a0\u1794\u17d2\u179a\u1787\u17b6\u1787\u17b6\u178f\u17b7" },
            { "US", "\u179f\u17a0\u179a\u178a\u17d2\u178b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "haw", "\u17a0\u17b6\u179c\u17c3" },
            { "UY", "\u17a2\u17ca\u17bb\u1799\u179a\u17bc\u17a0\u17d2\u1782\u17b6\u1799" },
            { "prg", "\u1796\u17d2\u179a\u17bc\u179f\u17ca\u17b6\u1793" },
            { "UZ", "\u17a2\u17ca\u17bc\u179f\u1794\u17c1\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "tzm", "\u178f\u17b6\u1798\u17c9\u17b6\u179f\u17b6\u1799\u17a2\u17b6\u178f\u17d2\u179b\u17b6\u179f\u1780\u178e\u17d2\u178f\u17b6\u179b" },
            { "nnh", "\u1784\u17c0\u1798\u1794\u17ca\u17bc\u1793" },
            { "VA", "\u1794\u17bb\u179a\u17b8\u200b\u179c\u17c9\u17b6\u1791\u17b8\u1780\u1784\u17cb" },
            { "VC", "\u179f\u17b6\u17c6\u1784\u200b\u179c\u17c9\u17b6\u17c6\u1784\u179f\u1784\u17cb \u1793\u17b7\u1784 \u17a0\u17d2\u1782\u17d2\u179a\u17c1\u178e\u17b6\u178c\u17b8\u1793" },
            { "VE", "\u179c\u17c9\u17c1\u178e\u17c1\u179f\u17ca\u17bb\u1799\u17a2\u17c1\u17a1\u17b6" },
            { "VG", "\u1780\u17c4\u17c7\u200b\u179c\u17ba\u1787\u17b7\u1793\u200b\u1785\u1780\u17d2\u179a\u1797\u1796\u200b\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f" },
            { "VI", "\u1780\u17c4\u17c7\u200b\u179c\u17ba\u1787\u17b8\u1793\u200b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "VN", metaValue_VN },
            { "VU", "\u179c\u17c9\u17b6\u1793\u17bc\u1791\u17bc" },
            { "nog", "\u178e\u17bc\u17a0\u17d2\u1782\u17c3" },
            { "rwk", "\u179a\u17c9\u17d2\u179c\u17b6" },
            { "053", "\u17a2\u17bc\u179f\u17d2\u178f\u17d2\u179a\u17b6\u17a1\u17b6\u179f\u17ca\u17b8" },
            { "054", "\u1798\u17c1\u17a1\u17b6\u178e\u17c1\u179f\u17ca\u17b8" },
            { "WF", "\u179c\u17c9\u17b6\u179b\u17b8\u179f \u1793\u17b7\u1784\u200b\u17a0\u17d2\u179c\u17bc\u1791\u17bc\u178e\u17b6" },
            { "057", "\u178f\u17c6\u1794\u1793\u17cb\u200b\u1798\u17b8\u1780\u17d2\u179a\u17bc\u178e\u17c1\u179f\u17ca\u17b8" },
            { "jgo", "\u1784\u17bb\u17c6\u1794\u17b6" },
            { "lkt", "\u17a1\u17b6\u1780\u17bc\u178f\u17b6" },
            { "wae", "\u179c\u17c1\u179b\u179f\u17ba" },
            { "WS", metaValue_WS },
            { "wal", "\u179c\u17c9\u17bc\u17a1\u17b6\u1799\u178f\u17b6" },
            { "war", "\u179c\u17c9\u17b6\u179a\u17c1\u1799" },
            { "awa", "\u17a2\u17b6\u179c\u17c9\u17b6\u178c\u17b8" },
            { "061", "\u1794\u17c9\u17bc\u179b\u17b8\u178e\u17c1\u179f\u17ca\u17b8" },
            { "XK", "\u1780\u17bc\u179f\u17bc\u179c\u17c9\u17bc" },
            { "Gujr", "\u1782\u17bc\u1785\u17b6\u179a\u17c9\u17b6\u1791\u17b8" },
            { "Zxxx", "\u1782\u17d2\u1798\u17b6\u1793\u1780\u17b6\u179a\u179f\u179a\u179f\u17c1\u179a" },
            { "wbp", "\u179c\u17c9\u17b6\u179a\u17b8\u1794\u17c9\u17b6\u179a\u17b8" },
            { "YE", "\u1799\u17c1\u1798\u17c9\u17c2\u1793" },
            { "nqo", "\u1793\u1782\u17c4" },
            { "type.co.standard", "\u179b\u17c6\u178a\u17b6\u1794\u17cb\u200b\u178f\u1798\u17d2\u179a\u17c0\u1794\u200b\u179f\u17d2\u178f\u1784\u17cb\u178a\u17b6\u179a" },
            { "YT", "\u1798\u17c9\u17b6\u1799\u17bb\u178f" },
            { "ZA", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "type.lb.loose", "\u179a\u1794\u17c0\u1794\u1785\u17bb\u17c7\u1794\u1793\u17d2\u1791\u17b6\u178f\u17cb\u1781\u17d2\u179b\u17b8" },
            { "Deva", "\u178a\u17b6\u179c\u17c9\u17b6\u1793\u17cb\u178e\u17b6\u1780\u17b6\u179a\u17b7" },
            { "type.nu.geor", "\u179b\u17c1\u1781\u200b\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17b8" },
            { "Hira", "\u17a0\u17ca\u17b8\u179a\u17c9\u17b6\u1780\u17b6\u178e\u17b6" },
            { "ZM", "\u179f\u17c6\u1794\u17ca\u17b8" },
            { "ZW", "\u179f\u17ca\u17b8\u1798\u1794\u17b6\u179c\u17c9\u17c1" },
            { "ZZ", "\u178f\u17c6\u1794\u1793\u17cb\u1798\u17b7\u1793\u179f\u17d2\u1782\u17b6\u179b\u17cb" },
            { "type.ms.metric", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792\u179c\u17b6\u179f\u17cb\u179c\u17c2\u1784\u1798\u17c9\u17b6\u1791\u17d2\u179a\u17b7\u1780" },
            { "type.ca.iso8601", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793 ISO-8601" },
            { "nso", "\u179f\u17bc\u1790\u17bc\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "type.nu.telu", "\u179b\u17c1\u1781\u200b\u178f\u17c1\u179b\u17bb\u1782\u17bb" },
            { "loz", "\u17a1\u17bc\u17a0\u17d2\u179f\u17ca\u17b8" },
            { "jmc", "\u1798\u17c9\u17b6\u1786\u17b6\u17c6" },
            { "type.nu.hansfin", "\u179b\u17c1\u1781\u200b\u17a0\u17b7\u179a\u1789\u17d2\u1789\u179c\u178f\u17d2\u1790\u17bb\u200b\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1780\u17b6\u178f\u17cb" },
            { "hil", "\u17a0\u17ca\u17b8\u179b\u17b8\u17a0\u17d2\u1782\u17c1\u178e\u17bb\u1793" },
            { "type.nu.arabext", "\u179b\u17c1\u1781\u200b\u17a5\u178e\u17d2\u178c\u17b6-\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u200b\u1796\u1784\u17d2\u179a\u17b8\u1780" },
            { "nus", "\u1793\u17bc\u17a2\u17d0\u179a" },
            { "dak", "\u178a\u17b6\u1780\u17bc\u178f\u17b6" },
            { "type.nu.fullwide", "\u179b\u17c1\u1781\u200b\u1791\u1791\u17b9\u1784\u200b\u1796\u17c1\u1789" },
            { "dar", "\u178a\u17b6\u1785\u179c\u17c9\u17b6" },
            { "dav", "\u178f\u17c3\u178f\u17b6" },
            { "lrc", "\u179b\u17bc\u179a\u17b8\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "udm", "\u17a2\u17b6\u178f\u17cb\u1798\u17bc\u178a" },
            { "Khmr", metaValue_km },
            { "sad", "\u179f\u17b6\u1793\u178a\u17b6\u179c\u17b8" },
            { "type.nu.roman", "\u179b\u17c1\u1781\u200b\u179a\u17c9\u17bc\u1798\u17b6\u17c6\u1784" },
            { "sah", "\u179f\u17b6\u1781\u17b6" },
            { "saq", "\u179f\u17b6\u1798\u1794\u17bc\u179a\u17bc" },
            { "sat", "\u179f\u17b6\u1793\u17cb\u178f\u17b6\u179b\u17b8" },
            { "sba", "\u1784\u17b6\u17c6\u1794\u17c1\u1799" },
            { "Guru", "\u1780\u17bb\u1798\u17bb\u1799\u1783\u17b8" },
            { "lua", "\u179b\u17bc\u1794\u17b6\u179b\u17bc\u17a1\u17b6" },
            { "sbp", "\u179f\u17b6\u1793\u17a0\u17d2\u1782\u17bc" },
            { "nyn", "\u178e\u17b6\u1793\u1780\u17bc\u179b\u17c1" },
            { "lun", "\u179b\u17bb\u1793\u178a\u17b6" },
            { "luo", "\u179b\u17bc\u17a2\u17bc" },
            { "fil", metaValue_PH },
            { "hmn", "\u1798\u17c9\u17bb\u1784" },
            { "lus", "\u1798\u17b8\u17a0\u17d2\u179f\u17bc" },
            { "ban", "\u1794\u17b6\u179b\u17b8" },
            { "luy", "\u179b\u17bc\u1799\u17c9\u17b6" },
            { "bas", "\u1794\u17b6\u179f\u17b6" },
            { "es_ES", "\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789 (\u17a2\u17ca\u17ba\u179a\u17c9\u17bb\u1794)" },
            { "sco", "\u179f\u17d2\u1780\u17bb\u178f" },
            { "scn", "\u179f\u17ca\u17b8\u179f\u17ca\u17b8\u179b\u17b6\u1793" },
            { "aa", "\u17a2\u17b6\u17a0\u17d2\u179c\u17b6\u179a" },
            { "ab", "\u17a2\u17b6\u1794\u17cb\u1781\u17b6\u17a0\u17ca\u17d2\u179f\u17b6\u1793" },
            { "ae", "\u17a2\u17b6\u179c\u17c1\u179f\u17d2\u1790\u17b6\u1793" },
            { "af", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u17b6\u1793" },
            { "ak", "\u17a2\u17b6\u1780\u17b6\u1793" },
            { "am", "\u17a2\u17b6\u17c6\u17a0\u17b6\u179a\u17b7\u1780" },
            { "Arab", metaValue_ar },
            { "an", "\u17a2\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17c4\u1793" },
            { "Jpan", metaValue_JP },
            { "ar", metaValue_ar },
            { "Hrkt", "\u179f\u1789\u17d2\u1789\u17b6\u179f\u17c6\u17a1\u17c1\u1784\u1797\u17b6\u179f\u17b6\u1787\u1794\u17c9\u17bb\u1793" },
            { "as", "\u17a2\u17b6\u179f\u17b6\u1798\u17b8\u179f" },
            { "av", "\u17a2\u17b6\u179c\u17c9\u17b6\u179a\u17b8\u1780" },
            { "sdh", "\u1783\u17be\u178a\u1797\u17b6\u1782\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "ay", "\u17a2\u17b8\u1798\u17c9\u17b6\u179a\u17c9\u17b6" },
            { "az", metaValue_AZ },
            { "ba", "\u1794\u17b6\u179f\u17d2\u1782\u17c0" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bi", "\u1794\u17ca\u17b8\u179f\u17d2\u179b\u17b6\u1798\u17c9\u17b6" },
            { "bm", "\u1794\u17b6\u1798\u17d2\u1794\u17b6\u179a\u17b6" },
            { "bn", metaValue_BD },
            { "bo", metaValue_bo },
            { "dgr", "\u178a\u17bc\u1782\u17d2\u179a\u17b8\u1794" },
            { "br", "\u1794\u17d2\u179a\u17b8\u179f\u17d2\u178f\u17bb\u1793" },
            { "bs", "\u1794\u17bc\u179f\u17d2\u1793\u17b8" },
            { "Mymr", metaValue_my },
            { "type.nu.laoo", "\u179b\u17c1\u1781\u200b\u17a1\u17b6\u179c" },
            { "seh", "\u179f\u17ca\u17b8\u178e\u17b6" },
            { "ca", "\u1780\u17b6\u178f\u17b6\u17a1\u17b6\u1793" },
            { "ses", "\u1782\u17bb\u1799\u179a\u17c9\u17b6\u1794\u17bc\u179a\u17c9\u17bb\u179f\u17ca\u17b8\u1793\u17b8" },
            { "ce", "\u1788\u17b8\u1786\u17c1\u1793" },
            { "ch", "\u1788\u17b8\u1798\u17c9\u17bc\u179a\u17c9\u17bc" },
            { "co", "\u1780\u17bc\u179f\u17ca\u17b8\u1781\u17b6\u1793" },
            { "Orya", metaValue_or },
            { "cs", "\u1786\u17c2\u1780" },
            { "cu", "\u1788\u17ba\u1787\u179f\u17d2\u179b\u17b6\u179c\u17b7\u1780" },
            { "cv", "\u1788\u17bc\u179c\u17c9\u17b6\u179f" },
            { "cy", "\u179c\u17c1\u179b" },
            { "type.nu.ethi", "\u179b\u17c1\u1781\u200b\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8" },
            { "da", metaValue_DK },
            { "pt_PT", "\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1782\u17b6\u179b\u17cb (\u17a2\u17ba\u179a\u17c9\u17bb\u1794)" },
            { "de", metaValue_DE },
            { "type.cf.standard", "\u1791\u1798\u17d2\u179a\u1784\u17cb\u179a\u17bc\u1794\u17b7\u1799\u1794\u17d0\u178e\u17d2\u178e\u1794\u1791\u178a\u17d2\u178b\u17b6\u1793" },
            { "bem", "\u1794\u17c1\u1798\u1794\u17b6" },
            { "dv", "\u1791\u17c1\u179c\u17b8\u17a0\u17ca\u17b8" },
            { "dz", "\u178a\u17bb\u1784\u1781\u17b6" },
            { "bez", "\u1794\u17c1\u178e\u17b6" },
            { "type.ca.chinese", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u200b\u1785\u17b7\u1793" },
            { "dje", "\u17a0\u17d2\u179f\u17b6\u1798\u17c9\u17b6" },
            { "type.nu.grek", "\u179b\u17c1\u1781\u200b\u1780\u17d2\u179a\u17b7\u1780" },
            { "ee", "\u17a2\u17ca\u17b8\u179c" },
            { "type.lb.normal", "\u179a\u1794\u17c0\u1794\u1785\u17bb\u17c7\u1794\u1793\u17d2\u1791\u17b6\u178f\u17cb\u1792\u1798\u17d2\u1798\u178f\u17b6" },
            { "ro_MD", metaValue_MD },
            { "el", metaValue_GR },
            { "en", "\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f" },
            { "eo", "\u17a2\u17c1\u179f\u17d2\u1796\u17c1\u179a\u17c9\u17b6\u1793\u17cb\u178f\u17bc" },
            { "es", metaValue_ES },
            { "et", metaValue_EE },
            { "Hanb", "\u17a0\u17b6\u1793\u1794\u17cd" },
            { "eu", "\u1794\u17b6\u179f\u1781\u17cd" },
            { "Hang", "\u17a0\u17b6\u17c6\u1784\u1780\u17bb\u179b" },
            { "shi", "\u178f\u17b6\u1788\u17b8\u179b\u17a0\u17ca\u17b8\u178f" },
            { "hsb", "\u179f\u17bc\u1794\u17ca\u17b8\u179b\u17be" },
            { "Hani", "\u17a0\u17b6\u1793" },
            { "shn", "\u179f\u17b6\u1793" },
            { "fa", "\u1797\u17ba\u179f\u17c0\u1793" },
            { "Hans", "\u17a2\u1780\u17d2\u179f\u179a\u200b\u1785\u17b7\u1793\u200b\u1780\u17b6\u178f\u17cb" },
            { "type.nu.latn", "\u179b\u17c1\u1781\u200b\u1794\u1785\u17d2\u1785\u17b9\u1798\u200b\u1794\u17d2\u179a\u1791\u17c1\u179f" },
            { "Hant", "\u17a2\u1780\u17d2\u179f\u179a\u200b\u1785\u17b7\u1793\u200b\u1796\u17c1\u1789" },
            { "ff", "\u17a0\u17d2\u179c\u17ca\u17bc\u17a1\u17b6" },
            { "fi", metaValue_FI },
            { "fj", "\u17a0\u17ca\u17d2\u179c\u17b8\u1787\u17b8" },
            { "fon", "\u17a0\u17d2\u179c\u17ca\u17bb\u1793" },
            { "bgn", "\u1794\u17b6\u17a1\u17bc\u1787\u17b8\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "yue", "\u1780\u1793\u17d2\u178f\u17b6\u17c6\u1784" },
            { "fo", "\u17a0\u17d2\u179c\u17b6\u179a\u17bc\u179f" },
            { "umb", "\u17a2\u17b6\u1798\u17cb\u1794\u17ca\u17bb\u1793\u178c\u17bc" },
            { "fr", metaValue_FR },
            { "fy", "\u17a0\u17d2\u179c\u17d2\u179a\u17b8\u179f\u17ca\u17b6\u1793\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "ga", metaValue_IE },
            { "gd", "\u179f\u17d2\u1780\u17bb\u178f\u17a0\u17d2\u1780\u17c2\u179b\u17b7\u1782" },
            { "gl", "\u17a0\u17d2\u1782\u17b6\u179b\u17b8\u179f\u17d2\u1799\u17b6\u1793" },
            { "gn", "\u17a0\u17d2\u1782\u17bc\u179a\u17c9\u17b6\u1793\u17b8" },
            { "bho", "\u1794\u17bc\u1785\u1796\u17bc\u179a\u17b8" },
            { "und", "\u1797\u17b6\u179f\u17b6\u1798\u17b7\u1793\u179f\u17d2\u1782\u17b6\u179b\u17cb" },
            { "gu", "\u17a0\u17d2\u1780\u17bb\u1799\u17c9\u17b6\u179a\u17b6\u1791\u17b8" },
            { "gv", "\u1798\u17c1\u1793" },
            { "ha", "\u17a0\u17bc\u179f\u17b6" },
            { "he", "\u17a0\u17c1\u1794\u17d2\u179a\u17ba" },
            { "hi", "\u17a0\u17b7\u178e\u17d2\u178c\u17b8" },
            { "hup", "\u17a0\u17ca\u17bc\u1794\u17c9\u17b6" },
            { "bin", "\u1794\u17ca\u17b8\u1793\u17b8" },
            { "hr", "\u1780\u17d2\u179a\u17bc\u17a2\u17b6\u178f" },
            { "ht", metaValue_HT },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "\u17a0\u17ba\u179a\u17b8\u179a\u17c9\u17bc" },
            { "ia", "\u17a2\u17b8\u1793\u1792\u17be\u179b\u17b8\u1784" },
            { "Jamo", "\u1785\u17b6\u1798\u17c9\u17bc" },
            { "id", metaValue_ID },
            { "type.nu.tibt", "\u179b\u17c1\u1781\u1791\u17b8\u1794\u17c1" },
            { "ig", "\u17a2\u17ca\u17b8\u1780\u1794\u17bc" },
            { "ii", "\u179f\u17ca\u17b8\u1788\u17b6\u1793\u17cb\u1799\u17b8" },
            { "io", "\u17a2\u17ca\u17b8\u178a\u17bc" },
            { "is", metaValue_IS },
            { "it", metaValue_IT },
            { "iu", "\u17a2\u17ca\u17b8\u1793\u17bb\u1780\u1791\u17b8\u1791\u17bb\u178f" },
            { "ja", metaValue_JP },
            { "Mlym", "\u1798\u179b\u1799\u17b6\u179b\u17d0\u1798" },
            { "sma", "\u179f\u17b6\u1798\u17b8\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "jv", "\u1787\u17d2\u179c\u17b6" },
            { "mad", "\u1798\u17c9\u17b6\u178c\u17bc\u179a\u17b8\u179f" },
            { "smj", "\u179b\u17bc\u179b\u17b8\u179f\u17b6\u1798\u17b8" },
            { "mag", "\u1798\u17c9\u17b6\u17a0\u17d2\u1782\u17b6\u17a0\u17ca\u17b8" },
            { "mai", "\u1798\u17c9\u17c3\u1792\u17b8\u179b\u17b8" },
            { "smn", "\u17a2\u17ca\u17b8\u178e\u17b6\u179a\u17b8\u179f\u17b6\u1798\u17c9\u17b8" },
            { "ka", "\u17a0\u17d2\u179f\u1780\u200b\u17a0\u17d2\u179f\u17ca\u17b8" },
            { "bla", "\u179f\u17ca\u17b8\u1780\u179f\u17ca\u17b8\u1780\u17b6" },
            { "mak", "\u1798\u17c9\u17b6\u1780\u17b6\u179f\u17b6" },
            { "sms", "\u179f\u17d2\u1780\u17bb\u179b\u179f\u17b6\u1798\u17b8" },
            { "ki", "\u1782\u17b8\u1782\u17bc\u1799\u17bc" },
            { "mas", "\u1798\u17c9\u17b6\u179f\u17c3" },
            { "kj", "\u1782\u17bc\u1793\u1799\u17c9\u17b6\u1798\u17c9\u17b6" },
            { "kk", "\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb" },
            { "kl", "\u1780\u17b6\u17a1\u17b6\u179b\u179b\u17b8\u179f\u17ca\u17bb\u178f" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u1780\u17b6\u1793\u17bc\u179a\u17b8" },
            { "ks", "\u1780\u17b6\u179f\u17d2\u1798\u17c0\u179a" },
            { "ku", "\u1783\u17ba\u178a" },
            { "kv", "\u1780\u17bc\u1798\u17b8" },
            { "kw", "\u1780\u17bc\u1793\u17b8\u179f" },
            { "ky", "\u200b\u1780\u17c0\u17a0\u17d2\u179f\u17ca\u17b8\u179f" },
            { "snk", "\u179f\u17bc\u1793\u17b8\u1793\u1782\u17c1" },
            { "la", "\u17a1\u17b6\u178f\u17c6\u17b6\u1784" },
            { "lb", metaValue_LU },
            { "type.nu.mlym", "\u179b\u17c1\u1781\u200b\u1798\u179b\u1799\u17b6\u179b\u17d0\u1798" },
            { "lg", "\u17a0\u17d2\u1782\u17b6\u1793\u17cb\u178a\u17b6" },
            { "li", "\u179b\u17b8\u1798\u1794\u17ca\u17bc\u179f" },
            { "Tibt", metaValue_bo },
            { "ln", "\u179b\u17b8\u1793\u1780\u17b6\u17a1\u17b6" },
            { "fur", "\u17a0\u17ca\u17d2\u179c\u17d2\u179a\u17bc\u179b\u17b6\u1793" },
            { "lo", metaValue_LA },
            { "type.ms.uksystem", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792\u179c\u17b6\u179f\u17cb\u179c\u17c2\u1784\u1785\u1780\u17d2\u179a\u1796\u17d0\u1791\u17d2\u1792" },
            { "lt", metaValue_LT },
            { "lu", "\u179b\u17bc\u1794\u17b6\u1780\u17b6\u178f\u17b6\u1793\u17a0\u17d2\u1782\u17b6" },
            { "lv", "\u17a1\u17b6\u178f\u179c\u17b8" },
            { "mg", "\u1798\u17c9\u17b6\u17a1\u17b6\u17a0\u17d2\u1782\u17b6\u179f\u17ca\u17b8" },
            { "mh", "\u1798\u17c9\u17b6\u179f\u17cb\u179f\u179b" },
            { "type.co.ducet", "\u179b\u17c6\u178a\u17b6\u1794\u17cb\u200b\u178f\u1798\u17d2\u179a\u17c0\u1794\u200b\u1799\u17bc\u1793\u17b8\u1780\u17bc\u178a\u200b\u179b\u17c6\u1793\u17b6\u17c6\u178a\u17be\u1798" },
            { "mi", "\u1798\u17c9\u17c4\u179a\u17b8" },
            { "mk", "\u1798\u17c9\u17b6\u179f\u17c1\u178a\u17bc\u1793\u17b8" },
            { "ml", "\u1798\u17c9\u17b6\u17a1\u17b6\u1799\u17c9\u17b6\u17a1\u17b6\u1798" },
            { "mn", metaValue_MN },
            { "mr", "\u1798\u17c9\u17b6\u179a\u17c9\u17b6\u1792\u17b8" },
            { "ms", "\u1798\u17c9\u17b6\u17a1\u17c1" },
            { "mt", "\u1798\u17c9\u17b6\u179b\u17cb\u178f\u17b6" },
            { "my", metaValue_my },
            { "Armn", metaValue_AM },
            { "mdf", "\u1798\u17bb\u1781\u179f\u17b6" },
            { "dsb", "\u179f\u17bc\u1794\u17ca\u17b8\u1780\u17d2\u179a\u17c4\u1798" },
            { "na", metaValue_NR },
            { "type.co.search", "\u179f\u17d2\u179c\u17c2\u1784\u179a\u1780\u200b\u1791\u17bc\u1791\u17c5" },
            { "nb", "\u1793\u17d0\u179a\u179c\u17c2\u179f \u1794\u17bb\u1780\u1798\u17c9\u17b6\u179b\u17cb" },
            { "nd", "\u1793\u17c1\u1794\u17c1\u179b\u17c1\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "ne", metaValue_NP },
            { "ng", "\u1793\u17bb\u1793\u17a0\u17d2\u1782\u17b6" },
            { "nl", metaValue_NL },
            { "nn", "\u1793\u17d0\u179a\u179c\u17c2\u179f \u1793\u17b8\u1793\u17bc\u179f" },
            { "no", metaValue_NO },
            { "nr", "\u1793\u17c1\u1794\u17ca\u17c1\u179b\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "nv", "\u178e\u17b6\u179c\u17c9\u17b6\u1785\u17bc" },
            { "ny", "\u178e\u17b6\u1793\u1785\u17b6" },
            { "kac", "\u1780\u17b6\u1788\u17b8\u1793" },
            { "kab", "\u1780\u17b6\u1794\u17ca\u17b8\u17a1\u17c1" },
            { "oc", "\u17a2\u17bc\u179f\u17b8\u178f\u17b6\u1793\u17cb" },
            { "kaj", "\u1787\u17bc" },
            { "kam", "\u1780\u17b6\u17c6\u1794\u17b6" },
            { "men", "\u1798\u17c1\u1793\u178c\u17b8" },
            { "mer", "\u1798\u17c1\u179a\u17bc" },
            { "type.nu.armn", "\u179b\u17c1\u1781\u200b\u17a2\u17b6\u1798\u17c1\u1793\u17b8" },
            { "om", "\u17a2\u17bc\u179a\u17c9\u17bc\u1798\u17c9\u17bc" },
            { "or", metaValue_or },
            { "os", "\u17a2\u17bc\u179f\u17ca\u17b8\u1791\u17b7\u1780" },
            { "kbd", "\u1780\u17b6\u1794\u17b6\u178c\u17c0" },
            { "mfe", "\u1798\u17c9\u17bc\u179a\u17b8\u179f\u17ca\u17b8\u1793" },
            { "srn", "\u179f\u17d2\u179a\u17b6\u178e\u17b6\u1793\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17c4" },
            { "pa", "\u1794\u17b9\u1793\u1787\u17b6\u1796\u17b7" },
            { "dua", "\u178c\u17bd\u179b\u17a1\u17b6" },
            { "pl", metaValue_PL },
            { "type.ca.dangi", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u1780\u17bc\u179a\u17c9\u17c1" },
            { "ps", "\u1794\u17b6\u179f\u17d2\u178f\u17bc" },
            { "pt", metaValue_PT },
            { "key.co", "\u179b\u17c6\u178a\u17b6\u1794\u17cb\u200b\u178f\u1798\u17d2\u179a\u17c0\u1794" },
            { "kcg", "\u1799\u17c9\u17b6\u1794\u17cb" },
            { "mgh", "\u1798\u17c9\u17b6\u1780\u1782\u17bc\u179c\u17c9\u17b6\u1798\u17b8\u178f\u17bc" },
            { "key.cf", "\u1791\u1798\u17d2\u179a\u1784\u17cb\u179a\u17bc\u1794\u17b7\u1799\u1794\u17d0\u178e\u17d2\u178e" },
            { "key.ca", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793" },
            { "Laoo", metaValue_LA },
            { "mgo", "\u1798\u17c1\u178f\u17b6" },
            { "type.hc.h23", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792 24 \u1798\u17c9\u17c4\u1784 (0\u201323)" },
            { "type.hc.h24", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792 24 \u1798\u17c9\u17c4\u1784 (1\u201324)" },
            { "ssy", "\u179f\u17b6\u17a0\u17bc" },
            { "type.nu.mymr", "\u179b\u17c1\u1781\u200b\u1797\u17bc\u1798\u17b6" },
            { "qu", "\u17a0\u17d2\u1782\u17b7\u1780\u1788\u17bd" },
            { "brx", "\u1794\u17bc\u178a\u17bc" },
            { "kde", "\u1798\u17c9\u17b6\u1780\u17bc\u1793\u178a\u17c1" },
            { "Ethi", metaValue_ET },
            { "type.hc.h12", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792 12 \u1798\u17c9\u17c4\u1784 (1\u201312)" },
            { "type.hc.h11", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792 12 \u1798\u17c9\u17c4\u1784 (0\u201311)" },
            { "rm", "\u179a\u17c9\u17bc\u1798\u17c9\u1784\u17cb" },
            { "rn", "\u179a\u17bb\u178e\u17d2\u178c\u17b8" },
            { "key.cu", "\u179a\u17bc\u1794\u17b7\u1799\u1794\u17d0\u178e\u17d2\u178e" },
            { "ro", metaValue_RO },
            { "type.nu.orya", "\u179b\u17c1\u1781\u17a2\u17bc\u178c\u17c0" },
            { "type.nu.hanidec", "\u179b\u17c1\u1781\u200b\u1791\u179f\u1797\u17b6\u1782\u200b\u1785\u17b7\u1793" },
            { "ru", metaValue_RU },
            { "rw", "\u1782\u17b7\u1793\u1799\u17c9\u17b6\u179c\u17c9\u17b6\u1793\u17cb\u178a\u17b6" },
            { "kea", "\u1780\u17b6\u1794\u17ca\u17bc\u179c\u17ba\u178c\u17c0\u1793\u17bc" },
            { "mic", "\u1798\u17b7\u1780\u1798\u17c1\u1780" },
            { "suk", "\u179f\u17ca\u17bc\u1782\u17bc\u1798\u17c9\u17b6" },
            { "sa", "\u179f\u17c6\u179f\u17d2\u1780\u17d2\u179a\u17b9\u178f" },
            { "sc", "\u179f\u17b6\u178c\u17b8\u1793\u17b6" },
            { "sd", "\u179f\u17ca\u17b8\u1793\u178c\u17b8" },
            { "se", "\u179f\u17b6\u1798\u17b8\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "min", "\u1798\u17b8\u178e\u17b6\u1784\u1780\u17b6\u1794\u17ca\u17bc" },
            { "sg", "\u179f\u17b6\u1793\u17a0\u17d2\u1782\u17c4" },
            { "sh", "\u179f\u17ba\u1794\u17bc\u1780\u17d2\u179a\u17bc\u17a2\u17b6\u178f" },
            { "si", metaValue_LK },
            { "sk", metaValue_SK },
            { "sl", "\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1793\u17b8" },
            { "sm", metaValue_WS },
            { "sn", "\u179f\u17bc\u178e\u17b6" },
            { "so", metaValue_SO },
            { "type.nu.arab", "\u179b\u17c1\u1781\u200b\u17a5\u178e\u17d2\u178c\u17b6-\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb" },
            { "sq", metaValue_AL },
            { "sr", "\u179f\u17ca\u17c2\u1794" },
            { "ListKeyTypePattern", "{0}\u17d6 {1}" },
            { "ss", "\u179f\u17d2\u179c\u17b6\u1791\u17b8" },
            { "type.cf.account", "\u1791\u1798\u17d2\u179a\u1784\u17cb\u179a\u17bc\u1794\u17b7\u1799\u1794\u17d0\u178e\u17d2\u178e\u1782\u178e\u1793\u17b8" },
            { "st", "\u179f\u17bc\u1790\u17bc\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "su", metaValue_SD },
            { "sv", metaValue_SE },
            { "sw", "\u179f\u17d2\u179c\u17b6\u17a0\u17ca\u17b8\u179b\u17b8" },
            { "type.nu.hantfin", "\u179b\u17c1\u1781\u200b\u17a0\u17b7\u179a\u1789\u17d2\u1789\u179c\u178f\u17d2\u1790\u17bb\u200b\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1796\u17c1\u1789" },
            { "ibb", "\u17a2\u17b6\u1799\u1794\u17ca\u17b8\u1794\u17ca\u17b8\u17a2\u17bc" },
            { "iba", "\u17a2\u17ca\u17b8\u1794\u17b6\u1793" },
            { "ta", metaValue_ta },
            { "142", "\u17a2\u17b6\u179f\u17ca\u17b8" },
            { "143", "\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1780\u178e\u17d2\u178a\u17b6\u179b" },
            { "te", metaValue_te },
            { "145", "\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u200b\u179b\u17b7\u1785" },
            { "tg", "\u178f\u17b6\u17a0\u17d2\u179f\u17ca\u17b8\u1782" },
            { "th", metaValue_TH },
            { "ti", "\u1791\u17b8\u17a0\u17d2\u1782\u17d2\u179a\u17b8\u1789\u17c9\u17b6" },
            { "bug", "\u1794\u17ca\u17bb\u1780\u17a0\u17d2\u1782\u17b8" },
            { "kfo", "\u1782\u17bc\u179a\u17bc" },
            { "tk", "\u178f\u17bd\u1780\u1798\u17c9\u17c1\u1793" },
            { "tn", "\u179f\u17d2\u179c\u17b6\u178e\u17b6" },
            { "to", metaValue_TO },
            { "dyo", "\u1785\u17bc\u17a1\u17b6\u17a0\u17ca\u17d2\u179c\u17bb\u1793\u1799\u17b8" },
            { "type.nu.jpan", "\u179b\u17c1\u1781\u200b\u1787\u1794\u17c9\u17bb\u1793" },
            { "tr", "\u1791\u17bd\u179a\u1782\u17b8" },
            { "ts", "\u179f\u17bb\u1784\u17a0\u17d2\u1782\u17b6" },
            { "swb", "\u1780\u17bc\u1798\u17c9\u17bc\u179a\u17b8" },
            { "tt", "\u178f\u17b6\u178f\u17b6" },
            { "tw", "\u1791\u17d2\u179c\u17b8" },
            { "ty", "\u178f\u17b6\u17a0\u17ca\u17b8\u1791\u17b8" },
            { "150", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794" },
            { "151", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794\u200b\u1781\u17b6\u1784\u200b\u1780\u17be\u178f" },
            { "154", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "dzg", "\u178a\u17b6\u17a0\u17d2\u179f\u17b6\u17a0\u17d2\u1782\u17b6" },
            { "155", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794\u200b\u1781\u17b6\u1784\u200b\u179b\u17b7\u1785" },
            { "ug", "\u17a2\u17ca\u17bb\u1799\u17a0\u17d2\u1782\u17ba\u179a" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u1791\u17bc\u1791\u17c5" },
            { "uk", metaValue_UA },
            { "ur", "\u17a2\u17ca\u17bc\u179a\u178c\u17bc" },
            { "xal", "\u1780\u17b6\u179b\u1798\u17b8\u1782" },
            { "uz", "\u17a2\u17ca\u17bc\u179f\u1794\u17c1\u1782" },
            { "kha", "\u1780\u17b6\u179f\u17ca\u17b8" },
            { "nds_NL", "\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u1799\u17bb\u1784\u1780\u17d2\u179a\u17c4\u1798" },
            { "ve", "\u179c\u17c1\u1793\u178a\u17b6" },
            { "type.ca.roc", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u1798\u17b8\u1784\u1782\u17d0\u179a" },
            { "vi", metaValue_VN },
            { "khq", "\u1782\u17bb\u1799\u179a\u17c9\u17b6\u1788\u17b8\u1793\u17b8" },
            { "key.hc", "\u179c\u178a\u17d2\u178f\u1798\u17c9\u17c4\u1784 (12 vs 24)" },
            { "vo", "\u179c\u17bc\u17a1\u17b6\u1796\u17bc\u1780" },
            { "quc", "\u1782\u17b8\u1785\u1788\u17b8" },
            { "gaa", "\u17a0\u17d2\u1782\u17b6" },
            { "wa", "\u179c\u17c9\u17b6\u179b\u17bc\u1793" },
            { "gag", "\u1780\u17b6\u1782\u17bc\u179f" },
            { "syr", metaValue_SY },
            { "Grek", "\u1780\u17d2\u179a\u17b7\u1785" },
            { "wo", "\u179c\u17bc\u17a1\u17bb\u17a0\u17d2\u179c" },
            { "zgh", "\u178f\u17b6\u1798\u17c9\u17b6\u17a0\u17d2\u179f\u17c3\u1798\u17c9\u17b6\u179a\u17c9\u17bb\u1780\u179f\u17d2\u178f\u1784\u17cb\u178a\u17b6" },
            { "ar_001", "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb (\u179f\u17d2\u178f\u1784\u17cb\u178a\u17b6\u179a)" },
            { "Mong", metaValue_MN },
            { "mni", "\u1798\u17c9\u17b6\u1793\u17b8\u1796\u17bc\u179a\u17b8" },
            { "Latn", "\u17a1\u17b6\u178f\u17b6\u17c6\u1784" },
            { "type.nu.hans", "\u179b\u17c1\u1781\u200b\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1780\u17b6\u178f\u17cb" },
            { "type.nu.hant", "\u179b\u17c1\u1781\u200b\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1796\u17c1\u1789" },
            { "xh", "\u1783\u179f\u17b6" },
            { "type.nu.romanlow", "\u179b\u17c1\u1781\u200b\u178f\u17bc\u1785\u200b\u179a\u17c9\u17bc\u1798\u17b6\u17c6\u1784" },
            { "byn", "\u1794\u17d2\u179b\u17ca\u17b8\u1793" },
            { "moh", "\u1798\u17ca\u17bc\u17a0\u17b6\u1782" },
            { "kkj", "\u1780\u17b6\u1780\u17bc" },
            { "yi", "\u1799\u17c9\u17b8\u178c\u17b8\u179f" },
            { "mos", "\u1798\u17bc\u179f\u17ca\u17b8" },
            { "yo", "\u1799\u179a\u17bc\u1794\u17b6" },
            { "vai", "\u179c\u17c3" },
            { "za", "\u17a0\u17d2\u179f\u17bd\u1784" },
            { "kln", "\u1780\u17b6\u179b\u17c2\u1793\u1787\u17b8\u1793" },
            { "zh", metaValue_CN },
            { "Bopo", "\u1794\u17bc\u1795\u17bc\u1798\u17c9\u17bc\u17a0\u17d2\u179c\u17bc" },
            { "key.lb", "\u179a\u1794\u17c0\u1794\u1785\u17bb\u17c7\u1794\u1793\u17d2\u1791\u17b6\u178f\u17cb" },
            { "zu", "\u17a0\u17d2\u179f\u17bc\u179b\u17bc" },
            { "Geor", metaValue_GE },
            { "kmb", "\u1782\u17b8\u1798\u1794\u17ca\u17bb\u1793\u178c\u17bc" },
            { "type.nu.jpanfin", "\u179b\u17c1\u1781\u200b\u17a0\u17b7\u179a\u1789\u17d2\u1789\u179c\u178f\u17d2\u1790\u17bb\u200b\u1787\u1794\u17c9\u17bb\u1793" },
            { "gez", "\u1787\u17b8\u179f" },
            { "ebu", "\u17a2\u17c1\u1798\u1794\u17ca\u17bc" },
            { "zh_Hans", "\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1780\u17b6\u178f\u17cb" },
            { "koi", "\u1782\u17bc\u1798\u17b8\u1797\u17b9\u1798\u1799\u17c9\u17b6\u1782" },
            { "kok", "\u1782\u17bb\u1793\u1780\u17b6\u1793\u17b8" },
            { "zh_Hant", "\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1796\u17c1\u1789" },
            { "kpe", "\u1782\u17d2\u179b\u17b8\u1794" },
            { "type.nu.khmr", "\u179b\u17c1\u1781\u200b\u1781\u17d2\u1798\u17c2\u179a" },
            { "ilo", "\u17a2\u17ca\u17b8\u17a1\u17bc\u1780\u17bc" },
            { "mua", "\u1798\u17bb\u1793\u178a\u17b6\u1784" },
            { "type.nu.guru", "\u179b\u17c1\u1781\u200b\u1780\u17bb\u1798\u17bb\u1783\u17b8" },
            { "mul", "\u1796\u17a0\u17bb\u1797\u17b6\u179f\u17b6" },
            { "key.ms", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792\u179c\u17b6\u179f\u17cb\u179c\u17c2\u1784" },
            { "mus", "\u1782\u17d2\u179a\u17b8\u1780" },
            { "gil", "\u17a0\u17d2\u1782\u17b8\u179b\u1794\u17ba\u1791" },
            { "type.nu.tamldec", metaValue_type_nu_taml },
            { "krc", "\u1780\u17b6\u179a\u17c9\u17b6\u1786\u17b6\u1799\u1794\u17b6\u179b\u17cb\u1780\u17b6" },
            { "inh", "\u17a2\u17ca\u17b7\u1793\u17a0\u17d2\u1782\u17bc\u179f" },
            { "krl", "\u1780\u17b6\u179a\u17b8\u179b\u17b6" },
            { "efi", "\u17a2\u17ca\u17b8\u17a0\u17d2\u179c\u17b7\u1780" },
            { "key.nu", "\u179b\u17c1\u1781" },
            { "kru", "\u1782\u17bc\u179a\u17bc\u1780" },
            { "ksb", "\u179f\u17b6\u1798\u1794\u17b6\u17a1\u17b6" },
            { "Telu", metaValue_te },
            { "ksf", "\u1794\u17b6\u17a0\u17d2\u179c\u17c0" },
        };
        return data;
    }
}
