Object.assign(window.search, {"doc_urls":["what-is-rustdoc.html#what-is-rustdoc","what-is-rustdoc.html#basic-usage","what-is-rustdoc.html#using-rustdoc-with-cargo","what-is-rustdoc.html#using-standalone-markdown-files","what-is-rustdoc.html#summary","how-to-write-documentation.html#how-to-write-documentation","how-to-write-documentation.html#basic-structure","how-to-write-documentation.html#markdown","how-to-write-documentation.html#lints","command-line-arguments.html#command-line-arguments","command-line-arguments.html#-h--help-help","command-line-arguments.html#-v--version-version-information","command-line-arguments.html#-v--verbose-more-verbose-output","command-line-arguments.html#-r--input-format-input-format","command-line-arguments.html#-w--output-format-output-format","command-line-arguments.html#-o--output-output-path","command-line-arguments.html#--crate-name-controlling-the-name-of-the-crate","command-line-arguments.html#-l--library-path-where-to-look-for-dependencies","command-line-arguments.html#--cfg-passing-configuration-flags","command-line-arguments.html#--extern-specify-a-dependencys-location","command-line-arguments.html#-c--codegen-pass-codegen-options-to-rustc","command-line-arguments.html#--passes-add-more-rustdoc-passes","command-line-arguments.html#--no-defaults-dont-run-default-passes","command-line-arguments.html#--test-run-code-examples-as-tests","command-line-arguments.html#--test-args-pass-options-to-test-runner","command-line-arguments.html#--target-generate-documentation-for-the-specified-target-triple","command-line-arguments.html#--markdown-css-include-more-css-files-when-rendering-markdown","command-line-arguments.html#--html-in-header-include-more-html-in","command-line-arguments.html#--html-before-content-include-more-html-before-the-content","command-line-arguments.html#--html-after-content-include-more-html-after-the-content","command-line-arguments.html#--markdown-playground-url-control-the-location-of-the-playground","command-line-arguments.html#--markdown-no-toc-dont-generate-a-table-of-contents","command-line-arguments.html#-e--extend-css-extend-rustdocs-css","command-line-arguments.html#--sysroot-override-the-system-root","command-line-arguments.html#--edition-control-the-edition-of-docs-and-doctests","command-line-arguments.html#--theme-add-a-theme-to-the-documentation-output","command-line-arguments.html#--check-theme-verify-custom-themes-against-the-default-theme","command-line-arguments.html#--crate-version-control-the-crate-version","the-doc-attribute.html#the-doc-attribute","the-doc-attribute.html#at-the-crate-level","the-doc-attribute.html#html_favicon_url","the-doc-attribute.html#html_logo_url","the-doc-attribute.html#html_playground_url","the-doc-attribute.html#issue_tracker_base_url","the-doc-attribute.html#html_root_url","the-doc-attribute.html#html_no_source","the-doc-attribute.html#testno_crate_inject","the-doc-attribute.html#testattr","the-doc-attribute.html#at-the-item-level","the-doc-attribute.html#docno_inlinedocinline","the-doc-attribute.html#dochidden","the-doc-attribute.html#docprimitive","documentation-tests.html#documentation-tests","documentation-tests.html#passing-or-failing-a-doctest","documentation-tests.html#pre-processing-examples","documentation-tests.html#hiding-portions-of-the-example","documentation-tests.html#using--in-doc-tests","documentation-tests.html#documenting-macros","documentation-tests.html#attributes","documentation-tests.html#syntax-reference","documentation-tests.html#include-items-only-when-collecting-doctests","lints.html#lints","lints.html#intra_doc_link_resolution_failure","lints.html#missing_docs","lints.html#missing_doc_code_examples","lints.html#private_doc_tests","passes.html#passes","passes.html#default-passes","passes.html#strip-hidden","passes.html#unindent-comments","passes.html#collapse-docs","passes.html#strip-private","passes.html#strip-priv-imports","advanced-features.html#advanced-features","advanced-features.html#cfgdoc-documenting-platform-feature-specific-information","unstable-features.html#unstable-features","unstable-features.html#nightly-gated-functionality","unstable-features.html#error-numbers-for-compile-fail-doctests","unstable-features.html#linking-to-items-by-name","unstable-features.html#extensions-to-the-doc-attribute","unstable-features.html#documenting-platform-feature-specific-information","unstable-features.html#exclude-certain-dependencies-from-documentation","unstable-features.html#include-external-files-as-api-documentation","unstable-features.html#add-aliases-for-an-item-in-documentation-search","unstable-features.html#unstable-command-line-arguments","unstable-features.html#--markdown-before-content-include-rendered-markdown-before-the-content","unstable-features.html#--markdown-after-content-include-rendered-markdown-after-the-content","unstable-features.html#--playground-url-control-the-location-of-the-playground","unstable-features.html#--sort-modules-by-appearance-control-how-items-on-module-pages-are-sorted","unstable-features.html#--resource-suffix-modifying-the-name-of-cssjavascript-in-crate-docs","unstable-features.html#--display-warnings-display-warnings-when-documenting-or-running-documentation-tests","unstable-features.html#--extern-html-root-url-control-how-rustdoc-links-to-non-local-crates","unstable-features.html#-z-force-unstable-if-unmarked","unstable-features.html#--index-page-provide-a-top-level-landing-page-for-docs","unstable-features.html#--enable-index-page-generate-a-default-index-page-for-docs","unstable-features.html#--static-root-path-control-how-static-files-are-loaded-in-html-output","unstable-features.html#--persist-doctests-persist-doctest-executables-after-running","unstable-features.html#--show-coverage-calculate-the-percentage-of-items-with-documentation","unstable-features.html#--enable-per-target-ignores-allow-ignore-foo-style-filters-for-doctests","unstable-features.html#--runtool---runtool-arg-program-to-run-tests-with-args-to-pass-to-it"],"index":{"documentStore":{"docInfo":{"0":{"body":25,"breadcrumbs":1,"title":1},"1":{"body":152,"breadcrumbs":2,"title":2},"10":{"body":27,"breadcrumbs":3,"title":3},"11":{"body":18,"breadcrumbs":4,"title":4},"12":{"body":50,"breadcrumbs":5,"title":5},"13":{"body":33,"breadcrumbs":5,"title":5},"14":{"body":19,"breadcrumbs":5,"title":5},"15":{"body":26,"breadcrumbs":4,"title":4},"16":{"body":25,"breadcrumbs":5,"title":5},"17":{"body":34,"breadcrumbs":5,"title":5},"18":{"body":23,"breadcrumbs":4,"title":4},"19":{"body":28,"breadcrumbs":4,"title":4},"2":{"body":79,"breadcrumbs":3,"title":3},"20":{"body":91,"breadcrumbs":6,"title":6},"21":{"body":32,"breadcrumbs":5,"title":5},"22":{"body":30,"breadcrumbs":5,"title":5},"23":{"body":19,"breadcrumbs":5,"title":5},"24":{"body":24,"breadcrumbs":6,"title":6},"25":{"body":28,"breadcrumbs":6,"title":6},"26":{"body":31,"breadcrumbs":8,"title":8},"27":{"body":22,"breadcrumbs":5,"title":5},"28":{"body":30,"breadcrumbs":8,"title":8},"29":{"body":27,"breadcrumbs":6,"title":6},"3":{"body":47,"breadcrumbs":4,"title":4},"30":{"body":23,"breadcrumbs":6,"title":6},"31":{"body":20,"breadcrumbs":6,"title":6},"32":{"body":30,"breadcrumbs":6,"title":6},"33":{"body":17,"breadcrumbs":4,"title":4},"34":{"body":33,"breadcrumbs":5,"title":5},"35":{"body":47,"breadcrumbs":5,"title":5},"36":{"body":59,"breadcrumbs":8,"title":8},"37":{"body":27,"breadcrumbs":5,"title":5},"38":{"body":103,"breadcrumbs":2,"title":2},"39":{"body":6,"breadcrumbs":2,"title":2},"4":{"body":11,"breadcrumbs":1,"title":1},"40":{"body":22,"breadcrumbs":1,"title":1},"41":{"body":26,"breadcrumbs":1,"title":1},"42":{"body":25,"breadcrumbs":1,"title":1},"43":{"body":28,"breadcrumbs":1,"title":1},"44":{"body":50,"breadcrumbs":1,"title":1},"45":{"body":10,"breadcrumbs":1,"title":1},"46":{"body":12,"breadcrumbs":1,"title":1},"47":{"body":16,"breadcrumbs":1,"title":1},"48":{"body":8,"breadcrumbs":2,"title":2},"49":{"body":139,"breadcrumbs":1,"title":1},"5":{"body":33,"breadcrumbs":2,"title":2},"50":{"body":10,"breadcrumbs":1,"title":1},"51":{"body":19,"breadcrumbs":1,"title":1},"52":{"body":61,"breadcrumbs":2,"title":2},"53":{"body":37,"breadcrumbs":3,"title":3},"54":{"body":87,"breadcrumbs":3,"title":3},"55":{"body":225,"breadcrumbs":3,"title":3},"56":{"body":130,"breadcrumbs":3,"title":3},"57":{"body":76,"breadcrumbs":2,"title":2},"58":{"body":132,"breadcrumbs":1,"title":1},"59":{"body":72,"breadcrumbs":2,"title":2},"6":{"body":140,"breadcrumbs":2,"title":2},"60":{"body":158,"breadcrumbs":4,"title":4},"61":{"body":28,"breadcrumbs":1,"title":1},"62":{"body":27,"breadcrumbs":1,"title":1},"63":{"body":27,"breadcrumbs":1,"title":1},"64":{"body":50,"breadcrumbs":1,"title":1},"65":{"body":37,"breadcrumbs":1,"title":1},"66":{"body":21,"breadcrumbs":1,"title":1},"67":{"body":23,"breadcrumbs":2,"title":2},"68":{"body":19,"breadcrumbs":2,"title":2},"69":{"body":40,"breadcrumbs":2,"title":2},"7":{"body":12,"breadcrumbs":1,"title":1},"70":{"body":25,"breadcrumbs":2,"title":2},"71":{"body":26,"breadcrumbs":2,"title":2},"72":{"body":9,"breadcrumbs":3,"title":3},"73":{"body":8,"breadcrumbs":2,"title":2},"74":{"body":108,"breadcrumbs":6,"title":6},"75":{"body":44,"breadcrumbs":2,"title":2},"76":{"body":25,"breadcrumbs":3,"title":3},"77":{"body":66,"breadcrumbs":5,"title":5},"78":{"body":145,"breadcrumbs":3,"title":3},"79":{"body":12,"breadcrumbs":3,"title":3},"8":{"body":13,"breadcrumbs":1,"title":1},"80":{"body":186,"breadcrumbs":5,"title":5},"81":{"body":82,"breadcrumbs":4,"title":4},"82":{"body":46,"breadcrumbs":5,"title":5},"83":{"body":32,"breadcrumbs":5,"title":5},"84":{"body":32,"breadcrumbs":4,"title":4},"85":{"body":53,"breadcrumbs":8,"title":8},"86":{"body":49,"breadcrumbs":6,"title":6},"87":{"body":96,"breadcrumbs":5,"title":5},"88":{"body":37,"breadcrumbs":8,"title":8},"89":{"body":43,"breadcrumbs":7,"title":7},"9":{"body":5,"breadcrumbs":3,"title":3},"90":{"body":43,"breadcrumbs":8,"title":8},"91":{"body":69,"breadcrumbs":10,"title":10},"92":{"body":41,"breadcrumbs":4,"title":4},"93":{"body":30,"breadcrumbs":8,"title":8},"94":{"body":9,"breadcrumbs":8,"title":8},"95":{"body":70,"breadcrumbs":9,"title":9},"96":{"body":36,"breadcrumbs":6,"title":6},"97":{"body":110,"breadcrumbs":6,"title":6},"98":{"body":81,"breadcrumbs":10,"title":10},"99":{"body":49,"breadcrumbs":8,"title":8}},"docs":{"0":{"body":"The standard Rust distribution ships with a tool called rustdoc. Its job is to generate documentation for Rust projects. On a fundamental level, Rustdoc takes as an argument either a crate root or a Markdown file, and produces HTML, CSS, and JavaScript.","breadcrumbs":"What is rustdoc?","id":"0","title":"What is rustdoc?"},"1":{"body":"Let's give it a try! Let's create a new project with Cargo: $ cargo new docs\n$ cd docs In src/lib.rs, you'll find that Cargo has generated some sample code. Delete it and replace it with this: /// foo is a function\nfn foo() {} Let's run rustdoc on our code. To do so, we can call it with the path to our crate root like this: $ rustdoc src/lib.rs This will create a new directory, doc, with a website inside! In our case, the main page is located in doc/lib/index.html. If you open that up in a web browser, you'll see a page with a search bar, and \"Crate lib\" at the top, with no contents. There's two problems with this: first, why does it think that our package is named \"lib\"? Second, why does it not have any contents? The first problem is due to rustdoc trying to be helpful; like rustc, it assumes that our crate's name is the name of the file for the crate root. To fix this, we can pass in a command-line flag: $ rustdoc src/lib.rs --crate-name docs Now, doc/docs/index.html will be generated, and the page says \"Crate docs.\" For the second issue, it's because our function foo is not public; rustdoc defaults to generating documentation for only public functions. If we change our code... /// foo is a function\npub fn foo() {} ... and then re-run rustdoc: $ rustdoc src/lib.rs --crate-name docs We'll have some generated documentation. Open up doc/docs/index.html and check it out! It should show a link to the foo function's page, which is located at doc/docs/fn.foo.html. On that page, you'll see the \"foo is a function\" we put inside the documentation comment in our crate.","breadcrumbs":"Basic usage","id":"1","title":"Basic usage"},"10":{"body":"Using this flag looks like this: $ rustdoc -h\n$ rustdoc --help This will show rustdoc's built-in help, which largely consists of a list of possible command-line flags. Some of rustdoc's flags are unstable; this page only shows stable options, --help will show them all.","breadcrumbs":"-h/--help: help","id":"10","title":"-h/--help: help"},"11":{"body":"Using this flag looks like this: $ rustdoc -V\n$ rustdoc --version This will show rustdoc's version, which will look something like this: rustdoc 1.17.0 (56124baa9 2017-04-24)","breadcrumbs":"-V/--version: version information","id":"11","title":"-V/--version: version information"},"12":{"body":"Using this flag looks like this: $ rustdoc -v src/lib.rs\n$ rustdoc --verbose src/lib.rs This enables \"verbose mode\", which means that more information will be written to standard out. What is written depends on the other flags you've passed in. For example, with --version: $ rustdoc --verbose --version\nrustdoc 1.17.0 (56124baa9 2017-04-24)\nbinary: rustdoc\ncommit-hash: hash\ncommit-date: date\nhost: host-triple\nrelease: 1.17.0\nLLVM version: 3.9","breadcrumbs":"-v/--verbose: more verbose output","id":"12","title":"-v/--verbose: more verbose output"},"13":{"body":"This flag is currently ignored; the idea is that rustdoc would support various input formats, and you could specify them via this flag. Rustdoc only supports Rust source code and Markdown input formats. If the file ends in .md or .markdown, rustdoc treats it as a Markdown file. Otherwise, it assumes that the input file is Rust.","breadcrumbs":"-r/--input-format: input format","id":"13","title":"-r/--input-format: input format"},"14":{"body":"This flag is currently ignored; the idea is that rustdoc would support various output formats, and you could specify them via this flag. Rustdoc only supports HTML output, and so this flag is redundant today.","breadcrumbs":"-w/--output-format: output format","id":"14","title":"-w/--output-format: output format"},"15":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -o target/doc\n$ rustdoc src/lib.rs --output target/doc By default, rustdoc's output appears in a directory named doc in the current working directory. With this flag, it will place all output into the directory you specify.","breadcrumbs":"-o/--output: output path","id":"15","title":"-o/--output: output path"},"16":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --crate-name mycrate By default, rustdoc assumes that the name of your crate is the same name as the .rs file. --crate-name lets you override this assumption with whatever name you choose.","breadcrumbs":"--crate-name: controlling the name of the crate","id":"16","title":"--crate-name: controlling the name of the crate"},"17":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -L target/debug/deps\n$ rustdoc src/lib.rs --library-path target/debug/deps If your crate has dependencies, rustdoc needs to know where to find them. Passing --library-path gives rustdoc a list of places to look for these dependencies. This flag takes any number of directories as its argument, and will use all of them when searching.","breadcrumbs":"-L/--library-path: where to look for dependencies","id":"17","title":"-L/--library-path: where to look for dependencies"},"18":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --cfg feature=\"foo\" This flag accepts the same values as rustc --cfg, and uses it to configure compilation. The example above uses feature, but any of the cfg values are acceptable.","breadcrumbs":"--cfg: passing configuration flags","id":"18","title":"--cfg: passing configuration flags"},"19":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --extern lazy-static=/path/to/lazy-static Similar to --library-path, --extern is about specifying the location of a dependency. --library-path provides directories to search in, --extern instead lets you specify exactly which dependency is located where.","breadcrumbs":"--extern: specify a dependency's location","id":"19","title":"--extern: specify a dependency's location"},"2":{"body":"Cargo also has integration with rustdoc to make it easier to generate docs. Instead of the rustdoc command, we could have done this: $ cargo doc Internally, this calls out to rustdoc like this: $ rustdoc --crate-name docs src/lib.rs -o <path>/docs/target/doc -L\ndependency=<path>/docs/target/debug/deps You can see this with cargo doc --verbose. It generates the correct --crate-name for us, as well as pointing to src/lib.rs But what about those other arguments? -o controls the o utput of our docs. Instead of a top-level doc directory, you'll notice that Cargo puts generated documentation under target. That's the idiomatic place for generated files in Cargo projects. Also, it passes -L, a flag that helps rustdoc find the dependencies your code relies on. If our project used dependencies, we'd get documentation for them as well!","breadcrumbs":"Using rustdoc with Cargo","id":"2","title":"Using rustdoc with Cargo"},"20":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -C target_feature=+avx\n$ rustdoc src/lib.rs --codegen target_feature=+avx $ rustdoc --test src/lib.rs -C target_feature=+avx\n$ rustdoc --test src/lib.rs --codegen target_feature=+avx $ rustdoc --test README.md -C target_feature=+avx\n$ rustdoc --test README.md --codegen target_feature=+avx When rustdoc generates documentation, looks for documentation tests, or executes documentation tests, it needs to compile some rust code, at least part-way. This flag allows you to tell rustdoc to provide some extra codegen options to rustc when it runs these compilations. Most of the time, these options won't affect a regular documentation run, but if something depends on target features to be enabled, or documentation tests need to use some additional options, this flag allows you to affect that. The arguments to this flag are the same as those for the -C flag on rustc. Run rustc -C help to get the full list.","breadcrumbs":"-C/--codegen: pass codegen options to rustc","id":"20","title":"-C/--codegen: pass codegen options to rustc"},"21":{"body":"Using this flag looks like this: $ rustdoc --passes list\n$ rustdoc src/lib.rs --passes strip-priv-imports An argument of \"list\" will print a list of possible \"rustdoc passes\", and other arguments will be the name of which passes to run in addition to the defaults. For more details on passes, see the chapter on them . See also --no-defaults.","breadcrumbs":"--passes: add more rustdoc passes","id":"21","title":"--passes: add more rustdoc passes"},"22":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --no-defaults By default, rustdoc will run several passes over your code. This removes those defaults, allowing you to use --passes to specify exactly which passes you want. For more details on passes, see the chapter on them . See also --passes.","breadcrumbs":"--no-defaults: don't run default passes","id":"22","title":"--no-defaults: don't run default passes"},"23":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --test This flag will run your code examples as tests. For more, see the chapter on documentation tests . See also --test-args.","breadcrumbs":"--test: run code examples as tests","id":"23","title":"--test: run code examples as tests"},"24":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --test --test-args ignored This flag will pass options to the test runner when running documentation tests. For more, see the chapter on documentation tests . See also --test.","breadcrumbs":"--test-args: pass options to test runner","id":"24","title":"--test-args: pass options to test runner"},"25":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --target x86_64-pc-windows-gnu Similar to the --target flag for rustc, this generates documentation for a target triple that's different than your host triple. All of the usual caveats of cross-compiling code apply.","breadcrumbs":"--target: generate documentation for the specified target triple","id":"25","title":"--target: generate documentation for the specified target triple"},"26":{"body":"Using this flag looks like this: $ rustdoc README.md --markdown-css foo.css When rendering Markdown files, this will create a <link> element in the <head> section of the generated HTML. For example, with the invocation above, <link rel=\"stylesheet\" type=\"text/css\" href=\"foo.css\"> will be added. When rendering Rust files, this flag is ignored.","breadcrumbs":"--markdown-css: include more CSS files when rendering markdown","id":"26","title":"--markdown-css: include more CSS files when rendering markdown"},"27":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --html-in-header header.html\n$ rustdoc README.md --html-in-header header.html This flag takes a list of files, and inserts them into the <head> section of the rendered documentation.","breadcrumbs":"--html-in-header: include more HTML in","id":"27","title":"--html-in-header: include more HTML in"},"28":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --html-before-content extra.html\n$ rustdoc README.md --html-before-content extra.html This flag takes a list of files, and inserts them inside the <body> tag but before the other content rustdoc would normally produce in the rendered documentation.","breadcrumbs":"--html-before-content: include more HTML before the content","id":"28","title":"--html-before-content: include more HTML before the content"},"29":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --html-after-content extra.html\n$ rustdoc README.md --html-after-content extra.html This flag takes a list of files, and inserts them before the </body> tag but after the other content rustdoc would normally produce in the rendered documentation.","breadcrumbs":"--html-after-content: include more HTML after the content","id":"29","title":"--html-after-content: include more HTML after the content"},"3":{"body":"rustdoc can also generate HTML from standalone Markdown files. Let's give it a try: create a README.md file with these contents: # Docs This is a project to test out `rustdoc`. [Here is a link!](https://www.rust-lang.org) ## Subheading ```rust\nfn foo() -> i32 { 1 + 1\n}\n``` And call rustdoc on it: $ rustdoc README.md You'll find an HTML file in docs/doc/README.html generated from its Markdown contents. Cargo currently does not understand standalone Markdown files, unfortunately.","breadcrumbs":"Using standalone Markdown files","id":"3","title":"Using standalone Markdown files"},"30":{"body":"Using this flag looks like this: $ rustdoc README.md --markdown-playground-url https://play.rust-lang.org/ When rendering a Markdown file, this flag gives the base URL of the Rust Playground, to use for generating Run buttons.","breadcrumbs":"--markdown-playground-url: control the location of the playground","id":"30","title":"--markdown-playground-url: control the location of the playground"},"31":{"body":"Using this flag looks like this: $ rustdoc README.md --markdown-no-toc When generating documentation from a Markdown file, by default, rustdoc will generate a table of contents. This flag suppresses that, and no TOC will be generated.","breadcrumbs":"--markdown-no-toc: don't generate a table of contents","id":"31","title":"--markdown-no-toc: don't generate a table of contents"},"32":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -e extra.css\n$ rustdoc src/lib.rs --extend-css extra.css With this flag, the contents of the files you pass are included at the bottom of Rustdoc's theme.css file. While this flag is stable, the contents of theme.css are not, so be careful! Updates may break your theme extensions.","breadcrumbs":"-e/--extend-css: extend rustdoc's CSS","id":"32","title":"-e/--extend-css: extend rustdoc's CSS"},"33":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --sysroot /path/to/sysroot Similar to rustc --sysroot, this lets you change the sysroot rustdoc uses when compiling your code.","breadcrumbs":"--sysroot: override the system root","id":"33","title":"--sysroot: override the system root"},"34":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --edition 2018\n$ rustdoc --test src/lib.rs --edition 2018 This flag allows rustdoc to treat your rust code as the given edition. It will compile doctests with the given edition as well. As with rustc, the default edition that rustdoc will use is 2015 (the first edition).","breadcrumbs":"--edition: control the edition of docs and doctests","id":"34","title":"--edition: control the edition of docs and doctests"},"35":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --theme /path/to/your/custom-theme.css rustdoc's default output includes two themes: light (the default) and dark. This flag allows you to add custom themes to the output. Giving a CSS file to this flag adds it to your documentation as an additional theme choice. The theme's name is determined by its filename; a theme file named custom-theme.css will add a theme named custom-theme to the documentation.","breadcrumbs":"--theme: add a theme to the documentation output","id":"35","title":"--theme: add a theme to the documentation output"},"36":{"body":"Using this flag looks like this: $ rustdoc --check-theme /path/to/your/custom-theme.css While rustdoc's HTML output is more-or-less consistent between versions, there is no guarantee that a theme file will have the same effect. The --theme flag will still allow you to add the theme to your documentation, but to ensure that your theme works as expected, you can use this flag to verify that it implements the same CSS rules as the official light theme. --check-theme is a separate mode in rustdoc. When rustdoc sees the --check-theme flag, it discards all other flags and only performs the CSS rule comparison operation.","breadcrumbs":"--check-theme: verify custom themes against the default theme","id":"36","title":"--check-theme: verify custom themes against the default theme"},"37":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --crate-version 1.3.37 When rustdoc receives this flag, it will print an extra \"Version (version)\" into the sidebar of the crate root's docs. You can use this flag to differentiate between different versions of your library's documentation.","breadcrumbs":"--crate-version: control the crate version","id":"37","title":"--crate-version: control the crate version"},"38":{"body":"The #[doc] attribute lets you control various aspects of how rustdoc does its job. The most basic function of #[doc] is to handle the actual documentation text. That is, /// is syntax sugar for #[doc]. This means that these two are the same: /// This is a doc comment.\n#[doc = \" This is a doc comment.\"] (Note the leading space in the attribute version.) In most cases, /// is easier to use than #[doc]. One case where the latter is easier is when generating documentation in macros; the collapse-docs pass will combine multiple #[doc] attributes into a single doc comment, letting you generate code like this: #[doc = \"This is\"]\n#[doc = \" a \"]\n#[doc = \"doc comment\"] Which can feel more flexible. Note that this would generate this: #[doc = \"This is\\n a \\ndoc comment\"] but given that docs are rendered via Markdown, it will remove these newlines. The doc attribute has more options though! These don't involve the text of the output, but instead, various aspects of the presentation of the output. We've split them into two kinds below: attributes that are useful at the crate level, and ones that are useful at the item level.","breadcrumbs":"The #[doc] attribute","id":"38","title":"The #[doc] attribute"},"39":{"body":"These options control how the docs look at a crate level.","breadcrumbs":"At the crate level","id":"39","title":"At the crate level"},"4":{"body":"This covers the simplest use-cases of rustdoc. The rest of this book will explain all of the options that rustdoc has, and how to use them.","breadcrumbs":"Summary","id":"4","title":"Summary"},"40":{"body":"This form of the doc attribute lets you control the favicon of your docs. #![doc(html_favicon_url = \"https://example.com/favicon.ico\")] This will put <link rel=\"shortcut icon\" href=\"{}\"> into your docs, where the string for the attribute goes into the {}. If you don't use this attribute, there will be no favicon.","breadcrumbs":"html_favicon_url","id":"40","title":"html_favicon_url"},"41":{"body":"This form of the doc attribute lets you control the logo in the upper left hand side of the docs. #![doc(html_logo_url = \"https://example.com/logo.jpg\")] This will put <a href='index.html'><img src='{}' alt='logo' width='100'></a> into your docs, where the string for the attribute goes into the {}. If you don't use this attribute, there will be no logo.","breadcrumbs":"html_logo_url","id":"41","title":"html_logo_url"},"42":{"body":"This form of the doc attribute lets you control where the \"run\" buttons on your documentation examples make requests to. #![doc(html_playground_url = \"https://playground.example.com/\")] Now, when you press \"run\", the button will make a request to this domain. If you don't use this attribute, there will be no run buttons.","breadcrumbs":"html_playground_url","id":"42","title":"html_playground_url"},"43":{"body":"This form of the doc attribute is mostly only useful for the standard library; When a feature is unstable, an issue number for tracking the feature must be given. rustdoc uses this number, plus the base URL given here, to link to the tracking issue. #![doc(issue_tracker_base_url = \"https://github.com/rust-lang/rust/issues/\")]","breadcrumbs":"issue_tracker_base_url","id":"43","title":"issue_tracker_base_url"},"44":{"body":"The #[doc(html_root_url = \"…\")] attribute value indicates the URL for generating links to external crates. When rustdoc needs to generate a link to an item in an external crate, it will first check if the extern crate has been documented locally on-disk, and if so link directly to it. Failing that, it will use the URL given by the --extern-html-root-url command-line flag if available. If that is not available, then it will use the html_root_url value in the extern crate if it is available. If that is not available, then the extern items will not be linked. #![doc(html_root_url = \"https://docs.rs/serde/1.0\")]","breadcrumbs":"html_root_url","id":"44","title":"html_root_url"},"45":{"body":"By default, rustdoc will include the source code of your program, with links to it in the docs. But if you include this: #![doc(html_no_source)] it will not.","breadcrumbs":"html_no_source","id":"45","title":"html_no_source"},"46":{"body":"By default, rustdoc will automatically add a line with extern crate my_crate; into each doctest. But if you include this: #![doc(test(no_crate_inject))] it will not.","breadcrumbs":"test(no_crate_inject)","id":"46","title":"test(no_crate_inject)"},"47":{"body":"This form of the doc attribute allows you to add arbitrary attributes to all your doctests. For example, if you want your doctests to fail if they produce any warnings, you could add this: #![doc(test(attr(deny(warnings))))]","breadcrumbs":"test(attr(...))","id":"47","title":"test(attr(...))"},"48":{"body":"These forms of the #[doc] attribute are used on individual items, to control how they are documented.","breadcrumbs":"At the item level","id":"48","title":"At the item level"},"49":{"body":"These attributes are used on use statements, and control where the documentation shows up. For example, consider this Rust code: pub use bar::Bar; /// bar docs\npub mod bar { /// the docs for Bar pub struct Bar;\n} The documentation will generate a \"Re-exports\" section, and say pub use bar::Bar;, where Bar is a link to its page. If we change the use line like this: #[doc(inline)]\npub use bar::Bar; Instead, Bar will appear in a Structs section, just like Bar was defined at the top level, rather than pub use'd. Let's change our original example, by making bar private: pub use bar::Bar; /// bar docs\nmod bar { /// the docs for Bar pub struct Bar;\n} Here, because bar is not public, Bar wouldn't have its own page, so there's nowhere to link to. rustdoc will inline these definitions, and so we end up in the same case as the #[doc(inline)] above; Bar is in a Structs section, as if it were defined at the top level. If we add the no_inline form of the attribute: #[doc(no_inline)]\npub use bar::Bar; /// bar docs\nmod bar { /// the docs for Bar pub struct Bar;\n} Now we'll have a Re-exports line, and Bar will not link to anywhere. One special case: In Rust 2018 and later, if you pub use one of your dependencies, rustdoc will not eagerly inline it as a module unless you add #[doc(inline)].","breadcrumbs":"#[doc(no_inline)]/#[doc(inline)]","id":"49","title":"#[doc(no_inline)]/#[doc(inline)]"},"5":{"body":"This chapter covers not only how to write documentation but specifically how to write good documentation. Something to keep in mind when writing documentation is that your audience is not just yourself but others who simply don't have the context you do. It is important to be as clear as you can, and as complete as possible. As a rule of thumb: the more documentation you write for your crate the better. If an item is public then it should be documented.","breadcrumbs":"How to write documentation","id":"5","title":"How to write documentation"},"50":{"body":"Any item annotated with #[doc(hidden)] will not appear in the documentation, unless the strip-hidden pass is removed.","breadcrumbs":"#[doc(hidden)]","id":"50","title":"#[doc(hidden)]"},"51":{"body":"Since primitive types are defined in the compiler, there's no place to attach documentation attributes. This attribute is used by the standard library to provide a way to generate documentation for primitive types.","breadcrumbs":"#[doc(primitive)]","id":"51","title":"#[doc(primitive)]"},"52":{"body":"rustdoc supports executing your documentation examples as tests. This makes sure that examples within your documentation are up to date and working. The basic idea is this: /// # Examples\n///\n/// ```\n/// let x = 5;\n/// ``` The triple backticks start and end code blocks. If this were in a file named foo.rs, running rustdoc --test foo.rs will extract this example, and then run it as a test. Please note that by default, if no language is set for the block code, rustdoc assumes it is Rust code. So the following: ```rust\nlet x = 5;\n``` is strictly equivalent to: ```\nlet x = 5;\n``` There's some subtlety though! Read on for more details.","breadcrumbs":"Documentation tests","id":"52","title":"Documentation tests"},"53":{"body":"Like regular unit tests, regular doctests are considered to \"pass\" if they compile and run without panicking. So if you want to demonstrate that some computation gives a certain result, the assert! family of macros works the same as other Rust code: let foo = \"foo\"; assert_eq!(foo, \"foo\"); This way, if the computation ever returns something different, the code panics and the doctest fails.","breadcrumbs":"Passing or failing a doctest","id":"53","title":"Passing or failing a doctest"},"54":{"body":"In the example above, you'll note something strange: there's no main function! Forcing you to write main for every example, no matter how small, adds friction. So rustdoc processes your examples slightly before running them. Here's the full algorithm rustdoc uses to preprocess examples: Some common allow attributes are inserted, including unused_variables, unused_assignments, unused_mut, unused_attributes, and dead_code. Small examples often trigger these lints. Any attributes specified with #![doc(test(attr(...)))] are added. Any leading #![foo] attributes are left intact as crate attributes. If the example does not contain extern crate, and #![doc(test(no_crate_inject))] was not specified, then extern crate <mycrate>; is inserted (note the lack of #[macro_use]). Finally, if the example does not contain fn main, the remainder of the text is wrapped in fn main() { your_code }. For more about that caveat in rule 4, see \"Documenting Macros\" below.","breadcrumbs":"Pre-processing examples","id":"54","title":"Pre-processing examples"},"55":{"body":"Sometimes, you need some setup code, or other things that would distract from your example, but are important to make the tests work. Consider an example block that looks like this: /// /// Some documentation.\n/// # fn foo() {} // this function will be hidden\n/// println!(\"Hello, World!\"); It will render like this: /// Some documentation.\n# fn foo() {}\nprintln!(\"Hello, World!\"); Yes, that's right: you can add lines that start with # , and they will be hidden from the output, but will be used when compiling your code. You can use this to your advantage. In this case, documentation comments need to apply to some kind of function, so if I want to show you just a documentation comment, I need to add a little function definition below it. At the same time, it's only there to satisfy the compiler, so hiding it makes the example more clear. You can use this technique to explain longer examples in detail, while still preserving the testability of your documentation. For example, imagine that we wanted to document this code: let x = 5;\nlet y = 6;\nprintln!(\"{}\", x + y); We might want the documentation to end up looking like this: First, we set x to five: let x = 5;\n# let y = 6;\n# println!(\"{}\", x + y); Next, we set y to six: # let x = 5;\nlet y = 6;\n# println!(\"{}\", x + y); Finally, we print the sum of x and y: # let x = 5;\n# let y = 6;\nprintln!(\"{}\", x + y); To keep each code block testable, we want the whole program in each block, but we don't want the reader to see every line every time. Here's what we put in our source code: First, we set `x` to five: ```\nlet x = 5;\n# let y = 6;\n# println!(\"{}\", x + y);\n``` Next, we set `y` to six: ```\n# let x = 5;\nlet y = 6;\n# println!(\"{}\", x + y);\n``` Finally, we print the sum of `x` and `y`: ```\n# let x = 5;\n# let y = 6;\nprintln!(\"{}\", x + y);\n``` By repeating all parts of the example, you can ensure that your example still compiles, while only showing the parts that are relevant to that part of your explanation. The #-hiding of lines can be prevented by using two consecutive hashes ##. This only needs to be done with the first # which would've otherwise caused hiding. If we have a string literal like the following, which has a line that starts with a #: let s = \"foo\n## bar # baz\"; We can document it by escaping the initial #: /// let s = \"foo\n/// ## bar # baz\";","breadcrumbs":"Hiding portions of the example","id":"55","title":"Hiding portions of the example"},"56":{"body":"When writing an example, it is rarely useful to include a complete error handling, as it would add significant amounts of boilerplate code. Instead, you may want the following: /// ```\n/// use std::io;\n/// let mut input = String::new();\n/// io::stdin().read_line(&mut input)?;\n/// ``` The problem is that ? returns a Result<T, E> and test functions don't return anything, so this will give a mismatched types error. You can get around this limitation by manually adding a main that returns Result<T, E>, because Result<T, E> implements the Termination trait: /// A doc test using ?\n///\n/// ```\n/// use std::io;\n///\n/// fn main() -> io::Result<()> {\n/// let mut input = String::new();\n/// io::stdin().read_line(&mut input)?;\n/// Ok(())\n/// }\n/// ``` Together with the # from the section above, you arrive at a solution that appears to the reader as the initial idea but works with doc tests: /// ```\n/// use std::io;\n/// # fn main() -> io::Result<()> {\n/// let mut input = String::new();\n/// io::stdin().read_line(&mut input)?;\n/// # Ok(())\n/// # }\n/// ``` As of version 1.34.0, one can also omit the fn main(), but you will have to disambiguate the error type: /// ```\n/// use std::io;\n/// let mut input = String::new();\n/// io::stdin().read_line(&mut input)?;\n/// # Ok::<(), io::Error>(())\n/// ``` This is an unfortunate consequence of the ? operator adding an implicit conversion, so type inference fails because the type is not unique. Please note that you must write the (()) in one sequence without intermediate whitespace so that rustdoc understands you want an implicit Result-returning function.","breadcrumbs":"Using ? in doc tests","id":"56","title":"Using ? in doc tests"},"57":{"body":"Here’s an example of documenting a macro: /// Panic with a given message unless an expression evaluates to true.\n///\n/// # Examples\n///\n/// ```\n/// # #[macro_use] extern crate foo;\n/// # fn main() {\n/// panic_unless!(1 + 1 == 2, “Math is broken.”);\n/// # }\n/// ```\n///\n/// ```should_panic\n/// # #[macro_use] extern crate foo;\n/// # fn main() {\n/// panic_unless!(true == false, “I’m broken.”);\n/// # }\n/// ```\n#[macro_export]\nmacro_rules! panic_unless { ($condition:expr, $($rest:expr),+) => ({ if ! $condition { panic!($($rest),+); } });\n}\n# fn main() {} You’ll note three things: we need to add our own extern crate line, so that we can add the #[macro_use] attribute. Second, we’ll need to add our own main() as well (for reasons discussed above). Finally, a judicious use of # to comment out those two things, so they don’t show up in the output.","breadcrumbs":"Documenting macros","id":"57","title":"Documenting macros"},"58":{"body":"There are a few annotations that are useful to help rustdoc do the right thing when testing your code: /// ```ignore\n/// fn foo() {\n/// ```\n# fn foo() {} The ignore directive tells Rust to ignore your code. This is almost never what you want, as it's the most generic. Instead, consider annotating it with text if it's not code, or using #s to get a working example that only shows the part you care about. /// ```should_panic\n/// assert!(false);\n/// ```\n# fn foo() {} should_panic tells rustdoc that the code should compile correctly, but not actually pass as a test. /// ```no_run\n/// loop {\n/// println!(\"Hello, world\");\n/// }\n/// ```\n# fn foo() {} The no_run attribute will compile your code, but not run it. This is important for examples such as \"Here's how to retrieve a web page,\" which you would want to ensure compiles, but might be run in a test environment that has no network access. /// ```compile_fail\n/// let x = 5;\n/// x += 2; // shouldn't compile!\n/// ``` compile_fail tells rustdoc that the compilation should fail. If it compiles, then the test will fail. However please note that code failing with the current Rust release may work in a future release, as new features are added. /// Only runs on the 2018 edition.\n///\n/// ```edition2018\n/// let result: Result<i32, ParseIntError> = try {\n/// \"1\".parse::<i32>()?\n/// + \"2\".parse::<i32>()?\n/// + \"3\".parse::<i32>()?\n/// };\n/// ``` edition2018 tells rustdoc that the code sample should be compiled using the 2018 edition of Rust. Similarly, you can specify edition2015 to compile the code with the 2015 edition.","breadcrumbs":"Attributes","id":"58","title":"Attributes"},"59":{"body":"The exact syntax for code blocks, including the edge cases, can be found in the Fenced Code Blocks section of the CommonMark specification. Rustdoc also accepts indented code blocks as an alternative to fenced code blocks: instead of surrounding your code with three backticks, you can indent each line by four or more spaces. let foo = \"foo\"; assert_eq!(foo, \"foo\"); These, too, are documented in the CommonMark specification, in the Indented Code Blocks section. However, it's preferable to use fenced code blocks over indented code blocks. Not only are fenced code blocks considered more idiomatic for Rust code, but there is no way to use directives such as ignore or should_panic with indented code blocks.","breadcrumbs":"Syntax reference","id":"59","title":"Syntax reference"},"6":{"body":"It is recommended that each item's documentation follows this basic structure: [short sentence explaining what it is] [more detailed explanation] [at least one code example that users can copy/paste to try it] [even more advanced explanations if necessary] This basic structure should be straightforward to follow when writing your documentation and, while you might think that a code example is trivial, the examples are really important because they can help your users to understand what an item is, how it is used, and for what purpose it exists. Let's see an example coming from the standard library by taking a look at the std::env::args() function: Returns the arguments which this program was started with (normally passed\nvia the command line). The first element is traditionally the path of the executable, but it can be\nset to arbitrary text, and may not even exist. This means this property should\nnot be relied upon for security purposes. On Unix systems shell usually expands unquoted arguments with glob patterns\n(such as `*` and `?`). On Windows this is not done, and such arguments are\npassed as-is. # Panics The returned iterator will panic during iteration if any argument to the\nprocess is not valid unicode. If this is not desired,\nuse the [`args_os`] function instead. # Examples ```\nuse std::env; // Prints each argument on a separate line\nfor argument in env::args() { println!(\"{}\", argument);\n}\n``` [`args_os`]: ./fn.args_os.html As you can see, it follows the structure detailed above: it starts with a short sentence explaining what the functions does, then it provides more information and finally provides a code example.","breadcrumbs":"Basic structure","id":"6","title":"Basic structure"},"60":{"body":"Rustdoc's documentation tests can do some things that regular unit tests can't, so it can sometimes be useful to extend your doctests with samples that wouldn't otherwise need to be in documentation. To this end, Rustdoc allows you to have certain items only appear when it's collecting doctests, so you can utilize doctest functionality without forcing the test to appear in docs, or to find an arbitrary private item to include it on. When compiling a crate for use in doctests (with --test option), rustdoc will set cfg(doctest). Note that they will still link against only the public items of your crate; if you need to test private items, you need to write a unit test. In this example, we're adding doctests that we know won't compile, to verify that our struct can only take in valid data: /// We have a struct here. Remember it doesn't accept negative numbers!\npub struct MyStruct(pub usize); /// ```compile_fail\n/// let x = my_crate::MyStruct(-5);\n/// ```\n#[cfg(doctest)]\npub struct MyStructOnlyTakesUsize; Note that the struct MyStructOnlyTakesUsize here isn't actually part of your public crate API. The use of #[cfg(doctest)] makes sure that this struct only exists while rustdoc is collecting doctests. This means that its doctest is executed when --test is passed to rustdoc, but is hidden from the public documentation. Another possible use of cfg(doctest) is to test doctests that are included in your README file without including it in your main documentation. For example, you could write this into your lib.rs to test your README as part of your doctests: #![feature(external_doc)] #[doc(include=\"../README.md\")]\n#[cfg(doctest)]\npub struct ReadmeDoctests; This will include your README as documentation on the hidden struct ReadmeDoctests, which will then be tested alongside the rest of your doctests.","breadcrumbs":"Include items only when collecting doctests","id":"60","title":"Include items only when collecting doctests"},"61":{"body":"rustdoc provides lints to help you writing and testing your documentation. You can use them like any other lints by doing this: #![allow(missing_docs)] // allowing the lint, no message\n#![warn(missing_docs)] // warn if there is missing docs\n#![deny(missing_docs)] // rustdoc will fail if there is missing docs Here is the list of the lints provided by rustdoc:","breadcrumbs":"Lints","id":"61","title":"Lints"},"62":{"body":"This lint warns by default and is nightly-only . This lint detects when an intra-doc link fails to get resolved. For example: /// I want to link to [`Inexistent`] but it doesn't exist!\npub fn foo() {} You'll get a warning saying: error: `[`Inexistent`]` cannot be resolved, ignoring it...","breadcrumbs":"intra_doc_link_resolution_failure","id":"62","title":"intra_doc_link_resolution_failure"},"63":{"body":"This lint is allowed by default . It detects items missing documentation. For example: #![warn(missing_docs)] pub fn undocumented() {}\n# fn main() {} The undocumented function will then have the following warning: warning: missing documentation for a function --> your-crate/lib.rs:3:1 | 3 | pub fn undocumented() {} | ^^^^^^^^^^^^^^^^^^^^^","breadcrumbs":"missing_docs","id":"63","title":"missing_docs"},"64":{"body":"This lint is allowed by default . It detects when a documentation block is missing a code example. For example: #![warn(missing_doc_code_examples)] /// There is no code example!\npub fn no_code_example() {}\n# fn main() {} The no_code_example function will then have the following warning: warning: Missing code example in this documentation --> your-crate/lib.rs:3:1 |\nLL | /// There is no code example! | ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ To fix the lint, you need to add a code example into the documentation block: /// There is no code example!\n///\n/// ```\n/// println!(\"calling no_code_example...\");\n/// no_code_example();\n/// println!(\"we called no_code_example!\");\n/// ```\npub fn no_code_example() {}","breadcrumbs":"missing_doc_code_examples","id":"64","title":"missing_doc_code_examples"},"65":{"body":"This lint is allowed by default . It detects documentation tests when they are on a private item. For example: #![warn(private_doc_tests)] mod foo { /// private doc test /// /// ``` /// assert!(false); /// ``` fn bar() {}\n}\n# fn main() {} Which will give: warning: Documentation test in private item --> your-crate/lib.rs:4:1 | 4 | / /// private doc test 5 | | /// 6 | | /// ``` 7 | | /// assert!(false); 8 | | /// ``` | |___________^","breadcrumbs":"private_doc_tests","id":"65","title":"private_doc_tests"},"66":{"body":"Rustdoc has a concept called \"passes\". These are transformations that rustdoc runs on your documentation before producing its final output. In addition to the passes below, check out the docs for these flags: --passes --no-defaults","breadcrumbs":"Passes","id":"66","title":"Passes"},"67":{"body":"By default, rustdoc will run some passes, namely: strip-hidden strip-private collapse-docs unindent-comments However, strip-private implies strip-priv-imports, and so effectively, all passes are run by default.","breadcrumbs":"Default passes","id":"67","title":"Default passes"},"68":{"body":"This pass implements the #[doc(hidden)] attribute. When this pass runs, it checks each item, and if it is annotated with this attribute, it removes it from rustdoc's output. Without this pass, these items will remain in the output.","breadcrumbs":"strip-hidden","id":"68","title":"strip-hidden"},"69":{"body":"When you write a doc comment like this: /// This is a documentation comment. There's a space between the /// and that T. That spacing isn't intended to be a part of the output; it's there for humans, to help separate the doc comment syntax from the text of the comment. This pass is what removes that space. The exact rules are left under-specified so that we can fix issues that we find. Without this pass, the exact number of spaces is preserved.","breadcrumbs":"unindent-comments","id":"69","title":"unindent-comments"},"7":{"body":"rustdoc is using the commonmark markdown specification . You might be interested into taking a look at their website to see what's possible to do.","breadcrumbs":"Markdown","id":"7","title":"Markdown"},"70":{"body":"With this pass, multiple #[doc] attributes are converted into one single documentation string. For example: #[doc = \"This is the first line.\"]\n#[doc = \"This is the second line.\"] Gets collapsed into a single doc string of This is the first line.\nThis is the second line.","breadcrumbs":"collapse-docs","id":"70","title":"collapse-docs"},"71":{"body":"This removes documentation for any non-public items, so for example: /// These are private docs.\nstruct Private; /// These are public docs.\npub struct Public; This pass removes the docs for Private, since they're not public. This pass implies strip-priv-imports.","breadcrumbs":"strip-private","id":"71","title":"strip-private"},"72":{"body":"This is the same as strip-private, but for extern crate and use statements instead of items.","breadcrumbs":"strip-priv-imports","id":"72","title":"strip-priv-imports"},"73":{"body":"The features listed on this page fall outside the rest of the main categories.","breadcrumbs":"Advanced Features","id":"73","title":"Advanced Features"},"74":{"body":"For conditional compilation, Rustdoc treats your crate the same way the compiler does. Only things from the host target are available (or from the given --target if present), and everything else is \"filtered out\" from the crate. This can cause problems if your crate is providing different things on different targets and you want your documentation to reflect all the available items you provide. If you want to make sure an item is seen by Rustdoc regardless of what platform it's targeting, you can apply #[cfg(doc)] to it. Rustdoc sets this whenever it's building documentation, so anything that uses that flag will make it into documentation it generates. To apply this to an item with other #[cfg] filters on it, you can write something like #[cfg(any(windows, doc))]. This will preserve the item either when built normally on Windows, or when being documented anywhere. Please note that this feature is not passed to doctests. Example: /// Token struct that can only be used on Windows.\n#[cfg(any(windows, doc))]\npub struct WindowsToken;\n/// Token struct that can only be used on Unix.\n#[cfg(any(unix, doc))]\npub struct UnixToken; Here, the respective tokens can only be used by dependent crates on their respective platforms, but they will both appear in documentation.","breadcrumbs":"#[cfg(doc)]: Documenting platform-/feature-specific information","id":"74","title":"#[cfg(doc)]: Documenting platform-/feature-specific information"},"75":{"body":"Rustdoc is under active development, and like the Rust compiler, some features are only available on nightly releases. Some of these features are new and need some more testing before they're able to be released to the world at large, and some of them are tied to features in the Rust compiler that are unstable. Several features here require a matching #![feature(...)] attribute to enable, and thus are more fully documented in the Unstable Book . Those sections will link over there as necessary.","breadcrumbs":"Unstable features","id":"75","title":"Unstable features"},"76":{"body":"These features just require a nightly build to operate. Unlike the other features on this page, these don't need to be \"turned on\" with a command-line flag or a #![feature(...)] attribute in your crate. This can give them some subtle fallback modes when used on a stable release, so be careful!","breadcrumbs":"Nightly-gated functionality","id":"76","title":"Nightly-gated functionality"},"77":{"body":"As detailed in the chapter on documentation tests , you can add a compile_fail attribute to a doctest to state that the test should fail to compile. However, on nightly, you can optionally add an error number to state that a doctest should emit a specific error number: ```compile_fail,E0044\nextern { fn some_func<T>(x: T); }\n``` This is used by the error index to ensure that the samples that correspond to a given error number properly emit that error code. However, these error codes aren't guaranteed to be the only thing that a piece of code emits from version to version, so this is unlikely to be stabilized in the future. Attempting to use these error numbers on stable will result in the code sample being interpreted as plain text.","breadcrumbs":"Error numbers for compile-fail doctests","id":"77","title":"Error numbers for compile-fail doctests"},"78":{"body":"Rustdoc is capable of directly linking to other rustdoc pages in Markdown documentation using the path of item as a link. For example, in the following code all of the links will link to the rustdoc page for Bar: /// This struct is not [Bar]\npub struct Foo1; /// This struct is also not [bar](Bar)\npub struct Foo2; /// This struct is also not [bar][b]\n///\n/// [b]: Bar\npub struct Foo3; /// This struct is also not [`Bar`]\npub struct Foo4; pub struct Bar; You can refer to anything in scope, and use paths, including Self. You may also use foo() and foo!() to refer to methods/functions and macros respectively. use std::sync::mpsc::Receiver; /// This is an version of [`Receiver`], with support for [`std::future`].\n///\n/// You can obtain a [`std::future::Future`] by calling [`Self::recv()`].\npub struct AsyncReceiver<T> { sender: Receiver<T>\n} impl<T> AsyncReceiver<T> { pub async fn recv() -> T { unimplemented!() }\n} Paths in Rust have three namespaces: type, value, and macro. Items from these namespaces are allowed to overlap. In case of ambiguity, rustdoc will warn about the ambiguity and ask you to disambiguate, which can be done by using a prefix like struct@, enum@, type@, trait@, union@, const@, static@, value@, function@, mod@, fn@, module@, method@ , macro@, or derive@: /// See also: [`Foo`](struct@Foo)\nstruct Bar; /// This is different from [`Foo`](fn@Foo)\nstruct Foo {} fn Foo() {} Note: Because of how macro_rules macros are scoped in Rust, the intra-doc links of a macro_rules macro will be resolved relative to the crate root, as opposed to the module it is defined in.","breadcrumbs":"Linking to items by name","id":"78","title":"Linking to items by name"},"79":{"body":"These features operate by extending the #[doc] attribute, and thus can be caught by the compiler and enabled with a #![feature(...)] attribute in your crate.","breadcrumbs":"Extensions to the #[doc] attribute","id":"79","title":"Extensions to the #[doc] attribute"},"8":{"body":"To be sure that you didn't miss any item without documentation or code examples, you can take a look at the rustdoc lints here .","breadcrumbs":"Lints","id":"8","title":"Lints"},"80":{"body":"Because of the way Rustdoc documents a crate, the documentation it creates is specific to the target rustc compiles for. Anything that's specific to any other target is dropped via #[cfg] attribute processing early in the compilation process. However, Rustdoc has a trick up its sleeve to handle platform-specific code if it does receive it. Because Rustdoc doesn't need to fully compile a crate to binary, it replaces function bodies with loop {} to prevent having to process more than necessary. This means that any code within a function that requires platform-specific pieces is ignored. Combined with a special attribute, #[doc(cfg(...))], you can tell Rustdoc exactly which platform something is supposed to run on, ensuring that doctests are only run on the appropriate platforms. The #[doc(cfg(...))] attribute has another effect: When Rustdoc renders documentation for that item, it will be accompanied by a banner explaining that the item is only available on certain platforms. For Rustdoc to document an item, it needs to see it, regardless of what platform it's currently running on. To aid this, Rustdoc sets the flag #[cfg(doc)] when running on your crate. Combining this with the target platform of a given item allows it to appear when building your crate normally on that platform, as well as when building documentation anywhere. For example, #[cfg(any(windows, doc))] will preserve the item either on Windows or during the documentation process. Then, adding a new attribute #[doc(cfg(windows))] will tell Rustdoc that the item is supposed to be used on Windows. For example: #![feature(doc_cfg)] /// Token struct that can only be used on Windows.\n#[cfg(any(windows, doc))]\n#[doc(cfg(windows))]\npub struct WindowsToken; /// Token struct that can only be used on Unix.\n#[cfg(any(unix, doc))]\n#[doc(cfg(unix))]\npub struct UnixToken; In this sample, the tokens will only appear on their respective platforms, but they will both appear in documentation. #[doc(cfg(...))] was introduced to be used by the standard library and currently requires the #![feature(doc_cfg)] feature gate. For more information, see its chapter in the Unstable Book and its tracking issue .","breadcrumbs":"Documenting platform-/feature-specific information","id":"80","title":"Documenting platform-/feature-specific information"},"81":{"body":"The standard library uses several dependencies which, in turn, use several types and traits from the standard library. In addition, there are several compiler-internal crates that are not considered to be part of the official standard library, and thus would be a distraction to include in documentation. It's not enough to exclude their crate documentation, since information about trait implementations appears on the pages for both the type and the trait, which can be in different crates! To prevent internal types from being included in documentation, the standard library adds an attribute to their extern crate declarations: #[doc(masked)]. This causes Rustdoc to \"mask out\" types from these crates when building lists of trait implementations. The #[doc(masked)] attribute is intended to be used internally, and requires the #![feature(doc_masked)] feature gate. For more information, see its chapter in the Unstable Book and its tracking issue .","breadcrumbs":"Exclude certain dependencies from documentation","id":"81","title":"Exclude certain dependencies from documentation"},"82":{"body":"As designed in RFC 1990 , Rustdoc can read an external file to use as a type's documentation. This is useful if certain documentation is so long that it would break the flow of reading the source. Instead of writing it all inline, writing #[doc(include = \"sometype.md\")] will ask Rustdoc to instead read that file and use it as if it were written inline. #[doc(include = \"...\")] currently requires the #![feature(external_doc)] feature gate. For more information, see its chapter in the Unstable Book and its tracking issue .","breadcrumbs":"Include external files as API documentation","id":"82","title":"Include external files as API documentation"},"83":{"body":"This feature allows you to add alias(es) to an item when using the rustdoc search through the doc(alias) attribute. Example: #![feature(doc_alias)] #[doc(alias = \"x\")]\n#[doc(alias = \"big\")]\npub struct BigX; Then, when looking for it through the rustdoc search, if you enter \"x\" or \"big\", search will show the BigX struct first.","breadcrumbs":"Add aliases for an item in documentation search","id":"83","title":"Add aliases for an item in documentation search"},"84":{"body":"These features are enabled by passing a command-line flag to Rustdoc, but the flags in question are themselves marked as unstable. To use any of these options, pass -Z unstable-options as well as the flag in question to Rustdoc on the command-line. To do this from Cargo, you can either use the RUSTDOCFLAGS environment variable or the cargo rustdoc command.","breadcrumbs":"Unstable command-line arguments","id":"84","title":"Unstable command-line arguments"},"85":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --markdown-before-content extra.md\n$ rustdoc README.md -Z unstable-options --markdown-before-content extra.md Just like --html-before-content, this allows you to insert extra content inside the <body> tag but before the other content rustdoc would normally produce in the rendered documentation. However, instead of directly inserting the file verbatim, rustdoc will pass the files through a Markdown renderer before inserting the result into the file.","breadcrumbs":"--markdown-before-content: include rendered Markdown before the content","id":"85","title":"--markdown-before-content: include rendered Markdown before the content"},"86":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --markdown-after-content extra.md\n$ rustdoc README.md -Z unstable-options --markdown-after-content extra.md Just like --html-after-content, this allows you to insert extra content before the </body> tag but after the other content rustdoc would normally produce in the rendered documentation. However, instead of directly inserting the file verbatim, rustdoc will pass the files through a Markdown renderer before inserting the result into the file.","breadcrumbs":"--markdown-after-content: include rendered Markdown after the content","id":"86","title":"--markdown-after-content: include rendered Markdown after the content"},"87":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --playground-url https://play.rust-lang.org/ When rendering a crate's docs, this flag gives the base URL of the Rust Playground, to use for generating Run buttons. Unlike --markdown-playground-url, this argument works for standalone Markdown files and Rust crates. This works the same way as adding #![doc(html_playground_url = \"url\")] to your crate root, as mentioned in the chapter about the #[doc] attribute . Please be aware that the official Rust Playground at https://play.rust-lang.org does not have every crate available, so if your examples require your crate, make sure the playground you provide has your crate available. If both --playground-url and --markdown-playground-url are present when rendering a standalone Markdown file, the URL given to --markdown-playground-url will take precedence. If both --playground-url and #![doc(html_playground_url = \"url\")] are present when rendering crate docs, the attribute will take precedence.","breadcrumbs":"--playground-url: control the location of the playground","id":"87","title":"--playground-url: control the location of the playground"},"88":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --sort-modules-by-appearance Ordinarily, when rustdoc prints items in module pages, it will sort them alphabetically (taking some consideration for their stability, and names that end in a number). Giving this flag to rustdoc will disable this sorting and instead make it print the items in the order they appear in the source.","breadcrumbs":"--sort-modules-by-appearance: control how items on module pages are sorted","id":"88","title":"--sort-modules-by-appearance: control how items on module pages are sorted"},"89":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --resource-suffix suf When rendering docs, rustdoc creates several CSS and JavaScript files as part of the output. Since all these files are linked from every page, changing where they are can be cumbersome if you need to specially cache them. This flag will rename all these files in the output to include the suffix in the filename. For example, light.css would become light-suf.css with the above command.","breadcrumbs":"--resource-suffix: modifying the name of CSS/JavaScript in crate docs","id":"89","title":"--resource-suffix: modifying the name of CSS/JavaScript in crate docs"},"9":{"body":"Here's the list of arguments you can pass to rustdoc:","breadcrumbs":"Command-line arguments","id":"9","title":"Command-line arguments"},"90":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --display-warnings\n$ rustdoc --test src/lib.rs -Z unstable-options --display-warnings The intent behind this flag is to allow the user to see warnings that occur within their library or their documentation tests, which are usually suppressed. However, due to a bug , this flag doesn't 100% work as intended. See the linked issue for details.","breadcrumbs":"--display-warnings: display warnings when documenting or running documentation tests","id":"90","title":"--display-warnings: display warnings when documenting or running documentation tests"},"91":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --extern-html-root-url some-crate=https://example.com/some-crate/1.0.1 Ordinarily, when rustdoc wants to link to a type from a different crate, it looks in two places: docs that already exist in the output directory, or the #![doc(doc_html_root)] set in the other crate. However, if you want to link to docs that exist in neither of those places, you can use these flags to control that behavior. When the --extern-html-root-url flag is given with a name matching one of your dependencies, rustdoc use that URL for those docs. Keep in mind that if those docs exist in the output directory, those local docs will still override this flag.","breadcrumbs":"--extern-html-root-url: control how rustdoc links to non-local crates","id":"91","title":"--extern-html-root-url: control how rustdoc links to non-local crates"},"92":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z force-unstable-if-unmarked This is an internal flag intended for the standard library and compiler that applies an #[unstable] attribute to any dependent crate that doesn't have another stability attribute. This allows rustdoc to be able to generate documentation for the compiler crates and the standard library, as an equivalent command-line argument is provided to rustc when building those crates.","breadcrumbs":"-Z force-unstable-if-unmarked","id":"92","title":"-Z force-unstable-if-unmarked"},"93":{"body":"This feature allows you to generate an index-page with a given markdown file. A good example of it is the rust documentation index . With this, you'll have a page which you can custom as much as you want at the top of your crates. Using index-page option enables enable-index-page option as well.","breadcrumbs":"--index-page: provide a top-level landing page for docs","id":"93","title":"--index-page: provide a top-level landing page for docs"},"94":{"body":"This feature allows the generation of a default index-page which lists the generated crates.","breadcrumbs":"--enable-index-page: generate a default index page for docs","id":"94","title":"--enable-index-page: generate a default index page for docs"},"95":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --static-root-path '/cache/' This flag controls how rustdoc links to its static files on HTML pages. If you're hosting a lot of crates' docs generated by the same version of rustdoc, you can use this flag to cache rustdoc's CSS, JavaScript, and font files in a single location, rather than duplicating it once per \"doc root\" (grouping of crate docs generated into the same output directory, like with cargo doc). Per-crate files like the search index will still load from the documentation root, but anything that gets renamed with --resource-suffix will load from the given path.","breadcrumbs":"--static-root-path: control how static files are loaded in HTML output","id":"95","title":"--static-root-path: control how static files are loaded in HTML output"},"96":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --test -Z unstable-options --persist-doctests target/rustdoctest This flag allows you to keep doctest executables around after they're compiled or run. Usually, rustdoc will immediately discard a compiled doctest after it's been tested, but with this option, you can keep those binaries around for farther testing.","breadcrumbs":"--persist-doctests: persist doctest executables after running","id":"96","title":"--persist-doctests: persist doctest executables after running"},"97":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --show-coverage If you want to determine how many items in your crate are documented, pass this flag to rustdoc. When it receives this flag, it will count the public items in your crate that have documentation, and print out the counts and a percentage instead of generating docs. Some methodology notes about what rustdoc counts in this metric: Rustdoc will only count items from your crate (i.e. items re-exported from other crates don't count). Docs written directly onto inherent impl blocks are not counted, even though their doc comments are displayed, because the common pattern in Rust code is to write all inherent methods into the same impl block. Items in a trait implementation are not counted, as those impls will inherit any docs from the trait itself. By default, only public items are counted. To count private items as well, pass --document-private-items at the same time. Public items that are not documented can be seen with the built-in missing_docs lint. Private items that are not documented can be seen with Clippy's missing_docs_in_private_items lint.","breadcrumbs":"--show-coverage: calculate the percentage of items with documentation","id":"97","title":"--show-coverage: calculate the percentage of items with documentation"},"98":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --enable-per-target-ignores This flag allows you to tag doctests with compiltest style ignore-foo filters that prevent rustdoc from running that test if the target triple string contains foo. For example: ///```ignore-foo,ignore-bar\n///assert!(2 == 2);\n///```\nstruct Foo; This will not be run when the build target is super-awesome-foo or less-bar-awesome. If the flag is not enabled, then rustdoc will consume the filter, but do nothing with it, and the above example will be run for all targets. If you want to preserve backwards compatibility for older versions of rustdoc, you can use ///```ignore,ignore-foo\n///assert!(2 == 2);\n///```\nstruct Foo; In older versions, this will be ignored on all targets, but on newer versions ignore-gnu will override ignore.","breadcrumbs":"--enable-per-target-ignores: allow ignore-foo style filters for doctests","id":"98","title":"--enable-per-target-ignores: allow ignore-foo style filters for doctests"},"99":{"body":"Using these options looks like this: $ rustdoc src/lib.rs -Z unstable-options --runtool runner --runtool-arg --do-thing --runtool-arg --do-other-thing These options can be used to run the doctest under a program, and also pass arguments to that program. For example, if you want to run your doctests under valgrind you might run $ rustdoc src/lib.rs -Z unstable-options --runtool valgrind Another use case would be to run a test inside an emulator, or through a Virtual Machine.","breadcrumbs":"--runtool, --runtool-arg: program to run tests with; args to pass to it","id":"99","title":"--runtool, --runtool-arg: program to run tests with; args to pass to it"}},"length":100,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{"4":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}},"1":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"1":{"7":{".":{"0":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"3":{"7":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"9":{"9":{"0":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"3":{"tf":1.4142135623730951},"57":{"tf":1.0}}},"2":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"0":{"1":{"5":{"df":2,"docs":{"34":{"tf":1.0},"58":{"tf":1.0}}},"7":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"8":{"df":3,"docs":{"34":{"tf":1.4142135623730951},"49":{"tf":1.0},"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"df":3,"docs":{"57":{"tf":1.0},"58":{"tf":1.0},"98":{"tf":1.4142135623730951}}},"3":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"9":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.0}}},"4":{"df":2,"docs":{"54":{"tf":1.0},"65":{"tf":1.0}}},"5":{"6":{"1":{"2":{"4":{"b":{"a":{"a":{"9":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"52":{"tf":1.7320508075688772},"55":{"tf":2.6457513110645907},"58":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0}}},"6":{"df":2,"docs":{"55":{"tf":2.6457513110645907},"65":{"tf":1.0}}},"7":{"df":1,"docs":{"65":{"tf":1.0}}},"8":{"df":1,"docs":{"65":{"tf":1.0}}},"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":9,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"89":{"tf":1.0},"98":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"58":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"80":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"75":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"38":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":14,"docs":{"21":{"tf":1.0},"35":{"tf":2.0},"36":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"64":{"tf":1.0},"77":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"35":{"tf":1.0},"66":{"tf":1.0},"81":{"tf":1.0}}}}},"df":7,"docs":{"26":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"6":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"d":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}}},"i":{"a":{"df":0,"docs":{},"s":{"(":{"df":1,"docs":{"83":{"tf":1.0}}},"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":23,"docs":{"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"47":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"=":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"50":{"tf":1.0},"58":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"60":{"tf":1.0},"80":{"tf":1.0},"92":{"tf":1.0},"99":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"56":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"95":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"49":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":1.0},"82":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":9,"docs":{"15":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.4142135623730951},"74":{"tf":1.0},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"88":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"25":{"tf":1.0},"55":{"tf":1.0},"74":{"tf":1.4142135623730951},"92":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"47":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":3,"docs":{"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"99":{"tf":2.0}},"s":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"6":{"tf":2.6457513110645907},"84":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":1.4142135623730951},"92":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"56":{"tf":1.0},"96":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":2,"docs":{"78":{"tf":1.0},"82":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"2":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"58":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"53":{"tf":1.0},"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"53":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"52":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"78":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":24,"docs":{"38":{"tf":2.449489742783178},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"54":{"tf":2.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.7320508075688772},"80":{"tf":2.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.0},"87":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"44":{"tf":2.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}}}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"52":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"98":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"r":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{"b":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"1":{"tf":1.0},"49":{"tf":4.47213595499958},"55":{"tf":1.4142135623730951},"65":{"tf":1.0},"78":{"tf":2.449489742783178},"98":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"30":{"tf":1.0},"43":{"tf":1.0},"87":{"tf":1.0}}},"i":{"c":{"df":4,"docs":{"1":{"tf":1.0},"38":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"df":1,"docs":{"78":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":3,"docs":{"74":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"28":{"tf":2.23606797749979},"29":{"tf":1.0},"54":{"tf":1.0},"66":{"tf":1.0},"75":{"tf":1.0},"85":{"tf":2.6457513110645907},"86":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"38":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"36":{"tf":1.0},"37":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"83":{"tf":1.4142135623730951}},"x":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"12":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"52":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"59":{"tf":3.0},"64":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":5,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"df":5,"docs":{"4":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"74":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"32":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"90":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"92":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"74":{"tf":1.0},"97":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"30":{"tf":1.0},"42":{"tf":1.7320508075688772},"87":{"tf":1.0}}}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"89":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"78":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"32":{"tf":1.0},"58":{"tf":1.0},"76":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{"df":5,"docs":{"1":{"tf":1.7320508075688772},"2":{"tf":2.449489742783178},"3":{"tf":1.0},"84":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"1":{"tf":1.0},"38":{"tf":1.4142135623730951},"4":{"tf":1.0},"49":{"tf":1.4142135623730951},"55":{"tf":1.0},"59":{"tf":1.0},"78":{"tf":1.0},"99":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}},"s":{"df":3,"docs":{"55":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":1,"docs":{"20":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"53":{"tf":1.0},"60":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"74":{"tf":1.0},"80":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"74":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"74":{"tf":1.4142135623730951},"80":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"18":{"tf":2.0},"74":{"tf":1.0},"80":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"1":{"tf":1.0},"33":{"tf":1.0},"49":{"tf":1.4142135623730951},"89":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"5":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"1":{"tf":1.0},"36":{"tf":2.0},"44":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":25,"docs":{"1":{"tf":1.7320508075688772},"13":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"55":{"tf":2.23606797749979},"56":{"tf":1.0},"58":{"tf":2.8284271247461903},"59":{"tf":3.3166247903554},"6":{"tf":1.7320508075688772},"64":{"tf":2.449489742783178},"77":{"tf":2.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"97":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":2.449489742783178}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":3,"docs":{"38":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"38":{"tf":1.0},"80":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":10,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"2":{"tf":1.0},"44":{"tf":1.0},"6":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":2.0},"89":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"38":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":2.23606797749979},"97":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"54":{"tf":1.0},"97":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"98":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":18,"docs":{"18":{"tf":1.0},"20":{"tf":1.4142135623730951},"25":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.7320508075688772},"58":{"tf":2.8284271247461903},"60":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"92":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{",":{"df":0,"docs":{},"e":{"0":{"0":{"4":{"4":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"58":{"tf":1.4142135623730951},"60":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"56":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"74":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"56":{"tf":1.0}}}}},"i":{"d":{"df":6,"docs":{"49":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"36":{"tf":1.0}}}}},"t":{"df":1,"docs":{"78":{"tf":1.0}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"98":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"54":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"1":{"tf":1.4142135623730951},"28":{"tf":2.23606797749979},"29":{"tf":2.23606797749979},"3":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"85":{"tf":2.6457513110645907},"86":{"tf":2.6457513110645907}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":16,"docs":{"16":{"tf":1.0},"2":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"56":{"tf":1.0}}},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":3.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}},"df":2,"docs":{"4":{"tf":1.0},"5":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"1":{"tf":1.0},"87":{"tf":1.0}}},"/":{"1":{".":{"0":{".":{"1":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"3":{":":{"1":{"df":2,"docs":{"63":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{":":{"1":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":29,"docs":{"0":{"tf":1.0},"1":{"tf":2.6457513110645907},"16":{"tf":2.23606797749979},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"37":{"tf":2.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"44":{"tf":2.0},"46":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":2.0},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":2.0},"81":{"tf":2.23606797749979},"87":{"tf":2.449489742783178},"89":{"tf":1.0},"91":{"tf":1.7320508075688772},"92":{"tf":1.7320508075688772},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.7320508075688772},"97":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.0},"80":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":7,"docs":{"0":{"tf":1.0},"26":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"89":{"tf":1.0},"95":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":1.0},"58":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"t":{"a":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"52":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":20,"docs":{"1":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":2.23606797749979},"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.7320508075688772},"94":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"78":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"55":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":10,"docs":{"12":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"49":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"19":{"tf":1.0}}},"=":{"<":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{">":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.4142135623730951},"77":{"tf":1.0},"90":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"35":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"25":{"tf":1.0},"37":{"tf":1.0},"53":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"91":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"44":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"97":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"1":{"tf":1.0},"15":{"tf":1.7320508075688772},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"91":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"56":{"tf":1.0},"78":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"36":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"44":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"90":{"tf":2.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"o":{"c":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"83":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"80":{"tf":1.7320508075688772}}}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"50":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"42":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"82":{"tf":1.4142135623730951}},"e":{"=":{"\"":{".":{".":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"81":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}},"e":{")":{"]":{"/":{"#":{"[":{"d":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":37,"docs":{"1":{"tf":2.449489742783178},"15":{"tf":1.0},"2":{"tf":2.449489742783178},"3":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":4.242640687119285},"39":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":2.449489742783178},"56":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":2.23606797749979},"71":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"87":{"tf":1.7320508075688772},"89":{"tf":1.4142135623730951},"91":{"tf":2.23606797749979},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":2.0},"97":{"tf":2.0}},"s":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"34":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"60":{"tf":3.3166247903554},"74":{"tf":1.0},"77":{"tf":1.7320508075688772},"80":{"tf":1.0},"96":{"tf":2.23606797749979},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":53,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"20":{"tf":2.23606797749979},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"42":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":2.8284271247461903},"57":{"tf":1.4142135623730951},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":2.449489742783178},"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":2.8284271247461903},"81":{"tf":2.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":2.449489742783178}}}}}}}},"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"60":{"tf":1.0},"62":{"tf":1.0},"80":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":11,"docs":{"22":{"tf":1.0},"31":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"76":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"2":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.0}}},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"80":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"1":{"tf":1.0},"90":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"6":{"tf":1.0},"80":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"46":{"tf":1.0},"55":{"tf":1.4142135623730951},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"68":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"80":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"38":{"tf":1.4142135623730951}}}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"59":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":2.8284271247461903},"58":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":1,"docs":{"58":{"tf":1.0}}},"8":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"32":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"36":{"tf":1.0},"67":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"6":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.0},"98":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"d":{"df":6,"docs":{"13":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"36":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"78":{"tf":1.0}}}},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"58":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"52":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"56":{"tf":1.7320508075688772},"62":{"tf":1.0},"77":{"tf":2.8284271247461903}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"6":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"74":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.0},"69":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"19":{"tf":1.0},"22":{"tf":1.0},"80":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":31,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":2.0},"54":{"tf":2.8284271247461903},"55":{"tf":2.8284271247461903},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"6":{"tf":2.449489742783178},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":2.6457513110645907},"65":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"83":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"81":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"20":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"62":{"tf":1.0},"91":{"tf":1.7320508075688772}}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"4":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.4142135623730951},"80":{"tf":1.0}}}},"n":{"df":2,"docs":{"55":{"tf":1.0},"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"32":{"tf":1.7320508075688772},"60":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"32":{"tf":1.0},"79":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":10,"docs":{"19":{"tf":2.0},"44":{"tf":2.449489742783178},"46":{"tf":1.0},"54":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"72":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772}}}}},"r":{"a":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951}}}}}},"m":{"d":{"df":2,"docs":{"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":4,"docs":{"20":{"tf":1.0},"37":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":8,"docs":{"44":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.0},"77":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}},"s":{"df":1,"docs":{"57":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":16,"docs":{"18":{"tf":1.0},"20":{"tf":1.0},"43":{"tf":1.4142135623730951},"58":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":2.449489742783178},"76":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}},"e":{"(":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"60":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"=":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"59":{"tf":2.0}}},"df":0,"docs":{}},"w":{"df":1,"docs":{"58":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":24,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":2.23606797749979},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"82":{"tf":1.7320508075688772},"85":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772},"93":{"tf":1.0},"95":{"tf":2.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"35":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"74":{"tf":1.4142135623730951},"98":{"tf":1.7320508075688772}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0}}}},"d":{"df":6,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.4142135623730951},"34":{"tf":1.0},"44":{"tf":1.0},"55":{"tf":1.7320508075688772},"6":{"tf":1.0},"70":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"x":{"df":3,"docs":{"1":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":48,"docs":{"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":2.23606797749979},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"36":{"tf":2.23606797749979},"37":{"tf":1.7320508075688772},"44":{"tf":1.0},"66":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.7320508075688772},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.7320508075688772},"91":{"tf":2.0},"92":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772},"98":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"82":{"tf":1.0}}}}},"n":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":13,"docs":{"1":{"tf":1.4142135623730951},"3":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"58":{"tf":2.0},"62":{"tf":1.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.7320508075688772}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.7320508075688772},"63":{"tf":1.0},"64":{"tf":1.0},"78":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}},"o":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}},".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"1":{"df":1,"docs":{"78":{"tf":1.0}}},"2":{"df":1,"docs":{"78":{"tf":1.0}}},"3":{"df":1,"docs":{"78":{"tf":1.0}}},"4":{"df":1,"docs":{"78":{"tf":1.0}}},"`":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"1":{"tf":2.6457513110645907},"3":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":2.0},"57":{"tf":1.4142135623730951},"58":{"tf":2.0},"59":{"tf":1.7320508075688772},"62":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":2.0},"98":{"tf":2.6457513110645907}}},"r":{"c":{"df":3,"docs":{"54":{"tf":1.0},"60":{"tf":1.0},"92":{"tf":1.4142135623730951}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":2.0},"14":{"tf":1.7320508075688772}}}},"df":7,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"20":{"tf":1.0},"54":{"tf":1.0}},"i":{"df":2,"docs":{"75":{"tf":1.0},"80":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"1":{"tf":1.0}}},"df":12,"docs":{"1":{"tf":2.23606797749979},"38":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"60":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.4142135623730951}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"58":{"tf":1.0},"77":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"76":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":21,"docs":{"0":{"tf":1.0},"1":{"tf":2.0},"2":{"tf":2.0},"20":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":2.0},"38":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"49":{"tf":1.0},"51":{"tf":1.0},"58":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.7320508075688772},"95":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"t":{"df":2,"docs":{"70":{"tf":1.0},"95":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":11,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.0},"76":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}},"n":{"df":12,"docs":{"34":{"tf":1.4142135623730951},"38":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"57":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"25":{"tf":1.0},"98":{"tf":1.0}}}},"o":{"df":0,"docs":{},"e":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}},"o":{"d":{"df":2,"docs":{"5":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"36":{"tf":1.0},"77":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"41":{"tf":1.0}},"l":{"df":3,"docs":{"38":{"tf":1.0},"56":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"55":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"80":{"tf":1.0}}}}},"df":1,"docs":{"10":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":8,"docs":{"1":{"tf":1.0},"10":{"tf":2.23606797749979},"2":{"tf":1.0},"20":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":4,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"9":{"tf":1.0}}},"df":8,"docs":{"3":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0}},"’":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"50":{"tf":1.0},"55":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"55":{"tf":2.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"25":{"tf":1.0},"74":{"tf":1.0},"95":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"'":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"'":{">":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"g":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":13,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":2.0},"28":{"tf":2.0},"29":{"tf":2.0},"3":{"tf":1.4142135623730951},"36":{"tf":1.0},"44":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.7320508075688772},"95":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"/":{"1":{".":{"0":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{".":{"df":1,"docs":{"97":{"tf":1.0}}},"3":{"2":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":4,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":9,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"62":{"tf":1.0},"80":{"tf":1.0},"98":{"tf":2.8284271247461903}},"e":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":1,"docs":{"97":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"36":{"tf":1.0},"56":{"tf":1.0},"68":{"tf":1.0},"81":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"67":{"tf":1.0},"71":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"21":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":18,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"78":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":2.23606797749979}}}},"x":{"df":4,"docs":{"77":{"tf":1.0},"93":{"tf":2.23606797749979},"94":{"tf":1.7320508075688772},"95":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":7,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":2.23606797749979},"56":{"tf":2.8284271247461903}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"54":{"tf":1.4142135623730951},"85":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772}}}}},"i":{"d":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"28":{"tf":1.0},"85":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"a":{"d":{"df":14,"docs":{"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"38":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}},"n":{"d":{"df":4,"docs":{"69":{"tf":1.0},"81":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":3,"docs":{"2":{"tf":1.0},"81":{"tf":1.7320508075688772},"92":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"62":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":7,"docs":{"1":{"tf":1.0},"43":{"tf":1.4142135623730951},"69":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"'":{"df":10,"docs":{"1":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"6":{"tf":1.0}}},"df":19,"docs":{"38":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":2.23606797749979},"63":{"tf":1.0},"65":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":2.0},"78":{"tf":1.7320508075688772},"8":{"tf":1.0},"80":{"tf":2.449489742783178},"83":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"97":{"tf":3.3166247903554}}},"r":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"’":{"df":0,"docs":{},"m":{"df":1,"docs":{"57":{"tf":1.0}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"0":{"tf":1.0},"38":{"tf":1.0}}},"df":0,"docs":{}},"u":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"5":{"tf":1.0},"55":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"38":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"17":{"tf":1.0},"60":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"3":{"tf":1.0},"30":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"75":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":2,"docs":{"17":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":2,"docs":{"38":{"tf":1.0},"54":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"41":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"36":{"tf":1.0},"98":{"tf":1.0}}}},"t":{"'":{"df":4,"docs":{"1":{"tf":1.7320508075688772},"3":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.0}}},"df":7,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":7,"docs":{"0":{"tf":1.0},"2":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":1,"docs":{"1":{"tf":1.4142135623730951}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":9,"docs":{"17":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"43":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":2.0},"90":{"tf":1.0},"92":{"tf":1.4142135623730951}}},"y":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":0,"docs":{}},"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"89":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":14,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"55":{"tf":2.0},"57":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"70":{"tf":2.0},"76":{"tf":1.0},"84":{"tf":1.7320508075688772},"9":{"tf":1.0},"92":{"tf":1.0}}},"k":{"!":{"]":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"1":{"tf":1.0},"26":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"49":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":2.449489742783178},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.7320508075688772},"95":{"tf":1.0}}},"t":{"df":8,"docs":{"54":{"tf":1.0},"61":{"tf":2.23606797749979},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"8":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":12,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"61":{"tf":1.0},"73":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"64":{"tf":1.0}},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}}}}},"o":{"a":{"d":{"df":1,"docs":{"95":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"44":{"tf":1.0},"91":{"tf":1.4142135623730951}}},"t":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"30":{"tf":1.0},"87":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":45,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"p":{"df":2,"docs":{"58":{"tf":1.0},"80":{"tf":1.0}}}},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"99":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"57":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"54":{"tf":1.0},"57":{"tf":1.7320508075688772}}}}},"df":5,"docs":{"38":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.4142135623730951},"78":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"1":{"tf":1.0},"54":{"tf":2.0},"56":{"tf":2.0},"57":{"tf":2.0},"60":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":9,"docs":{"2":{"tf":1.0},"42":{"tf":1.4142135623730951},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.4142135623730951},"60":{"tf":1.0},"74":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":13,"docs":{"0":{"tf":1.0},"13":{"tf":1.7320508075688772},"26":{"tf":2.0},"3":{"tf":2.0},"30":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"38":{"tf":1.0},"7":{"tf":1.4142135623730951},"78":{"tf":1.0},"85":{"tf":2.23606797749979},"86":{"tf":2.23606797749979},"87":{"tf":2.23606797749979},"93":{"tf":1.0}}}}}},"df":1,"docs":{"84":{"tf":1.0}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"81":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"75":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"57":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"12":{"tf":1.0},"38":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"57":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"78":{"tf":1.0},"97":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"5":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":4,"docs":{"61":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"63":{"tf":1.0},"97":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"d":{"df":3,"docs":{"49":{"tf":1.7320508075688772},"65":{"tf":1.0},"78":{"tf":1.0}},"e":{"df":3,"docs":{"12":{"tf":1.0},"36":{"tf":1.0},"76":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"89":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"49":{"tf":1.0},"78":{"tf":1.4142135623730951},"88":{"tf":2.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":21,"docs":{"12":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.0},"70":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"56":{"tf":2.0}}}},"y":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":12,"docs":{"1":{"tf":2.23606797749979},"15":{"tf":1.0},"16":{"tf":2.6457513110645907},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"35":{"tf":1.7320508075688772},"52":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"6":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":11,"docs":{"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"44":{"tf":1.0},"55":{"tf":2.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"64":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.4142135623730951},"89":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"60":{"tf":1.0}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}}},"w":{"df":4,"docs":{"1":{"tf":1.7320508075688772},"58":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"62":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.0},"91":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":10,"docs":{"38":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"74":{"tf":1.0},"78":{"tf":1.0},"97":{"tf":1.0}}},"h":{"df":1,"docs":{"98":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":3,"docs":{"1":{"tf":1.0},"42":{"tf":1.0},"49":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"17":{"tf":1.0},"43":{"tf":1.4142135623730951},"60":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":2.23606797749979},"88":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"15":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"36":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":1,"docs":{"56":{"tf":1.7320508075688772}}},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"95":{"tf":1.0}}},"df":6,"docs":{"38":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"6":{"tf":1.0},"70":{"tf":1.0},"91":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"r":{"df":4,"docs":{"36":{"tf":1.0},"56":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"78":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":22,"docs":{"10":{"tf":1.0},"20":{"tf":2.0},"24":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"60":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"13":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0},"97":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":14,"docs":{"12":{"tf":1.0},"14":{"tf":2.0},"15":{"tf":2.23606797749979},"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"89":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"22":{"tf":1.0},"59":{"tf":1.0},"75":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"16":{"tf":1.0},"33":{"tf":1.0},"91":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":13,"docs":{"1":{"tf":2.23606797749979},"10":{"tf":1.0},"49":{"tf":1.4142135623730951},"58":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"81":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"93":{"tf":2.449489742783178},"94":{"tf":1.7320508075688772},"95":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"$":{"(":{"$":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"1":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"57":{"tf":1.0}}}}}}}}},"df":3,"docs":{"53":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.4142135623730951}},"k":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}}}}}}}}}},"t":{"df":7,"docs":{"20":{"tf":1.0},"55":{"tf":1.7320508075688772},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"69":{"tf":1.0},"81":{"tf":1.0},"89":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":29,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.6457513110645907},"22":{"tf":2.449489742783178},"24":{"tf":1.4142135623730951},"32":{"tf":1.0},"38":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"66":{"tf":2.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"74":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},">":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"1":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"6":{"tf":1.0},"78":{"tf":1.7320508075688772},"95":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"6":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"c":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"95":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.7320508075688772}}}}}}}},"i":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"77":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":5,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"51":{"tf":1.0},"91":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"74":{"tf":1.7320508075688772},"80":{"tf":3.1622776601683795}}}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"30":{"tf":2.0},"87":{"tf":3.3166247903554}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"52":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"43":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"5":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":1,"docs":{"54":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"78":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"v":{"df":5,"docs":{"55":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"98":{"tf":1.0}}}}},"s":{"df":1,"docs":{"42":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"55":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"98":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"21":{"tf":1.0},"37":{"tf":1.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.0},"88":{"tf":1.4142135623730951},"97":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"58":{"tf":1.0}}}}}}},"w":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"55":{"tf":2.6457513110645907},"6":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"49":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":2.0},"67":{"tf":1.4142135623730951},"71":{"tf":2.0},"72":{"tf":1.0},"97":{"tf":1.7320508075688772}},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"21":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"56":{"tf":1.0},"74":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"54":{"tf":1.4142135623730951},"6":{"tf":1.0},"80":{"tf":2.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":7,"docs":{"0":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"47":{"tf":1.0},"66":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"45":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"99":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":9,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"87":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":11,"docs":{"1":{"tf":1.0},"49":{"tf":3.3166247903554},"60":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":2.6457513110645907},"80":{"tf":1.4142135623730951},"83":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"c":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":1.0},"60":{"tf":1.7320508075688772},"71":{"tf":2.0},"97":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}}},"t":{"df":5,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"55":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"a":{"d":{"df":2,"docs":{"52":{"tf":1.0},"82":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":1.0}}}},"m":{"df":1,"docs":{"60":{"tf":1.7320508075688772}},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":10,"docs":{"20":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":4,"docs":{"37":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}}},"v":{"df":1,"docs":{"78":{"tf":1.0}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}},"df":3,"docs":{"1":{"tf":1.0},"49":{"tf":1.4142135623730951},"97":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"59":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"74":{"tf":1.0},"80":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"20":{"tf":1.0},"53":{"tf":1.4142135623730951},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":4,"docs":{"12":{"tf":1.0},"58":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"55":{"tf":1.0}}}},"i":{"df":2,"docs":{"2":{"tf":1.0},"6":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":6,"docs":{"22":{"tf":1.0},"38":{"tf":1.0},"50":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"89":{"tf":1.0},"95":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"26":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"87":{"tf":1.7320508075688772},"89":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":2,"docs":{"1":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"r":{"df":6,"docs":{"75":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"62":{"tf":1.4142135623730951},"78":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"89":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"74":{"tf":1.4142135623730951},"78":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":3,"docs":{"4":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"56":{"tf":1.7320508075688772}}}},"df":6,"docs":{"53":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"77":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"53":{"tf":1.0},"56":{"tf":2.0},"6":{"tf":1.4142135623730951}}}}}}},"f":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"58":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"33":{"tf":1.0},"44":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":1.7320508075688772},"95":{"tf":2.0}}}}},"s":{"df":1,"docs":{"16":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"36":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0}}}},"n":{"df":21,"docs":{"1":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"30":{"tf":1.0},"42":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"80":{"tf":2.0},"87":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.4142135623730951},"98":{"tf":1.7320508075688772},"99":{"tf":2.23606797749979}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":2.449489742783178}}}}}}},"s":{"df":0,"docs":{},"t":{"c":{"df":8,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":2.0},"25":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"80":{"tf":1.0},"92":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"'":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"15":{"tf":1.0},"32":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"95":{"tf":1.0}}},"df":72,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":2.6457513110645907},"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":2.23606797749979},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":2.449489742783178},"20":{"tf":2.8284271247461903},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":1.7320508075688772},"3":{"tf":2.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":2.0},"59":{"tf":1.0},"60":{"tf":2.0},"61":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.0},"78":{"tf":2.0},"8":{"tf":1.0},"80":{"tf":2.8284271247461903},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"85":{"tf":2.0},"86":{"tf":2.0},"87":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":2.0},"92":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951},"97":{"tf":2.0},"98":{"tf":2.0},"99":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":17,"docs":{"0":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"20":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"93":{"tf":1.0},"97":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":13,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"77":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"62":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"55":{"tf":1.4142135623730951},"58":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"83":{"tf":2.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"57":{"tf":1.0},"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"49":{"tf":1.7320508075688772},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"75":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":16,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"36":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.4142135623730951}},"n":{"df":2,"docs":{"74":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"36":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":7,"docs":{"52":{"tf":1.0},"55":{"tf":2.0},"6":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"91":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"55":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"22":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.7320508075688772},"89":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":9,"docs":{"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"83":{"tf":1.0},"97":{"tf":1.4142135623730951}}}}},"i":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"19":{"tf":1.0},"25":{"tf":1.0},"33":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":3,"docs":{"38":{"tf":1.0},"70":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"x":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"80":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"55":{"tf":1.0},"60":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":2.23606797749979}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":5,"docs":{"13":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"38":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"49":{"tf":1.0},"80":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":6,"docs":{"5":{"tf":1.0},"59":{"tf":1.4142135623730951},"7":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":2.23606797749979}},"i":{"df":9,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.7320508075688772},"22":{"tf":1.0},"25":{"tf":1.0},"54":{"tf":1.4142135623730951},"58":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":35,"docs":{"1":{"tf":2.0},"12":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":2.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"77":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0}}}},"l":{"df":4,"docs":{"10":{"tf":1.0},"32":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951}}}}},"r":{"d":{"df":8,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"43":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":2.0},"92":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"52":{"tf":1.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"77":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"72":{"tf":1.0}}}}}}},"i":{"c":{"=":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"19":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":2.0}}},"df":0,"docs":{}}}},"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"6":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"56":{"tf":2.0}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"c":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"36":{"tf":1.0},"55":{"tf":1.4142135623730951},"60":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"56":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":5,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"55":{"tf":1.0},"70":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"p":{"df":6,"docs":{"21":{"tf":1.0},"50":{"tf":1.0},"67":{"tf":2.0},"68":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"49":{"tf":2.23606797749979},"60":{"tf":2.8284271247461903},"71":{"tf":1.4142135623730951},"74":{"tf":2.0},"78":{"tf":3.605551275463989},"80":{"tf":2.0},"83":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":2.0}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}}}}},"u":{"b":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"76":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"89":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"89":{"tf":1.7320508075688772},"95":{"tf":1.0}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":1,"docs":{"55":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"52":{"tf":1.0},"78":{"tf":1.0}}}},"s":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"31":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"52":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":3,"docs":{"38":{"tf":1.0},"59":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"33":{"tf":1.0},"6":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":5,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"98":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":11,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"c":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"=":{"+":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"x":{"df":1,"docs":{"20":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":2.23606797749979},"74":{"tf":2.0},"80":{"tf":1.7320508075688772},"98":{"tf":2.449489742783178}}}}}}},"df":3,"docs":{"69":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"20":{"tf":1.0},"58":{"tf":2.0},"80":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":19,"docs":{"20":{"tf":2.6457513110645907},"23":{"tf":2.449489742783178},"24":{"tf":2.8284271247461903},"3":{"tf":1.0},"34":{"tf":1.0},"52":{"tf":2.0},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.0},"58":{"tf":2.0},"60":{"tf":3.1622776601683795},"61":{"tf":1.0},"65":{"tf":2.0},"75":{"tf":1.0},"77":{"tf":1.4142135623730951},"90":{"tf":1.7320508075688772},"96":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":6,"docs":{"38":{"tf":1.4142135623730951},"54":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":4,"docs":{"2":{"tf":1.0},"25":{"tf":1.0},"55":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"32":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.0}}}}},"df":0,"docs":{}},"df":3,"docs":{"32":{"tf":1.0},"35":{"tf":3.0},"36":{"tf":3.3166247903554}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":6,"docs":{"1":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"'":{"df":0,"docs":{},"r":{"df":3,"docs":{"71":{"tf":1.0},"75":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"55":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.4142135623730951},"77":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"k":{"df":2,"docs":{"1":{"tf":1.0},"6":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":9,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"57":{"tf":1.0},"75":{"tf":1.0},"91":{"tf":2.0},"92":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"38":{"tf":1.0},"52":{"tf":1.0},"97":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":3,"docs":{"57":{"tf":1.0},"59":{"tf":1.0},"78":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"99":{"tf":1.0}}}}}}},"u":{"df":3,"docs":{"75":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0}},"m":{"b":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"75":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"20":{"tf":1.0},"55":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"o":{"c":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}},"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"74":{"tf":1.7320508075688772},"80":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"p":{"df":4,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"49":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":4,"docs":{"43":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"56":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":2.0},"97":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"34":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":4,"docs":{"1":{"tf":1.4142135623730951},"3":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.0},"25":{"tf":1.7320508075688772},"52":{"tf":1.0},"98":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"57":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"76":{"tf":1.0},"81":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":6,"docs":{"1":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.0},"91":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"82":{"tf":1.0}}},"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":5,"docs":{"51":{"tf":1.4142135623730951},"56":{"tf":2.0},"78":{"tf":1.4142135623730951},"81":{"tf":2.0},"91":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"2":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"99":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"3":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"63":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.0},"56":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}}},"n":{"d":{"df":2,"docs":{"67":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"56":{"tf":1.0}}}},"t":{"df":2,"docs":{"53":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"x":{"df":3,"docs":{"6":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"74":{"tf":1.0},"80":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"49":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":3,"docs":{"76":{"tf":1.0},"77":{"tf":1.0},"87":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"92":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":20,"docs":{"10":{"tf":1.0},"43":{"tf":1.0},"75":{"tf":1.7320508075688772},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.7320508075688772},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"df":6,"docs":{"1":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"52":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"80":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":5,"docs":{"30":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"87":{"tf":3.3166247903554},"91":{"tf":2.0}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":72,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":3.0},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.0},"56":{"tf":2.6457513110645907},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"60":{"tf":2.0},"61":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":2.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":2.23606797749979},"80":{"tf":2.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.7320508075688772}},"e":{"'":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":2,"docs":{"6":{"tf":1.4142135623730951},"90":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"60":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"25":{"tf":1.0},"6":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"99":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"d":{"df":2,"docs":{"6":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"38":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"85":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"12":{"tf":2.23606797749979},"2":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"60":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"11":{"tf":2.0},"12":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":2.449489742783178},"38":{"tf":1.0},"56":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.7320508075688772}}}}}}}},"i":{"a":{"df":5,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"38":{"tf":1.0},"6":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"22":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":2.23606797749979},"56":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"62":{"tf":1.0},"74":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"47":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"78":{"tf":1.0},"90":{"tf":2.23606797749979}}}},"y":{"df":7,"docs":{"20":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.0}}}},"df":1,"docs":{"14":{"tf":1.0}},"e":{"'":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"49":{"tf":1.0}}}},"r":{"df":1,"docs":{"60":{"tf":1.0}}},"v":{"df":1,"docs":{"38":{"tf":1.0}}}},"b":{"df":2,"docs":{"1":{"tf":1.0},"58":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"7":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"2":{"tf":1.4142135623730951},"34":{"tf":1.0},"57":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}}}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"'":{"1":{"0":{"0":{"'":{">":{"<":{"/":{"a":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"25":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"74":{"tf":1.0},"80":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"52":{"tf":1.0},"80":{"tf":1.0},"90":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"53":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"k":{"df":9,"docs":{"15":{"tf":1.0},"36":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"90":{"tf":1.0}}},"l":{"d":{"df":3,"docs":{"55":{"tf":1.4142135623730951},"58":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"d":{"'":{"df":0,"docs":{},"v":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":10,"docs":{"5":{"tf":2.23606797749979},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"82":{"tf":1.0},"97":{"tf":1.0}}}}}}}}},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"52":{"tf":1.7320508075688772},"55":{"tf":4.242640687119285},"58":{"tf":1.4142135623730951},"60":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"y":{"df":1,"docs":{"55":{"tf":4.242640687119285}},"e":{"df":1,"docs":{"55":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"1":{"tf":1.7320508075688772},"2":{"tf":1.0},"3":{"tf":1.0},"54":{"tf":1.0},"62":{"tf":1.0},"93":{"tf":1.0}}}},"r":{"df":1,"docs":{"95":{"tf":1.0}}},"v":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}},"z":{"df":14,"docs":{"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}},"breadcrumbs":{"root":{"0":{"4":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}},"1":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"1":{"7":{".":{"0":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"3":{"7":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"0":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"9":{"9":{"0":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"3":{"tf":1.4142135623730951},"57":{"tf":1.0}}},"2":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"0":{"1":{"5":{"df":2,"docs":{"34":{"tf":1.0},"58":{"tf":1.0}}},"7":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"8":{"df":3,"docs":{"34":{"tf":1.4142135623730951},"49":{"tf":1.0},"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"df":3,"docs":{"57":{"tf":1.0},"58":{"tf":1.0},"98":{"tf":1.4142135623730951}}},"3":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"9":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.0}}},"4":{"df":2,"docs":{"54":{"tf":1.0},"65":{"tf":1.0}}},"5":{"6":{"1":{"2":{"4":{"b":{"a":{"a":{"9":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"52":{"tf":1.7320508075688772},"55":{"tf":2.6457513110645907},"58":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0}}},"6":{"df":2,"docs":{"55":{"tf":2.6457513110645907},"65":{"tf":1.0}}},"7":{"df":1,"docs":{"65":{"tf":1.0}}},"8":{"df":1,"docs":{"65":{"tf":1.0}}},"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":9,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"49":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"89":{"tf":1.0},"98":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"58":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"80":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"75":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"38":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":14,"docs":{"21":{"tf":1.4142135623730951},"35":{"tf":2.23606797749979},"36":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"64":{"tf":1.0},"77":{"tf":1.4142135623730951},"81":{"tf":1.0},"83":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"35":{"tf":1.0},"66":{"tf":1.0},"81":{"tf":1.0}}}}},"df":7,"docs":{"26":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"6":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"60":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"d":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}}},"i":{"a":{"df":0,"docs":{},"s":{"(":{"df":1,"docs":{"83":{"tf":1.0}}},"df":1,"docs":{"83":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":23,"docs":{"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"47":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"=":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"50":{"tf":1.0},"58":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"60":{"tf":1.0},"80":{"tf":1.0},"92":{"tf":1.0},"99":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"56":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"95":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"49":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"60":{"tf":1.0},"82":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":9,"docs":{"15":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.4142135623730951},"74":{"tf":1.0},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"88":{"tf":2.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"25":{"tf":1.0},"55":{"tf":1.0},"74":{"tf":1.4142135623730951},"92":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"47":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":3,"docs":{"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"99":{"tf":2.449489742783178}},"s":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"6":{"tf":2.6457513110645907},"84":{"tf":1.4142135623730951},"87":{"tf":1.0},"9":{"tf":1.7320508075688772},"92":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"56":{"tf":1.0},"96":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":2,"docs":{"78":{"tf":1.0},"82":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"2":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"58":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"53":{"tf":1.0},"59":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"53":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"52":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"78":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":24,"docs":{"38":{"tf":2.6457513110645907},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"54":{"tf":2.0},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":2.0},"80":{"tf":2.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.0},"87":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"44":{"tf":2.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}}}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"52":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"98":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"r":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{"b":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"1":{"tf":1.0},"49":{"tf":4.47213595499958},"55":{"tf":1.4142135623730951},"65":{"tf":1.0},"78":{"tf":2.449489742783178},"98":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"30":{"tf":1.0},"43":{"tf":1.0},"87":{"tf":1.0}}},"i":{"c":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"38":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":2.0}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"df":1,"docs":{"78":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":3,"docs":{"74":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"28":{"tf":2.6457513110645907},"29":{"tf":1.0},"54":{"tf":1.0},"66":{"tf":1.0},"75":{"tf":1.0},"85":{"tf":3.0},"86":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"38":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"36":{"tf":1.0},"37":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"83":{"tf":1.4142135623730951}},"x":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"12":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"52":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"59":{"tf":3.0},"64":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":5,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"df":5,"docs":{"4":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"74":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"32":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"90":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"92":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"74":{"tf":1.0},"97":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"30":{"tf":1.0},"42":{"tf":1.7320508075688772},"87":{"tf":1.0}}}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"89":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"l":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"78":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"32":{"tf":1.0},"58":{"tf":1.0},"76":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{"df":5,"docs":{"1":{"tf":1.7320508075688772},"2":{"tf":2.6457513110645907},"3":{"tf":1.0},"84":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"1":{"tf":1.0},"38":{"tf":1.4142135623730951},"4":{"tf":1.0},"49":{"tf":1.4142135623730951},"55":{"tf":1.0},"59":{"tf":1.0},"78":{"tf":1.0},"99":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}},"s":{"df":3,"docs":{"55":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":1,"docs":{"20":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"53":{"tf":1.0},"60":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"74":{"tf":1.0},"80":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"74":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"74":{"tf":1.7320508075688772},"80":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"18":{"tf":2.23606797749979},"74":{"tf":1.0},"80":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"1":{"tf":1.0},"33":{"tf":1.0},"49":{"tf":1.4142135623730951},"89":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"5":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"1":{"tf":1.0},"36":{"tf":2.23606797749979},"44":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"5":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":25,"docs":{"1":{"tf":1.7320508075688772},"13":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"25":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"55":{"tf":2.23606797749979},"56":{"tf":1.0},"58":{"tf":2.8284271247461903},"59":{"tf":3.3166247903554},"6":{"tf":1.7320508075688772},"64":{"tf":2.449489742783178},"77":{"tf":2.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"97":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":2.8284271247461903}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":3,"docs":{"38":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":2.0}}}},"df":0,"docs":{}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"38":{"tf":1.0},"80":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":10,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"2":{"tf":1.0},"44":{"tf":1.0},"6":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":2.23606797749979},"89":{"tf":1.0},"9":{"tf":1.4142135623730951},"92":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"38":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":2.449489742783178},"97":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"54":{"tf":1.0},"97":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"98":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":18,"docs":{"18":{"tf":1.0},"20":{"tf":1.4142135623730951},"25":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.7320508075688772},"58":{"tf":2.8284271247461903},"60":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"77":{"tf":1.7320508075688772},"79":{"tf":1.0},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"92":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{",":{"df":0,"docs":{},"e":{"0":{"0":{"4":{"4":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"58":{"tf":1.4142135623730951},"60":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"56":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"57":{"tf":1.0},"74":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"56":{"tf":1.0}}}}},"i":{"d":{"df":6,"docs":{"49":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"36":{"tf":1.0}}}}},"t":{"df":1,"docs":{"78":{"tf":1.0}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"98":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"54":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"1":{"tf":1.4142135623730951},"28":{"tf":2.6457513110645907},"29":{"tf":2.6457513110645907},"3":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"85":{"tf":3.0},"86":{"tf":3.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":16,"docs":{"16":{"tf":1.4142135623730951},"2":{"tf":1.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"91":{"tf":1.7320508075688772},"95":{"tf":1.7320508075688772}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"56":{"tf":1.0}}},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":3.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"97":{"tf":1.7320508075688772}}}},"df":2,"docs":{"4":{"tf":1.0},"5":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"1":{"tf":1.0},"87":{"tf":1.0}}},"/":{"1":{".":{"0":{".":{"1":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"3":{":":{"1":{"df":2,"docs":{"63":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{":":{"1":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"91":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":29,"docs":{"0":{"tf":1.0},"1":{"tf":2.6457513110645907},"16":{"tf":2.6457513110645907},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"37":{"tf":2.449489742783178},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"44":{"tf":2.0},"46":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"60":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":2.0},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":2.0},"81":{"tf":2.23606797749979},"87":{"tf":2.449489742783178},"89":{"tf":1.4142135623730951},"91":{"tf":2.0},"92":{"tf":1.7320508075688772},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.7320508075688772},"97":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":1.0},"80":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":7,"docs":{"0":{"tf":1.0},"26":{"tf":2.23606797749979},"32":{"tf":2.23606797749979},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"89":{"tf":1.0},"95":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":1.0},"58":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"35":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"t":{"a":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"52":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"81":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":20,"docs":{"1":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":2.6457513110645907},"31":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":2.0},"94":{"tf":1.7320508075688772},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"78":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"55":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":10,"docs":{"12":{"tf":1.0},"17":{"tf":2.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"49":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.7320508075688772},"91":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"=":{"<":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{">":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.4142135623730951},"77":{"tf":1.0},"90":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"35":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"25":{"tf":1.0},"37":{"tf":1.0},"53":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"91":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"44":{"tf":1.0},"78":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"97":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"1":{"tf":1.0},"15":{"tf":1.7320508075688772},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"91":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"56":{"tf":1.0},"78":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"36":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"44":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"90":{"tf":2.449489742783178},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"81":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"o":{"c":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"83":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"80":{"tf":1.7320508075688772}}}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"50":{"tf":1.7320508075688772},"68":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"42":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"82":{"tf":1.4142135623730951}},"e":{"=":{"\"":{".":{".":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"81":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}},"e":{")":{"]":{"/":{"#":{"[":{"d":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":37,"docs":{"1":{"tf":2.449489742783178},"15":{"tf":1.0},"2":{"tf":2.449489742783178},"3":{"tf":1.0},"34":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":4.358898943540674},"39":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":2.449489742783178},"56":{"tf":2.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":2.449489742783178},"71":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"80":{"tf":1.7320508075688772},"87":{"tf":1.7320508075688772},"89":{"tf":1.7320508075688772},"91":{"tf":2.23606797749979},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":2.0},"97":{"tf":2.0}},"s":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"34":{"tf":1.7320508075688772},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"53":{"tf":2.0},"60":{"tf":3.4641016151377544},"74":{"tf":1.0},"77":{"tf":2.0},"80":{"tf":1.0},"96":{"tf":2.6457513110645907},"98":{"tf":1.7320508075688772},"99":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":53,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"20":{"tf":2.23606797749979},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":2.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"42":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"5":{"tf":2.6457513110645907},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":2.0},"54":{"tf":1.0},"55":{"tf":2.8284271247461903},"57":{"tf":1.7320508075688772},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":2.23606797749979},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":2.6457513110645907},"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":3.0},"81":{"tf":2.23606797749979},"82":{"tf":2.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":2.23606797749979},"92":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":2.6457513110645907}}}}}}}},"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"60":{"tf":1.0},"62":{"tf":1.0},"80":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":11,"docs":{"22":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"76":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"2":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"78":{"tf":1.0}}},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"80":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"1":{"tf":1.0},"90":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"6":{"tf":1.0},"80":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"46":{"tf":1.0},"55":{"tf":1.4142135623730951},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"68":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"80":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"38":{"tf":1.4142135623730951}}}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"59":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":3.1622776601683795},"58":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":1,"docs":{"58":{"tf":1.0}}},"8":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"32":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"36":{"tf":1.0},"67":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"6":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"98":{"tf":2.0}}}},"df":0,"docs":{}},"d":{"df":6,"docs":{"13":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"36":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"83":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"78":{"tf":1.0}}}},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"58":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"52":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"56":{"tf":1.7320508075688772},"62":{"tf":1.0},"77":{"tf":3.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"6":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"74":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.0},"69":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"19":{"tf":1.0},"22":{"tf":1.0},"80":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":31,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.7320508075688772},"26":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":2.0},"54":{"tf":3.0},"55":{"tf":3.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"6":{"tf":2.449489742783178},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":2.6457513110645907},"65":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"83":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"81":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"20":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"96":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"62":{"tf":1.0},"91":{"tf":1.7320508075688772}}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"4":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.4142135623730951},"80":{"tf":1.0}}}},"n":{"df":2,"docs":{"55":{"tf":1.0},"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"32":{"tf":2.23606797749979},"60":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"32":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"df":10,"docs":{"19":{"tf":2.23606797749979},"44":{"tf":2.449489742783178},"46":{"tf":1.0},"54":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"72":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"91":{"tf":2.0}}}}},"r":{"a":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951}}}}}},"m":{"d":{"df":2,"docs":{"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":4,"docs":{"20":{"tf":1.0},"37":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":8,"docs":{"44":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.7320508075688772},"56":{"tf":1.0},"58":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.0},"77":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}},"s":{"df":1,"docs":{"57":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":16,"docs":{"18":{"tf":1.0},"20":{"tf":1.0},"43":{"tf":1.4142135623730951},"58":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"75":{"tf":2.6457513110645907},"76":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}},"e":{"(":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"60":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"=":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"59":{"tf":2.0}}},"df":0,"docs":{}},"w":{"df":1,"docs":{"58":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":24,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":2.449489742783178},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"52":{"tf":1.0},"60":{"tf":1.0},"82":{"tf":2.0},"85":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772},"93":{"tf":1.0},"95":{"tf":2.23606797749979}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"35":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"74":{"tf":1.4142135623730951},"98":{"tf":2.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"6":{"tf":1.0},"66":{"tf":1.0}}}},"d":{"df":6,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.4142135623730951},"34":{"tf":1.0},"44":{"tf":1.0},"55":{"tf":1.7320508075688772},"6":{"tf":1.0},"70":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"x":{"df":3,"docs":{"1":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":48,"docs":{"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":2.23606797749979},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"36":{"tf":2.23606797749979},"37":{"tf":1.7320508075688772},"44":{"tf":1.0},"66":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.7320508075688772},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.7320508075688772},"91":{"tf":2.0},"92":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772},"98":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"82":{"tf":1.0}}}}},"n":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":13,"docs":{"1":{"tf":1.4142135623730951},"3":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"58":{"tf":2.0},"62":{"tf":1.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.7320508075688772}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.7320508075688772},"63":{"tf":1.0},"64":{"tf":1.0},"78":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}},"o":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}},".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"1":{"df":1,"docs":{"78":{"tf":1.0}}},"2":{"df":1,"docs":{"78":{"tf":1.0}}},"3":{"df":1,"docs":{"78":{"tf":1.0}}},"4":{"df":1,"docs":{"78":{"tf":1.0}}},"`":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"1":{"tf":2.6457513110645907},"3":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":2.0},"57":{"tf":1.4142135623730951},"58":{"tf":2.0},"59":{"tf":1.7320508075688772},"62":{"tf":1.0},"65":{"tf":1.0},"78":{"tf":2.0},"98":{"tf":2.8284271247461903}}},"r":{"c":{"df":3,"docs":{"54":{"tf":1.0},"60":{"tf":1.0},"92":{"tf":1.7320508075688772}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":2.449489742783178},"14":{"tf":2.23606797749979}}}},"df":7,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"20":{"tf":1.0},"54":{"tf":1.0}},"i":{"df":2,"docs":{"75":{"tf":1.0},"80":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"1":{"tf":1.0}}},"df":12,"docs":{"1":{"tf":2.23606797749979},"38":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"60":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"80":{"tf":1.4142135623730951}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"58":{"tf":1.0},"77":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"76":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":21,"docs":{"0":{"tf":1.0},"1":{"tf":2.0},"2":{"tf":2.0},"20":{"tf":1.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":2.23606797749979},"38":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"49":{"tf":1.0},"51":{"tf":1.0},"58":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":2.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"t":{"df":2,"docs":{"70":{"tf":1.0},"95":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":11,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"35":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.0},"76":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}},"n":{"df":12,"docs":{"34":{"tf":1.4142135623730951},"38":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"57":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"25":{"tf":1.0},"98":{"tf":1.0}}}},"o":{"df":0,"docs":{},"e":{"df":2,"docs":{"40":{"tf":1.0},"41":{"tf":1.0}}},"o":{"d":{"df":2,"docs":{"5":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"36":{"tf":1.0},"77":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"41":{"tf":1.0}},"l":{"df":3,"docs":{"38":{"tf":1.0},"56":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"55":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"80":{"tf":1.0}}}}},"df":1,"docs":{"10":{"tf":1.7320508075688772}},"e":{"a":{"d":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"27":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":8,"docs":{"1":{"tf":1.0},"10":{"tf":2.6457513110645907},"2":{"tf":1.0},"20":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":4,"docs":{"54":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"9":{"tf":1.0}}},"df":8,"docs":{"3":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"8":{"tf":1.0}},"’":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"50":{"tf":1.0},"55":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"55":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"25":{"tf":1.0},"74":{"tf":1.0},"95":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"'":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"'":{">":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"g":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"df":13,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":2.449489742783178},"28":{"tf":2.449489742783178},"29":{"tf":2.449489742783178},"3":{"tf":1.4142135623730951},"36":{"tf":1.0},"44":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":2.0},"95":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"/":{"1":{".":{"0":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{".":{"df":1,"docs":{"97":{"tf":1.0}}},"3":{"2":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":4,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.0},"59":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":9,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"62":{"tf":1.0},"80":{"tf":1.0},"98":{"tf":3.1622776601683795}},"e":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":1,"docs":{"97":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"36":{"tf":1.0},"56":{"tf":1.0},"68":{"tf":1.0},"81":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"67":{"tf":1.0},"71":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"21":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":18,"docs":{"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.449489742783178},"78":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"89":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":2.23606797749979}}}},"x":{"df":4,"docs":{"77":{"tf":1.0},"93":{"tf":2.449489742783178},"94":{"tf":2.23606797749979},"95":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":7,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":2.6457513110645907},"56":{"tf":2.8284271247461903}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"54":{"tf":1.4142135623730951},"85":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772}}}}},"i":{"d":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"28":{"tf":1.0},"85":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"a":{"d":{"df":14,"docs":{"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"38":{"tf":1.0},"49":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"72":{"tf":1.0},"82":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}},"n":{"d":{"df":4,"docs":{"69":{"tf":1.0},"81":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":3,"docs":{"2":{"tf":1.0},"81":{"tf":1.7320508075688772},"92":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"62":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":7,"docs":{"1":{"tf":1.0},"43":{"tf":1.4142135623730951},"69":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"'":{"df":10,"docs":{"1":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"6":{"tf":1.0}}},"df":19,"docs":{"38":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"5":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":2.449489742783178},"63":{"tf":1.0},"65":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":2.0},"78":{"tf":2.0},"8":{"tf":1.0},"80":{"tf":2.449489742783178},"83":{"tf":1.7320508075688772},"88":{"tf":2.0},"97":{"tf":3.4641016151377544}}},"r":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"’":{"df":0,"docs":{},"m":{"df":1,"docs":{"57":{"tf":1.0}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"0":{"tf":1.0},"38":{"tf":1.0}}},"df":0,"docs":{}},"u":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"5":{"tf":1.0},"55":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"38":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"17":{"tf":1.0},"60":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"3":{"tf":1.0},"30":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"75":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":2,"docs":{"17":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":2,"docs":{"38":{"tf":1.0},"54":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"41":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"36":{"tf":1.0},"98":{"tf":1.0}}}},"t":{"'":{"df":4,"docs":{"1":{"tf":1.7320508075688772},"3":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.0}}},"df":7,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":7,"docs":{"0":{"tf":1.0},"2":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":1,"docs":{"1":{"tf":1.4142135623730951}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":9,"docs":{"17":{"tf":2.0},"19":{"tf":1.4142135623730951},"43":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":2.0},"90":{"tf":1.0},"92":{"tf":1.4142135623730951}}},"y":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":0,"docs":{}},"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"89":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":14,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"55":{"tf":2.0},"57":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"70":{"tf":2.0},"76":{"tf":1.0},"84":{"tf":2.0},"9":{"tf":1.4142135623730951},"92":{"tf":1.0}}},"k":{"!":{"]":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"1":{"tf":1.0},"26":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"49":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"75":{"tf":1.0},"78":{"tf":2.6457513110645907},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":2.0},"95":{"tf":1.0}}},"t":{"df":8,"docs":{"54":{"tf":1.0},"61":{"tf":2.449489742783178},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"8":{"tf":1.7320508075688772},"97":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":12,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"61":{"tf":1.0},"73":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"64":{"tf":1.0}},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}}}}},"o":{"a":{"d":{"df":1,"docs":{"95":{"tf":2.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"44":{"tf":1.0},"91":{"tf":1.7320508075688772}}},"t":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"19":{"tf":2.0},"30":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"82":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":45,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"p":{"df":2,"docs":{"58":{"tf":1.0},"80":{"tf":1.0}}}},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"99":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"57":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"54":{"tf":1.0},"57":{"tf":1.7320508075688772}}}}},"df":5,"docs":{"38":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.7320508075688772},"78":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"1":{"tf":1.0},"54":{"tf":2.0},"56":{"tf":2.0},"57":{"tf":2.0},"60":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":9,"docs":{"2":{"tf":1.0},"42":{"tf":1.4142135623730951},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.4142135623730951},"60":{"tf":1.0},"74":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":13,"docs":{"0":{"tf":1.0},"13":{"tf":1.7320508075688772},"26":{"tf":2.449489742783178},"3":{"tf":2.23606797749979},"30":{"tf":2.0},"31":{"tf":2.0},"38":{"tf":1.0},"7":{"tf":1.7320508075688772},"78":{"tf":1.0},"85":{"tf":2.6457513110645907},"86":{"tf":2.6457513110645907},"87":{"tf":2.23606797749979},"93":{"tf":1.0}}}}}},"df":1,"docs":{"84":{"tf":1.0}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"81":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"75":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"57":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"12":{"tf":1.0},"38":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"57":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"78":{"tf":1.0},"97":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"5":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":4,"docs":{"61":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"63":{"tf":1.4142135623730951},"97":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"d":{"df":3,"docs":{"49":{"tf":1.7320508075688772},"65":{"tf":1.0},"78":{"tf":1.0}},"e":{"df":3,"docs":{"12":{"tf":1.0},"36":{"tf":1.0},"76":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"89":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"49":{"tf":1.0},"78":{"tf":1.4142135623730951},"88":{"tf":2.449489742783178}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":21,"docs":{"12":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"93":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.0},"70":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"56":{"tf":2.0}}}},"y":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":12,"docs":{"1":{"tf":2.23606797749979},"15":{"tf":1.0},"16":{"tf":3.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"35":{"tf":1.7320508075688772},"52":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"91":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"6":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":11,"docs":{"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"44":{"tf":1.0},"55":{"tf":2.0},"57":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"64":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.4142135623730951},"89":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"60":{"tf":1.0}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}}},"w":{"df":4,"docs":{"1":{"tf":1.7320508075688772},"58":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"62":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.0}}}}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.0},"91":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":10,"docs":{"38":{"tf":1.4142135623730951},"52":{"tf":1.0},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"74":{"tf":1.0},"78":{"tf":1.0},"97":{"tf":1.0}}},"h":{"df":1,"docs":{"98":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":3,"docs":{"1":{"tf":1.0},"42":{"tf":1.0},"49":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"17":{"tf":1.0},"43":{"tf":1.4142135623730951},"60":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":2.449489742783178},"88":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"15":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"36":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":1,"docs":{"56":{"tf":1.7320508075688772}}},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"95":{"tf":1.0}}},"df":6,"docs":{"38":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"6":{"tf":1.0},"70":{"tf":1.0},"91":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"97":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"r":{"df":4,"docs":{"36":{"tf":1.0},"56":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"78":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":22,"docs":{"10":{"tf":1.0},"20":{"tf":2.23606797749979},"24":{"tf":1.7320508075688772},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"60":{"tf":1.0},"77":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"13":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0},"97":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":14,"docs":{"12":{"tf":1.4142135623730951},"14":{"tf":2.449489742783178},"15":{"tf":2.6457513110645907},"35":{"tf":2.0},"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"89":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"22":{"tf":1.0},"59":{"tf":1.0},"75":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"16":{"tf":1.0},"33":{"tf":1.4142135623730951},"91":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":13,"docs":{"1":{"tf":2.23606797749979},"10":{"tf":1.0},"49":{"tf":1.4142135623730951},"58":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"81":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.0},"93":{"tf":2.8284271247461903},"94":{"tf":2.23606797749979},"95":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"$":{"(":{"$":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"1":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"57":{"tf":1.0}}}}}}}}},"df":3,"docs":{"53":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.4142135623730951}},"k":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}}}}}}}}}},"t":{"df":7,"docs":{"20":{"tf":1.0},"55":{"tf":1.7320508075688772},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"69":{"tf":1.0},"81":{"tf":1.0},"89":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":29,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":3.0},"22":{"tf":2.6457513110645907},"24":{"tf":1.7320508075688772},"32":{"tf":1.0},"38":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.7320508075688772},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"66":{"tf":2.23606797749979},"67":{"tf":2.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"74":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.4142135623730951},"99":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},">":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"1":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":2.0},"19":{"tf":1.4142135623730951},"6":{"tf":1.0},"78":{"tf":1.7320508075688772},"95":{"tf":2.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"6":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"c":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"97":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"95":{"tf":1.4142135623730951},"98":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":2.23606797749979}}}}}}}},"i":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"77":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":5,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"51":{"tf":1.0},"91":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"74":{"tf":2.0},"80":{"tf":3.3166247903554}}}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"30":{"tf":2.449489742783178},"87":{"tf":3.605551275463989}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"52":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"43":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"5":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":1,"docs":{"54":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"78":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"v":{"df":5,"docs":{"55":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"98":{"tf":1.0}}}}},"s":{"df":1,"docs":{"42":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"55":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"98":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"21":{"tf":1.0},"37":{"tf":1.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.0},"88":{"tf":1.4142135623730951},"97":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"58":{"tf":1.0}}}}}}},"w":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"55":{"tf":2.6457513110645907},"6":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"49":{"tf":1.0},"60":{"tf":1.4142135623730951},"65":{"tf":2.0},"67":{"tf":1.4142135623730951},"71":{"tf":2.23606797749979},"72":{"tf":1.0},"97":{"tf":1.7320508075688772}},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"21":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.4142135623730951}}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"56":{"tf":1.0},"74":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"54":{"tf":1.7320508075688772},"6":{"tf":1.0},"80":{"tf":2.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":7,"docs":{"0":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"47":{"tf":1.0},"66":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"45":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"99":{"tf":2.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":9,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"87":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"b":{"df":11,"docs":{"1":{"tf":1.0},"49":{"tf":3.3166247903554},"60":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":2.6457513110645907},"80":{"tf":1.4142135623730951},"83":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"c":{"df":6,"docs":{"1":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":1.0},"60":{"tf":1.7320508075688772},"71":{"tf":2.0},"97":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}}}},"t":{"df":5,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"55":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":1,"docs":{"13":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":2,"docs":{"52":{"tf":1.0},"82":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":1.0}}}},"m":{"df":1,"docs":{"60":{"tf":1.7320508075688772}},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":10,"docs":{"20":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":4,"docs":{"37":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}}},"v":{"df":1,"docs":{"78":{"tf":1.0}}}},"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}},"df":3,"docs":{"1":{"tf":1.0},"49":{"tf":1.4142135623730951},"97":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"74":{"tf":1.0},"80":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"20":{"tf":1.0},"53":{"tf":1.4142135623730951},"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":4,"docs":{"12":{"tf":1.0},"58":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"55":{"tf":1.0}}}},"i":{"df":2,"docs":{"2":{"tf":1.0},"6":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":6,"docs":{"22":{"tf":1.0},"38":{"tf":1.0},"50":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"89":{"tf":1.0},"95":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"26":{"tf":2.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":2.0},"86":{"tf":2.0},"87":{"tf":1.7320508075688772},"89":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":2,"docs":{"1":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"r":{"df":6,"docs":{"75":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"62":{"tf":1.4142135623730951},"78":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"89":{"tf":1.7320508075688772},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"74":{"tf":1.4142135623730951},"78":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":3,"docs":{"4":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"56":{"tf":1.7320508075688772}}}},"df":6,"docs":{"53":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"77":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"53":{"tf":1.0},"56":{"tf":2.0},"6":{"tf":1.4142135623730951}}}}}}},"f":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.0},"58":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"44":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":2.0},"95":{"tf":2.23606797749979}}}}},"s":{"df":1,"docs":{"16":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"36":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0}}}},"n":{"df":21,"docs":{"1":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"30":{"tf":1.0},"42":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.7320508075688772},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"80":{"tf":2.0},"87":{"tf":1.0},"90":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772},"98":{"tf":1.7320508075688772},"99":{"tf":2.449489742783178}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.7320508075688772},"99":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":2.8284271247461903}}}}}}},"s":{"df":0,"docs":{},"t":{"c":{"df":8,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":2.23606797749979},"25":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"80":{"tf":1.0},"92":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"'":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"15":{"tf":1.0},"32":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":1.0},"60":{"tf":1.0},"68":{"tf":1.0},"95":{"tf":1.0}}},"df":72,"docs":{"0":{"tf":2.0},"1":{"tf":2.6457513110645907},"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":2.23606797749979},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":2.6457513110645907},"20":{"tf":2.8284271247461903},"21":{"tf":2.23606797749979},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":1.7320508075688772},"3":{"tf":2.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":2.0},"59":{"tf":1.0},"60":{"tf":2.0},"61":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.0},"78":{"tf":2.0},"8":{"tf":1.0},"80":{"tf":2.8284271247461903},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"85":{"tf":2.0},"86":{"tf":2.0},"87":{"tf":1.0},"88":{"tf":1.7320508075688772},"89":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":2.23606797749979},"92":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951},"97":{"tf":2.0},"98":{"tf":2.0},"99":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":17,"docs":{"0":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"20":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"75":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"93":{"tf":1.0},"97":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":13,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"77":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"62":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"55":{"tf":1.4142135623730951},"58":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"83":{"tf":2.23606797749979},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"57":{"tf":1.0},"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"49":{"tf":1.7320508075688772},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"75":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":16,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"36":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.4142135623730951}},"n":{"df":2,"docs":{"74":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":1.0}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"36":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":7,"docs":{"52":{"tf":1.0},"55":{"tf":2.0},"6":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"91":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"55":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"22":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.7320508075688772},"89":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":9,"docs":{"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"83":{"tf":1.0},"97":{"tf":1.7320508075688772}}}}},"i":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"19":{"tf":1.0},"25":{"tf":1.0},"33":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":3,"docs":{"38":{"tf":1.0},"70":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"x":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"80":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"55":{"tf":1.0},"60":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":2.6457513110645907}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":5,"docs":{"13":{"tf":1.0},"45":{"tf":1.0},"55":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"38":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"49":{"tf":1.0},"80":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":6,"docs":{"5":{"tf":1.0},"59":{"tf":1.4142135623730951},"7":{"tf":1.0},"74":{"tf":1.4142135623730951},"77":{"tf":1.0},"80":{"tf":2.449489742783178}},"i":{"df":9,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":2.0},"22":{"tf":1.0},"25":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"58":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":35,"docs":{"1":{"tf":2.0},"12":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":2.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"77":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0}}}},"l":{"df":4,"docs":{"10":{"tf":1.0},"32":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":2.0},"87":{"tf":1.4142135623730951}}}}},"r":{"d":{"df":8,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"43":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":2.0},"92":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"52":{"tf":1.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"77":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"72":{"tf":1.0}}}}}}},"i":{"c":{"=":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"19":{"tf":1.0},"78":{"tf":1.0},"95":{"tf":2.449489742783178}}},"df":0,"docs":{}}}},"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"6":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"56":{"tf":2.0}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"c":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"36":{"tf":1.0},"55":{"tf":1.4142135623730951},"60":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"56":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":5,"docs":{"40":{"tf":1.0},"41":{"tf":1.0},"55":{"tf":1.0},"70":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"p":{"df":6,"docs":{"21":{"tf":1.0},"50":{"tf":1.0},"67":{"tf":2.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"72":{"tf":1.7320508075688772}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"49":{"tf":2.23606797749979},"60":{"tf":2.8284271247461903},"71":{"tf":1.4142135623730951},"74":{"tf":2.0},"78":{"tf":3.605551275463989},"80":{"tf":2.0},"83":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"98":{"tf":1.7320508075688772}}}}}},"u":{"b":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"76":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"89":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"89":{"tf":2.0},"95":{"tf":1.0}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":1,"docs":{"55":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"52":{"tf":1.0},"78":{"tf":1.0}}}},"s":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"31":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"52":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":3,"docs":{"38":{"tf":1.0},"59":{"tf":1.7320508075688772},"69":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":2.23606797749979}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":5,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"98":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":11,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"c":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"=":{"+":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"x":{"df":1,"docs":{"20":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":2.6457513110645907},"74":{"tf":2.0},"80":{"tf":1.7320508075688772},"98":{"tf":2.6457513110645907}}}}}}},"df":3,"docs":{"69":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"20":{"tf":1.0},"58":{"tf":2.0},"80":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":19,"docs":{"20":{"tf":2.6457513110645907},"23":{"tf":2.8284271247461903},"24":{"tf":3.1622776601683795},"3":{"tf":1.0},"34":{"tf":1.0},"52":{"tf":2.23606797749979},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.23606797749979},"58":{"tf":2.0},"60":{"tf":3.1622776601683795},"61":{"tf":1.0},"65":{"tf":2.0},"75":{"tf":1.0},"77":{"tf":1.4142135623730951},"90":{"tf":2.0},"96":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}}}},"x":{"df":0,"docs":{},"t":{"df":6,"docs":{"38":{"tf":1.4142135623730951},"54":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":4,"docs":{"2":{"tf":1.0},"25":{"tf":1.0},"55":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"32":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.0}}}}},"df":0,"docs":{}},"df":3,"docs":{"32":{"tf":1.0},"35":{"tf":3.3166247903554},"36":{"tf":3.7416573867739413}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":6,"docs":{"1":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"'":{"df":0,"docs":{},"r":{"df":3,"docs":{"71":{"tf":1.0},"75":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"55":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"74":{"tf":1.4142135623730951},"77":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"k":{"df":2,"docs":{"1":{"tf":1.0},"6":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":9,"docs":{"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"57":{"tf":1.0},"75":{"tf":1.0},"91":{"tf":2.0},"92":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"38":{"tf":1.0},"52":{"tf":1.0},"97":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":3,"docs":{"57":{"tf":1.0},"59":{"tf":1.0},"78":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"99":{"tf":1.0}}}}}}},"u":{"df":3,"docs":{"75":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0}},"m":{"b":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"75":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"20":{"tf":1.0},"55":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"o":{"c":{"df":1,"docs":{"31":{"tf":2.0}}},"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"74":{"tf":1.7320508075688772},"80":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"p":{"df":4,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"49":{"tf":1.4142135623730951},"93":{"tf":1.7320508075688772}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":4,"docs":{"43":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"56":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":2.0},"97":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"34":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":4,"docs":{"1":{"tf":1.4142135623730951},"3":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.0},"25":{"tf":2.0},"52":{"tf":1.0},"98":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"57":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"76":{"tf":1.0},"81":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":6,"docs":{"1":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.0},"91":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"82":{"tf":1.0}}},"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":5,"docs":{"51":{"tf":1.4142135623730951},"56":{"tf":2.0},"78":{"tf":1.4142135623730951},"81":{"tf":2.0},"91":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"2":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"99":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"3":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"63":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.0},"56":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}}},"n":{"d":{"df":2,"docs":{"67":{"tf":1.0},"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"56":{"tf":1.0}}}},"t":{"df":2,"docs":{"53":{"tf":1.0},"60":{"tf":1.4142135623730951}}},"x":{"df":3,"docs":{"6":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"74":{"tf":1.0},"80":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"49":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":3,"docs":{"76":{"tf":1.0},"77":{"tf":1.0},"87":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"92":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":20,"docs":{"10":{"tf":1.0},"43":{"tf":1.0},"75":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":2.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":2.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"54":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"54":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}},"df":6,"docs":{"1":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"52":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"80":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":5,"docs":{"30":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"87":{"tf":3.4641016151377544},"91":{"tf":2.23606797749979}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"df":72,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":3.0},"51":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.0},"56":{"tf":2.8284271247461903},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"60":{"tf":2.0},"61":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":2.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":2.23606797749979},"80":{"tf":2.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.7320508075688772}},"e":{"'":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":2,"docs":{"6":{"tf":1.4142135623730951},"90":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"60":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"25":{"tf":1.0},"6":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"99":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"d":{"df":2,"docs":{"6":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":3,"docs":{"18":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"38":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"85":{"tf":1.0},"86":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"12":{"tf":2.6457513110645907},"2":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"60":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":10,"docs":{"11":{"tf":2.449489742783178},"12":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":2.8284271247461903},"38":{"tf":1.0},"56":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.7320508075688772}}}}}}}},"i":{"a":{"df":5,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"38":{"tf":1.0},"6":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"22":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":2.23606797749979},"56":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"62":{"tf":1.0},"74":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"61":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":8,"docs":{"47":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"78":{"tf":1.0},"90":{"tf":2.6457513110645907}}}},"y":{"df":7,"docs":{"20":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.0}}}},"df":1,"docs":{"14":{"tf":1.4142135623730951}},"e":{"'":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"49":{"tf":1.0}}}},"r":{"df":1,"docs":{"60":{"tf":1.0}}},"v":{"df":1,"docs":{"38":{"tf":1.0}}}},"b":{"df":2,"docs":{"1":{"tf":1.0},"58":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"7":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"2":{"tf":1.4142135623730951},"34":{"tf":1.0},"57":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}}}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"74":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"'":{"1":{"0":{"0":{"'":{">":{"<":{"/":{"a":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":4,"docs":{"25":{"tf":1.0},"6":{"tf":1.0},"74":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"74":{"tf":1.0},"80":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"52":{"tf":1.0},"80":{"tf":1.0},"90":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"53":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"k":{"df":9,"docs":{"15":{"tf":1.0},"36":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"90":{"tf":1.0}}},"l":{"d":{"df":3,"docs":{"55":{"tf":1.4142135623730951},"58":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"d":{"'":{"df":0,"docs":{},"v":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":10,"docs":{"5":{"tf":2.449489742783178},"54":{"tf":1.0},"56":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"82":{"tf":1.0},"97":{"tf":1.0}}}}}}}}},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"52":{"tf":1.7320508075688772},"55":{"tf":4.242640687119285},"58":{"tf":1.4142135623730951},"60":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"y":{"df":1,"docs":{"55":{"tf":4.242640687119285}},"e":{"df":1,"docs":{"55":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"1":{"tf":1.7320508075688772},"2":{"tf":1.0},"3":{"tf":1.0},"54":{"tf":1.0},"62":{"tf":1.0},"93":{"tf":1.0}}}},"r":{"df":1,"docs":{"95":{"tf":1.0}}},"v":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}},"z":{"df":14,"docs":{"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0},"92":{"tf":1.7320508075688772},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}},"title":{"root":{"a":{"d":{"d":{"df":3,"docs":{"21":{"tf":1.0},"35":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"98":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"24":{"tf":1.0},"99":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"84":{"tf":1.0},"9":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"58":{"tf":1.0},"79":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"1":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":1,"docs":{"20":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.0}}}},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"23":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"84":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"31":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":8,"docs":{"16":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":5,"docs":{"16":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"39":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":2,"docs":{"26":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"22":{"tf":1.4142135623730951},"36":{"tf":1.0},"67":{"tf":1.0},"94":{"tf":1.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"17":{"tf":1.0},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"o":{"c":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{")":{"]":{"/":{"#":{"[":{"d":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}}},"df":8,"docs":{"34":{"tf":1.0},"38":{"tf":1.0},"56":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"34":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":1.0},"77":{"tf":1.0},"96":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"25":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"90":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"31":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"32":{"tf":1.0}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"94":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"23":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"32":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":1,"docs":{"79":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":1.0},"82":{"tf":1.0},"91":{"tf":1.0}}}}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"53":{"tf":1.0},"77":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"26":{"tf":1.0},"3":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"98":{"tf":1.0}}},"r":{"c":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"25":{"tf":1.0},"31":{"tf":1.0},"94":{"tf":1.0}}}}}}},"h":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"91":{"tf":1.0},"95":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":8,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"60":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"93":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"11":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":6,"docs":{"48":{"tf":1.0},"60":{"tf":1.0},"78":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0},"97":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"17":{"tf":1.0}},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"39":{"tf":1.0},"48":{"tf":1.0},"93":{"tf":1.0}}}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"84":{"tf":1.0},"9":{"tf":1.0}}},"k":{"df":2,"docs":{"78":{"tf":1.0},"91":{"tf":1.0}}},"t":{"df":2,"docs":{"61":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"a":{"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"91":{"tf":1.0}}},"t":{"df":3,"docs":{"19":{"tf":1.0},"30":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":7,"docs":{"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"89":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"12":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"78":{"tf":1.0},"89":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"91":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":1,"docs":{"15":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"20":{"tf":1.0},"24":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"35":{"tf":1.0},"95":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":3,"docs":{"88":{"tf":1.0},"93":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":9,"docs":{"18":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"24":{"tf":1.0},"53":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"99":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"98":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.4142135623730951}}}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"74":{"tf":1.0},"80":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"30":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"54":{"tf":1.0}}},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"72":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"93":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":1,"docs":{"13":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"26":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"33":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":5,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"'":{"df":1,"docs":{"32":{"tf":1.0}}},"df":4,"docs":{"0":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"97":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"74":{"tf":1.0},"80":{"tf":1.0}},"i":{"df":2,"docs":{"19":{"tf":1.0},"25":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":3,"docs":{"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"98":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"89":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":6,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"35":{"tf":1.4142135623730951},"36":{"tf":1.7320508075688772}}}}}},"o":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":1,"docs":{"93":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"92":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"75":{"tf":1.0},"84":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"l":{"df":3,"docs":{"30":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":1.0}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":3,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"56":{"tf":1.0}}}},"v":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951}}}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"14":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"z":{"df":1,"docs":{"92":{"tf":1.0}}}}}},"pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});